/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.grading;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.MediaIfc;

public class MediaData
implements Serializable,
MediaIfc {
    private static final long serialVersionUID = -437737678404198607L;
    private Long mediaId;
    private ItemGradingIfc itemGradingData;
    private byte[] media;
    private Long fileSize;
    private String mimeType;
    private String description;
    private String location;
    private String filename;
    private boolean isLink;
    private boolean isHtmlInline;
    private Integer status;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private String duration;
    private boolean durationIsOver;
    private String timeAllowed;

    public MediaData() {
    }

    public MediaData(ItemGradingIfc itemGradingData, byte[] media, Long fileSize, String mimeType, String description, String location, String filename, boolean isLink, boolean isHtmlInline, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, String duration) {
        this.itemGradingData = itemGradingData;
        this.media = media;
        this.fileSize = fileSize;
        this.mimeType = mimeType;
        this.description = description;
        this.location = location;
        this.filename = filename;
        this.isLink = isLink;
        this.isHtmlInline = isHtmlInline;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.duration = duration;
    }

    public MediaData(Long mediaId, ItemGradingIfc itemGradingData, Long fileSize, String mimeType, String description, String location, String filename, boolean isLink, boolean isHtmlInline, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, String duration) {
        this.mediaId = mediaId;
        this.itemGradingData = itemGradingData;
        this.fileSize = fileSize;
        this.mimeType = mimeType;
        this.description = description;
        this.location = location;
        this.filename = filename;
        this.isLink = isLink;
        this.isHtmlInline = isHtmlInline;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.duration = duration;
    }

    public MediaData(byte[] media, String mimeType) {
        this.setMimeType(mimeType);
        this.setMedia(media);
        this.setFileSize(Long.valueOf(media.length));
    }

    public MediaData(Long mediaId, String filename, Long fileSize, String duration, Date createdDate) {
        this.mediaId = mediaId;
        this.filename = filename;
        this.fileSize = fileSize;
        this.duration = duration;
        this.createdDate = createdDate;
    }

    public Long getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public ItemGradingIfc getItemGradingData() {
        return this.itemGradingData;
    }

    public void setItemGradingData(ItemGradingIfc itemGradingData) {
        this.itemGradingData = itemGradingData;
    }

    public byte[] getMedia() {
        return this.media;
    }

    public void setMedia(byte[] media) {
        this.media = media;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public String getFileSizeKBFormat() {
        String fileSizeKBStr = "";
        if (this.fileSize != null) {
            double fileSizeKB = this.fileSize.doubleValue() / 1000.0;
            DecimalFormat nf = new DecimalFormat();
            nf.setMaximumFractionDigits(2);
            nf.setDecimalSeparatorAlwaysShown(true);
            fileSizeKBStr = nf.format(fileSizeKB);
        }
        return fileSizeKBStr;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String pdescription) {
        this.description = pdescription;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean getIsLink() {
        return this.isLink;
    }

    public void setIsLink(boolean isLink) {
        this.isLink = isLink;
    }

    public boolean getIsHtmlInline() {
        return this.isHtmlInline;
    }

    public void setIsHtmlInline(boolean isHtmlInline) {
        this.isHtmlInline = isHtmlInline;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public boolean getDurationIsOver() {
        return this.durationIsOver;
    }

    public void setDurationIsOver(boolean durationIsOver) {
        this.durationIsOver = durationIsOver;
    }

    public String getTimeAllowed() {
        return this.timeAllowed;
    }

    public void setTimeAllowed(String timeAllowed) {
        this.timeAllowed = timeAllowed;
    }
}

