/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.audio;

import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.sakaiproject.tool.assessment.audio.AudioRecorderParams;
import org.sakaiproject.tool.assessment.audio.AudioUtil;
import org.sakaiproject.tool.assessment.audio.ColorBackgroundPanel;

public class AudioFormatPanel
extends JPanel {
    static ResourceBundle res = AudioUtil.getInstance().getResourceBundle();
    protected AudioRecorderParams params;
    Vector groups = new Vector();
    JToggleButton linrB;
    JToggleButton ulawB;
    JToggleButton alawB;
    JToggleButton rate8B;
    JToggleButton rate11B;
    JToggleButton rate16B;
    JToggleButton rate22B;
    JToggleButton rate44B;
    JToggleButton size8B;
    JToggleButton size16B;
    JToggleButton signB;
    JToggleButton unsignB;
    JToggleButton litB;
    JToggleButton bigB;
    JToggleButton monoB;
    JToggleButton sterB;

    public AudioFormatPanel(AudioRecorderParams params) {
        this.params = params;
        this.setLayout(new GridLayout(0, 1));
        EmptyBorder eb = new EmptyBorder(0, 0, 0, 5);
        BevelBorder bb = new BevelBorder(1);
        CompoundBorder cb = new CompoundBorder(eb, bb);
        this.setBorder(new CompoundBorder(cb, new EmptyBorder(8, 5, 5, 5)));
        ColorBackgroundPanel p1 = new ColorBackgroundPanel(false);
        ButtonGroup encodingGroup = this.makeEncodingGroup(params, p1);
        this.add(p1);
        this.groups.addElement(encodingGroup);
        ColorBackgroundPanel p2 = new ColorBackgroundPanel(false);
        ColorBackgroundPanel p2b = new ColorBackgroundPanel(false);
        ButtonGroup sampleRateGroup = this.makeSampleRateGroup(params, p2, p2b);
        this.add(p2);
        this.add(p2b);
        this.groups.addElement(sampleRateGroup);
        ColorBackgroundPanel p3 = new ColorBackgroundPanel(false);
        ButtonGroup sampleSizeInBitsGroup = this.makeSizeInBitsGroup(params, p3);
        this.add(p3);
        this.groups.addElement(sampleSizeInBitsGroup);
        ColorBackgroundPanel p4 = new ColorBackgroundPanel(false);
        ButtonGroup signGroup = this.makeSignGroup(params, p4);
        this.add(p4);
        this.groups.addElement(signGroup);
        ColorBackgroundPanel p5 = new ColorBackgroundPanel(false);
        ButtonGroup endianGroup = this.makeEndianGroup(params, p5);
        this.add(p5);
        this.groups.addElement(endianGroup);
        ColorBackgroundPanel p6 = new ColorBackgroundPanel(false);
        ButtonGroup channelsGroup = this.makeChannelsGroup(params, p6);
        this.add(p6);
        this.groups.addElement(channelsGroup);
    }

    private ButtonGroup makeEncodingGroup(AudioRecorderParams params, JPanel p1) {
        ButtonGroup encodingGroup = new ButtonGroup();
        boolean linear = false;
        boolean ulaw = false;
        boolean alaw = false;
        if ("linear".equals(params.getCompression())) {
            linear = true;
        } else if ("ulaw".equals(params.getCompression())) {
            ulaw = true;
        } else {
            alaw = true;
        }
        this.linrB = this.addToggleButton(p1, encodingGroup, res.getString("linear"), linear);
        this.ulawB = this.addToggleButton(p1, encodingGroup, res.getString("ulaw"), ulaw);
        this.alawB = this.addToggleButton(p1, encodingGroup, res.getString("alaw"), alaw);
        return encodingGroup;
    }

    private ButtonGroup makeSampleRateGroup(AudioRecorderParams params, JPanel p2, JPanel p2b) {
        ButtonGroup sampleRateGroup = new ButtonGroup();
        boolean[] rates = new boolean[]{false, false, false, false, false};
        int rate = params.getFrequency();
        int i = 0;
        while (true) {
            if (i >= AudioRecorderParams.frequenciesAllowed.length) break;
            if (rate == AudioRecorderParams.frequenciesAllowed[i]) {
                rates[i] = true;
                break;
            }
            ++i;
        }
        this.rate8B = this.addToggleButton(p2, sampleRateGroup, "8000", rates[0]);
        this.rate11B = this.addToggleButton(p2, sampleRateGroup, "11025", rates[1]);
        this.rate16B = this.addToggleButton(p2b, sampleRateGroup, "16000", rates[2]);
        this.rate22B = this.addToggleButton(p2b, sampleRateGroup, "22050", rates[3]);
        this.rate44B = this.addToggleButton(p2b, sampleRateGroup, "44100", rates[4]);
        return sampleRateGroup;
    }

    private ButtonGroup makeSizeInBitsGroup(AudioRecorderParams params, JPanel p3) {
        ButtonGroup sampleSizeInBitsGroup = new ButtonGroup();
        boolean bit8 = params.getBits() == 8;
        this.size8B = this.addToggleButton(p3, sampleSizeInBitsGroup, "8", bit8);
        this.size16B = this.addToggleButton(p3, sampleSizeInBitsGroup, "16", !bit8);
        return sampleSizeInBitsGroup;
    }

    private ButtonGroup makeSignGroup(AudioRecorderParams params, JPanel p4) {
        ButtonGroup signGroup = new ButtonGroup();
        this.signB = this.addToggleButton(p4, signGroup, res.getString("signed"), params.isSigned());
        this.unsignB = this.addToggleButton(p4, signGroup, res.getString("unsigned"), !params.isSigned());
        return signGroup;
    }

    private ButtonGroup makeEndianGroup(AudioRecorderParams params, JPanel p5) {
        ButtonGroup endianGroup = new ButtonGroup();
        this.litB = this.addToggleButton(p5, endianGroup, res.getString("little_endian"), !params.isBigendian());
        this.bigB = this.addToggleButton(p5, endianGroup, res.getString("big_endian"), params.isBigendian());
        return endianGroup;
    }

    private ButtonGroup makeChannelsGroup(AudioRecorderParams params, JPanel p6) {
        ButtonGroup channelsGroup = new ButtonGroup();
        this.monoB = this.addToggleButton(p6, channelsGroup, res.getString("mono"), !params.isStereo());
        this.sterB = this.addToggleButton(p6, channelsGroup, res.getString("stereo"), params.isStereo());
        return channelsGroup;
    }

    private JToggleButton addToggleButton(JPanel p, ButtonGroup g, String name, boolean state) {
        JToggleButton b = new JToggleButton(name, state);
        p.add(b);
        g.add(b);
        return b;
    }

    public AudioFormat getFormat() {
        int channels;
        Vector<String> v = new Vector<String>(this.groups.size());
        block0: for (int i = 0; i < this.groups.size(); ++i) {
            ButtonGroup g = (ButtonGroup)this.groups.get(i);
            Enumeration<AbstractButton> e = g.getElements();
            while (e.hasMoreElements()) {
                AbstractButton b = e.nextElement();
                if (!b.isSelected()) continue;
                v.add(b.getText());
                continue block0;
            }
        }
        AudioFormat.Encoding encoding = AudioFormat.Encoding.ULAW;
        String encString = (String)v.get(0);
        float rate = Float.valueOf((String)v.get(1)).floatValue();
        int sampleSize = Integer.valueOf((String)v.get(2));
        String signedString = (String)v.get(3);
        boolean bigEndian = ((String)v.get(4)).startsWith(res.getString("big"));
        int n = channels = ((String)v.get(5)).equals(res.getString("mono")) ? 1 : 2;
        if (encString.equals(res.getString("linear"))) {
            encoding = signedString.equals(res.getString("signed")) ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
        } else if (encString.equals(res.getString("alaw"))) {
            encoding = AudioFormat.Encoding.ALAW;
        }
        return new AudioFormat(encoding, rate, sampleSize, channels, sampleSize / 8 * channels, rate, bigEndian);
    }

    public void setFormat(AudioFormat format) {
        AudioFormat.Encoding type = format.getEncoding();
        if (type == AudioFormat.Encoding.ULAW) {
            this.ulawB.doClick();
        } else if (type == AudioFormat.Encoding.ALAW) {
            this.alawB.doClick();
        } else if (type == AudioFormat.Encoding.PCM_SIGNED) {
            this.linrB.doClick();
            this.signB.doClick();
        } else if (type == AudioFormat.Encoding.PCM_UNSIGNED) {
            this.linrB.doClick();
            this.unsignB.doClick();
        }
        float rate = format.getFrameRate();
        if (rate == 8000.0f) {
            this.rate8B.doClick();
        } else if (rate == 11025.0f) {
            this.rate11B.doClick();
        } else if (rate == 16000.0f) {
            this.rate16B.doClick();
        } else if (rate == 22050.0f) {
            this.rate22B.doClick();
        } else if (rate == 44100.0f) {
            this.rate44B.doClick();
        }
        switch (format.getSampleSizeInBits()) {
            case 8: {
                this.size8B.doClick();
                break;
            }
            case 16: {
                this.size16B.doClick();
            }
        }
        if (format.isBigEndian()) {
            this.bigB.doClick();
        } else {
            this.litB.doClick();
        }
        if (format.getChannels() == 1) {
            this.monoB.doClick();
        } else {
            this.sterB.doClick();
        }
    }
}

