/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.audio;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.sakaiproject.tool.assessment.audio.AudioUtil;
import org.sakaiproject.tool.assessment.audio.ColorModel;

public class AudioMeterPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    int frame;
    int delay;
    Thread animator;
    static ResourceBundle res = AudioUtil.getInstance().getResourceBundle();
    String imageUrl = "";
    Dimension offDimension;
    Image offImage;
    Graphics offGraphics;
    private Image[] frames;
    static ColorModel colorModel = new ColorModel();
    private static final Font font12 = new Font("serif", 0, 12);
    private static final Color graphColor = colorModel.getColor("graphColor");
    int level;
    double seconds;

    public AudioMeterPanel() {
    }

    public AudioMeterPanel(String imageUrl) {
        this.imageUrl = imageUrl;
        try {
            this.frames = new Image[10];
            for (int i = 0; i < 10; ++i) {
                this.frames[i] = Toolkit.getDefaultToolkit().getImage(new URL(imageUrl + "/meter" + i + ".gif"));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.setBackground(Color.BLACK);
    }

    public void init() {
        int fps = 10;
        this.delay = fps > 0 ? 1000 / fps : 100;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (level > 9) {
            level = 9;
        }
        if (level > 5) {
            level -= 2;
        }
        if (level > 3 && level <= 5) {
            --level;
        }
        this.level = level;
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offGraphics == null || d.width != this.offDimension.width || d.height != this.offDimension.height) {
            this.offDimension = d;
            this.offImage = this.createImage(d.width, d.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, d.width, d.height);
        this.offGraphics.setColor(Color.black);
        this.paintFrame(this.offGraphics);
        g.drawImage(this.offImage, 0, 0, null);
        this.drawLengthText(this.getSeconds(), d.height, g);
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void paintFrame(Graphics g) {
        try {
            g.drawImage(this.frames[this.level], 0, 20, null);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            g.drawImage(this.frames[9], 0, 20, null);
        }
    }

    private void drawLengthText(double seconds, int h, Graphics g2) {
        g2.setColor(graphColor);
        g2.setFont(font12);
        g2.drawString(res.getString("Length_") + String.valueOf(seconds), 3, h - 4);
    }

    public double getSeconds() {
        return this.seconds;
    }

    public void setSeconds(double seconds) {
        this.seconds = seconds;
    }
}

