/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.audio;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.sakaiproject.tool.assessment.audio.AudioConfigHelp;
import org.sakaiproject.tool.assessment.audio.AudioControlContext;
import org.sakaiproject.tool.assessment.audio.AudioRecorder;
import org.sakaiproject.tool.assessment.audio.AudioRecorderApplet;
import org.sakaiproject.tool.assessment.audio.AudioRecorderParams;
import org.sakaiproject.tool.assessment.audio.AudioUtil;

public class AudioPanel
extends JPanel
implements ChangeListener,
Runnable {
    static ResourceBundle res = AudioUtil.getInstance().getResourceBundle();
    Vector tabPanels = new Vector(4);
    JTabbedPane tabPane = new JTabbedPane();
    int width = 450;
    int height = 350;
    int index;
    AudioRecorderParams params;

    public AudioPanel(String audioDirectory, AudioRecorderParams params) {
        this.params = params;
        this.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        if (this.isStandalone()) {
            this.configureFileMenu(menuBar);
        }
        this.configureHelpMenu(menuBar);
        this.add((Component)menuBar, "North");
        this.tabPane.addChangeListener(this);
        EmptyBorder eb = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bb = new BevelBorder(1);
        CompoundBorder cb = new CompoundBorder(eb, bb);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new CompoundBorder(cb, new EmptyBorder(0, 0, 0, 0)));
        new Thread(this).start();
        this.add((Component)this.tabPane, "Center");
    }

    private boolean isStandalone() {
        return AudioRecorderApplet.applet == null || AudioRecorderApplet.applet.isStandalone;
    }

    private void configureHelpMenu(JMenuBar menuBar) {
        menuBar.add(Box.createHorizontalGlue());
        JMenu options = menuBar.add(new JMenu(res.getString("Help")));
        options.setMnemonic(72);
        JMenuItem item = options.add(new JMenuItem(res.getString("Configuration")));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AudioConfigHelp help = new AudioConfigHelp();
                help.configHelp();
            }
        });
    }

    private void configureFileMenu(JMenuBar menuBar) {
        JMenu fileMenu = menuBar.add(new JMenu(res.getString("File")));
        fileMenu.setMnemonic(70);
        JMenuItem item = fileMenu.add(new JMenuItem(res.getString("Exit")));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
    }

    public void stateChanged(ChangeEvent e) {
        this.close();
        this.index = this.tabPane.getSelectedIndex();
        this.open();
    }

    public void close() {
        ((AudioControlContext)this.tabPanels.get(this.index)).close();
    }

    public void open() {
        ((AudioControlContext)this.tabPanels.get(this.index)).open();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void run() {
        EmptyBorder eb = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bb = new BevelBorder(1);
        CompoundBorder cb = new CompoundBorder(eb, bb);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new CompoundBorder(cb, new EmptyBorder(0, 0, 0, 0)));
        AudioRecorder recorder = new AudioRecorder(this.params);
        recorder.setContainingApplet((Applet)this.getParent().getParent().getParent().getParent());
        this.tabPanels.add(recorder);
        p.add(recorder);
        this.tabPane.addTab(res.getString("Audio_Recorder"), p);
    }

    public static void main(String[] args) {
        String media = "./audio";
        if (args.length > 0) {
            File file = new File(args[0]);
            if (file == null || !file.isDirectory()) {
                System.out.println(res.getString("usage_java_JavaSound"));
            } else {
                media = args[0];
            }
        }
        AudioRecorderParams params = new AudioRecorderParams();
        final AudioPanel tabPanel = new AudioPanel(media, params);
        JFrame f = new JFrame(res.getString("Audio_Recorder"));
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent e) {
                tabPanel.open();
            }

            public void windowIconified(WindowEvent e) {
                tabPanel.close();
            }
        });
        f.getContentPane().add("Center", tabPanel);
        f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        f.setLocation(d.width / 2 - tabPanel.width / 2, d.height / 2 - tabPanel.height / 2);
        f.setSize(new Dimension(tabPanel.width, tabPanel.height));
        f.setVisible(true);
    }
}

