/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.audio;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import netscape.javascript.JSObject;
import org.sakaiproject.tool.assessment.audio.AudioControlContext;
import org.sakaiproject.tool.assessment.audio.AudioFormatPanel;
import org.sakaiproject.tool.assessment.audio.AudioMeterPanel;
import org.sakaiproject.tool.assessment.audio.AudioRecorderParams;
import org.sakaiproject.tool.assessment.audio.AudioSampleGraphPanel;
import org.sakaiproject.tool.assessment.audio.AudioSamplingData;
import org.sakaiproject.tool.assessment.audio.AudioUtil;
import org.sakaiproject.tool.assessment.audio.SpringUtilities;

public class AudioRecorder
extends JPanel
implements ActionListener,
AudioControlContext {
    private static final long serialVersionUID = 0L;
    static ResourceBundle res;
    static final int bufSize = 16384;
    FormatControls formatControls = null;
    Capture capture = new Capture();
    Playback playback = new Playback();
    AudioInputStream audioInputStream;
    SamplingGraph samplingGraph;
    AudioMeter audioMeter;
    Timer timer;
    JButton playB;
    JButton captB;
    JButton stopB;
    JButton saveButton;
    JTextField textField;
    DecimalFormat NoDecimalPlaces = new DecimalFormat("#0");
    JTextField rtextField;
    JLabel finishedLabel;
    JPanel samplingPanelContainer;
    JLabel statusLabel = new JLabel("", 2);
    String fileName;
    String agentId;
    String errStr;
    String mediaId;
    double duration;
    double seconds;
    int attempts;
    File file;
    Vector<Line2D> lines = new Vector();
    AudioRecorderParams params;
    String imageUrl;
    ImageIcon recordIcon = null;
    ImageIcon playIcon = null;
    ImageIcon stopIcon = null;
    Applet containingApplet = null;
    String lastButtonClicked = "";
    final String RECORD = "record";
    final String PLAY = "play";

    public AudioRecorder(AudioRecorderParams params) {
        res = AudioUtil.getInstance().getResourceBundle();
        this.fileName = res.getString("default_file_name");
        this.params = params;
        if (params.getAttemptsRemaining() == -1) {
            params.setAttemptsRemaining(params.getAttemptsAllowed());
        }
        this.imageUrl = params.getImageUrl();
        try {
            this.recordIcon = new ImageIcon(new URL(this.imageUrl + "/audio_record.gif"));
            this.playIcon = new ImageIcon(new URL(this.imageUrl + "/audio_play.gif"));
            this.stopIcon = new ImageIcon(new URL(this.imageUrl + "/audio_stop.gif"));
        }
        catch (Exception ex) {
            this.reportStatus("**** cannot create image icons for applet:" + ex.toString());
        }
        EmptyBorder eb = new EmptyBorder(5, 5, 5, 5);
        SoftBevelBorder sbb = new SoftBevelBorder(1);
        CompoundBorder b = new CompoundBorder(eb, sbb);
        this.formatControls = new FormatControls(params);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 1));
        p2.add("West", this.makeAttemptsAllowedLabel());
        p2.add(this.makeAudioButtonsPanel());
        this.samplingGraph = new SamplingGraph();
        this.audioMeter = new AudioMeter(params.getImageUrl());
        this.samplingPanelContainer = this.makeAudioSamplingPanelContainer(b);
        this.samplingPanelContainer.add(this.audioMeter);
        p2.add(this.samplingPanelContainer);
        JPanel savePanel = new JPanel();
        savePanel.setLayout(new BoxLayout(savePanel, 1));
        JPanel saveTFpanel = this.makeSaveTFPanel();
        savePanel.add(saveTFpanel);
        p2.add(savePanel);
        this.add(p2);
    }

    private JPanel makeSaveTFPanel() {
        FlowLayout flow = new FlowLayout();
        SpringLayout spring = new SpringLayout();
        JPanel saveTFpanel = new JPanel(spring);
        JLabel flabel = new JLabel(res.getString("current_recordig_length"), 2);
        JLabel rlabel = new JLabel(res.getString("attempts_remaining"), 2);
        saveTFpanel.add(flabel);
        this.textField = new JTextField("" + this.params.getCurrentRecordingLength());
        saveTFpanel.add(this.textField);
        saveTFpanel.add(rlabel);
        if (this.params.getAttemptsRemaining() >= 9999) {
            this.rtextField = new JTextField("Unlimited");
            saveTFpanel.add(this.rtextField);
        } else if (this.params.getAttemptsRemaining() > 0 && this.params.getAttemptsRemaining() < 9999) {
            this.rtextField = new JTextField("" + this.params.getAttemptsRemaining());
            saveTFpanel.add(this.rtextField);
        } else {
            this.rtextField = new JTextField("0");
            saveTFpanel.add(this.rtextField);
        }
        this.textField.setEditable(false);
        this.rtextField.setEditable(false);
        Font font = new Font("Ariel", 0, 14);
        flabel.setFont(font);
        rlabel.setFont(font);
        this.textField.setFont(font);
        this.rtextField.setFont(font);
        SpringUtilities.makeCompactGrid(saveTFpanel, 2, 2, 5, 5, 5, 5);
        return saveTFpanel;
    }

    private JPanel makeAudioButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridLayout(2, 4));
        buttonsPanel.add(new JLabel(""));
        buttonsPanel.add(new JLabel(""));
        buttonsPanel.add(new JLabel(""));
        this.finishedLabel = new JLabel(res.getString("Finished"));
        this.finishedLabel.setForeground(Color.red);
        Font f = this.finishedLabel.getFont();
        this.finishedLabel.setFont(f.deriveFont(f.getStyle() ^ 1));
        buttonsPanel.add(this.finishedLabel);
        this.captB = this.params.getAttemptsRemaining() > 0 || this.params.getAttemptsRemaining() == -1 ? this.addButton(res.getString("Record"), buttonsPanel, true, this.params.isEnableRecord()) : this.addButton(res.getString("Record"), buttonsPanel, false, this.params.isEnableRecord());
        if (this.recordIcon != null) {
            this.captB.setIcon(this.recordIcon);
        }
        this.stopB = this.addButton(res.getString("Stop"), buttonsPanel, false, this.params.isEnableStop());
        if (this.stopIcon != null) {
            this.stopB.setIcon(this.stopIcon);
        }
        this.playB = this.addButton(res.getString("Play"), buttonsPanel, false, this.params.isEnablePlay());
        if (this.playIcon != null) {
            this.playB.setIcon(this.playIcon);
        }
        this.saveButton = this.addButton(res.getString("Save_and_close"), 1, buttonsPanel, false, this.params.isEnableSave());
        return buttonsPanel;
    }

    private JButton addButton(String name, int style, JPanel p, boolean state, boolean visible) {
        JButton b = new JButton(name);
        Font f = b.getFont();
        b.setFont(f.deriveFont(f.getStyle() ^ style));
        b.addActionListener(this);
        b.setEnabled(state);
        b.setVisible(visible);
        p.add(b);
        return b;
    }

    private JPanel makeAudioSamplingPanelContainer(Border b) {
        JPanel samplingPanel = new JPanel(new BorderLayout());
        samplingPanel.setBorder(b);
        samplingPanel.setPreferredSize(new Dimension(225, 150));
        return samplingPanel;
    }

    public void open() {
    }

    public void close() {
        if (this.playback.thread != null) {
            this.playB.doClick(0);
        }
        if (this.capture.thread != null) {
            this.captB.doClick(0);
        }
    }

    private JButton addButton(String name, JPanel p, boolean state, boolean visible) {
        return this.addButton(name, 0, p, state, visible);
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        this.statusLabel.setVisible(false);
        this.statusLabel.setText("");
        if (obj.equals(this.playB)) {
            this.lastButtonClicked = "play";
            this.playback.start();
            this.samplingGraph.start();
            this.captB.setEnabled(false);
            this.stopB.setEnabled(true);
            this.playB.setEnabled(false);
        } else if (obj.equals(this.captB)) {
            this.lastButtonClicked = "record";
            if (this.containingApplet != null) {
                JSObject openingWindow = (JSObject)JSObject.getWindow((Applet)this.containingApplet).getMember("opener");
                openingWindow.call("disableSubmitForGrade", null);
                openingWindow.call("disableSave", null);
            }
            this.file = null;
            this.capture.start();
            this.fileName = res.getString("default_file_name");
            this.samplingGraph.start();
            this.audioMeter.start();
            this.captB.setEnabled(false);
            this.playB.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.samplingPanelContainer.remove(this.samplingGraph);
            this.samplingPanelContainer.add(this.audioMeter);
            this.stopB.setEnabled(true);
            this.startTimer();
        } else if (obj.equals(this.stopB)) {
            if ("record".equals(this.lastButtonClicked)) {
                this.statusLabel.setText(res.getString("processing"));
                this.statusLabel.setVisible(true);
                this.playB.setEnabled(false);
                this.captB.setEnabled(false);
                this.saveButton.setEnabled(false);
                this.stopB.setEnabled(false);
                this.audioMeter.stop();
                this.samplingPanelContainer.remove(this.audioMeter);
                this.samplingPanelContainer.add(this.samplingGraph);
                this.captureAudio();
            } else if ("play".equals(this.lastButtonClicked)) {
                this.playback.stop();
                this.samplingGraph.stop();
                if (this.params.getAttemptsAllowed() > 0) {
                    if (this.attempts == 0) {
                        this.captB.setEnabled(false);
                    } else {
                        this.captB.setEnabled(true);
                    }
                    this.stopB.setEnabled(false);
                    this.playB.setEnabled(true);
                }
            }
        } else if (obj.equals(this.saveButton)) {
            this.saveButton.setEnabled(false);
            this.captB.setEnabled(false);
            this.playB.setEnabled(false);
            this.statusLabel.setText(res.getString("processing"));
            this.statusLabel.setVisible(true);
            this.saveMedia();
        }
    }

    public JPanel getFormatControlsPanel() {
        return this.formatControls;
    }

    public void createAudioInputStream(File file, boolean updateComponents) {
        if (file != null && file.isFile()) {
            try {
                this.file = file;
                this.errStr = null;
                this.audioInputStream = AudioSystem.getAudioInputStream(file);
                this.fileName = file.getName();
                long milliseconds = (long)((float)(this.audioInputStream.getFrameLength() * 1000L) / this.audioInputStream.getFormat().getFrameRate());
                this.duration = (double)milliseconds / 1000.0;
                if (updateComponents) {
                    this.formatControls.setFormat(this.audioInputStream.getFormat());
                    this.samplingGraph.createWaveForm(null, this.lines, this.audioInputStream);
                }
            }
            catch (Exception ex) {
                this.reportStatus(ex.toString());
            }
        } else {
            this.reportStatus(res.getString("Audio_file_required_"));
        }
    }

    public void saveAndPost(InputStream inputStream, final AudioFileFormat.Type audioType, final String urlString, int attemptsLeft, final boolean post) {
        Thread saveAndPostThread = new Thread(){

            public void run() {
                while (AudioRecorder.this.audioInputStream == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    AudioRecorder.this.audioInputStream.reset();
                }
                catch (Exception ex) {
                    AudioRecorder.this.reportStatus(res.getString("Unable_to_reset") + ex);
                    return;
                }
                if (post) {
                    AudioRecorder.this.postAudio(audioType, urlString);
                }
                if (AudioRecorder.this.containingApplet != null) {
                    JSObject window = JSObject.getWindow((Applet)AudioRecorder.this.containingApplet);
                    JSObject opener = (JSObject)window.getMember("opener");
                    opener.call("clickReloadLink", window);
                    window.call("close", null);
                }
            }
        };
        saveAndPostThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAudio(AudioFileFormat.Type audioType, String urlString) {
        String suffix = this.getAudioSuffix();
        try {
            this.agentId = this.params.getAgentId();
            String queryString = "&agent=" + this.agentId + "&lastDuration=" + this.duration + "&suffix=" + suffix + "&attempts=" + this.attempts;
            URL url = new URL(urlString + queryString);
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("CONTENT-TYPE", this.getMimeType(audioType));
            OutputStream outputStream = urlConn.getOutputStream();
            BufferedReader input = null;
            try {
                String str;
                int c = AudioSystem.write(this.audioInputStream, audioType, outputStream);
                if (c <= 0) {
                    throw new IOException(res.getString("Problems_writing_to"));
                }
                outputStream.flush();
                outputStream.close();
                input = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
                StringBuilder responseBuf = new StringBuilder();
                while (null != (str = input.readLine())) {
                    responseBuf.append(str);
                }
                String response = responseBuf.toString();
                input.close();
                this.mediaId = response;
            }
            catch (Exception ex) {
                this.reportStatus(ex.toString());
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        catch (IOException ex) {
            this.reportStatus(ex.toString());
        }
    }

    private void reportStatus(String msg) {
        this.errStr = msg;
        if (this.errStr != null) {
            System.out.println(this.errStr);
            this.samplingGraph.repaint();
        }
    }

    public static void main(String[] s) {
        AudioRecorderParams params = new AudioRecorderParams();
        AudioRecorder capturePlayback = new AudioRecorder(params);
        capturePlayback.open();
        JFrame f = new JFrame(res.getString("Capture_Playback"));
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add("Center", capturePlayback);
        f.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 600;
        int h = 250;
        f.setLocation(screenSize.width / 2 - w / 2, screenSize.height / 2 - h / 2);
        f.setSize(w, h);
        f.setVisible(true);
    }

    private JPanel makeAttemptsAllowedLabel() {
        GridLayout grid = new GridLayout(2, 3);
        JPanel panel = new JPanel(grid);
        JLabel label1 = new JLabel(res.getString("attempts_allowed") + " " + this.params.getAttemptsAllowed(), 2);
        if (this.params.getAttemptsAllowed() >= 9999) {
            label1 = new JLabel(res.getString("attempts_allowed") + " " + res.getString("unlimited"), 2);
        }
        JLabel label2 = new JLabel(res.getString("time_limit") + " " + this.params.getMaxSeconds() + " sec", 2);
        Font font = new Font("Ariel", 0, 14);
        label1.setFont(font);
        label2.setFont(font);
        Font statusFont = new Font("Ariel", 1, 12);
        this.statusLabel = new JLabel("", 0);
        this.statusLabel.setFont(statusFont);
        this.statusLabel.setForeground(Color.red);
        panel.add(label2);
        panel.add(this.statusLabel);
        panel.add(label1);
        return panel;
    }

    private String getAudioSuffix() {
        String suffix = "au";
        if (this.params.isSaveWave()) {
            suffix = "wav";
        }
        if (this.params.isSaveAiff()) {
            suffix = "aif";
        }
        return suffix;
    }

    private AudioFileFormat.Type getAudioType() {
        AudioFileFormat.Type type = AudioFileFormat.Type.AU;
        if (this.params.isSaveWave()) {
            type = AudioFileFormat.Type.WAVE;
        }
        if (this.params.isSaveAiff()) {
            type = AudioFileFormat.Type.AIFF;
        }
        return type;
    }

    private void saveMedia() {
        AudioFileFormat.Type type = this.getAudioType();
        if (this.params.isSaveToUrl()) {
            this.saveAndPost(this.audioInputStream, type, this.params.getUrl(), this.attempts, true);
        } else {
            this.saveAndPost(this.audioInputStream, type, this.params.getUrl(), this.attempts, false);
        }
    }

    private String getMimeType(AudioFileFormat.Type audioType) {
        String mimeType = "audio/basic";
        if (audioType.equals(AudioFileFormat.Type.AIFF)) {
            mimeType = "audio/x-aiff";
        } else if (audioType.equals(AudioFileFormat.Type.WAVE)) {
            mimeType = "audio/x-wav";
        }
        return mimeType;
    }

    private void captureAudio() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.lines.removeAllElements();
        this.capture.stop();
        this.samplingGraph.stop();
        boolean retry = true;
        while (this.audioInputStream == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            this.audioInputStream.reset();
        }
        catch (Exception ex) {
            this.reportStatus(res.getString("Unable_to_reset") + ex);
            return;
        }
        this.statusLabel.setVisible(false);
        this.statusLabel.setText("");
        this.playB.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.attempts = this.params.getAttemptsRemaining();
        if (this.attempts > 0 && this.attempts < 9999) {
            this.params.setAttemptsRemaining(--this.attempts);
            this.rtextField.setText("" + this.attempts);
        }
        if (this.attempts == 0) {
            this.captB.setEnabled(false);
        } else {
            this.captB.setEnabled(true);
        }
        if (this.duration > (double)this.params.getMaxSeconds()) {
            this.textField.setText(this.NoDecimalPlaces.format(this.params.getMaxSeconds()));
        } else {
            this.textField.setText(this.NoDecimalPlaces.format(this.duration));
        }
        this.samplingGraph.repaint();
        if (this.containingApplet != null) {
            JSObject openingWindow = (JSObject)JSObject.getWindow((Applet)this.containingApplet).getMember("opener");
            openingWindow.call("enableSubmitForGrade", null);
            openingWindow.call("enableSave", null);
        }
    }

    private void startTimer() {
        AbstractAction stopRecordingAction = new AbstractAction(){
            private static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent e) {
                AudioRecorder.this.statusLabel.setText(res.getString("time_expired"));
                AudioRecorder.this.statusLabel.setVisible(true);
                AudioRecorder.this.captB.setEnabled(false);
                AudioRecorder.this.stopB.setEnabled(false);
                AudioRecorder.this.playB.setEnabled(false);
                AudioRecorder.this.saveButton.setEnabled(false);
                AudioRecorder.this.audioMeter.stop();
                AudioRecorder.this.samplingPanelContainer.remove(AudioRecorder.this.audioMeter);
                AudioRecorder.this.samplingPanelContainer.add(AudioRecorder.this.samplingGraph);
                AudioRecorder.this.captureAudio();
            }
        };
        this.timer = new Timer(this.params.getMaxSeconds() * 1000 + 1000, stopRecordingAction);
        this.timer.start();
    }

    public void createAudioInputStream(String mediaUrl, boolean updateComponents) {
        try {
            URL url = new URL(mediaUrl);
            this.audioInputStream = AudioSystem.getAudioInputStream(url);
            long milliseconds = (long)((float)(this.audioInputStream.getFrameLength() * 1000L) / this.audioInputStream.getFormat().getFrameRate());
            this.duration = (double)milliseconds / 1000.0;
            System.out.println("*****createAudioInpuStream= " + this.audioInputStream);
            System.out.println("*** duration= " + this.duration);
            if (updateComponents) {
                this.formatControls.setFormat(this.audioInputStream.getFormat());
                System.out.println("*** calling samplingGraph.createWaveForm");
                this.samplingGraph.createWaveForm(null, this.lines, this.audioInputStream);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public Applet getContainingApplet() {
        return this.containingApplet;
    }

    public void setContainingApplet(Applet containingApplet) {
        this.containingApplet = containingApplet;
    }

    class AudioMeter
    extends AudioMeterPanel
    implements Runnable {
        private static final long serialVersionUID = 0L;

        public AudioMeter(String imageUrl) {
            super(imageUrl);
        }

        public void start() {
            this.animator = new Thread(this);
            this.animator.start();
        }

        public void stop() {
            this.animator = null;
            this.offImage = null;
            this.offGraphics = null;
        }

        public void run() {
            long tm = System.currentTimeMillis();
            while (Thread.currentThread() == this.animator) {
                this.repaint();
                try {
                    Thread.sleep(Math.max(0L, (tm += (long)this.delay) - System.currentTimeMillis()));
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    class SamplingGraph
    extends AudioSampleGraphPanel
    implements Runnable {
        private static final long serialVersionUID = 0L;
        private Thread thread;

        SamplingGraph() {
        }

        public void reportGraphStatus(String message) {
            AudioRecorder.this.reportStatus(message);
        }

        public void paint(Graphics g) {
            AudioSamplingData data = new AudioSamplingData();
            data.setAudioInputStream(AudioRecorder.this.audioInputStream);
            data.setCapture(AudioRecorder.this.capture);
            data.setCaptureThread(AudioRecorder.this.capture.thread);
            data.setDuration(AudioRecorder.this.duration);
            data.setErrStr(AudioRecorder.this.errStr);
            data.setFileName(AudioRecorder.this.fileName);
            data.setLine(AudioRecorder.this.lines);
            data.setSeconds(AudioRecorder.this.seconds);
            data.setMaxSeconds(AudioRecorder.this.params.getMaxSeconds());
            this.paintData(g, data);
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName(AudioSampleGraphPanel.res.getString("thread_Name2"));
            this.thread.start();
            AudioRecorder.this.seconds = 0.0;
        }

        public void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        public void run() {
            AudioRecorder.this.seconds = 0.0;
            block4: while (this.thread != null) {
                if (AudioRecorder.this.playback.line != null && AudioRecorder.this.playback.line.isOpen()) {
                    long milliseconds = AudioRecorder.this.playback.line.getMicrosecondPosition() / 1000L;
                    AudioRecorder.this.seconds = (double)milliseconds / 1000.0;
                } else if (AudioRecorder.this.capture.line != null && AudioRecorder.this.capture.line.isActive()) {
                    long milliseconds = AudioRecorder.this.capture.line.getMicrosecondPosition() / 1000L;
                    AudioRecorder.this.seconds = (double)milliseconds / 1000.0;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    break;
                }
                this.repaint();
                while (AudioRecorder.this.capture.line != null && !AudioRecorder.this.capture.line.isActive() || AudioRecorder.this.playback.line != null && !AudioRecorder.this.playback.line.isOpen()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception e) {
                        continue block4;
                    }
                }
            }
            AudioRecorder.this.seconds = 0.0;
            this.repaint();
        }
    }

    class FormatControls
    extends AudioFormatPanel
    implements AudioControlContext {
        private static final long serialVersionUID = 0L;

        FormatControls(AudioRecorderParams params) {
            super(params);
        }

        public void open() {
        }

        public void close() {
            if (AudioRecorder.this.playback.thread != null) {
                AudioRecorder.this.playB.doClick(0);
            }
            if (AudioRecorder.this.capture.thread != null) {
                AudioRecorder.this.captB.doClick(0);
            }
        }
    }

    class Capture
    implements Runnable {
        TargetDataLine line;
        Thread thread;

        Capture() {
        }

        public void start() {
            AudioRecorder.this.errStr = null;
            this.thread = new Thread(this);
            this.thread.setName(res.getString("thread_Name1"));
            this.thread.start();
        }

        public void stop() {
            this.thread = null;
        }

        private void shutDown(String message) {
            AudioRecorder.this.errStr = message;
            if (AudioRecorder.this.errStr != null && this.thread != null) {
                this.thread = null;
                AudioRecorder.this.samplingGraph.stop();
                AudioRecorder.this.playB.setEnabled(true);
                AudioRecorder.this.saveButton.setEnabled(true);
                System.err.println(AudioRecorder.this.errStr);
                AudioRecorder.this.samplingGraph.repaint();
            }
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public class Playback
    implements Runnable {
        SourceDataLine line;
        Thread thread;

        public void start() {
            AudioRecorder.this.errStr = null;
            this.thread = new Thread(this);
            this.thread.setName(res.getString("thread_Name"));
            this.thread.start();
        }

        public void stop() {
            this.thread = null;
        }

        private void shutDown(String message) {
            AudioRecorder.this.errStr = message;
            if (AudioRecorder.this.errStr != null) {
                System.err.println(AudioRecorder.this.errStr);
                AudioRecorder.this.samplingGraph.repaint();
            }
            if (this.thread != null) {
                this.thread = null;
                AudioRecorder.this.samplingGraph.stop();
                if (AudioRecorder.this.params.getAttemptsAllowed() > 0) {
                    if (AudioRecorder.this.attempts == 0) {
                        AudioRecorder.this.captB.setEnabled(false);
                    } else {
                        AudioRecorder.this.captB.setEnabled(true);
                    }
                }
                AudioRecorder.this.playB.setEnabled(true);
                AudioRecorder.this.stopB.setEnabled(false);
            }
        }

        public void run() {
            if (AudioRecorder.this.file != null) {
                AudioRecorder.this.createAudioInputStream(AudioRecorder.this.file, false);
            }
            if (AudioRecorder.this.audioInputStream == null) {
                this.shutDown(res.getString("No_loaded_audio_to1"));
                return;
            }
            try {
                AudioRecorder.this.audioInputStream.reset();
            }
            catch (Exception e) {
                this.shutDown(res.getString("Unable_to_reset_the") + e);
                return;
            }
            AudioFormat format = AudioRecorder.this.formatControls.getFormat();
            AudioInputStream playbackInputStream = AudioSystem.getAudioInputStream(format, AudioRecorder.this.audioInputStream);
            if (playbackInputStream == null) {
                this.shutDown(res.getString("Unable_to_convert") + AudioRecorder.this.audioInputStream + res.getString("to_format") + format);
                return;
            }
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                this.shutDown(res.getString("Line_matching") + info + res.getString("not_supported_"));
                return;
            }
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(format, 16384);
            }
            catch (LineUnavailableException ex) {
                this.shutDown(res.getString("Unable_to_open_the") + ex);
                return;
            }
            int frameSizeInBytes = format.getFrameSize();
            int bufferLengthInFrames = this.line.getBufferSize() / 8;
            int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
            byte[] data = new byte[bufferLengthInBytes];
            int numBytesRead = 0;
            this.line.start();
            while (this.thread != null) {
                try {
                    numBytesRead = playbackInputStream.read(data);
                    if (numBytesRead == -1) break;
                    for (int numBytesRemaining = numBytesRead; numBytesRemaining > 0; numBytesRemaining -= this.line.write(data, 0, numBytesRemaining)) {
                    }
                }
                catch (Exception e) {
                    this.shutDown(res.getString("Error_during_playback") + e);
                    break;
                }
            }
            if (this.thread != null) {
                this.line.drain();
            }
            this.line.stop();
            this.line.close();
            this.line = null;
            this.shutDown(null);
        }
    }
}

