/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.audio;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.JPanel;
import org.sakaiproject.tool.assessment.audio.AudioSamplingData;
import org.sakaiproject.tool.assessment.audio.AudioUtil;
import org.sakaiproject.tool.assessment.audio.ColorModel;

public class AudioSampleGraphPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    static ResourceBundle res = AudioUtil.getInstance().getResourceBundle();
    static ColorModel colorModel = new ColorModel();
    private static final Font font10 = new Font("serif", 0, 10);
    private static final Font font12 = new Font("serif", 0, 12);
    private static final Color graphColor = colorModel.getColor("graphColor");
    private static final Color currentPositionColor = colorModel.getColor("graphCurrentPositionColor");
    private static final Color backgroundColor = colorModel.getColor("graphBackgroundColor");
    private static final Color gridColor = colorModel.getColor("graphGridColor");

    public AudioSampleGraphPanel() {
        this.setBackground(backgroundColor);
    }

    public void reportGraphStatus(String msg) {
        System.out.println("Status: " + msg);
    }

    public void createWaveForm(byte[] audioBytes, Vector<Line2D> lines, AudioInputStream audioInputStream) {
        int i;
        int nlengthInSamples;
        lines.removeAllElements();
        AudioFormat format = audioInputStream.getFormat();
        if (audioBytes == null) {
            try {
                audioBytes = new byte[(int)(audioInputStream.getFrameLength() * (long)format.getFrameSize())];
                audioInputStream.read(audioBytes);
            }
            catch (Exception ex) {
                this.reportGraphStatus(ex.toString());
                return;
            }
        }
        Dimension d = this.getParent().getSize();
        int w = d.width;
        int h = d.height - 15;
        int[] audioData = null;
        if (format.getSampleSizeInBits() == 16) {
            nlengthInSamples = audioBytes.length / 2;
            audioData = new int[nlengthInSamples];
            if (format.isBigEndian()) {
                for (i = 0; i < nlengthInSamples; ++i) {
                    byte MSB = audioBytes[2 * i];
                    byte LSB = audioBytes[2 * i + 1];
                    audioData[i] = MSB << 8 | 0xFF & LSB;
                }
            } else {
                for (i = 0; i < nlengthInSamples; ++i) {
                    byte LSB = audioBytes[2 * i];
                    byte MSB = audioBytes[2 * i + 1];
                    audioData[i] = MSB << 8 | 0xFF & LSB;
                }
            }
        } else if (format.getSampleSizeInBits() == 8) {
            nlengthInSamples = audioBytes.length;
            audioData = new int[nlengthInSamples];
            if (format.getEncoding().toString().startsWith(res.getString("PCM_SIGN"))) {
                for (i = 0; i < audioBytes.length; ++i) {
                    audioData[i] = audioBytes[i];
                }
            } else {
                for (i = 0; i < audioBytes.length; ++i) {
                    audioData[i] = audioBytes[i] - 128;
                }
            }
        }
        int frames_per_pixel = audioBytes.length / format.getFrameSize() / w;
        byte my_byte = 0;
        double y_last = 0.0;
        int numChannels = format.getChannels();
        int signalPeak = 0;
        for (double x = 0.0; x < (double)w && audioData != null; x += 1.0) {
            int idx = (int)((double)(frames_per_pixel * numChannels) * x);
            my_byte = format.getSampleSizeInBits() == 8 ? (byte)audioData[idx] : (byte)(128 * audioData[idx] / 32768);
            if (Math.abs(my_byte) <= signalPeak) continue;
            signalPeak = Math.abs(my_byte);
        }
        double scaleFactor = 128.0 / (double)signalPeak;
        for (double x = 0.0; x < (double)w && audioData != null; x += 1.0) {
            int idx = (int)((double)(frames_per_pixel * numChannels) * x);
            my_byte = format.getSampleSizeInBits() == 8 ? (byte)audioData[idx] : (byte)(128 * audioData[idx] / 32768);
            double y_new = (double)h * (128.0 - (double)my_byte * scaleFactor) / 256.0;
            lines.add(new Line2D.Double(x, y_last, x, y_new));
            y_last = y_new;
        }
        this.repaint();
    }

    public void paintData(Graphics g, AudioSamplingData data) {
        AudioInputStream audioInputStream = data.getAudioInputStream();
        Vector<Line2D> lines = data.getLine();
        String errStr = data.getErrStr();
        Runnable capture = data.getCapture();
        Thread captureThread = data.getCaptureThread();
        double seconds = data.getSeconds();
        String fileName = data.getFileName();
        double duration = data.getDuration();
        double maxSeconds = data.getMaxSeconds();
        Dimension d = this.getSize();
        int w = d.width;
        int h = d.height;
        int INFOPAD = 15;
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(this.getBackground());
        g2.clearRect(0, 0, w, h);
        g2.setColor(colorModel.getColor("darkColor"));
        g2.fillRect(0, h - INFOPAD, w, INFOPAD);
        int gridHeight = h - INFOPAD - 2;
        this.drawGrid(g2, w, gridHeight);
        if (errStr != null) {
            this.drawErrorText(errStr, w, g2);
        } else if (captureThread != null) {
            if (seconds > maxSeconds) {
                this.drawLengthText(maxSeconds, h, g2);
            } else {
                this.drawLengthText(seconds, h, g2);
            }
        } else {
            if (duration > maxSeconds) {
                this.drawFileLengthText(seconds, fileName, maxSeconds, h, g2);
            } else {
                this.drawFileLengthText(seconds, fileName, duration, h, g2);
            }
            if (audioInputStream != null) {
                this.drawSamplingGraph(lines, g2);
                if (seconds != 0.0) {
                    this.drawCurrentPosition(seconds, duration, w, h, INFOPAD, g2);
                }
            }
        }
    }

    private void drawGrid(Graphics2D g2, int w, int h) {
        g2.setColor(gridColor);
        for (int x = 0; x < w; x += 10) {
            g2.draw(new Line2D.Double(x, 0.0, x, h));
        }
        for (int y = 0; y < h; y += 10) {
            g2.draw(new Line2D.Double(0.0, y, w, y));
        }
    }

    private void drawCurrentPosition(double seconds, double duration, int w, int h, int INFOPAD, Graphics2D g2) {
        double loc = seconds / duration * (double)w;
        g2.setColor(currentPositionColor);
        g2.setStroke(new BasicStroke(3.0f));
        g2.draw(new Line2D.Double(loc, 0.0, loc, h - INFOPAD - 2));
    }

    private void drawSamplingGraph(Vector<Line2D> lines, Graphics2D g2) {
        g2.setColor(graphColor);
        for (int i = 1; i < lines.size(); ++i) {
            g2.draw(lines.get(i));
        }
    }

    private void drawFileLengthText(double seconds, String fileName, double duration, int h, Graphics2D g2) {
        g2.setColor(graphColor);
        g2.setFont(font12);
        g2.drawString(res.getString("Length_1") + String.valueOf(duration), 3, h - 4);
    }

    private void drawLengthText(double seconds, int h, Graphics2D g2) {
        g2.setColor(graphColor);
        g2.setFont(font12);
        g2.drawString(res.getString("Length_") + String.valueOf(seconds), 3, h - 4);
    }

    private void drawErrorText(String errStr, int w, Graphics2D g2) {
        g2.setColor(colorModel.getColor("alertColor"));
        g2.setFont(new Font(res.getString("g2_Font"), 1, 20));
        g2.drawString(res.getString("ERROR"), 5, 20);
        AttributedString as = new AttributedString(errStr);
        as.addAttribute(TextAttribute.FONT, font12, 0, errStr.length());
        AttributedCharacterIterator aci = as.getIterator();
        FontRenderContext frc = g2.getFontRenderContext();
        LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
        float x = 5.0f;
        float y = 25.0f;
        lbm.setPosition(0);
        while (lbm.getPosition() < errStr.length()) {
            TextLayout tl = lbm.nextLayout((float)w - x - 5.0f);
            if (!tl.isLeftToRight()) {
                x = (float)w - tl.getAdvance();
            }
            tl.draw(g2, x, y += tl.getAscent());
            y += tl.getDescent() + tl.getLeading();
        }
    }
}

