/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.audio;

import java.applet.Applet;
import java.io.Serializable;
import org.sakaiproject.tool.assessment.audio.AudioUtil;

public class AudioRecorderParams
implements Serializable {
    private boolean enablePlay = true;
    private boolean enableRecord = true;
    private boolean enablePause = true;
    private boolean enableSave = true;
    private boolean enableLoad = false;
    private boolean enableStop = true;
    private boolean saveAu = true;
    private boolean saveWave = true;
    private boolean saveAiff = true;
    private boolean saveToFile = true;
    private boolean saveToUrl = false;
    private String fileName = "audio";
    private String url = "";
    private String compression = "linear";
    private int frequency = 8000;
    private int bits = 8;
    private boolean signed = true;
    private boolean bigendian = true;
    private boolean stereo = false;
    private int maxSeconds = 60;
    private int attemptsAllowed = 5;
    private String imageUrl = "";
    private String agentId = "";
    private String questionId = "";
    private String localeLanguage = "";
    private String localeCountry = "";
    private int attemptsRemaining = -1;
    private int currentRecordingLength = 0;
    public static final String[] compressionAllowed = new String[]{"ulaw", "alaw", "linear"};
    public static final int[] frequenciesAllowed = new int[]{8000, 11025, 16000, 22050, 44100};
    public static int[] bitsAllowed = new int[]{8, 16};

    public AudioRecorderParams() {
    }

    public AudioRecorderParams(Applet applet) {
        String s = applet.getParameter("enablePlay");
        if ("true".equalsIgnoreCase(s)) {
            this.enablePlay = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.enablePlay = false;
        }
        s = applet.getParameter("enableRecord");
        if ("true".equalsIgnoreCase(s)) {
            this.enableRecord = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.enableRecord = false;
        }
        s = applet.getParameter("enablePause");
        if ("true".equalsIgnoreCase(s)) {
            this.enablePause = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.enablePause = false;
        }
        s = applet.getParameter("enableLoad");
        if ("true".equalsIgnoreCase(s)) {
            this.enableLoad = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.enableLoad = false;
        }
        s = applet.getParameter("enableStop");
        if ("true".equalsIgnoreCase(s)) {
            this.enableStop = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.enableStop = false;
        }
        s = applet.getParameter("saveAu");
        if ("true".equalsIgnoreCase(s)) {
            this.saveAu = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.saveAu = false;
        }
        s = applet.getParameter("saveWave");
        if ("true".equalsIgnoreCase(s)) {
            this.saveWave = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.saveWave = false;
        }
        s = applet.getParameter("saveAiff");
        if ("true".equalsIgnoreCase(s)) {
            this.saveAiff = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.saveAiff = false;
        }
        s = applet.getParameter("saveToFile");
        if ("true".equalsIgnoreCase(s)) {
            this.saveToFile = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.saveToFile = false;
        }
        s = applet.getParameter("saveToUrl");
        if ("true".equalsIgnoreCase(s)) {
            this.saveToUrl = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.saveToUrl = false;
        }
        s = applet.getParameter("fileName");
        if (s != null) {
            this.fileName = s;
        }
        if ((s = applet.getParameter("url")) != null) {
            this.url = s;
        }
        if ((s = applet.getParameter("compression")) != null) {
            int i = 0;
            while (true) {
                if (i >= compressionAllowed.length) break;
                if (compressionAllowed[i].equalsIgnoreCase(s)) {
                    this.compression = compressionAllowed[i];
                }
                ++i;
            }
        }
        if ((s = applet.getParameter("frequency")) != null) {
            int f = 0;
            try {
                f = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            int i = 0;
            while (true) {
                if (i >= frequenciesAllowed.length) break;
                if (frequenciesAllowed[i] == f) {
                    this.frequency = f;
                }
                ++i;
            }
        }
        if ((s = applet.getParameter("bits")) != null) {
            int b = 0;
            try {
                b = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            int i = 0;
            while (true) {
                if (i >= bitsAllowed.length) break;
                if (bitsAllowed[i] == b) {
                    this.bits = b;
                }
                ++i;
            }
        }
        if ("true".equalsIgnoreCase(s = applet.getParameter("signed"))) {
            this.signed = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.signed = false;
        }
        s = applet.getParameter("bigendian");
        if ("true".equalsIgnoreCase(s)) {
            this.bigendian = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.bigendian = false;
        }
        s = applet.getParameter("stereo");
        if ("true".equalsIgnoreCase(s)) {
            this.stereo = true;
        } else if ("false".equalsIgnoreCase(s)) {
            this.stereo = false;
        }
        s = applet.getParameter("maxSeconds");
        if (s != null) {
            try {
                this.maxSeconds = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        if ((s = applet.getParameter("attemptsAllowed")) != null) {
            try {
                this.attemptsAllowed = Integer.parseInt(s);
            }
            catch (NumberFormatException ex1) {
                ex1.printStackTrace();
            }
        }
        if ((s = applet.getParameter("attemptsRemaining")) != null && !"".equals(s)) {
            try {
                this.attemptsRemaining = Integer.parseInt(s);
            }
            catch (NumberFormatException ex1) {
                ex1.printStackTrace();
            }
        }
        if ((s = applet.getParameter("currentRecordingLength")) != null) {
            try {
                this.currentRecordingLength = Integer.parseInt(s);
            }
            catch (NumberFormatException ex1) {
                ex1.printStackTrace();
            }
        }
        if ((s = applet.getParameter("imageUrl")) != null) {
            this.imageUrl = s;
        }
        if ((s = applet.getParameter("agentId")) != null) {
            this.agentId = s;
        }
        if ((s = applet.getParameter("questionId")) != null) {
            this.questionId = s;
        }
        if ((s = applet.getParameter("localeLanguage")) != null) {
            this.localeLanguage = s;
            AudioUtil.getInstance().setLocaleLanguage(s);
        }
        if ((s = applet.getParameter("localeCountry")) != null) {
            this.localeCountry = s;
            AudioUtil.getInstance().setLocaleCountry(s);
        }
    }

    public boolean isBigendian() {
        return this.bigendian;
    }

    public int getBits() {
        return this.bits;
    }

    public String getCompression() {
        return this.compression;
    }

    public boolean isEnableLoad() {
        return this.enableLoad;
    }

    public boolean isEnablePause() {
        return this.enablePause;
    }

    public boolean isEnablePlay() {
        return this.enablePlay;
    }

    public boolean isEnableRecord() {
        return this.enableRecord;
    }

    public boolean isEnableSave() {
        return this.enableSave;
    }

    public boolean isEnableStop() {
        return this.enableStop;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getMaxSeconds() {
        return this.maxSeconds;
    }

    public int getCurrentRecordingLength() {
        return this.currentRecordingLength;
    }

    public int getAttemptsAllowed() {
        return this.attemptsAllowed;
    }

    public int getAttemptsRemaining() {
        return this.attemptsRemaining;
    }

    public boolean isSaveAiff() {
        return this.saveAiff;
    }

    public boolean isSaveAu() {
        return this.saveAu;
    }

    public boolean isSaveToFile() {
        return this.saveToFile;
    }

    public boolean isSaveToUrl() {
        return this.saveToUrl;
    }

    public boolean isSaveWave() {
        return this.saveWave;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isStereo() {
        return this.stereo;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setStereo(boolean stereo) {
        this.stereo = stereo;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public void setSaveWave(boolean saveWave) {
        this.saveWave = saveWave;
    }

    public void setSaveToUrl(boolean saveToUrl) {
        this.saveToUrl = saveToUrl;
    }

    public void setSaveToFile(boolean saveToFile) {
        this.saveToFile = saveToFile;
    }

    public void setSaveAu(boolean saveAu) {
        this.saveAu = saveAu;
    }

    public void setSaveAiff(boolean saveAiff) {
        this.saveAiff = saveAiff;
    }

    public void setAttemptsAllowed(int attemptsAllowed) {
        this.attemptsAllowed = attemptsAllowed;
    }

    public void setAttemptsRemaining(int attemptsRemaining) {
        this.attemptsRemaining = attemptsRemaining;
    }

    public void setMaxSeconds(int maxSeconds) {
        this.maxSeconds = maxSeconds;
    }

    public void setCurrentRecordingLength(int currentRecordingLength) {
        this.currentRecordingLength = currentRecordingLength;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setEnableRecord(boolean enableRecord) {
        this.enableRecord = enableRecord;
    }

    public void setEnablePlay(boolean enablePlay) {
        this.enablePlay = enablePlay;
    }

    public void setEnableSave(boolean enableSave) {
        this.enableSave = enableSave;
    }

    public void setEnablePause(boolean enablePause) {
        this.enablePause = enablePause;
    }

    public void setEnableLoad(boolean enableLoad) {
        this.enableLoad = enableLoad;
    }

    public void setEnableStop(boolean enableStop) {
        this.enableStop = enableStop;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public void setBigendian(boolean bigendian) {
        this.bigendian = bigendian;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getLocaleLanguage() {
        return this.localeLanguage;
    }

    public void setLocaleLanguage(String localeLanguage) {
        this.localeLanguage = localeLanguage;
    }

    public String getLocaleCountry() {
        return this.localeCountry;
    }

    public void setLocaleCountry(String localeCountry) {
        this.localeCountry = localeCountry;
    }

    public String getQuestionId() {
        return this.questionId;
    }

    public void setQuestionId(String questionId) {
        this.questionId = questionId;
    }
}

