/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.audio;

import java.awt.Color;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ColorModel {
    private static final String RESOURCE_PACKAGE = "org.sakaiproject.tool.assessment.bundle";
    private static final String RESOURCE_NAME = "colors";
    private static ResourceBundle colors = ResourceBundle.getBundle("org.sakaiproject.tool.assessment.bundle.colors", Locale.getDefault());
    private static HashMap map = new HashMap();

    ColorModel() {
        if (map.size() == 0) {
            Enumeration<String> cEnum = colors.getKeys();
            while (cEnum.hasMoreElements()) {
                String colorName = cEnum.nextElement();
                String colorString = colors.getString(colorName);
                Color color = this.makeColor(colorString);
                map.put(colorName, color);
            }
        }
    }

    public Color getColor(String colorName) {
        return (Color)map.get(colorName);
    }

    private Color makeColor(String colorString) {
        int[] colorArray = new int[]{0, 0, 0};
        String[] colorNames = new String[]{"RED", "GREEN", "BLUE"};
        StringTokenizer st = new StringTokenizer(colorString, ",");
        int i = 0;
        while (st.hasMoreElements()) {
            try {
                String val = st.nextToken();
                colorArray[i] = val.startsWith("0x") ? Integer.parseInt(val.substring(2), 16) : Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                System.out.println("Unable to read color " + colorNames[i] + " value.");
            }
            ++i;
        }
        return new Color(colorArray[0], colorArray[1], colorArray[2]);
    }

    public static void main(String[] s) {
        new ColorModel();
        new ColorModel();
    }
}

