/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.contentpackaging;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionData;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ManifestGenerator {
    private static final Logger log = LoggerFactory.getLogger(ManifestGenerator.class);
    private static String DEFAULT_NAMESPACE_URI = "http://www.imsglobal.org/xsd/imscp_v1p1";
    private static String DEFAULT_NAMESPACE_SCHEMA_LOCATION = "http://www.imsglobal.org/xsd/imscp_v1p1.xsd";
    private static String IMSMD_NAMESPACE_URI = "http://www.imsglobal.org/xsd/imsmd_v1p2";
    private static String IMSMD_NAMESPACE_SCHEMA_LOCATION = "http://www.imsglobal.org/xsd/imsmd_v1p2.xsd";
    private static String EXPORT_ASSESSMENT = "exportAssessment";
    private static String EXPORT_ASSESSMENT_XML = EXPORT_ASSESSMENT + ".xml";
    private Document document;
    private String assessmentId;
    private HashMap contentMap = new HashMap();
    private ContentHostingService contentHostingService;

    public ManifestGenerator(String assessmentId) {
        this.assessmentId = assessmentId;
    }

    public String getManifest() {
        String xmlString;
        this.document = this.readXMLDocument();
        if (this.document == null) {
            log.info("document == null");
            return "";
        }
        String newXmlString = xmlString = XmlUtil.getDOMString((Node)this.document);
        if (xmlString.startsWith("<?xml version")) {
            newXmlString = xmlString.replaceFirst("version=\"1.0\"", "version=\"1.0\"  encoding=\"UTF-8\"");
        }
        log.debug(newXmlString);
        return newXmlString;
    }

    public HashMap getContentMap() {
        return this.contentMap;
    }

    private Document readXMLDocument() {
        this.document = this.getDocument();
        Element manifestElement = this.createManifestElement();
        this.document.appendChild(manifestElement);
        Element metadata = this.createDefaultNSElement("metadata");
        this.appendLOMMetadataToElement(EXPORT_ASSESSMENT, metadata);
        manifestElement.appendChild(metadata);
        Element organizationsElement = this.createOrganizationsElement();
        manifestElement.appendChild(organizationsElement);
        Element resourcesElement = this.createDefaultNSElement("resources");
        Element resourceElement = this.createResourceElement();
        Element xmlFileElement = this.createFileElement(EXPORT_ASSESSMENT_XML);
        resourceElement.appendChild(xmlFileElement);
        this.setContentHostingService();
        this.getAttachments();
        this.getFCKAttachments();
        Iterator iter = this.contentMap.keySet().iterator();
        String filename = null;
        Element fileElement = null;
        while (iter.hasNext()) {
            filename = ((String)iter.next()).replaceAll(" ", "");
            fileElement = this.createFileElement(filename);
            resourceElement.appendChild(fileElement);
        }
        resourcesElement.appendChild(resourceElement);
        manifestElement.appendChild(resourcesElement);
        return this.document;
    }

    private void getAttachments() {
        try {
            AssessmentService assessmentService = new AssessmentService();
            AssessmentFacade assessment = assessmentService.getAssessment(this.assessmentId);
            AssessmentData assessmentData = (AssessmentData)assessment.getData();
            Set assessmentAttachmentSet = assessmentData.getAssessmentAttachmentSet();
            Iterator assessmentAttachmentIter = assessmentAttachmentSet.iterator();
            byte[] content = null;
            String resourceId = null;
            while (assessmentAttachmentIter.hasNext()) {
                AssessmentAttachment assessmentAttachment = (AssessmentAttachment)assessmentAttachmentIter.next();
                resourceId = assessmentAttachment.getResourceId();
                content = this.contentHostingService.getResource(resourceId).getContent();
                this.contentMap.put(resourceId.replace(" ", ""), content);
            }
            Set sectionSet = assessment.getSectionSet();
            Iterator sectionIter = sectionSet.iterator();
            SectionData sectionData = null;
            Set sectionAttachmentSet = null;
            Iterator sectionAttachmentIter = null;
            SectionAttachment sectionAttachment2 = null;
            Set itemSet = null;
            ItemData itemData2 = null;
            Set itemAttachmentSet = null;
            Iterator itemAttachmentIter = null;
            ItemAttachment itemAttachment2 = null;
            while (sectionIter.hasNext()) {
                sectionData = (SectionData)((SectionFacade)sectionIter.next()).getData();
                sectionAttachmentSet = sectionData.getSectionAttachmentSet();
                for (SectionAttachment sectionAttachment2 : sectionAttachmentSet) {
                    resourceId = sectionAttachment2.getResourceId();
                    content = this.contentHostingService.getResource(resourceId).getContent();
                    this.contentMap.put(resourceId.replace(" ", ""), content);
                }
                itemSet = sectionData.getItemSet();
                for (ItemData itemData2 : itemSet) {
                    itemAttachmentSet = itemData2.getItemAttachmentSet();
                    for (ItemAttachment itemAttachment2 : itemAttachmentSet) {
                        resourceId = itemAttachment2.getResourceId();
                        content = this.contentHostingService.getResource(resourceId).getContent();
                        this.contentMap.put(resourceId.replace(" ", ""), content);
                    }
                }
            }
        }
        catch (PermissionException e) {
            log.error(e.getMessage());
        }
        catch (IdUnusedException e) {
            log.error(e.getMessage());
        }
        catch (TypeException e) {
            log.error(e.getMessage());
        }
        catch (ServerOverloadException e) {
            log.error(e.getMessage());
        }
    }

    private void getFCKAttachments() {
        AssessmentService assessmentService = new AssessmentService();
        AssessmentFacade assessment = assessmentService.getAssessment(this.assessmentId);
        AssessmentData assessmentData = (AssessmentData)assessment.getData();
        this.processDescription(assessmentData.getDescription());
        this.processDescription(assessmentData.getAssessmentAccessControl().getSubmissionMessage());
        Set sectionSet = assessment.getSectionSet();
        Iterator sectionIter = sectionSet.iterator();
        SectionData sectionData = null;
        Set itemSet = null;
        ItemData itemData2 = null;
        while (sectionIter.hasNext()) {
            sectionData = (SectionData)((SectionFacade)sectionIter.next()).getData();
            this.processDescription(sectionData.getDescription());
            itemSet = sectionData.getItemSet();
            for (ItemData itemData2 : itemSet) {
                if (itemData2.getTypeId().equals(TypeIfc.MATCHING) || itemData2.getTypeId().equals(TypeIfc.CALCULATED_QUESTION)) {
                    this.processDescription(itemData2.getInstruction());
                }
                Set itemTextSet = itemData2.getItemTextSet();
                ItemText itemText2 = null;
                for (ItemText itemText2 : itemTextSet) {
                    this.processDescription(itemText2.getText());
                    Set answerSet = itemText2.getAnswerSet();
                    Answer answer2 = null;
                    for (Answer answer2 : answerSet) {
                        this.processDescription(answer2.getText());
                        Set answerFeedbackSet = answer2.getAnswerFeedbackSet();
                        AnswerFeedback answerFeedback2 = null;
                        for (AnswerFeedback answerFeedback2 : answerFeedbackSet) {
                            this.processDescription(answerFeedback2.getText());
                        }
                    }
                }
                Set itemFeedbackSet = itemData2.getItemFeedbackSet();
                ItemFeedback itemFeedback2 = null;
                for (ItemFeedback itemFeedback2 : itemFeedbackSet) {
                    this.processDescription(itemFeedback2.getText());
                }
            }
        }
    }

    private void processDescription(String description) {
        block13: {
            String prependString = ServerConfigurationService.getAccessUrl() + "/content";
            String siteCollection = "/group/";
            String userCollection = "/user/";
            String attachment = "/attachment/";
            User user = UserDirectoryService.getCurrentUser();
            String userId = user.getId();
            String eid = user.getEid();
            try {
                if (description == null || description.indexOf("<img ") <= -1 && description.indexOf("<a ") <= -1 && description.indexOf("<a\n") <= -1) break block13;
                byte[] content = null;
                int srcStartIndex = 0;
                int srcEndIndex = 0;
                String src = null;
                String resourceId = null;
                String eidResourceId = null;
                String[] splittedString = description.split("<img ");
                for (int i = 0; i < splittedString.length; ++i) {
                    log.debug("splittedString[" + i + "] = " + splittedString[i]);
                    String[] splittedRefString = splittedString[i].split("<a[\n|\\s]+?");
                    for (int j = 0; j < splittedRefString.length; ++j) {
                        if (splittedRefString[j].indexOf(prependString) <= -1) continue;
                        int offset = 5;
                        srcStartIndex = splittedRefString[j].indexOf("src=\"");
                        if (srcStartIndex == -1) {
                            srcStartIndex = splittedRefString[j].indexOf("href=\"");
                            ++offset;
                        }
                        srcEndIndex = splittedRefString[j].indexOf("\"", srcStartIndex + offset);
                        src = splittedRefString[j].substring(srcStartIndex + offset, srcEndIndex).replace(" ", "");
                        try {
                            src = URLDecoder.decode(src, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            log.error(e.getMessage());
                        }
                        if (src.indexOf(siteCollection) > -1) {
                            resourceId = src.replace(prependString, "");
                            content = this.contentHostingService.getResource(resourceId).getContent();
                            if (content == null) continue;
                            this.contentMap.put(resourceId, content);
                            continue;
                        }
                        if (src.indexOf(userCollection) > -1) {
                            eidResourceId = src.replace(prependString, "");
                            resourceId = eidResourceId.replace(eid, userId);
                            content = this.contentHostingService.getResource(resourceId).getContent();
                            if (content == null) continue;
                            this.contentMap.put(eidResourceId, content);
                            continue;
                        }
                        if (src.indexOf(attachment) > -1) {
                            resourceId = src.replace(prependString, "");
                            content = this.contentHostingService.getResource(resourceId).getContent();
                            if (content == null) continue;
                            this.contentMap.put(resourceId, content);
                            continue;
                        }
                        log.error("Neither group nor user");
                    }
                }
            }
            catch (PermissionException e) {
                log.error(e.getMessage());
            }
            catch (IdUnusedException e) {
                log.error(e.getMessage());
            }
            catch (TypeException e) {
                log.error(e.getMessage());
            }
            catch (ServerOverloadException e) {
                log.error(e.getMessage());
            }
        }
    }

    public void setContentHostingService() {
        if (this.contentHostingService == null) {
            this.contentHostingService = AssessmentService.getContentHostingService();
        }
    }

    private Element createManifestElement() {
        Element manifest = this.createDefaultNSElement("manifest");
        manifest.setAttribute("identifier", "MANIFEST1");
        manifest.setAttribute("xmlns", DEFAULT_NAMESPACE_URI);
        manifest.setAttribute("xmlns:imsmd", IMSMD_NAMESPACE_URI);
        manifest.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        manifest.setAttribute("xsi:schemaLocation", DEFAULT_NAMESPACE_URI + " " + DEFAULT_NAMESPACE_SCHEMA_LOCATION + " " + IMSMD_NAMESPACE_URI + " " + IMSMD_NAMESPACE_SCHEMA_LOCATION);
        return manifest;
    }

    public void appendLOMMetadataToElement(String title, Element parent) {
        Element imsmdLom = this.createLOMElement("lom");
        Element imsmdGeneral = this.createLOMElement("general");
        String identifier = Long.toHexString(new Date().getTime());
        Element imsmdIdentifier = this.createLOMElementWithLangstring("identifier", identifier);
        imsmdGeneral.appendChild(imsmdIdentifier);
        Element imsmdTitle = this.createLOMElementWithLangstring("title", title);
        imsmdGeneral.appendChild(imsmdTitle);
        imsmdLom.appendChild(imsmdGeneral);
        parent.appendChild(imsmdLom);
    }

    private Element createOrganizationsElement() {
        Element organizations = this.createDefaultNSElement("organizations");
        return organizations;
    }

    public Element createResourceElement() {
        Element resourceElement = this.createDefaultNSElement("resource");
        resourceElement.setAttributeNS(DEFAULT_NAMESPACE_URI, "identifier", "RESOURCE1");
        resourceElement.setAttributeNS(DEFAULT_NAMESPACE_URI, "type", "imsqti_xmlv1p1");
        resourceElement.setAttributeNS(DEFAULT_NAMESPACE_URI, "href", EXPORT_ASSESSMENT_XML);
        return resourceElement;
    }

    public Element createFileElement(String href) {
        Element fileElement = this.createDefaultNSElement("file");
        fileElement.setAttributeNS(DEFAULT_NAMESPACE_URI, "href", href);
        return fileElement;
    }

    private Element createDefaultNSElement(String elename) {
        return this.getDocument().createElementNS(DEFAULT_NAMESPACE_URI, elename);
    }

    private Element createLOMElement(String elename) {
        Element imsmdlom = this.getDocument().createElementNS(IMSMD_NAMESPACE_URI, elename);
        imsmdlom.setPrefix("imsmd");
        return imsmdlom;
    }

    private Element createLOMElementWithLangstring(String elementName, String text) {
        Element element = this.createLOMElement(elementName);
        Element imsmdlangstring = this.createLOMElement("langstring");
        imsmdlangstring.setAttribute("xml:lang", "en-US");
        this.setNodeValue(imsmdlangstring, text);
        element.appendChild(imsmdlangstring);
        return element;
    }

    private void setNodeValue(Element parent, String data) {
        Text textNode = this.getDocument().createTextNode(data);
        parent.appendChild(textNode);
    }

    private Document getDocument() {
        if (this.document != null) {
            return this.document;
        }
        this.document = XmlUtil.createDocument();
        return this.document;
    }
}

