/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.contentpackaging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportService {
    private static Log log = LogFactory.getLog(ImportService.class);
    private String qtiFilename;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unzipImportFile(String filename) {
        FileInputStream fileInputStream = null;
        FileOutputStream ofile = null;
        ZipInputStream zipStream = null;
        ZipEntry entry = null;
        ExternalContext external = FacesContext.getCurrentInstance().getExternalContext();
        StringBuilder unzipLocation = new StringBuilder((String)((ServletContext)external.getContext()).getAttribute("FILEUPLOAD_REPOSITORY_PATH"));
        log.debug((Object)("****" + unzipLocation));
        unzipLocation.append("/jsf/upload_tmp/qti_imports/");
        unzipLocation.append(AgentFacade.getAgentString());
        unzipLocation.append("/unzip_files/");
        unzipLocation.append(Long.toString(new Date().getTime()));
        try {
            fileInputStream = new FileInputStream(new File(filename));
            byte[] data = new byte[fileInputStream.available()];
            fileInputStream.read(data, 0, fileInputStream.available());
            File dir = new File(unzipLocation.toString());
            if (!dir.exists() && !dir.mkdirs()) {
                log.error((Object)("unable to mkdir " + dir.getPath()));
            }
            TreeSet<String> dirsMade = new TreeSet<String>();
            zipStream = new ZipInputStream(new ByteArrayInputStream(data));
            entry = zipStream.getNextEntry();
            String tmpName = filename.substring(filename.lastIndexOf("/") + 1);
            this.qtiFilename = "exportAssessment.xml";
            ArrayList<String> xmlFilenames = new ArrayList<String>();
            while (entry != null) {
                File zipEntryFile;
                File d;
                String dirName;
                String zipName = entry.getName();
                int ix = zipName.lastIndexOf(47);
                if (!(ix <= 0 || dirsMade.contains(dirName = zipName.substring(0, ix)) || (d = new File(dir.getPath() + "/" + dirName)).exists() && d.isDirectory())) {
                    if (!d.mkdirs()) {
                        log.error((Object)("unable to mkdir " + dir.getPath() + "/" + dirName));
                    }
                    dirsMade.add(dirName);
                }
                if (!(zipEntryFile = new File(dir.getPath() + "/" + entry.getName())).isDirectory()) {
                    int bytesRead;
                    ofile = new FileOutputStream(zipEntryFile);
                    byte[] buffer = new byte[10240];
                    while ((bytesRead = zipStream.read(buffer)) != -1) {
                        ofile.write(buffer, 0, bytesRead);
                    }
                }
                if ("imsmanifest.xml".equals(entry.getName())) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    try {
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document doc = db.parse(zipEntryFile);
                        doc.getDocumentElement().normalize();
                        NodeList nodeLst = doc.getElementsByTagName("resource");
                        Node fstNode = nodeLst.item(0);
                        NamedNodeMap namedNodeMap = fstNode.getAttributes();
                        this.qtiFilename = namedNodeMap.getNamedItem("href").getNodeValue();
                    }
                    catch (Exception e) {
                        log.error((Object)"error parsing imsmanifest.xml");
                    }
                } else if (entry.getName() != null && entry.getName().trim().endsWith(".xml")) {
                    xmlFilenames.add(entry.getName().trim());
                }
                zipStream.closeEntry();
                entry = zipStream.getNextEntry();
            }
            if (!xmlFilenames.contains(this.qtiFilename.trim())) {
                this.qtiFilename = xmlFilenames.contains("exportAssessment.xml") ? "exportAssessment.xml" : tmpName.substring(0, tmpName.lastIndexOf("_")) + ".xml";
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (ofile != null) {
                try {
                    ofile.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            if (zipStream != null) {
                try {
                    zipStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
        return unzipLocation.toString();
    }

    public String setQTIFilename() {
        return this.qtiFilename;
    }

    public String getQTIFilename() {
        return this.qtiFilename;
    }
}

