/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.contentpackaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sakaiproject.tool.assessment.qti.asi.ASIBaseClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Manifest
extends ASIBaseClass {
    private static final Logger log = LoggerFactory.getLogger(Manifest.class);
    private String basePath = "questestinterop/assessment";
    private Map sections = new HashMap();
    private Map items = new HashMap();
    public static final String MANIFEST_TAG = "manifest";
    public static final String RESOURCE_PATH = "manifest/resources/resource";
    public static final String FILE_PATH = "manifest/resources/resource/file";

    protected Manifest() {
    }

    public Manifest(Document document) {
        super(document);
    }

    public void setFieldentry(String prefixPath, String fieldlabel, String setValue) {
        StringBuilder xpath = new StringBuilder(prefixPath);
        xpath.append("/fieldlabel[text()='");
        xpath.append(fieldlabel);
        xpath.append("']/following-sibling::fieldentry");
        super.setFieldentry(xpath.toString(), setValue);
    }

    public void addSectionRef(String sectionId) {
        if (log.isDebugEnabled()) {
            log.debug("addSection(String " + sectionId + ")");
        }
        try {
            String xpath = this.basePath;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element element = document.createElement("sectionref");
            element.setAttribute("linkrefid", sectionId);
            this.addElement(xpath, element);
        }
        catch (ParserConfigurationException pce) {
            log.error("Exception thrown from addSectionRef() : " + pce.getMessage());
        }
    }

    public void removeSectionRef(String sectionId) {
        if (log.isDebugEnabled()) {
            log.debug("removeSectionRef(String " + sectionId + ")");
        }
        String xpath = this.basePath + "/" + "sectionref" + "[@" + "linkrefid" + "='" + sectionId + "']";
        this.removeElement(xpath);
    }

    public void removeSectionRefs() {
        log.debug("removeSectionRefs()");
        String xpath = this.basePath + "/" + "sectionref";
        this.removeElement(xpath);
    }

    public List getSectionRefs() {
        log.debug("getSectionRefs()");
        String xpath = this.basePath + "/" + "sectionref";
        return this.selectNodes(xpath);
    }

    public Collection getSections() {
        return this.sections.values();
    }

    public Collection getItems() {
        return this.items.values();
    }

    public List getSectionRefIds() {
        log.debug("getSectionRefIds()");
        List refs = this.getSectionRefs();
        ArrayList<String> ids = new ArrayList<String>();
        int size = refs.size();
        for (int i = 0; i < size; ++i) {
            Element ref = (Element)refs.get(0);
            String idString = ref.getAttribute("linkrefid");
            ids.add(idString);
        }
        return ids;
    }

    public String getTitle() {
        String title = "";
        String xpath = this.basePath;
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            title = element.getAttribute("title");
        }
        return title;
    }

    public String getIdent() {
        String ident = "";
        String xpath = this.basePath;
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            ident = element.getAttribute("ident");
        }
        return ident;
    }

    public void setIdent(String ident) {
        String xpath = this.basePath;
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            element.setAttribute("ident", ident);
        }
    }

    public void setTitle(String title) {
        String xpath = this.basePath;
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            element.setAttribute("title", Manifest.escapeXml((String)title));
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

