/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.contentpackaging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportService {
    private static final Logger log = LoggerFactory.getLogger(ImportService.class);
    private String qtiFilename;

    public String unzipImportFile(String filename) {
        ServerConfigurationService serverConfigurationService = (ServerConfigurationService)ComponentManager.get(ServerConfigurationService.class);
        String repositoryPath = serverConfigurationService.getString("samigo.answerUploadRepositoryPath", "${sakai.home}/samigo/answerUploadRepositoryPath/");
        StringBuilder unzipLocation = new StringBuilder(repositoryPath);
        log.debug("**** {}", (Object)unzipLocation);
        unzipLocation.append("/jsf/upload_tmp/qti_imports/");
        unzipLocation.append(AgentFacade.getAgentString());
        unzipLocation.append("/unzip_files/");
        unzipLocation.append(Instant.now().toEpochMilli());
        try (FileInputStream fileInputStream = new FileInputStream(new File(filename));){
            byte[] data = new byte[fileInputStream.available()];
            fileInputStream.read(data, 0, fileInputStream.available());
            File dir = new File(unzipLocation.toString());
            if (!dir.exists() && !dir.mkdirs()) {
                log.warn("Unable to mkdir {}", (Object)dir.getPath());
            }
            TreeSet<String> dirsMade = new TreeSet<String>();
            try (ZipInputStream zipStream = new ZipInputStream(new ByteArrayInputStream(data));){
                ZipEntry entry = zipStream.getNextEntry();
                String tmpName = filename.substring(filename.lastIndexOf("/") + 1);
                this.qtiFilename = "exportAssessment.xml";
                ArrayList<String> xmlFilenames = new ArrayList<String>();
                while (entry != null) {
                    File zipEntryFile;
                    File d;
                    String dirName;
                    String entryName = entry.getName();
                    String entryNameTrimmed = entryName.trim();
                    int ix = entryName.lastIndexOf(47);
                    if (!(ix <= 0 || dirsMade.contains(dirName = entryName.substring(0, ix)) || (d = new File(dir.getPath() + "/" + dirName)).exists() && d.isDirectory())) {
                        if (!d.mkdirs()) {
                            log.warn("unable to mkdir {}/{}", (Object)dir.getPath(), (Object)dirName);
                        }
                        dirsMade.add(dirName);
                    }
                    if (!(zipEntryFile = new File(dir.getPath() + "/" + entryName)).isDirectory()) {
                        try (FileOutputStream ofile = new FileOutputStream(zipEntryFile);){
                            int bytesRead;
                            byte[] buffer = new byte[10240];
                            while ((bytesRead = zipStream.read(buffer)) != -1) {
                                ofile.write(buffer, 0, bytesRead);
                            }
                        }
                    }
                    if ("imsmanifest.xml".equals(entry.getName())) {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        try {
                            DocumentBuilder db = dbf.newDocumentBuilder();
                            Document doc = db.parse(zipEntryFile);
                            doc.getDocumentElement().normalize();
                            NodeList nodeLst = doc.getElementsByTagName("resource");
                            Node fstNode = nodeLst.item(0);
                            NamedNodeMap namedNodeMap = fstNode.getAttributes();
                            this.qtiFilename = namedNodeMap.getNamedItem("href").getNodeValue();
                        }
                        catch (Exception e) {
                            log.warn("Could not parse imsmanifest.xml: {}", (Object)e.toString());
                        }
                    } else if (entryNameTrimmed.endsWith(".xml")) {
                        xmlFilenames.add(entryNameTrimmed);
                        if (!xmlFilenames.contains(this.qtiFilename.trim())) {
                            this.qtiFilename = xmlFilenames.contains("exportAssessment.xml") ? "exportAssessment.xml" : (xmlFilenames.contains(tmpName.substring(0, tmpName.lastIndexOf("_")) + ".xml") ? tmpName.substring(0, tmpName.lastIndexOf("_")) + ".xml" : entryNameTrimmed);
                        }
                    }
                    zipStream.closeEntry();
                    entry = zipStream.getNextEntry();
                }
            }
        }
        catch (IOException e) {
            log.warn(e.toString());
        }
        return unzipLocation.toString();
    }

    public String getQtiFilename() {
        return this.qtiFilename;
    }

    public void setQtiFilename(String qtiFilename) {
        this.qtiFilename = qtiFilename;
    }
}

