/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Category;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;

public class Answer
implements Serializable,
AnswerIfc,
Comparable<AnswerIfc>,
Cloneable {
    static Category errorLogger = Category.getInstance((String)"errorLogger");
    private static final long serialVersionUID = 7526471155622776147L;
    private Long id;
    private ItemTextIfc itemText;
    private ItemDataIfc item;
    private String text;
    private Long sequence;
    private String label;
    private Boolean isCorrect;
    private String grade;
    private Double score;
    private Double discount;
    private Double partialCredit;
    private Set answerFeedbackSet;
    private HashMap answerFeedbackMap;
    private ItemData dat = new ItemData();

    public Answer() {
    }

    public Answer(ItemTextIfc itemText, String text, Long sequence, String label) {
        this(itemText, text, sequence, label, null, null, null, null, null);
    }

    public Answer(ItemTextIfc itemText, String text, Long sequence, String label, Boolean isCorrect, String grade, Double score, Double partialCredit, Double discount) {
        this.itemText = itemText;
        this.item = itemText.getItem();
        this.text = text;
        this.sequence = sequence;
        this.label = label;
        this.isCorrect = isCorrect;
        this.grade = grade;
        this.score = score;
        this.discount = discount;
        this.partialCredit = partialCredit;
    }

    public Answer(ItemTextIfc itemText, String text, Long sequence, String label, Boolean isCorrect, String grade, Double score, Double partialCredit, Double discount, Set answerFeedbackSet) {
        this.itemText = itemText;
        this.item = itemText.getItem();
        this.text = text;
        this.sequence = sequence;
        this.label = label;
        this.isCorrect = isCorrect;
        this.grade = grade;
        this.score = score;
        this.discount = discount;
        this.answerFeedbackSet = answerFeedbackSet;
        this.partialCredit = partialCredit;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ItemTextIfc getItemText() {
        return this.itemText;
    }

    public void setItemText(ItemTextIfc itemText) {
        this.itemText = itemText;
    }

    public ItemDataIfc getItem() {
        return this.item;
    }

    public void setItem(ItemDataIfc item) {
        this.item = item;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Boolean getIsCorrect() {
        return this.isCorrect;
    }

    public void setIsCorrect(Boolean isCorrect) {
        this.isCorrect = isCorrect;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public Double getDiscount() {
        if (this.discount == null) {
            this.discount = 0.0;
        }
        return this.discount;
    }

    public void setDiscount(Double discount) {
        if (discount == null) {
            discount = 0.0;
        }
        this.discount = discount;
    }

    public Set getAnswerFeedbackSet() {
        return this.answerFeedbackSet;
    }

    public ArrayList getAnswerFeedbackArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.answerFeedbackSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public void setAnswerFeedbackSet(Set answerFeedbackSet) {
        this.answerFeedbackSet = answerFeedbackSet;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String getAnswerFeedback(String typeId) {
        if (this.answerFeedbackMap == null) {
            this.answerFeedbackMap = this.getAnswerFeedbackMap();
        }
        return (String)this.answerFeedbackMap.get(typeId);
    }

    public HashMap getAnswerFeedbackMap() {
        HashMap<String, String> answerFeedbackMap = new HashMap<String, String>();
        if (this.answerFeedbackSet != null) {
            for (AnswerFeedback answerFeedback : this.answerFeedbackSet) {
                answerFeedbackMap.put(answerFeedback.getTypeId(), answerFeedback.getText());
            }
        }
        return answerFeedbackMap;
    }

    public String getCorrectAnswerFeedback() {
        return this.getAnswerFeedback("Correct Feedback");
    }

    public String getInCorrectAnswerFeedback() {
        return this.getAnswerFeedback("InCorrect Feedback");
    }

    public String getGeneralAnswerFeedback() {
        return this.getAnswerFeedback("General Feedback");
    }

    public String getTheAnswerFeedback() {
        return this.getAnswerFeedback("answerfeedback");
    }

    @Override
    public int compareTo(AnswerIfc o) {
        return this.sequence.compareTo(o.getSequence());
    }

    public boolean getGeneralAnswerFbIsNotEmpty() {
        return this.dat.isNotEmpty(this.getGeneralAnswerFeedback());
    }

    public boolean getCorrectAnswerFbIsNotEmpty() {
        return this.dat.isNotEmpty(this.getCorrectAnswerFeedback());
    }

    public boolean getIncorrectAnswerFbIsNotEmpty() {
        return this.dat.isNotEmpty(this.getInCorrectAnswerFeedback());
    }

    public boolean getTextIsNotEmpty() {
        return this.dat.isNotEmpty(this.getText());
    }

    public Double getPartialCredit() {
        return this.partialCredit;
    }

    public void setPartialCredit(Double pCredit) {
        this.partialCredit = pCredit;
    }

    protected Answer clone() throws CloneNotSupportedException {
        return (Answer)super.clone();
    }
}

