/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedAttachmentData
implements Serializable,
AttachmentIfc {
    private static final long serialVersionUID = -7673339618446778553L;
    private static Logger log = LoggerFactory.getLogger(PublishedAttachmentData.class);
    private Long attachmentId;
    private ItemDataIfc item;
    private String resourceId;
    private String filename;
    private String mimeType;
    private Long fileSize;
    private String description;
    private String location;
    private Boolean isLink;
    private Integer status;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private Long attachmentType;

    public PublishedAttachmentData() {
    }

    public PublishedAttachmentData(String resourceId, Long attachmentType, String filename, String mimeType, Long fileSize, String description, String location, Boolean isLink, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate) {
        this.resourceId = resourceId;
        this.attachmentType = attachmentType;
        this.filename = filename;
        this.mimeType = mimeType;
        this.fileSize = fileSize;
        this.description = description;
        this.location = location;
        this.isLink = isLink;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
    }

    public PublishedAttachmentData(Long attachmentId, String resourceId, Long attachmentType, String filename, String mimeType, Long fileSize, String description, String location, Boolean isLink, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate) {
        this.attachmentId = attachmentId;
        this.resourceId = resourceId;
        this.attachmentType = attachmentType;
        this.filename = filename;
        this.mimeType = mimeType;
        this.fileSize = fileSize;
        this.description = description;
        this.location = location;
        this.isLink = isLink;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
    }

    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String pdescription) {
        this.description = pdescription;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Boolean getIsLink() {
        return this.isLink;
    }

    public void setIsLink(Boolean isLink) {
        this.isLink = isLink;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Long getAttachmentType() {
        return this.attachmentType;
    }

    public void setAttachmentType(Long attachmentType) {
    }

    public boolean getIsInlineVideo() {
        return this.mimeType.equals("video/quicktime");
    }

    public boolean getIsInlineImage() {
        return this.mimeType.equalsIgnoreCase("image/jpeg") || this.mimeType.equalsIgnoreCase("image/pjpeg") || this.mimeType.equalsIgnoreCase("image/gif") || this.mimeType.equalsIgnoreCase("image/png");
    }

    public boolean getIsInlineFlash() {
        return this.mimeType.equalsIgnoreCase("application/x-shockwave-flash");
    }

    public boolean getIsMedia() {
        return this.getIsInlineVideo() || this.getIsInlineImage() || this.getIsInlineFlash();
    }

    public String getEncodedResourceId() {
        try {
            return URLEncoder.encode(this.resourceId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingException: " + e.getMessage());
            return "";
        }
    }
}

