/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;

public class ExtendedTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private AssessmentBaseIfc assessment;
    private PublishedAssessmentIfc pubAssessment;
    private String user;
    private String group;
    private Date startDate;
    private Date dueDate;
    private Date retractDate;
    private Integer timeHours;
    private Integer timeMinutes;

    public ExtendedTime(AssessmentBaseIfc ass) {
        this.assessment = ass;
    }

    public ExtendedTime(PublishedAssessmentIfc pub) {
        this.pubAssessment = pub;
    }

    public ExtendedTime(ExtendedTime source) {
        this(source.id, source.assessment, source.pubAssessment, source.user, source.group, source.startDate, source.dueDate, source.retractDate, source.timeHours, source.timeMinutes);
    }

    public Long getAssessmentId() {
        if (this.assessment == null) {
            return null;
        }
        return this.assessment.getAssessmentBaseId();
    }

    public Long getPubAssessmentId() {
        if (this.pubAssessment == null) {
            return null;
        }
        return this.pubAssessment.getPublishedAssessmentId();
    }

    public void syncDates() {
        AssessmentAccessControlIfc ac = null;
        if (this.assessment != null) {
            ac = this.assessment.getAssessmentAccessControl();
        } else if (this.pubAssessment != null) {
            ac = this.pubAssessment.getAssessmentAccessControl();
        }
        if (ac == null) {
            return;
        }
        if (this.getDueDate() == null) {
            this.setDueDate(ac.getDueDate());
        }
        if (this.getStartDate() == null) {
            this.setStartDate(ac.getStartDate());
        }
        if (this.getRetractDate() == null && ac.getLateHandling() == AssessmentAccessControlIfc.ACCEPT_LATE_SUBMISSION) {
            this.setRetractDate(ac.getRetractDate());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ExtendedTime) {
            ExtendedTime other = (ExtendedTime)obj;
            return new EqualsBuilder().append((Object)this.getAssessmentId(), (Object)other.getAssessmentId()).append((Object)this.getPubAssessmentId(), (Object)other.getPubAssessmentId()).append((Object)this.user, (Object)other.user).append((Object)this.group, (Object)other.group).append((Object)this.startDate, (Object)other.startDate).append((Object)this.dueDate, (Object)other.dueDate).append((Object)this.retractDate, (Object)other.retractDate).append((Object)this.timeHours, (Object)other.timeHours).append((Object)this.timeMinutes, (Object)other.timeMinutes).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getAssessmentId()).append((Object)this.getPubAssessmentId()).append((Object)this.user).append((Object)this.group).append((Object)this.startDate).append((Object)this.dueDate).append((Object)this.retractDate).append((Object)this.timeHours).append((Object)this.timeMinutes).toHashCode();
    }

    public Long getId() {
        return this.id;
    }

    public AssessmentBaseIfc getAssessment() {
        return this.assessment;
    }

    public PublishedAssessmentIfc getPubAssessment() {
        return this.pubAssessment;
    }

    public String getUser() {
        return this.user;
    }

    public String getGroup() {
        return this.group;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getRetractDate() {
        return this.retractDate;
    }

    public Integer getTimeHours() {
        return this.timeHours;
    }

    public Integer getTimeMinutes() {
        return this.timeMinutes;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAssessment(AssessmentBaseIfc assessment) {
        this.assessment = assessment;
    }

    public void setPubAssessment(PublishedAssessmentIfc pubAssessment) {
        this.pubAssessment = pubAssessment;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setRetractDate(Date retractDate) {
        this.retractDate = retractDate;
    }

    public void setTimeHours(Integer timeHours) {
        this.timeHours = timeHours;
    }

    public void setTimeMinutes(Integer timeMinutes) {
        this.timeMinutes = timeMinutes;
    }

    public String toString() {
        return "ExtendedTime(id=" + this.getId() + ", assessment=" + this.getAssessment() + ", pubAssessment=" + this.getPubAssessment() + ", user=" + this.getUser() + ", group=" + this.getGroup() + ", startDate=" + this.getStartDate() + ", dueDate=" + this.getDueDate() + ", retractDate=" + this.getRetractDate() + ", timeHours=" + this.getTimeHours() + ", timeMinutes=" + this.getTimeMinutes() + ")";
    }

    public ExtendedTime() {
    }

    public ExtendedTime(Long id, AssessmentBaseIfc assessment, PublishedAssessmentIfc pubAssessment, String user, String group, Date startDate, Date dueDate, Date retractDate, Integer timeHours, Integer timeMinutes) {
        this.id = id;
        this.assessment = assessment;
        this.pubAssessment = pubAssessment;
        this.user = user;
        this.group = group;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
        this.timeHours = timeHours;
        this.timeMinutes = timeMinutes;
    }
}

