/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.authz;

import java.io.Serializable;
import java.util.Date;
import org.sakaiproject.tool.assessment.data.ifc.authz.AuthorizationIfc;

public class AuthorizationData
implements AuthorizationIfc,
Serializable {
    private static final long serialVersionUID = -1460106795359785530L;
    private String agentId;
    private String functionId;
    private String qualifierId;
    private Date effectiveDate;
    private Date expirationDate;
    private Date lastModifiedDate;
    private String lastModifiedBy;
    private Boolean isExplicit;
    private Long surrogateKey;
    private Integer lockId;

    public AuthorizationData() {
    }

    public AuthorizationData(String agentId, String functionId, String qualifierId, Date effectiveDate, Date expirationDate, String lastModifiedBy, Date lastModifiedDate, Boolean isExplicit) {
        this.agentId = agentId;
        this.functionId = functionId;
        this.qualifierId = qualifierId;
        this.effectiveDate = effectiveDate;
        this.expirationDate = expirationDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.isExplicit = isExplicit;
    }

    public String getAgentIdString() {
        return this.agentId;
    }

    public void setAgentIdString(String id) {
        this.agentId = id;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(String id) {
        this.functionId = id;
    }

    public String getQualifierId() {
        return this.qualifierId;
    }

    public void setQualifierId(String id) {
        this.qualifierId = id;
    }

    public Date getAuthorizationEffectiveDate() {
        return this.effectiveDate;
    }

    public void setAuthorizationEffectiveDate(Date cal) {
        this.effectiveDate = cal;
    }

    public Date getAuthorizationExpirationDate() {
        return this.expirationDate;
    }

    public void setAuthorizationExpirationDate(Date cal) {
        this.expirationDate = cal;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String id) {
        this.lastModifiedBy = id;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date cal) {
        this.lastModifiedDate = cal;
    }

    public Boolean getIsExplicitBoolean() {
        return this.isExplicit;
    }

    public void setIsExplicitBoolean(Boolean type) {
        this.isExplicit = type;
    }

    public Boolean getIsActiveNowBoolean() {
        int effectiveVal = this.getAuthorizationEffectiveDate() == null ? 0 : 1;
        int expirationVal = this.getAuthorizationExpirationDate() == null ? 0 : 2;
        long nowMillis = new Date().getTime();
        boolean returnVal = false;
        switch (effectiveVal + expirationVal) {
            case 0: {
                returnVal = true;
                break;
            }
            case 1: {
                if (nowMillis > this.getAuthorizationEffectiveDate().getTime()) {
                    returnVal = true;
                    break;
                }
                returnVal = false;
                break;
            }
            case 2: {
                if (nowMillis < this.getAuthorizationExpirationDate().getTime()) {
                    returnVal = true;
                    break;
                }
                returnVal = false;
                break;
            }
            case 3: {
                returnVal = nowMillis > this.getAuthorizationEffectiveDate().getTime() && nowMillis < this.getAuthorizationExpirationDate().getTime();
            }
        }
        return returnVal;
    }

    public final Integer getLockId() {
        return this.lockId;
    }

    public final void setLockId(Integer lockId) {
        this.lockId = lockId;
    }

    public final Long getSurrogateKey() {
        return this.surrogateKey;
    }

    public final void setSurrogateKey(Long surrogateKey) {
        this.surrogateKey = surrogateKey;
    }

    public boolean equals(Object authorization) {
        boolean returnValue = false;
        if (this == authorization) {
            returnValue = true;
        }
        if (authorization != null && authorization.getClass() == this.getClass()) {
            AuthorizationData a = (AuthorizationData)authorization;
            if (this.getAgentIdString().equals(a.getAgentIdString()) && this.getFunctionId().equals(a.getFunctionId()) && this.getQualifierId().equals(a.getQualifierId())) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    public int hashCode() {
        return (this.getAgentIdString() + ":" + this.getFunctionId() + ":" + this.getQualifierId()).hashCode();
    }
}

