/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;

public class AssessmentBaseData
implements Serializable,
AssessmentBaseIfc {
    private static final long serialVersionUID = 7526471155622776147L;
    public static final int TITLE_LENGTH = 255;
    private Long assessmentBaseId;
    private Boolean isTemplate;
    private Long parentId;
    private String title;
    private String description;
    private String comments;
    private Long typeId;
    private Integer instructorNotification;
    private Integer testeeNotification;
    private Integer multipartAllowed;
    private Integer status;
    private String createdBy;
    private Date createdDate;
    private Date startDate;
    private Date dueDate;
    private String lastModifiedBy;
    private String releaseTo;
    private Date lastModifiedDate;
    private AssessmentAccessControlIfc assessmentAccessControl;
    private EvaluationModelIfc evaluationModel;
    private AssessmentFeedbackIfc assessmentFeedback;
    private Set assessmentMetaDataSet;
    private HashMap assessmentMetaDataMap = new HashMap();
    private HashMap assessmentFeedbackMap = new HashMap();
    private Set securedIPAddressSet;
    private Integer questionSize;

    public AssessmentBaseData() {
    }

    public AssessmentBaseData(Long assessmentBaseId, String title) {
        this.assessmentBaseId = assessmentBaseId;
        this.title = title;
    }

    public AssessmentBaseData(Long assessmentBaseId, String title, Date lastModifiedDate) {
        this.assessmentBaseId = assessmentBaseId;
        this.title = title;
        this.lastModifiedDate = lastModifiedDate;
    }

    public AssessmentBaseData(Long assessmentBaseId, String title, Date lastModifiedDate, String lastModifiedBy, Date startDate, Date dueDate, String releaseTo) {
        this.assessmentBaseId = assessmentBaseId;
        this.title = title;
        this.lastModifiedDate = lastModifiedDate;
        this.lastModifiedBy = lastModifiedBy;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.releaseTo = releaseTo;
    }

    public AssessmentBaseData(Long assessmentBaseId, String title, Date lastModifiedDate, String lastModifiedBy, Integer questionSize) {
        this.assessmentBaseId = assessmentBaseId;
        this.title = title;
        this.lastModifiedDate = lastModifiedDate;
        this.lastModifiedBy = lastModifiedBy;
        this.questionSize = questionSize;
    }

    public AssessmentBaseData(Long assessmentBaseId, String title, Date lastModifiedDate, Long typeId) {
        this.assessmentBaseId = assessmentBaseId;
        this.title = title;
        this.lastModifiedDate = lastModifiedDate;
        this.typeId = typeId;
    }

    public AssessmentBaseData(Boolean isTemplate, Long parentId, String title, String description, String comments, Long typeId, Integer instructorNotification, Integer testeeNotification, Integer multipartAllowed, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate) {
        this.isTemplate = isTemplate;
        this.parentId = parentId;
        this.title = title;
        this.description = description;
        this.comments = comments;
        this.typeId = typeId;
        this.instructorNotification = instructorNotification;
        this.testeeNotification = testeeNotification;
        this.multipartAllowed = multipartAllowed;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
    }

    public Long getAssessmentBaseId() {
        return this.assessmentBaseId;
    }

    public void setAssessmentBaseId(Long assessmentBaseId) {
        this.assessmentBaseId = assessmentBaseId;
    }

    public Boolean getIsTemplate() {
        return this.isTemplate;
    }

    public void setIsTemplate(Boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Integer getInstructorNotification() {
        return this.instructorNotification;
    }

    public void setInstructorNotification(Integer instructorNotification) {
        this.instructorNotification = instructorNotification;
    }

    public Integer getTesteeNotification() {
        return this.testeeNotification;
    }

    public void setTesteeNotification(Integer testeeNotification) {
        this.testeeNotification = testeeNotification;
    }

    public Integer getMultipartAllowed() {
        return this.multipartAllowed;
    }

    public void setMultipartAllowed(Integer multipartAllowed) {
        this.multipartAllowed = multipartAllowed;
    }

    public Long getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getReleaseTo() {
        return this.releaseTo;
    }

    public void setReleaseTo(String releaseTo) {
        this.releaseTo = releaseTo;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public AssessmentAccessControlIfc getAssessmentAccessControl() {
        return this.assessmentAccessControl;
    }

    public void setAssessmentAccessControl(AssessmentAccessControlIfc assessmentAccessControl) {
        this.assessmentAccessControl = assessmentAccessControl;
    }

    public EvaluationModelIfc getEvaluationModel() {
        return this.evaluationModel;
    }

    public void setEvaluationModel(EvaluationModelIfc evaluationModel) {
        this.evaluationModel = evaluationModel;
    }

    public AssessmentFeedbackIfc getAssessmentFeedback() {
        return this.assessmentFeedback;
    }

    public void setAssessmentFeedback(AssessmentFeedbackIfc assessmentFeedback) {
        this.assessmentFeedback = assessmentFeedback;
    }

    public Set getSecuredIPAddressSet() {
        return this.securedIPAddressSet;
    }

    public void setSecuredIPAddressSet(Set securedIPAddressSet) {
        this.securedIPAddressSet = securedIPAddressSet;
    }

    public Set getAssessmentMetaDataSet() {
        return this.assessmentMetaDataSet;
    }

    public void setAssessmentMetaDataSet(Set assessmentMetaDataSet) {
        this.assessmentMetaDataSet = assessmentMetaDataSet;
        this.assessmentMetaDataMap = this.getAssessmentMetaDataMap(assessmentMetaDataSet);
    }

    public HashMap getAssessmentMetaDataMap(Set assessmentMetaDataSet) {
        HashMap<String, String> assessmentMetaDataMap = new HashMap<String, String>();
        if (assessmentMetaDataSet != null) {
            for (AssessmentMetaData assessmentMetaData : assessmentMetaDataSet) {
                assessmentMetaDataMap.put(assessmentMetaData.getLabel(), assessmentMetaData.getEntry());
            }
        }
        return assessmentMetaDataMap;
    }

    public HashMap getAssessmentMetaDataMap() {
        HashMap<String, String> assessmentMetaDataMap = new HashMap<String, String>();
        if (this.assessmentMetaDataSet != null) {
            for (AssessmentMetaData assessmentMetaData : this.assessmentMetaDataSet) {
                assessmentMetaDataMap.put(assessmentMetaData.getLabel(), assessmentMetaData.getEntry());
            }
        }
        return assessmentMetaDataMap;
    }

    public String getAssessmentMetaDataByLabel(String label) {
        return (String)this.assessmentMetaDataMap.get(label);
    }

    public void addAssessmentMetaData(String label, String entry) {
        if (this.assessmentMetaDataMap.get(label) != null) {
            for (AssessmentMetaData metadata : this.assessmentMetaDataSet) {
                if (!metadata.getLabel().equals(label)) continue;
                metadata.setEntry(entry);
            }
        } else {
            AssessmentMetaData metadata = null;
            if (!"".equals(entry.trim())) {
                metadata = new AssessmentMetaData(this, label, entry);
                this.assessmentMetaDataSet.add(metadata);
            }
            this.setAssessmentMetaDataSet(this.assessmentMetaDataSet);
        }
    }

    public void updateAssessmentMetaData(String label, String entry) {
        this.addAssessmentMetaData(label, entry);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public TypeIfc getType() {
        return null;
    }

    public Integer getQuestionSize() {
        return this.questionSize;
    }

    public void setQuestionSize(Integer questionSize) {
        this.questionSize = questionSize;
    }
}

