/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTagIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemData
implements Serializable,
ItemDataIfc,
Comparable<ItemDataIfc> {
    private static final Logger log = LoggerFactory.getLogger(ItemData.class);
    static ResourceBundle rb = ResourceBundle.getBundle("org.sakaiproject.tool.assessment.bundle.Messages");
    private static final long serialVersionUID = 7526471155622776147L;
    public static final Long ADMIN = 34L;
    private Long itemId;
    private String itemIdString;
    private SectionDataIfc section;
    private Integer sequence;
    private Integer duration;
    private Integer triesAllowed;
    private String instruction;
    private String description;
    private Long typeId;
    private String grade;
    private Double score;
    private Double discount;
    private Boolean scoreDisplayFlag = Boolean.TRUE;
    private String hint;
    private Boolean hasRationale;
    private Integer status;
    private Boolean partialCreditFlag;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private Set<ItemTextIfc> itemTextSet;
    private Set<ItemMetaDataIfc> itemMetaDataSet;
    private Set<ItemFeedbackIfc> itemFeedbackSet;
    private Set<ItemAttachmentIfc> itemAttachmentSet;
    private Set<ItemTagIfc> itemTagSet;
    private Double minScore;
    private String hash;
    private Long originalItemId;
    private String themeText;
    private String leadInText;
    private Integer answerOptionsRichCount;
    private Integer answerOptionsSimpleOrRich = ItemDataIfc.ANSWER_OPTIONS_SIMPLE;
    private String tagListToJsonString;

    public ItemData() {
    }

    public ItemData(SectionDataIfc section, Integer sequence, Integer duration, String instruction, String description, Long typeId, String grade, Double score, Boolean scoreDisplayFlag, Double discount, Double minScore, String hint, Boolean hasRationale, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, Set<ItemTextIfc> itemTextSet, Set<ItemMetaDataIfc> itemMetaDataSet, Set<ItemFeedbackIfc> itemFeedbackSet, Boolean partialCreditFlag, String hash) {
        this.section = section;
        this.sequence = sequence;
        this.duration = duration;
        this.instruction = instruction;
        this.description = description;
        this.typeId = typeId;
        this.grade = grade;
        this.score = score;
        this.scoreDisplayFlag = scoreDisplayFlag;
        this.discount = discount;
        this.hint = hint;
        this.hasRationale = hasRationale;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.itemTextSet = itemTextSet;
        this.itemMetaDataSet = itemMetaDataSet;
        this.itemFeedbackSet = itemFeedbackSet;
        this.partialCreditFlag = partialCreditFlag;
        this.minScore = minScore;
        this.hash = hash;
    }

    public ItemData(SectionDataIfc section, Integer sequence, Integer duration, String instruction, String description, Long typeId, String grade, Double score, Boolean scoreDisplayFlag, Double discount, Double minScore, String hint, Boolean hasRationale, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, Set<ItemTextIfc> itemTextSet, Set<ItemMetaDataIfc> itemMetaDataSet, Set<ItemFeedbackIfc> itemFeedbackSet, Integer triesAllowed, Boolean partialCreditFlag, String hash) {
        this.section = section;
        this.sequence = sequence;
        this.duration = duration;
        this.instruction = instruction;
        this.description = description;
        this.typeId = typeId;
        this.grade = grade;
        this.score = score;
        this.scoreDisplayFlag = scoreDisplayFlag;
        this.discount = discount;
        this.hint = hint;
        this.hasRationale = hasRationale;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.itemTextSet = itemTextSet;
        this.itemMetaDataSet = itemMetaDataSet;
        this.itemFeedbackSet = itemFeedbackSet;
        this.triesAllowed = triesAllowed;
        this.partialCreditFlag = partialCreditFlag;
        this.minScore = minScore;
        this.hash = hash;
    }

    public ItemData(SectionDataIfc section, Integer sequence, Integer duration, String instruction, String description, Long typeId, String grade, Double score, Boolean scoreDisplayFlag, Double discount, Double minScore, String hint, Boolean hasRationale, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, Set<ItemTextIfc> itemTextSet, Set<ItemMetaDataIfc> itemMetaDataSet, Set<ItemFeedbackIfc> itemFeedbackSet, Integer triesAllowed, Boolean partialCreditFlag, String hash, Long originalItemId) {
        this.section = section;
        this.sequence = sequence;
        this.duration = duration;
        this.instruction = instruction;
        this.description = description;
        this.typeId = typeId;
        this.grade = grade;
        this.score = score;
        this.scoreDisplayFlag = scoreDisplayFlag;
        this.discount = discount;
        this.hint = hint;
        this.hasRationale = hasRationale;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.itemTextSet = itemTextSet;
        this.itemMetaDataSet = itemMetaDataSet;
        this.itemFeedbackSet = itemFeedbackSet;
        this.triesAllowed = triesAllowed;
        this.partialCreditFlag = partialCreditFlag;
        this.minScore = minScore;
        this.hash = hash;
        this.originalItemId = originalItemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
        this.setItemIdString(itemId.toString());
    }

    public String getItemIdString() {
        return this.itemIdString;
    }

    public void setItemIdString(String itemIdString) {
        this.itemIdString = itemIdString;
    }

    public SectionDataIfc getSection() {
        return this.section;
    }

    public void setSection(SectionDataIfc section) {
        this.section = section;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public Boolean getScoreDisplayFlag() {
        if (this.scoreDisplayFlag == null) {
            return Boolean.TRUE;
        }
        return this.scoreDisplayFlag;
    }

    public void setScoreDisplayFlag(Boolean scoreDisplayFlag) {
        this.scoreDisplayFlag = scoreDisplayFlag;
    }

    public Double getDiscount() {
        if (this.discount == null) {
            this.discount = 0.0;
        }
        return this.discount;
    }

    public void setDiscount(Double discount) {
        if (discount == null) {
            discount = 0.0;
        }
        this.discount = discount;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public Boolean getHasRationale() {
        return this.hasRationale;
    }

    public void setHasRationale(Boolean hasRationale) {
        this.hasRationale = hasRationale == null ? Boolean.valueOf(false) : hasRationale;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Set<ItemTextIfc> getItemTextSet() {
        return this.itemTextSet;
    }

    public void setItemTextSet(Set<ItemTextIfc> itemTextSet) {
        this.itemTextSet = itemTextSet;
    }

    public Set<ItemMetaDataIfc> getItemMetaDataSet() {
        return this.itemMetaDataSet;
    }

    public void setItemMetaDataSet(Set<ItemMetaDataIfc> itemMetaDataSet) {
        this.itemMetaDataSet = itemMetaDataSet;
    }

    public Set<ItemTagIfc> getItemTagSet() {
        return this.itemTagSet;
    }

    public void setItemTagSet(Set<ItemTagIfc> itemTagSet) {
        this.itemTagSet = itemTagSet;
        this.tagListToJsonString = this.convertTagListToJsonString(itemTagSet);
    }

    public Set<ItemFeedbackIfc> getItemFeedbackSet() {
        return this.itemFeedbackSet;
    }

    public void setItemFeedbackSet(Set<ItemFeedbackIfc> itemFeedbackSet) {
        this.itemFeedbackSet = itemFeedbackSet;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Long getOriginalItemId() {
        return this.originalItemId;
    }

    public void setOriginalItemId(Long originalItemId) {
        this.originalItemId = originalItemId;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void addItemText(String text, Set<AnswerIfc> answerSet) {
        if (this.itemTextSet == null) {
            this.itemTextSet = new HashSet<ItemTextIfc>();
        }
        Long sequence = this.itemTextSet.size() + 1;
        ItemText itemText = new ItemText(this, sequence, text, answerSet);
        this.itemTextSet.add(itemText);
    }

    public String getItemMetaDataByLabel(String label) {
        for (ItemMetaData itemMetaData : this.itemMetaDataSet) {
            if (!itemMetaData.getLabel().equals(label)) continue;
            return itemMetaData.getEntry();
        }
        return null;
    }

    public void addItemMetaData(String label, String entry) {
        if (this.itemMetaDataSet == null) {
            this.setItemMetaDataSet(new HashSet<ItemMetaDataIfc>());
        }
        this.itemMetaDataSet.add(new ItemMetaData(this, label, entry));
    }

    public String getCorrectItemFeedback() {
        return this.getItemFeedback("Correct Feedback");
    }

    public void setCorrectItemFeedback(String text) {
        this.removeFeedbackByType("Correct Feedback");
        this.addItemFeedback("Correct Feedback", text);
    }

    public String getInCorrectItemFeedback() {
        return this.getItemFeedback("InCorrect Feedback");
    }

    public void setInCorrectItemFeedback(String text) {
        this.removeFeedbackByType("InCorrect Feedback");
        this.addItemFeedback("InCorrect Feedback", text);
    }

    public String getGeneralItemFeedback() {
        return this.getItemFeedback("General Feedback");
    }

    public void setGeneralItemFeedback(String text) {
        this.removeFeedbackByType("General Feedback");
        this.addItemFeedback("General Feedback", text);
    }

    public String getItemFeedback(String typeId) {
        if (this.itemFeedbackSet == null || this.itemFeedbackSet.isEmpty()) {
            return null;
        }
        for (ItemFeedback itemFeedback : this.itemFeedbackSet) {
            if (!itemFeedback.getTypeId().equals(typeId)) continue;
            return itemFeedback.getText();
        }
        return null;
    }

    public void addItemFeedback(String typeId, String text) {
        if (this.itemFeedbackSet == null) {
            this.setItemFeedbackSet(new HashSet<ItemFeedbackIfc>());
        }
        this.itemFeedbackSet.add(new ItemFeedback(this, typeId, text));
    }

    public void removeFeedbackByType(String typeId) {
        if (this.itemFeedbackSet != null) {
            Iterator<ItemFeedbackIfc> i = this.itemFeedbackSet.iterator();
            while (i.hasNext()) {
                ItemFeedbackIfc itemFeedback = i.next();
                if (!itemFeedback.getTypeId().equals(typeId)) continue;
                i.remove();
            }
        }
    }

    public void removeMetaDataByType(String label) {
        try {
            if (this.itemMetaDataSet != null) {
                Iterator<ItemMetaDataIfc> i = this.itemMetaDataSet.iterator();
                while (i.hasNext()) {
                    ItemMetaDataIfc itemMetaData = i.next();
                    if (!itemMetaData.getLabel().equals(label)) continue;
                    i.remove();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean getIsTrue() {
        Iterator aiter;
        if (!this.getTypeId().equals(TypeD.TRUE_FALSE)) {
            return Boolean.FALSE;
        }
        Set answerSet = null;
        Set<ItemTextIfc> set = this.getItemTextSet();
        Iterator<ItemTextIfc> iter = set.iterator();
        if (iter.hasNext()) {
            answerSet = iter.next().getAnswerSet();
        }
        if (answerSet != null && (aiter = answerSet.iterator()).hasNext()) {
            AnswerIfc answer = (AnswerIfc)aiter.next();
            return answer.getIsCorrect();
        }
        return Boolean.FALSE;
    }

    public String getText() {
        String text = "";
        if (this.getTypeId().equals(TypeIfc.MATCHING) || this.getTypeId().equals(TypeIfc.CALCULATED_QUESTION) || this.getTypeId().equals(TypeIfc.IMAGEMAP_QUESTION) || this.getTypeId().equals(TypeIfc.MATRIX_CHOICES_SURVEY)) {
            return this.instruction;
        }
        Set<ItemTextIfc> set = this.getItemTextSet();
        for (ItemTextIfc itemText : set) {
            if (this.getTypeId().equals(TypeIfc.EXTENDED_MATCHING_ITEMS)) {
                if (!itemText.getSequence().equals(0L)) continue;
                text = itemText.getText();
                break;
            }
            text = text + "" + itemText.getText();
            if (this.getTypeId().equals(TypeIfc.FILL_IN_BLANK)) {
                text = text.replaceAll("\\{", "__");
                text = text.replaceAll("\\}", "__");
            }
            if (!this.getTypeId().equals(TypeIfc.FILL_IN_NUMERIC)) continue;
            text = text.replaceAll("\\{", "__");
            text = text.replaceAll("\\}", "__");
        }
        return text;
    }

    public TypeIfc getType() {
        return null;
    }

    public List<ItemTextIfc> getItemTextArray() {
        ArrayList<ItemTextIfc> list = new ArrayList<ItemTextIfc>();
        if (this.itemTextSet != null) {
            Iterator<ItemTextIfc> iter = this.itemTextSet.iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public List<ItemTextIfc> getItemTextArraySorted() {
        List<ItemTextIfc> list = this.getItemTextArray();
        Collections.sort(list);
        return list;
    }

    public void setTriesAllowed(Integer triesAllowed) {
        this.triesAllowed = triesAllowed;
    }

    public Integer getTriesAllowed() {
        return this.triesAllowed;
    }

    public String getAnswerKey() {
        String answerKey = "";
        List<ItemTextIfc> itemTextArray = this.getItemTextArraySorted();
        if (itemTextArray.size() == 0) {
            return answerKey;
        }
        if (this.getTypeId().equals(TypeD.EXTENDED_MATCHING_ITEMS)) {
            for (ItemTextIfc itemText : itemTextArray) {
                if (!itemText.isEmiQuestionItemText()) continue;
                answerKey = answerKey + itemText.getSequence() + ":";
                List emiItems = itemText.getAnswerArraySorted();
                for (AnswerIfc answer : emiItems) {
                    if (!answer.getIsCorrect().booleanValue()) continue;
                    answerKey = answerKey + answer.getLabel();
                }
                answerKey = answerKey + " ";
            }
            return answerKey;
        }
        if (this.typeId.equals(TypeD.MATCHING)) {
            ArrayList<String> answerKeys = new ArrayList<String>(itemTextArray.size());
            for (ItemTextIfc question : itemTextArray) {
                boolean isDistractor = true;
                List answersSorted = question.getAnswerArraySorted();
                for (AnswerIfc answer : answersSorted) {
                    if (this.getPartialCreditFlag().booleanValue() || !answer.getIsCorrect().booleanValue()) continue;
                    answerKeys.add(question.getSequence() + ":" + answer.getLabel());
                    isDistractor = false;
                    break;
                }
                if (!isDistractor) continue;
                answerKeys.add(question.getSequence() + ":" + rb.getString("choice_labels").split(":")[answersSorted.size()]);
            }
            answerKey = StringUtils.join(answerKeys, (String)", ");
            return answerKey;
        }
        for (int i = 0; i < itemTextArray.size(); ++i) {
            ItemTextIfc text = itemTextArray.get(i);
            List answers = text.getAnswerArraySorted();
            for (int j = 0; j < answers.size(); ++j) {
                AnswerIfc a = (AnswerIfc)answers.get(j);
                if (!this.getPartialCreditFlag().booleanValue() && Boolean.TRUE.equals(a.getIsCorrect()) && !this.getTypeId().equals(TypeD.MATCHING) && !this.getTypeId().equals(TypeD.IMAGEMAP_QUESTION)) {
                    answerKey = this.getTypeId().equals(TypeD.TRUE_FALSE) ? a.getText() : ("".equals(answerKey) ? a.getLabel() : answerKey + "," + a.getLabel());
                }
                if (!this.getTypeId().equals(TypeD.MULTIPLE_CHOICE) || !this.getPartialCreditFlag().booleanValue()) continue;
                Double pc = (double)a.getPartialCredit();
                if (pc == null) {
                    pc = 0.0;
                }
                if (!(pc > 0.0)) continue;
                String correct = rb.getString("correct");
                answerKey = "".equals(answerKey) ? a.getLabel() + "&nbsp;<span style='color: green'>(" + pc + "%&nbsp;" + correct + ")</span>" : answerKey + ",&nbsp;" + a.getLabel() + "&nbsp;<span style='color: green'>(" + pc + "%&nbsp;" + correct + ")</span>";
            }
        }
        return answerKey;
    }

    @Override
    public int compareTo(ItemDataIfc o) {
        return this.sequence.compareTo(o.getSequence());
    }

    public boolean getGeneralItemFbIsNotEmpty() {
        return this.isNotEmpty(this.getGeneralItemFeedback());
    }

    public boolean getCorrectItemFbIsNotEmpty() {
        return this.isNotEmpty(this.getCorrectItemFeedback());
    }

    public boolean getIncorrectItemFbIsNotEmpty() {
        return this.isNotEmpty(this.getInCorrectItemFeedback());
    }

    public boolean isNotEmpty(String wyzText) {
        if (wyzText != null) {
            String t = wyzText.replaceAll("(?i)<(?!img|/img).*?>", " ").trim();
            for (int index = 0; index < t.length(); ++index) {
                char c = t.charAt(index);
                if (!Character.isLetterOrDigit(c)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<ItemAttachmentIfc> getItemAttachmentSet() {
        return this.itemAttachmentSet;
    }

    public void setItemAttachmentSet(Set<ItemAttachmentIfc> itemAttachmentSet) {
        this.itemAttachmentSet = itemAttachmentSet;
    }

    public List<ItemAttachmentIfc> getItemAttachmentList() {
        if (this.itemAttachmentSet == null || this.itemAttachmentSet.isEmpty()) {
            return new ArrayList<ItemAttachmentIfc>();
        }
        return new ArrayList<ItemAttachmentIfc>(this.itemAttachmentSet);
    }

    public Map<Long, ItemAttachmentIfc> getItemAttachmentMap() {
        HashMap<Long, ItemAttachmentIfc> map = new HashMap<Long, ItemAttachmentIfc>();
        if (this.itemAttachmentSet == null || this.itemAttachmentSet.isEmpty()) {
            return map;
        }
        for (ItemAttachmentIfc a : this.itemAttachmentSet) {
            map.put(a.getAttachmentId(), a);
        }
        return map;
    }

    public void addItemAttachment(ItemAttachmentIfc attachment) {
        if (attachment == null) {
            return;
        }
        if (this.itemAttachmentSet == null) {
            this.itemAttachmentSet = new HashSet<ItemAttachmentIfc>();
        }
        attachment.setItem((ItemDataIfc)this);
        this.itemAttachmentSet.add(attachment);
    }

    public void removeItemAttachmentById(Long attachmentId) {
        if (attachmentId == null) {
            return;
        }
        if (this.itemAttachmentSet == null || this.itemAttachmentSet.isEmpty()) {
            return;
        }
        Iterator<ItemAttachmentIfc> i = this.itemAttachmentSet.iterator();
        while (i.hasNext()) {
            ItemAttachmentIfc a = i.next();
            if (!attachmentId.equals(a.getAttachmentId())) continue;
            i.remove();
            a.setItem(null);
        }
    }

    public void removeItemAttachment(ItemAttachmentIfc attachment) {
        if (attachment == null) {
            return;
        }
        attachment.setItem(null);
        if (this.itemAttachmentSet == null || this.itemAttachmentSet.isEmpty()) {
            return;
        }
        this.itemAttachmentSet.remove(attachment);
    }

    public Boolean getPartialCreditFlag() {
        if (this.partialCreditFlag == null) {
            return Boolean.FALSE;
        }
        return this.partialCreditFlag;
    }

    public void setPartialCreditFlag(Boolean particalCreditFlag) {
        this.partialCreditFlag = particalCreditFlag;
    }

    public String getLeadInText() {
        if (this.leadInText == null) {
            this.setThemeAndLeadInText();
        }
        return this.leadInText;
    }

    public String getThemeText() {
        if (this.themeText == null) {
            this.setThemeAndLeadInText();
        }
        return this.themeText;
    }

    private void setThemeAndLeadInText() {
        if (TypeD.EXTENDED_MATCHING_ITEMS.equals(this.getTypeId())) {
            boolean themeTextIsSet = false;
            boolean leadInTextIsSet = false;
            if (this.itemTextSet == null) {
                return;
            }
            for (ItemTextIfc itemText : this.itemTextSet) {
                if (itemText.getSequence().equals(ItemTextIfc.EMI_THEME_TEXT_SEQUENCE)) {
                    this.themeText = itemText.getText();
                    themeTextIsSet = true;
                }
                if (itemText.getSequence().equals(ItemTextIfc.EMI_LEAD_IN_TEXT_SEQUENCE)) {
                    this.leadInText = itemText.getText();
                    leadInTextIsSet = true;
                }
                if (!themeTextIsSet || !leadInTextIsSet) continue;
                return;
            }
        }
    }

    public int getNumberOfCorrectEmiOptions() {
        int count = 0;
        if (this.itemTextSet == null) {
            return count;
        }
        for (ItemTextIfc itemText : this.itemTextSet) {
            if (!itemText.isEmiQuestionItemText()) continue;
            for (AnswerIfc answer : itemText.getAnswerSet()) {
                if (!answer.getIsCorrect().booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    public String getEmiAnswerOptionLabels() {
        String emiAnswerOptionLabels = null;
        if (TypeD.EXTENDED_MATCHING_ITEMS.equals(this.getTypeId())) {
            if (this.getIsAnswerOptionsSimple()) {
                emiAnswerOptionLabels = "";
                if (this.getEmiAnswerOptions() != null) {
                    for (AnswerIfc answer : this.getEmiAnswerOptions()) {
                        emiAnswerOptionLabels = emiAnswerOptionLabels + answer.getLabel();
                    }
                }
            } else {
                emiAnswerOptionLabels = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".substring(0, this.getAnswerOptionsRichCount());
            }
        }
        return emiAnswerOptionLabels;
    }

    public boolean isValidEmiAnswerOptionLabel(String label) {
        if (label == null) {
            return false;
        }
        String validOptionLabels = this.getEmiAnswerOptionLabels();
        return label.length() == 1 && validOptionLabels.contains(label);
    }

    public List<AnswerIfc> getEmiAnswerOptions() {
        if (!this.typeId.equals(TypeD.EXTENDED_MATCHING_ITEMS)) {
            return null;
        }
        ItemTextIfc itemText = this.getItemTextBySequence(ItemTextIfc.EMI_ANSWER_OPTIONS_SEQUENCE);
        if (itemText != null) {
            return itemText.getAnswerArraySorted();
        }
        return null;
    }

    public List<ItemTextIfc> getEmiQuestionAnswerCombinations() {
        if (!this.typeId.equals(TypeD.EXTENDED_MATCHING_ITEMS)) {
            return null;
        }
        Iterator<ItemTextIfc> iter = this.getItemTextArraySorted().iterator();
        ArrayList<ItemTextIfc> emiQuestionAnswerCombinations = new ArrayList<ItemTextIfc>();
        while (iter.hasNext()) {
            ItemTextIfc itemText = iter.next();
            if (!itemText.isEmiQuestionItemText()) continue;
            emiQuestionAnswerCombinations.add(itemText);
        }
        return emiQuestionAnswerCombinations;
    }

    public ItemTextIfc getItemTextBySequence(Long itemTextSequence) {
        ItemTextIfc itemText2 = null;
        if (this.itemTextSet == null) {
            return null;
        }
        for (ItemTextIfc itemText2 : this.itemTextSet) {
            if (!itemText2.getSequence().equals(itemTextSequence)) continue;
            return itemText2;
        }
        return null;
    }

    public Integer getAnswerOptionsRichCount() {
        return this.answerOptionsRichCount;
    }

    public void setAnswerOptionsRichCount(Integer answerOptionsRichCount) {
        this.answerOptionsRichCount = answerOptionsRichCount;
    }

    public Integer getAnswerOptionsSimpleOrRich() {
        if (this.answerOptionsSimpleOrRich == null) {
            this.answerOptionsSimpleOrRich = ItemDataIfc.ANSWER_OPTIONS_SIMPLE;
        }
        return this.answerOptionsSimpleOrRich;
    }

    public void setAnswerOptionsSimpleOrRich(Integer answerOptionsSimpleOrRich) {
        this.answerOptionsSimpleOrRich = answerOptionsSimpleOrRich;
    }

    public String getEmiAnswerOptionsRichText() {
        if (!this.typeId.equals(TypeD.EXTENDED_MATCHING_ITEMS)) {
            return null;
        }
        ItemTextIfc itemText = this.getItemTextBySequence(ItemTextIfc.EMI_ANSWER_OPTIONS_SEQUENCE);
        if (itemText != null) {
            return itemText.getText();
        }
        return null;
    }

    public boolean getIsAnswerOptionsSimple() {
        return this.getAnswerOptionsSimpleOrRich().equals(ItemDataIfc.ANSWER_OPTIONS_SIMPLE);
    }

    public boolean getIsAnswerOptionsRich() {
        return this.getAnswerOptionsSimpleOrRich().equals(ItemDataIfc.ANSWER_OPTIONS_RICH);
    }

    public String[] getRowChoices() {
        List<ItemTextIfc> itemTextArray = this.getItemTextArraySorted();
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < itemTextArray.size(); ++i) {
            String str = itemTextArray.get(i).getText();
            if (str == null || str.length() <= 0) continue;
            stringList.add(str);
        }
        String[] rowChoices = stringList.toArray(new String[stringList.size()]);
        return rowChoices;
    }

    public List<Integer> getColumnIndexList() {
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        List<ItemTextIfc> itemTextArray = this.getItemTextArraySorted();
        List answerArray = itemTextArray.get(0).getAnswerArraySorted();
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < answerArray.size(); ++i) {
            String str = ((AnswerIfc)answerArray.get(i)).getText();
            if (str == null || str.length() <= 0) continue;
            stringList.add(str);
        }
        for (int k = 0; k < stringList.size(); ++k) {
            columnIndexList.add(k);
        }
        return columnIndexList;
    }

    public String[] getColumnChoices() {
        List<ItemTextIfc> itemTextArray = this.getItemTextArraySorted();
        List answerArray = itemTextArray.get(0).getAnswerArraySorted();
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < answerArray.size(); ++i) {
            String str = ((AnswerIfc)answerArray.get(i)).getText();
            if (str == null || str.length() <= 0) continue;
            stringList.add(str);
        }
        String[] columnChoices = stringList.toArray(new String[stringList.size()]);
        return columnChoices;
    }

    public boolean getAddCommentFlag() {
        if (this.getItemMetaDataByLabel("ADD_COMMENT_MATRIX") != null) {
            return Boolean.parseBoolean(this.getItemMetaDataByLabel("ADD_COMMENT_MATRIX"));
        }
        return false;
    }

    public String getCommentField() {
        if (this.getItemMetaDataByLabel("ADD_COMMENT_MATRIX") != null && this.getItemMetaDataByLabel("ADD_COMMENT_MATRIX").equalsIgnoreCase("true")) {
            return this.getItemMetaDataByLabel("MX_SURVEY_QUESTION_COMMENTFIELD");
        }
        return null;
    }

    public String getRelativeWidthStyle() {
        String width = this.getItemMetaDataByLabel("MX_SURVEY_RELATIVE_WIDTH");
        if (width != null && Integer.valueOf(width) != 0) {
            return "width:" + width + "%";
        }
        return "";
    }

    public String getImageMapSrc() {
        return this.getItemMetaDataByLabel("IMAGE_MAP_SRC");
    }

    public String getImageMapAltText() {
        return this.getItemMetaDataByLabel("IMAGE_MAP_ALT_TEXT");
    }

    public Double getMinScore() {
        return this.minScore;
    }

    public void setMinScore(Double minScore) {
        this.minScore = minScore;
    }

    private String convertTagListToJsonString(Set<ItemTagIfc> itemTagSet) {
        String tagsListToJson = "[";
        if (itemTagSet != null) {
            Iterator<ItemTagIfc> i = itemTagSet.iterator();
            Boolean more = false;
            while (i.hasNext()) {
                if (more.booleanValue()) {
                    tagsListToJson = tagsListToJson + ",";
                }
                ItemTagIfc tagToShow = i.next();
                String tagId = tagToShow.getTagId();
                String tagLabel = tagToShow.getTagLabel();
                String tagCollectionName = tagToShow.getTagCollectionName();
                tagsListToJson = tagsListToJson + "{\"tagId\":\"" + tagId + "\",\"tagLabel\":\"" + tagLabel + "\",\"tagCollectionName\":\"" + tagCollectionName + "\"}";
                more = true;
            }
        }
        tagsListToJson = tagsListToJson + "]";
        return tagsListToJson;
    }

    public String getTagListToJsonString() {
        return this.tagListToJsonString;
    }

    public void setTagListToJsonString(String tagListToJsonString) {
        this.tagListToJsonString = tagListToJsonString;
    }
}

