/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;

public class SectionData
implements Serializable,
SectionDataIfc,
Comparable {
    private static final long serialVersionUID = 7526471155622776147L;
    public static final Integer ACTIVE_STATUS = 1;
    public static final Integer INACTIVE_STATUS = 0;
    public static final Integer ANY_STATUS = 2;
    private Long id;
    private Long assessmentId;
    private AssessmentIfc assessment;
    private Integer duration;
    private Integer sequence;
    private String title;
    private String description;
    private Long typeId;
    private Integer status;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private Set itemSet;
    private Set sectionMetaDataSet;
    private HashMap sectionMetaDataMap;
    private Set sectionAttachmentSet;

    public SectionData() {
    }

    public SectionData(Integer duration, Integer sequence, String title, String description, Long typeId, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate) {
        this.duration = duration;
        this.sequence = sequence;
        this.title = title;
        this.description = description;
        this.typeId = typeId;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
    }

    public Long getSectionId() {
        return this.id;
    }

    public void setSectionId(Long id) {
        this.id = id;
    }

    public Long getAssessmentId() {
        return this.assessmentId;
    }

    public void setAssessmentId(Long assessmentId) {
        this.assessmentId = assessmentId;
    }

    public void setAssessment(AssessmentIfc assessment) {
        this.assessment = assessment;
    }

    public AssessmentIfc getAssessment() {
        return this.assessment;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Set getItemSet() {
        return this.itemSet;
    }

    public void setItemSet(Set itemSet) {
        this.itemSet = itemSet;
    }

    public Set getSectionMetaDataSet() {
        return this.sectionMetaDataSet;
    }

    public void setSectionMetaDataSet(Set param) {
        this.sectionMetaDataSet = param;
        this.sectionMetaDataMap = this.getSectionMetaDataMap(this.sectionMetaDataSet);
    }

    public HashMap getSectionMetaDataMap(Set metaDataSet) {
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        if (metaDataSet != null) {
            for (SectionMetaData metaData : metaDataSet) {
                metaDataMap.put(metaData.getLabel(), metaData.getEntry());
            }
        }
        return metaDataMap;
    }

    public void addSectionMetaData(String label, String entry) {
        if (this.sectionMetaDataSet == null) {
            this.setSectionMetaDataSet(new HashSet());
            this.sectionMetaDataMap = new HashMap();
        }
        this.sectionMetaDataMap.put(label, entry);
        this.sectionMetaDataSet.add(new SectionMetaData(this, label, entry));
    }

    public String getSectionMetaDataByLabel(String label) {
        return (String)this.sectionMetaDataMap.get(label);
    }

    public ArrayList getItemArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.itemSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public ArrayList getItemArraySortedForGrading() {
        ArrayList list = this.getItemArray();
        Collections.sort(list);
        return list;
    }

    public ArrayList getItemArraySorted() {
        ArrayList list = this.getItemArray();
        Collections.sort(list);
        return list;
    }

    public ArrayList getItemArraySortedWithRandom(long seed) {
        ArrayList list = this.getItemArray();
        Collections.sort(list);
        return list;
    }

    public void addItem(ItemDataIfc item) {
        if (this.itemSet == null) {
            this.itemSet = new HashSet();
        }
        this.itemSet.add((ItemData)item);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public TypeIfc getType() {
        return null;
    }

    public int compareTo(Object o) {
        SectionData a = (SectionData)o;
        return this.sequence.compareTo(a.sequence);
    }

    public Set getSectionAttachmentSet() {
        return this.sectionAttachmentSet;
    }

    public void setSectionAttachmentSet(Set sectionAttachmentSet) {
        this.sectionAttachmentSet = sectionAttachmentSet;
    }

    public List getSectionAttachmentList() {
        ArrayList<SectionAttachmentIfc> list = new ArrayList<SectionAttachmentIfc>();
        if (this.sectionAttachmentSet != null) {
            for (SectionAttachmentIfc a : this.sectionAttachmentSet) {
                list.add(a);
            }
        }
        return list;
    }
}

