/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;

public class PublishedAssessmentData
implements Serializable,
PublishedAssessmentIfc {
    private static final long serialVersionUID = 7526471155622776147L;
    private Long assessmentId;
    private Long assessmentBaseId;
    private String title;
    private String description;
    private String comments;
    private Long typeId;
    private Integer instructorNotification;
    private Integer testeeNotification;
    private Integer multipartAllowed;
    private Integer status;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private AssessmentAccessControlIfc assessmentAccessControl;
    private EvaluationModelIfc evaluationModel;
    private AssessmentFeedbackIfc assessmentFeedback;
    private Set assessmentMetaDataSet;
    private Set securedIPAddressSet;
    private HashMap assessmentMetaDataMap = new HashMap();
    private Set sectionSet;
    private String releaseTo;
    private Date startDate;
    private Date dueDate;
    private Date retractDate;
    private int submissionSize;
    private Integer lateHandling;
    private Boolean unlimitedSubmissions;
    private Integer submissionsAllowed;
    private Integer feedbackDelivery;
    private Integer feedbackComponentOption;
    private Integer feedbackAuthoring;
    private Date feedbackDate;
    private Date feedbackEndDate;
    private Double feedbackScoreThreshold;
    private Set assessmentAttachmentSet;
    private Integer scoringType;
    private Date lastNeedResubmitDate;
    private Integer timeLimit;
    private Long categoryId;

    public PublishedAssessmentData() {
    }

    public PublishedAssessmentData(Long id, String title, Date lastModifiedDate) {
        this.assessmentBaseId = id;
        this.title = title;
        this.lastModifiedDate = lastModifiedDate;
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate) {
        this.assessmentBaseId = id;
        this.title = title;
        this.releaseTo = releaseTo;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Integer status, Date lastModifiedDate, String lastModifiedBy, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed) {
        this.assessmentBaseId = id;
        this.title = title;
        this.releaseTo = releaseTo;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
        this.status = status;
        this.lastModifiedDate = lastModifiedDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lateHandling = lateHandling;
        this.unlimitedSubmissions = unlimitedSubmissions;
        this.submissionsAllowed = submissionsAllowed;
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date lastModifiedDate, String lastModifiedBy) {
        this.assessmentBaseId = id;
        this.title = title;
        this.releaseTo = releaseTo;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
        this.lastModifiedDate = lastModifiedDate;
        this.lastModifiedBy = lastModifiedBy;
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Integer status) {
        this.assessmentBaseId = id;
        this.title = title;
        this.releaseTo = releaseTo;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
        this.status = status;
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Integer status, Date lastModifiedDate, String lastModifiedBy) {
        this.assessmentBaseId = id;
        this.title = title;
        this.releaseTo = releaseTo;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
        this.status = status;
        this.lastModifiedDate = lastModifiedDate;
        this.lastModifiedBy = lastModifiedBy;
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed) {
        this.assessmentBaseId = id;
        this.title = title;
        this.releaseTo = releaseTo;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
        this.lateHandling = lateHandling;
        this.unlimitedSubmissions = unlimitedSubmissions != null ? unlimitedSubmissions : Boolean.TRUE;
        this.submissionsAllowed = submissionsAllowed == null ? Integer.valueOf(0) : submissionsAllowed;
    }

    public PublishedAssessmentData(Long id, String title, PublishedAccessControl assessmentAccessControl) {
        this.assessmentBaseId = id;
        this.title = title;
        this.assessmentAccessControl = assessmentAccessControl;
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed, Date feedbackEndDate, Double feedbackScoreThreshold) {
        this(id, title, releaseTo, startDate, dueDate, retractDate, feedbackDate, feedbackDelivery, feedbackComponentOption, feedbackAuthoring, lateHandling, unlimitedSubmissions, submissionsAllowed, null, null, null, feedbackEndDate, feedbackScoreThreshold);
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed, Integer scoringType, Date feedbackEndDate, Double feedbackScoreThreshold) {
        this(id, title, releaseTo, startDate, dueDate, retractDate, feedbackDate, feedbackDelivery, feedbackComponentOption, feedbackAuthoring, lateHandling, unlimitedSubmissions, submissionsAllowed, scoringType, null, null, feedbackEndDate, feedbackScoreThreshold);
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed, Integer scoringType, Integer status, Date feedbackEndDate, Double feedbackScoreThreshold) {
        this(id, title, releaseTo, startDate, dueDate, retractDate, feedbackDate, feedbackDelivery, feedbackComponentOption, feedbackAuthoring, lateHandling, unlimitedSubmissions, submissionsAllowed, scoringType, status, null, feedbackEndDate, feedbackScoreThreshold);
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed, Integer scoringType, Integer status, Date lastModifiedDate, Date feedbackEndDate, Double feedbackScoreThreshold) {
        this(id, title, releaseTo, startDate, dueDate, retractDate, feedbackDate, feedbackDelivery, feedbackComponentOption, feedbackAuthoring, lateHandling, unlimitedSubmissions, submissionsAllowed, scoringType, status, lastModifiedDate, null, feedbackEndDate, feedbackScoreThreshold);
    }

    public PublishedAssessmentData(Long id, String title, String releaseTo, Date startDate, Date dueDate, Date retractDate, Date feedbackDate, Integer feedbackDelivery, Integer feedbackComponentOption, Integer feedbackAuthoring, Integer lateHandling, Boolean unlimitedSubmissions, Integer submissionsAllowed, Integer scoringType, Integer status, Date lastModifiedDate, Integer timeLimit, Date feedbackEndDate, Double feedbackScoreThreshold) {
        this.assessmentBaseId = id;
        this.title = title;
        this.releaseTo = releaseTo;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.retractDate = retractDate;
        this.feedbackDelivery = feedbackDelivery;
        this.feedbackComponentOption = feedbackComponentOption;
        this.feedbackAuthoring = feedbackAuthoring;
        this.feedbackDate = feedbackDate;
        this.lateHandling = lateHandling;
        this.unlimitedSubmissions = unlimitedSubmissions != null ? unlimitedSubmissions : Boolean.TRUE;
        this.submissionsAllowed = submissionsAllowed == null ? Integer.valueOf(0) : submissionsAllowed;
        this.scoringType = scoringType;
        this.status = status;
        this.lastModifiedDate = lastModifiedDate;
        this.timeLimit = timeLimit;
        this.feedbackEndDate = feedbackEndDate;
        this.feedbackScoreThreshold = feedbackScoreThreshold;
    }

    public PublishedAssessmentData(Long id, int submissionSize) {
        this.assessmentBaseId = id;
        this.submissionSize = submissionSize;
    }

    public PublishedAssessmentData(String title, String description, String comments, Long typeId, Integer instructorNotification, Integer testeeNotification, Integer multipartAllowed, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate) {
        this.title = title;
        this.description = description;
        this.comments = comments;
        this.typeId = typeId;
        this.instructorNotification = instructorNotification;
        this.testeeNotification = testeeNotification;
        this.multipartAllowed = multipartAllowed;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
    }

    public Long getAssessmentId() {
        return this.assessmentId;
    }

    public void setAssessmentId(Long assessmentId) {
        this.assessmentId = assessmentId;
    }

    public Long getPublishedAssessmentId() {
        return this.assessmentBaseId;
    }

    public void setPublishedAssessmentId(Long assessmentBaseId) {
        this.assessmentBaseId = assessmentBaseId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Integer getInstructorNotification() {
        return this.instructorNotification;
    }

    public void setInstructorNotification(Integer instructorNotification) {
        this.instructorNotification = instructorNotification;
    }

    public Integer getTesteeNotification() {
        return this.testeeNotification;
    }

    public void setTesteeNotification(Integer testeeNotification) {
        this.testeeNotification = testeeNotification;
    }

    public Integer getMultipartAllowed() {
        return this.multipartAllowed;
    }

    public void setMultipartAllowed(Integer multipartAllowed) {
        this.multipartAllowed = multipartAllowed;
    }

    public Long getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public AssessmentAccessControlIfc getAssessmentAccessControl() {
        return this.assessmentAccessControl;
    }

    public void setAssessmentAccessControl(AssessmentAccessControlIfc assessmentAccessControl) {
        this.assessmentAccessControl = assessmentAccessControl;
    }

    public EvaluationModelIfc getEvaluationModel() {
        return this.evaluationModel;
    }

    public void setEvaluationModel(EvaluationModelIfc evaluationModel) {
        this.evaluationModel = evaluationModel;
    }

    public AssessmentFeedbackIfc getAssessmentFeedback() {
        return this.assessmentFeedback;
    }

    public void setAssessmentFeedback(AssessmentFeedbackIfc assessmentFeedback) {
        this.assessmentFeedback = assessmentFeedback;
    }

    public Set getAssessmentMetaDataSet() {
        return this.assessmentMetaDataSet;
    }

    public void setAssessmentMetaDataSet(Set assessmentMetaDataSet) {
        this.assessmentMetaDataSet = assessmentMetaDataSet;
        this.assessmentMetaDataMap = this.getAssessmentMetaDataMap(assessmentMetaDataSet);
    }

    public Set getSecuredIPAddressSet() {
        return this.securedIPAddressSet;
    }

    public void setSecuredIPAddressSet(Set securedIPAddressSet) {
        this.securedIPAddressSet = securedIPAddressSet;
    }

    public HashMap getAssessmentMetaDataMap(Set assessmentMetaDataSet) {
        HashMap<String, String> assessmentMetaDataMap = new HashMap<String, String>();
        if (assessmentMetaDataSet != null) {
            for (PublishedMetaData assessmentMetaData : assessmentMetaDataSet) {
                assessmentMetaDataMap.put(assessmentMetaData.getLabel(), assessmentMetaData.getEntry());
            }
        }
        return assessmentMetaDataMap;
    }

    public HashMap getAssessmentMetaDataMap() {
        HashMap<String, String> assessmentMetaDataMap = new HashMap<String, String>();
        if (this.assessmentMetaDataSet != null) {
            for (PublishedMetaData assessmentMetaData : this.assessmentMetaDataSet) {
                assessmentMetaDataMap.put(assessmentMetaData.getLabel(), assessmentMetaData.getEntry());
            }
        }
        return assessmentMetaDataMap;
    }

    public String getAssessmentMetaDataByLabel(String label) {
        return (String)this.assessmentMetaDataMap.get(label);
    }

    public void addAssessmentMetaData(String label, String entry) {
        if (this.assessmentMetaDataMap.get(label) != null) {
            for (AssessmentMetaData metadata : this.assessmentMetaDataSet) {
                if (!metadata.getLabel().equals(label)) continue;
                metadata.setEntry(entry);
            }
        } else {
            AssessmentMetaData metadata = null;
            if (!"".equals(entry.trim())) {
                metadata = new AssessmentMetaData((AssessmentBaseIfc)this, label, entry);
                this.assessmentMetaDataSet.add(metadata);
            }
            this.setAssessmentMetaDataSet(this.assessmentMetaDataSet);
        }
    }

    public void updateAssessmentMetaData(String label, String entry) {
        this.addAssessmentMetaData(label, entry);
    }

    public Set getSectionSet() {
        return this.sectionSet;
    }

    public void setSectionSet(Set sectionSet) {
        this.sectionSet = sectionSet;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public Long getAssessmentBaseId() {
        return this.getAssessmentId();
    }

    public void setAssessmentBaseId(Long assessmentBaseId) {
        this.setAssessmentId(assessmentBaseId);
    }

    public Boolean getIsTemplate() {
        return Boolean.FALSE;
    }

    public void setIsTemplate(Boolean isTemplate) {
    }

    public Long getParentId() {
        return null;
    }

    public void setParentId(Long parentId) {
    }

    public Long getAssessmentTemplateId() {
        return null;
    }

    public void setAssessmentTemplateId(Long assessmentTemplateId) {
    }

    public TypeIfc getType() {
        return null;
    }

    public String getReleaseTo() {
        return this.releaseTo;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getRetractDate() {
        return this.retractDate;
    }

    public int getSubmissionSize() {
        return this.submissionSize;
    }

    public ArrayList getSectionArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.sectionSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public ArrayList getSectionArraySorted() {
        ArrayList list = this.getSectionArray();
        Collections.sort(list);
        return list;
    }

    public SectionDataIfc getSection(Long sequence) {
        ArrayList list = this.getSectionArraySorted();
        if (list == null) {
            return null;
        }
        return (SectionDataIfc)list.get(sequence.intValue() - 1);
    }

    public SectionDataIfc getDefaultSection() {
        ArrayList list = this.getSectionArraySorted();
        if (list == null) {
            return null;
        }
        return (SectionDataIfc)list.get(0);
    }

    public Integer getLateHandling() {
        return this.lateHandling;
    }

    public Boolean getUnlimitedSubmissions() {
        return this.unlimitedSubmissions;
    }

    public Integer getSubmissionsAllowed() {
        return this.submissionsAllowed;
    }

    public Integer getScoringType() {
        return this.scoringType;
    }

    public Integer getFeedbackDelivery() {
        return this.feedbackDelivery;
    }

    public Integer getFeedbackComponentOption() {
        return this.feedbackComponentOption;
    }

    public Integer getFeedbackAuthoring() {
        return this.feedbackAuthoring;
    }

    public Date getFeedbackDate() {
        return this.feedbackDate;
    }

    public Double getTotalScore() {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (PublishedSectionData s : this.sectionSet) {
            ArrayList list = s.getItemArray();
            Iterator iter2 = null;
            if (s.getSectionMetaDataByLabel("AUTHOR_TYPE") != null && s.getSectionMetaDataByLabel("AUTHOR_TYPE").equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
                ArrayList randomsample = new ArrayList();
                Integer numberToBeDrawn = 0;
                if (s.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN") != null) {
                    numberToBeDrawn = new Integer(s.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
                }
                int samplesize = numberToBeDrawn;
                for (int i = 0; i < samplesize; ++i) {
                    randomsample.add(list.get(i));
                }
                iter2 = randomsample.iterator();
            } else {
                iter2 = list.iterator();
            }
            while (iter2.hasNext()) {
                PublishedItemData item = (PublishedItemData)iter2.next();
                if (item.getIsExtraCredit() != null && item.getIsExtraCredit().booleanValue()) continue;
                total = total.add(BigDecimal.valueOf(item.getScore()));
            }
        }
        return total.doubleValue();
    }

    public Set getAssessmentAttachmentSet() {
        return this.assessmentAttachmentSet;
    }

    public void setAssessmentAttachmentSet(Set assessmentAttachmentSet) {
        this.assessmentAttachmentSet = assessmentAttachmentSet;
    }

    public List getAssessmentAttachmentList() {
        ArrayList<AssessmentAttachmentIfc> list = new ArrayList<AssessmentAttachmentIfc>();
        if (this.assessmentAttachmentSet != null) {
            for (AssessmentAttachmentIfc a : this.assessmentAttachmentSet) {
                list.add(a);
            }
        }
        return list;
    }

    public String getHasMetaDataForQuestions() {
        return "false";
    }

    public Date getLastNeedResubmitDate() {
        return this.lastNeedResubmitDate;
    }

    public void setLastNeedResubmitDate(Date lastNeedResubmitDate) {
        this.lastNeedResubmitDate = lastNeedResubmitDate;
    }

    public Integer getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public void setFeedbackEndDate(Date feedbackEndDate) {
        this.feedbackEndDate = feedbackEndDate;
    }

    public Date getFeedbackEndDate() {
        return this.feedbackEndDate;
    }

    public void setFeedbackScoreThreshold(Double feedbackScoreThreshold) {
        this.feedbackScoreThreshold = feedbackScoreThreshold;
    }

    public Double getFeedbackScoreThreshold() {
        return this.feedbackScoreThreshold;
    }
}

