/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentBaseData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;

public class AssessmentData
extends AssessmentBaseData
implements Serializable,
AssessmentIfc {
    private static final long serialVersionUID = -2260656620640273214L;
    private Long assessmentTemplateId;
    private Set sectionSet;
    private Set assessmentAttachmentSet;

    public AssessmentData() {
        this.setIsTemplate(Boolean.FALSE);
    }

    public AssessmentData(Long assessmentTemplateId, String title, Date lastModifiedDate) {
        super(assessmentTemplateId, title, lastModifiedDate);
    }

    public AssessmentData(Long assessmentTemplateId, String title, Date lastModifiedDate, String lastModifiedBy, Date startDate, Date dueDate, String releaseTo) {
        super(assessmentTemplateId, title, lastModifiedDate, lastModifiedBy, startDate, dueDate, releaseTo);
    }

    public AssessmentData(Long assessmentTemplateId, String title, Date lastModifiedDate, String lastModifiedBy, Integer questionSize) {
        super(assessmentTemplateId, title, lastModifiedDate, lastModifiedBy, questionSize);
    }

    public AssessmentData(Long parentId, String title, String description, String comments, Long assessmentTemplateId, Long typeId, Integer instructorNotification, Integer testeeNotification, Integer multipartAllowed, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate) {
        super(Boolean.FALSE, parentId, title, description, comments, typeId, instructorNotification, testeeNotification, multipartAllowed, status, createdBy, createdDate, lastModifiedBy, lastModifiedDate);
        this.assessmentTemplateId = assessmentTemplateId;
    }

    public Long getAssessmentId() {
        return this.getAssessmentBaseId();
    }

    public Long getAssessmentTemplateId() {
        return this.assessmentTemplateId;
    }

    public void setAssessmentTemplateId(Long assessmentTemplateId) {
        this.assessmentTemplateId = assessmentTemplateId;
    }

    public Set getSectionSet() {
        return this.sectionSet;
    }

    public void setSectionSet(Set sectionSet) {
        this.sectionSet = sectionSet;
    }

    public ArrayList getSectionArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.sectionSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public ArrayList getSectionArraySorted() {
        ArrayList list = this.getSectionArray();
        Collections.sort(list);
        return list;
    }

    public SectionDataIfc getSection(Long sequence) {
        ArrayList list = this.getSectionArraySorted();
        if (list == null) {
            return null;
        }
        return (SectionDataIfc)list.get(sequence.intValue() - 1);
    }

    public SectionDataIfc getDefaultSection() {
        ArrayList list = this.getSectionArraySorted();
        if (list == null) {
            return null;
        }
        return (SectionDataIfc)list.get(0);
    }

    public Set getAssessmentAttachmentSet() {
        return this.assessmentAttachmentSet;
    }

    public void setAssessmentAttachmentSet(Set assessmentAttachmentSet) {
        this.assessmentAttachmentSet = assessmentAttachmentSet;
    }

    public List getAssessmentAttachmentList() {
        ArrayList<AssessmentAttachmentIfc> list = new ArrayList<AssessmentAttachmentIfc>();
        if (this.assessmentAttachmentSet != null) {
            for (AssessmentAttachmentIfc a : this.assessmentAttachmentSet) {
                list.add(a);
            }
        }
        return list;
    }

    public String getHasMetaDataForQuestions() {
        return "false";
    }
}

