/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAnswer;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;

public class PublishedItemText
implements Serializable,
ItemTextIfc,
Comparable<ItemTextIfc> {
    private static final long serialVersionUID = 7526471155622776147L;
    static ResourceBundle rb = ResourceBundle.getBundle("org.sakaiproject.tool.assessment.bundle.Messages");
    private Long id;
    private ItemDataIfc item;
    private Long sequence;
    private String text;
    private Set answerSet;
    private Set<ItemTextAttachmentIfc> itemTextAttachmentSet;
    private Integer requiredOptionsCount;

    public PublishedItemText() {
    }

    public PublishedItemText(PublishedItemData item, Long sequence, String text, Set answerSet) {
        this.item = item;
        this.sequence = sequence;
        this.text = text;
        this.answerSet = answerSet;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ItemDataIfc getItem() {
        return this.item;
    }

    public void setItem(ItemDataIfc item) {
        this.item = item;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Set getAnswerSet() {
        return this.answerSet;
    }

    public void setAnswerSet(Set answerSet) {
        this.answerSet = answerSet;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public ArrayList getAnswerArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.answerSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    private boolean hasDistractors() {
        List thisItemElements = this.getItem().getItemTextArray();
        return thisItemElements.size() != this.answerSet.size();
    }

    private boolean hasCorrectAnswers() {
        for (Object thisAnswer : this.answerSet) {
            if (!((PublishedAnswer)thisAnswer).getIsCorrect().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public ArrayList getAnswerArraySorted() {
        ArrayList list = this.getAnswerArray();
        Collections.sort(list);
        return list;
    }

    public List<AnswerIfc> getAnswerArrayWithDistractorSorted() {
        ArrayList answers = this.getAnswerArraySorted();
        List questions = this.item.getItemTextArray();
        if (questions.size() != answers.size()) {
            for (ItemTextIfc question : questions) {
                boolean isDistractor = true;
                List answersSorted = question.getAnswerArraySorted();
                for (AnswerIfc answer : answersSorted) {
                    if (!answer.getIsCorrect().booleanValue()) continue;
                    isDistractor = false;
                    break;
                }
                if (!isDistractor) continue;
                Answer distractor = new Answer();
                distractor.setId(new Long(0L));
                distractor.setLabel(rb.getString("choice_labels").split(":")[answersSorted.size()]);
                distractor.setText("none_above");
                distractor.setIsCorrect(!this.hasCorrectAnswers());
                distractor.setScore(this.getItem().getScore());
                distractor.setSequence(new Long(answers.size()));
                answers.add(distractor);
                break;
            }
        }
        return answers;
    }

    @Override
    public int compareTo(ItemTextIfc o) {
        return this.sequence.compareTo(o.getSequence());
    }

    public Set getItemTextAttachmentSet() {
        return this.itemTextAttachmentSet;
    }

    public List getItemTextAttachmentList() {
        return new ArrayList<ItemTextAttachmentIfc>(this.itemTextAttachmentSet);
    }

    public void setItemTextAttachmentSet(Set itemTextAttachmentSet) {
        this.itemTextAttachmentSet = itemTextAttachmentSet;
    }

    public Map<Long, ItemTextAttachmentIfc> getItemTextAttachmentMap() {
        HashMap<Long, ItemTextAttachmentIfc> map = new HashMap<Long, ItemTextAttachmentIfc>();
        if (this.itemTextAttachmentSet == null || this.itemTextAttachmentSet.isEmpty()) {
            return map;
        }
        for (ItemTextAttachmentIfc a : this.itemTextAttachmentSet) {
            map.put(a.getAttachmentId(), a);
        }
        return map;
    }

    public void addItemTextAttachment(ItemTextAttachmentIfc attachment) {
        if (attachment == null) {
            return;
        }
        if (this.itemTextAttachmentSet == null) {
            this.itemTextAttachmentSet = new HashSet<ItemTextAttachmentIfc>();
        }
        attachment.setItemText((ItemTextIfc)this);
        this.itemTextAttachmentSet.add(attachment);
    }

    public void addNewItemTextAttachment(ItemTextAttachmentIfc attachment) {
        Long attachmentId;
        if (attachment == null) {
            return;
        }
        if (this.itemTextAttachmentSet == null) {
            this.itemTextAttachmentSet = new HashSet<ItemTextAttachmentIfc>();
        }
        if ((attachmentId = attachment.getAttachmentId()) != null) {
            attachment.setAttachmentId(null);
            this.removeItemTextAttachmentById(attachmentId);
        }
        attachment.setItemText((ItemTextIfc)this);
        this.itemTextAttachmentSet.add(attachment);
    }

    public void removeItemTextAttachmentById(Long attachmentId) {
        if (attachmentId == null) {
            return;
        }
        if (this.itemTextAttachmentSet == null || this.itemTextAttachmentSet.isEmpty()) {
            return;
        }
        Iterator<ItemTextAttachmentIfc> i = this.itemTextAttachmentSet.iterator();
        while (i.hasNext()) {
            ItemTextAttachmentIfc a = i.next();
            if (!attachmentId.equals(a.getAttachmentId())) continue;
            i.remove();
            a.setItemText(null);
        }
    }

    public void removeItemTextAttachment(ItemTextAttachmentIfc attachment) {
        if (attachment == null) {
            return;
        }
        attachment.setItemText(null);
        if (this.itemTextAttachmentSet == null || this.itemTextAttachmentSet.isEmpty()) {
            return;
        }
        this.itemTextAttachmentSet.remove(attachment);
    }

    public boolean getHasAttachment() {
        return this.itemTextAttachmentSet != null && this.itemTextAttachmentSet.size() > 0;
    }

    public boolean isEmiQuestionItemText() {
        return this.getSequence() > 0L;
    }

    public Integer getRequiredOptionsCount() {
        if (this.requiredOptionsCount == null) {
            return 1;
        }
        return this.requiredOptionsCount;
    }

    public void setRequiredOptionsCount(Integer requiredOptionsCount) {
        this.requiredOptionsCount = requiredOptionsCount;
    }

    public String getEmiCorrectOptionLabels() {
        if (!this.item.getTypeId().equals(TypeD.EXTENDED_MATCHING_ITEMS)) {
            return null;
        }
        if (!this.isEmiQuestionItemText()) {
            return null;
        }
        if (this.answerSet == null) {
            return null;
        }
        Object correctOptionLabels = "";
        for (AnswerIfc answer : this.getAnswerArraySorted()) {
            if (!answer.getIsCorrect().booleanValue()) continue;
            correctOptionLabels = (String)correctOptionLabels + answer.getLabel();
        }
        return correctOptionLabels;
    }
}

