/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.samigo.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.email.api.DigestService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.emailtemplateservice.model.EmailTemplate;
import org.sakaiproject.emailtemplateservice.model.RenderedTemplate;
import org.sakaiproject.emailtemplateservice.service.EmailTemplateService;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.NotificationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.samigo.api.SamigoETSProvider;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.api.Preferences;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamigoETSProviderImpl
implements SamigoETSProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SamigoETSProviderImpl.class);
    private final Map<String, String> constantValues = new HashMap<String, String>();
    private final String MULTIPART_BOUNDARY = "======sakai-multi-part-boundary======";
    private final String BOUNDARY_LINE = "\n\n--======sakai-multi-part-boundary======\n";
    private final String TERMINATION_LINE = "\n\n--======sakai-multi-part-boundary======--\n\n";
    private final String MIME_ADVISORY = "This message is for MIME-compliant mail readers.";
    private static final String ADMIN = "admin";
    private String fromAddress = "";
    private static final ResourceLoader RB = new ResourceLoader("EmailNotificationMessages");
    private static final String CHANGE_SETTINGS_HOW_TO_INSTRUCTOR = RB.getString("changeSetting_instructor");
    private static final String CHANGE_SETTINGS_HOW_TO_STUDENT = RB.getString("changeSetting_student");
    private ServerConfigurationService serverConfigurationService;
    private UserDirectoryService userDirectoryService;
    private EmailTemplateService emailTemplateService;
    private PreferencesService preferencesService;
    private EmailService emailService;
    private DigestService digestService;
    private NotificationService notificationService;
    private SiteService siteService;
    private SessionManager sessionManager;
    private SecurityService securityService;
    private AuthzGroupService authzGroupService;

    public void init() {
        LOG.info("init()");
        String samigoFromAddress = this.serverConfigurationService.getString("samigo.fromAddress");
        this.fromAddress = samigoFromAddress == null || StringUtils.isBlank((String)samigoFromAddress) ? this.serverConfigurationService.getString("setup.request", "no-reply@" + this.serverConfigurationService.getServerName()) : samigoFromAddress;
        this.constantValues.put("localSakaiName", this.serverConfigurationService.getString("ui.service", ""));
        this.constantValues.put("localSakaiUrl", this.serverConfigurationService.getPortalUrl());
        this.loadTemplate("template-assessmentSubmission.xml", "sam.assessmentSubmitted");
        this.loadTemplate("template-assessmentAutoSubmission.xml", "sam.assessmentAutoSubmitted");
        this.loadTemplate("template-assessmentTimedSubmission.xml", "sam.assessmentTimedSubmitted");
    }

    public void notify(String eventKey, Map<String, Object> notificationValues, Event event) {
        LOG.debug("Notify, templateKey: " + eventKey + " event: " + event.toString());
        switch (eventKey) {
            case "sam.assessmentSubmitted": {
                this.handleAssessmentSubmitted(notificationValues, event);
                break;
            }
            case "sam.assessmentAutoSubmitted": {
                this.handleAssessmentAutoSubmitted(notificationValues, event);
                break;
            }
            case "sam.assessmentTimedSubmitted": {
                this.handleAssessmentTimedSubmitted(notificationValues, event);
            }
        }
    }

    private void handleAssessmentSubmitted(Map<String, Object> notificationValues, Event event) {
        LOG.debug("Assessment Submitted");
        this.assessmentSubmittedHelper(notificationValues, event, 1);
    }

    private void handleAssessmentAutoSubmitted(Map<String, Object> notificationValues, Event event) {
        LOG.debug("Assessment Auto Submitted");
        this.assessmentSubmittedHelper(notificationValues, event, 2);
    }

    private void handleAssessmentTimedSubmitted(Map<String, Object> notificationValues, Event event) {
        LOG.debug("Assessment Timed Submitted");
        this.assessmentSubmittedHelper(notificationValues, event, 3);
    }

    private void assessmentSubmittedHelper(Map<String, Object> notificationValues, Event event, int assessmentSubmittedType) {
        LOG.debug("assessment Submitted helper, assessmentSubmittedType: " + assessmentSubmittedType);
        String priStr = Integer.toString(event.getPriority());
        HashMap<String, String> replacementValues = new HashMap<String, String>(this.constantValues);
        try {
            User user = this.userDirectoryService.getUser(notificationValues.get("userID").toString());
            PublishedAssessmentService pubAssServ = new PublishedAssessmentService();
            PublishedAssessmentFacade pubAssFac = pubAssServ.getSettingsOfPublishedAssessment(notificationValues.get("publishedAssessmentID").toString());
            String siteID = pubAssFac.getOwnerSiteId();
            replacementValues.put("siteName", pubAssFac.getOwnerSite());
            replacementValues.put("siteID", siteID);
            replacementValues.put("userName", user.getDisplayName());
            replacementValues.put("userDisplayID", user.getDisplayId());
            replacementValues.put("assessmentTitle", pubAssFac.getTitle());
            replacementValues.put("assessmentDueDate", pubAssFac.getDueDate() == null ? "" : pubAssFac.getDueDate().toString());
            replacementValues.put("assessmentGradingID", notificationValues.get("assessmentGradingID").toString());
            replacementValues.put("submissionDate", notificationValues.get("submissionDate").toString());
            replacementValues.put("confirmationNumber", notificationValues.get("confirmationNumber").toString());
            this.notifyStudent(user, priStr, assessmentSubmittedType, replacementValues);
            this.notifyInstructor(siteID, pubAssFac.getInstructorNotification(), priStr, assessmentSubmittedType, user, replacementValues);
        }
        catch (UserNotDefinedException e) {
            LOG.warn("UserNotDefined: " + notificationValues.get("userID").toString() + " in sending samigo notification.");
        }
    }

    private void notifyInstructor(String siteID, Integer instructNoti, String priStr, int assessmentSubmittedType, User submittingUser, Map<String, String> replacementValues) {
        User user;
        LOG.debug("notifyInstructor");
        replacementValues.put("changeSettingInstructions", CHANGE_SETTINGS_HOW_TO_INSTRUCTOR);
        HashMap<User, Integer> validUsers = new HashMap<User, Integer>();
        RenderedTemplate rt = this.getRenderedTemplateBySubmissionType(assessmentSubmittedType, submittingUser, replacementValues);
        String message = this.getBody(rt);
        try {
            Site site = this.siteService.getSite(siteID);
            AuthzGroup azGroup = this.authzGroupService.getAuthzGroup("/site/" + siteID);
            Set siteUsersHasRole = site.getUsersHasRole(azGroup.getMaintainRole());
            for (String string : siteUsersHasRole) {
                try {
                    if (string.equals(ADMIN)) continue;
                    user = this.userDirectoryService.getUser(string);
                    Integer uPref = this.getUserPreferences(user, priStr);
                    validUsers.put(user, uPref);
                }
                catch (UserNotDefinedException e) {
                    LOG.warn("Instructor '" + string + "' not found in samigo notification.");
                }
            }
        }
        catch (IdUnusedException e) {
            LOG.warn("Site '{}' not found while sending instructor notifications for samigo submission.", (Object)siteID);
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        catch (GroupNotDefinedException e) {
            LOG.warn("AuthzGroup '/site/{}' not found while sending instructor notifications for samigo submission", (Object)siteID);
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        ArrayList<User> users = new ArrayList<User>();
        ArrayList<User> immediateUsers = new ArrayList<User>();
        if (validUsers.size() > 0) {
            users.addAll(validUsers.keySet());
            List<String> headers = this.getHeaders(rt, users, this.constantValues.get("localSakaiName"), this.fromAddress);
            for (Map.Entry entry : validUsers.entrySet()) {
                user = (User)entry.getKey();
                if (instructNoti == 3) {
                    immediateUsers.add(user);
                    continue;
                }
                if (instructNoti != 2) continue;
                LOG.debug("notifyInstructor + sendDigest + User: " + user.getDisplayName() + " rt: " + rt.getKey());
                this.digestService.digest(user.getId(), rt.getRenderedSubject(), rt.getRenderedMessage());
            }
            if (instructNoti == 3 && !immediateUsers.isEmpty()) {
                LOG.debug("notifyInstructor + send one email to Users: " + ((Object)immediateUsers).toString() + " rt: " + rt.getKey());
                this.emailService.sendToUsers(immediateUsers, headers, message);
            }
        }
    }

    private void notifyStudent(User user, String priStr, int assessmentSubmittedType, Map<String, String> replacementValues) {
        LOG.debug("notifyStudent");
        replacementValues.put("changeSettingInstructions", CHANGE_SETTINGS_HOW_TO_STUDENT);
        ArrayList<User> users = new ArrayList<User>();
        RenderedTemplate rt = this.getRenderedTemplateBySubmissionType(assessmentSubmittedType, user, replacementValues);
        String message = this.getBody(rt);
        users.add(user);
        List<String> headers = this.getHeaders(rt, users, this.constantValues.get("localSakaiName"), this.fromAddress);
        int uSamEmailPref = this.getUserPreferences(user, priStr);
        if (uSamEmailPref == 3) {
            LOG.debug("notifyStudent + send one email + rt: " + rt.getKey());
            this.emailService.sendToUsers(users, headers, message);
        } else if (uSamEmailPref == 2) {
            LOG.debug("notifyStudent + sendDigest + rt: " + rt.getKey());
            this.digestService.digest(user.getId(), rt.getRenderedSubject(), rt.getRenderedMessage());
        }
    }

    private int getUserPreferences(User user, String priStr) {
        LOG.debug("getUserPreferences User: " + user.getDisplayName());
        int uSamEmailPref = 3;
        Preferences userPrefs = this.preferencesService.getPreferences(user.getId());
        ResourceProperties props = userPrefs.getProperties("noti:types:sakai:samigo");
        try {
            uSamEmailPref = (int)props.getLongProperty(priStr);
        }
        catch (EntityPropertyNotDefinedException | EntityPropertyTypeException throwable) {
            // empty catch block
        }
        LOG.debug("getUserPreferences: pref=" + uSamEmailPref);
        return uSamEmailPref;
    }

    private String getBody(RenderedTemplate rt) {
        LOG.debug("getBody");
        StringBuilder body = new StringBuilder();
        body.append("This message is for MIME-compliant mail readers.");
        if (rt.getRenderedMessage() != null) {
            body.append("\n\n--======sakai-multi-part-boundary======\n");
            body.append("Content-Type: text/plain; charset=UTF-8\n");
            body.append(rt.getRenderedMessage());
        }
        if (rt.getRenderedHtmlMessage() != null) {
            body.append("\n\n--======sakai-multi-part-boundary======\n");
            body.append("Content-Type: text/html; charset=UTF-8\n");
            body.append(rt.getRenderedHtmlMessage());
        }
        body.append("\n\n--======sakai-multi-part-boundary======--\n\n");
        return body.toString();
    }

    private RenderedTemplate getRenderedTemplateBySubmissionType(int assessmentSubmittedType, User user, Map<String, String> replacementValues) {
        RenderedTemplate template;
        switch (assessmentSubmittedType) {
            case 2: {
                template = this.getRenderedTemplate("sam.assessmentAutoSubmitted", user, replacementValues);
                break;
            }
            case 3: {
                template = this.getRenderedTemplate("sam.assessmentTimedSubmitted", user, replacementValues);
                break;
            }
            default: {
                template = this.getRenderedTemplate("sam.assessmentSubmitted", user, replacementValues);
            }
        }
        return template;
    }

    private RenderedTemplate getRenderedTemplate(String templateName, User user, Map<String, String> replacementValues) {
        LOG.debug("getting template: " + templateName);
        RenderedTemplate template = null;
        try {
            template = this.emailTemplateService.getRenderedTemplateForUser(templateName, user != null ? user.getReference() : "", replacementValues);
        }
        catch (Exception e) {
            LOG.warn("Samigo Notification email template error. " + this + e.getMessage());
        }
        return template;
    }

    private List<String> getHeaders(RenderedTemplate rt, List<User> toAddress, String fromName, String fromEmail) {
        LOG.debug("getHeaders");
        ArrayList<String> headers = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)rt.getFrom())) {
            headers.add("From: \"" + rt.getFrom());
        } else {
            headers.add("From: \"" + fromName + "\" <" + fromEmail + ">");
        }
        String toName = fromName;
        String toEmail = fromEmail;
        if (toAddress.size() == 1) {
            User u = toAddress.get(0);
            toName = u.getDisplayName();
            toEmail = u.getEmail();
        }
        headers.add("To: \"" + toName + "\" <" + toEmail + ">");
        headers.add("Subject: " + rt.getRenderedSubject());
        headers.add("Content-Type: multipart/alternative; boundary=\"======sakai-multi-part-boundary======\"");
        headers.add("Mime-Version: 1.0");
        headers.add("Return-Path: <>");
        headers.add("Auto-Submitted: auto-generated");
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTemplate(String templateFileName, String templateRegistrationString) {
        LOG.info(this + " loading template " + templateFileName);
        SecurityAdvisor yesMan = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        try {
            this.securityService.pushAdvisor(yesMan);
            InputStream input = SamigoETSProviderImpl.class.getClassLoader().getResourceAsStream("" + templateFileName);
            if (input == null) {
                LOG.error("Could not load resource from '" + templateFileName + "'. Skipping ...");
            } else {
                Document document = new SAXBuilder().build(input);
                List childTemplates = document.getRootElement().getChildren("emailTemplate");
                Iterator iter = childTemplates.iterator();
                while (iter.hasNext()) {
                    this.xmlToTemplate((Element)iter.next(), templateRegistrationString);
                }
            }
        }
        catch (IOException | JDOMException e) {
            LOG.error("loadTemplate error: ", e);
        }
        finally {
            this.securityService.popAdvisor(yesMan);
        }
    }

    private void xmlToTemplate(Element xmlTemplate, String key) {
        String subject = xmlTemplate.getChildText("subject");
        String body = xmlTemplate.getChildText("message");
        String bodyHtml = xmlTemplate.getChildText("messagehtml");
        String locale = xmlTemplate.getChildText("locale");
        String localeLangTag = xmlTemplate.getChildText("localeLangTag");
        String versionString = xmlTemplate.getChildText("version");
        if (this.emailTemplateService.getEmailTemplate(key, Locale.forLanguageTag(localeLangTag)) == null) {
            EmailTemplate template = new EmailTemplate();
            template.setSubject(subject);
            template.setMessage(body);
            if (bodyHtml != null) {
                String decodedHtml;
                try {
                    decodedHtml = URLDecoder.decode(bodyHtml, "utf8");
                }
                catch (UnsupportedEncodingException e) {
                    decodedHtml = bodyHtml;
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
                template.setHtmlMessage(decodedHtml);
            }
            template.setLocale(locale);
            template.setKey(key);
            template.setVersion(Integer.valueOf(versionString));
            template.setOwner(ADMIN);
            template.setLastModified(new Date());
            try {
                this.emailTemplateService.saveTemplate(template);
                LOG.info(this + " user notification template " + key + " added");
            }
            catch (Exception e) {
                LOG.warn("Samigo notification xmlToTemplate error." + e);
            }
        }
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setDigestService(DigestService digestService) {
        this.digestService = digestService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }
}

