/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.samigo.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.samigo.impl.SamigoETSProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamigoObserver
implements Observer {
    private static final Logger log = LoggerFactory.getLogger(SamigoObserver.class);
    private EventTrackingService eventTrackingService;
    private SamigoETSProviderImpl samigoETSProvider;

    public void init() {
        log.info("init()");
        this.eventTrackingService.addLocalObserver((Observer)this);
    }

    public void destroy() {
        log.info("destroy");
        this.eventTrackingService.deleteObserver((Observer)this);
    }

    @Override
    public void update(Observable arg0, Object arg) {
        if (!(arg instanceof Event)) {
            return;
        }
        Event event = (Event)arg;
        String eventType = event.getEvent();
        if ("sam.assessmentSubmitted".equals(eventType)) {
            log.debug("Assessment Submitted Event");
            String hashMapString = event.getResource();
            Map<String, Object> notiValues = this.stringToHashMap(hashMapString);
            this.samigoETSProvider.notify("sam.assessmentSubmitted", notiValues, event);
        } else if ("sam.assessmentAutoSubmitted".equals(eventType)) {
            log.debug("Assessment Auto Submitted Event");
            String hashMapString = event.getResource();
            Map<String, Object> notiValues = this.stringToHashMap(hashMapString);
            this.samigoETSProvider.notify("sam.assessmentAutoSubmitted", notiValues, event);
        } else if ("sam.assessmentTimedSubmitted".equals(eventType)) {
            log.debug("Assessment Timed Submitted Event");
            String hashMapString = event.getResource();
            Map<String, Object> notiValues = this.stringToHashMap(hashMapString);
            this.samigoETSProvider.notify("sam.assessmentTimedSubmitted", notiValues, event);
        }
    }

    private Map<String, Object> stringToHashMap(String hashMapString) {
        String[] keyValuePairs;
        HashMap<String, Object> map = new HashMap<String, Object>();
        hashMapString = StringUtils.substringBetween((String)hashMapString, (String)"{", (String)"}");
        for (String pair : keyValuePairs = hashMapString.split(",")) {
            String[] entry = pair.split("=");
            String key = StringUtils.trim((String)entry[0]);
            if (entry.length == 2) {
                if (key.equals("assessmentGradingID") || key.equals("publishedAssessmentID")) {
                    map.put(key, Long.valueOf(StringUtils.trim((String)entry[1])));
                    continue;
                }
                map.put(key, String.valueOf(StringUtils.trim((String)entry[1])));
                continue;
            }
            map.put(key, "");
        }
        return map;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public void setSamigoETSProvider(SamigoETSProviderImpl samigoETSProvider) {
        this.samigoETSProvider = samigoETSProvider;
    }
}

