/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.samigo.search;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.htmlparser.jericho.Source;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.EntityContentProducerEvents;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.tool.assessment.entity.impl.PublishedItemEntityProviderImpl;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacade;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedItemContentProducer
implements EntityContentProducer,
EntityContentProducerEvents {
    private static final Logger log = LoggerFactory.getLogger(PublishedItemContentProducer.class);
    private SearchService searchService;
    private SearchIndexBuilder searchIndexBuilder;
    private EntityManager entityManager = null;
    PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();

    protected void init() throws Exception {
        if ("true".equals(ServerConfigurationService.getString((String)"search.enable", (String)"false"))) {
            this.getSearchIndexBuilder().registerEntityContentProducer((EntityContentProducer)this);
        }
    }

    public Set<String> getTriggerFunctions() {
        HashSet<String> h = new HashSet<String>();
        h.add("sam.pubassessment.saveitem");
        h.add("sam.pubassessment.unindexitem");
        return h;
    }

    protected void destroy() {
        log.info("destroy() PublishedItemContentProducer");
    }

    private Reference getReference(String reference) {
        return null;
    }

    private EntityReference getEntityReference(String reference) {
        try {
            return new EntityReference("/sam_publisheditem/" + reference);
        }
        catch (Exception ex) {
            log.debug("Managed exception getting the published item entity reference: " + ex.getClass().getName() + " : " + ex.getMessage());
            return null;
        }
    }

    public boolean canRead(String eventResource) {
        String reference = this.getReferenceFromEventResource(eventResource);
        EntityProviderManager entityProviderManager = (EntityProviderManager)ComponentManager.get(EntityProviderManager.class);
        EntityReference er = new EntityReference("/sam_publisheditem/" + reference);
        try {
            PublishedItemEntityProviderImpl qhp = (PublishedItemEntityProviderImpl)entityProviderManager.getProviderByPrefix(er.getPrefix());
            qhp.entityExists(er.getId());
            return true;
        }
        catch (Exception ex) {
            log.debug("Managed exception getting the item canRead function" + ex.getClass().getName() + " : " + ex.getMessage());
            return false;
        }
    }

    public Integer getAction(Event event) {
        String evt = event.getEvent();
        if (evt == null) {
            return SearchBuilderItem.ACTION_UNKNOWN;
        }
        if (evt.equals("sam.pubassessment.saveitem")) {
            return SearchBuilderItem.ACTION_ADD;
        }
        if (evt.equals("sam.pubassessment.unindexitem")) {
            return SearchBuilderItem.ACTION_DELETE;
        }
        return SearchBuilderItem.ACTION_UNKNOWN;
    }

    public List getAllContent() {
        ArrayList all = new ArrayList();
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> getAllFields(String resourceName) {
        HashMap<String, Object> allInfo = new HashMap<String, Object>();
        String reference = this.getReferenceFromEventResource(resourceName);
        EntityProviderManager entityProviderManager = (EntityProviderManager)ComponentManager.get(EntityProviderManager.class);
        EntityReference er = new EntityReference("/sam_publisheditem/" + reference);
        PublishedItemEntityProviderImpl qhp = (PublishedItemEntityProviderImpl)entityProviderManager.getProviderByPrefix(er.getPrefix());
        try {
            PublishedItemFacade item = (PublishedItemFacade)qhp.getEntity(er);
            allInfo.put("questionId", this.getId(resourceName));
            allInfo.put("site", qhp.siteIds(item).get(0));
            allInfo.put("tags", qhp.tags(item));
            allInfo.put("questionPoolId", new ArrayList());
            allInfo.put("assessmentId", qhp.assessmentId(item));
            allInfo.put("hash", item.getHash());
            allInfo.put("type", "question");
            allInfo.put("subtype", "publisheditem");
            allInfo.put("typeId", item.getTypeId().toString());
            if (item.getTypeId() == 14L) {
                allInfo.put("qText", item.getThemeText());
            }
            allInfo.put("qText", item.getText());
        }
        catch (Exception ex) {
            log.debug("Managed exception getting the question hash " + ex.getClass().getName() + " : " + ex.getMessage());
        }
        finally {
            return allInfo;
        }
    }

    public String getContainer(String reference) {
        return "";
    }

    public String getContent(String eventResource) {
        String reference = this.getReferenceFromEventResource(eventResource);
        EntityProviderManager entityProviderManager = (EntityProviderManager)ComponentManager.get(EntityProviderManager.class);
        EntityReference er = new EntityReference("/sam_publisheditem/" + reference);
        PublishedItemEntityProviderImpl qhp = (PublishedItemEntityProviderImpl)entityProviderManager.getProviderByPrefix(er.getPrefix());
        try {
            PublishedItemFacade item = (PublishedItemFacade)qhp.getEntity(er);
            String content = qhp.content(item);
            Source parseContent = new Source((CharSequence)content);
            return parseContent.getTextExtractor().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(" Failed to get item content ", e);
        }
    }

    public Reader getContentReader(String reference) {
        return new StringReader(this.getContent(reference));
    }

    public Map getCustomProperties(String eventResource) {
        HashMap customProperties = new HashMap();
        try {
            return customProperties;
        }
        catch (Exception ex) {
            log.debug("Managed exception getting the question custom Properties" + ex.getClass().getName() + " : " + ex.getMessage());
            return null;
        }
    }

    public List<String> getTags(String resource) {
        String reference = this.getReferenceFromEventResource(resource);
        EntityProviderManager entityProviderManager = (EntityProviderManager)ComponentManager.get(EntityProviderManager.class);
        EntityReference er = new EntityReference("/sam_publisheditem/" + reference);
        PublishedItemEntityProviderImpl qhp = (PublishedItemEntityProviderImpl)entityProviderManager.getProviderByPrefix(er.getPrefix());
        try {
            PublishedItemFacade item = (PublishedItemFacade)qhp.getEntity(er);
            return qhp.tags(item);
        }
        catch (Exception ex) {
            log.debug("Managed exception getting the question tags" + ex.getClass().getName() + " : " + ex.getMessage());
            return null;
        }
    }

    public String getHash(String resource) {
        String reference = this.getReferenceFromEventResource(resource);
        EntityProviderManager entityProviderManager = (EntityProviderManager)ComponentManager.get(EntityProviderManager.class);
        EntityReference er = new EntityReference("/sam_publisheditem/" + reference);
        PublishedItemEntityProviderImpl qhp = (PublishedItemEntityProviderImpl)entityProviderManager.getProviderByPrefix(er.getPrefix());
        try {
            PublishedItemFacade item = (PublishedItemFacade)qhp.getEntity(er);
            return item.getHash();
        }
        catch (Exception ex) {
            log.debug("Managed exception getting the question hash " + ex.getClass().getName() + " : " + ex.getMessage());
            return null;
        }
    }

    public String getCustomRDF(String ref) {
        return null;
    }

    public String getId(String reference) {
        try {
            return "/sam_publisheditem/" + this.getReferenceFromEventResource(reference);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public List getSiteContent(String context) {
        ArrayList questionIdList = new ArrayList();
        List assessmentsList1 = this.publishedAssessmentService.getBasicInfoOfAllActivePublishedAssessmentsByAgentId("title", true, context);
        Iterator assessmentList1Iterator = assessmentsList1.iterator();
        while (assessmentList1Iterator.hasNext()) {
            List assessmentQuestionIdsList1 = this.publishedAssessmentService.getPublishedItemIds(Long.toString(((PublishedAssessmentFacade)assessmentList1Iterator.next()).getPublishedAssessmentId()));
            questionIdList.addAll(assessmentQuestionIdsList1);
        }
        List assessmentsList2 = this.publishedAssessmentService.getBasicInfoOfAllInActivePublishedAssessmentsByAgentId("title", true, context);
        Iterator assessmentList1Iterator2 = assessmentsList2.iterator();
        while (assessmentList1Iterator2.hasNext()) {
            List assessmentQuestionIdsList2 = this.publishedAssessmentService.getPublishedItemIds(Long.toString(((PublishedAssessmentFacade)assessmentList1Iterator2.next()).getPublishedAssessmentId()));
            questionIdList.addAll(assessmentQuestionIdsList2);
        }
        return questionIdList;
    }

    public Iterator getSiteContentIterator(String context) {
        return this.getSiteContent(context).iterator();
    }

    private String getSiteId(Reference ref) {
        String reference = this.getReferenceFromEventResource(ref.getReference());
        return this.getSiteId(reference);
    }

    public String getSiteId(String resource) {
        String reference = this.getReferenceFromEventResource(resource);
        EntityProviderManager entityProviderManager = (EntityProviderManager)ComponentManager.get(EntityProviderManager.class);
        EntityReference er = new EntityReference("/sam_publisheditem/" + reference);
        PublishedItemEntityProviderImpl qhp = (PublishedItemEntityProviderImpl)entityProviderManager.getProviderByPrefix(er.getPrefix());
        try {
            PublishedItemFacade item = (PublishedItemFacade)qhp.getEntity(er);
            return (String)qhp.siteIds(item).get(0);
        }
        catch (Exception ex) {
            log.debug("Managed exception getting the question site id" + ex.getClass().getName() + " : " + ex.getMessage());
            return null;
        }
    }

    public String getAssessmentId(String resource) {
        String reference = this.getReferenceFromEventResource(resource);
        EntityProviderManager entityProviderManager = (EntityProviderManager)ComponentManager.get(EntityProviderManager.class);
        EntityReference er = new EntityReference("/sam_publisheditem/" + reference);
        PublishedItemEntityProviderImpl qhp = (PublishedItemEntityProviderImpl)entityProviderManager.getProviderByPrefix(er.getPrefix());
        try {
            PublishedItemFacade item = (PublishedItemFacade)qhp.getEntity(er);
            return qhp.assessmentId(item);
        }
        catch (Exception ex) {
            log.debug("Managed exception getting the question origin" + ex.getClass().getName() + " : " + ex.getMessage());
            return null;
        }
    }

    public String getSubType(String reference) {
        return "publisheditem";
    }

    public String getTitle(String reference) {
        return "";
    }

    public String getTool() {
        return "";
    }

    public String getType(String reference) {
        return "question";
    }

    public String getUrl(String reference) {
        return "";
    }

    public boolean isContentFromReader(String reference) {
        return false;
    }

    public boolean isForIndex(String resource) {
        String reference = this.getReferenceFromEventResource(resource);
        EntityProviderManager entityProviderManager = (EntityProviderManager)ComponentManager.get(EntityProviderManager.class);
        EntityReference er = new EntityReference("/sam_publisheditem/" + reference);
        PublishedItemEntityProviderImpl qhp = (PublishedItemEntityProviderImpl)entityProviderManager.getProviderByPrefix(er.getPrefix());
        try {
            return qhp.entityExists(reference);
        }
        catch (Exception ex) {
            log.debug("Managed exception in isForIndex" + ex.getClass().getName() + " : " + ex.getMessage());
            return false;
        }
    }

    public boolean matches(String resource) {
        String reference = this.getReferenceFromEventResource(resource);
        EntityProviderManager entityProviderManager = (EntityProviderManager)ComponentManager.get(EntityProviderManager.class);
        EntityReference er = new EntityReference("/sam_publisheditem/" + this.getReferenceFromEventResource(reference));
        PublishedItemEntityProviderImpl qhp = (PublishedItemEntityProviderImpl)entityProviderManager.getProviderByPrefix(er.getPrefix());
        return qhp.entityExists(reference);
    }

    public boolean matches(Event event) {
        return this.matches(this.getReferenceFromEventResource(event.getResource()));
    }

    private String getReferenceFromEventResource(String resource) {
        String reference = resource.indexOf(" publishedItemId=") == -1 ? (resource.indexOf("/sam_publisheditem/") == -1 ? resource : resource.substring(resource.indexOf("/sam_publisheditem/") + 19)) : resource.substring(resource.indexOf(" publishedItemId=") + 17);
        return reference;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public SearchIndexBuilder getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }
}

