/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.samigo.search;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.lang3.ArrayUtils;
import org.elasticsearch.common.lang3.tuple.Pair;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.FacetBuilders;
import org.osid.shared.SharedException;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.samigo.search.ItemContentProducer;
import org.sakaiproject.samigo.search.PublishedItemContentProducer;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.elasticsearch.BaseElasticSearchIndexBuilder;
import org.sakaiproject.search.elasticsearch.NoContentException;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolData;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolIteratorFacade;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionElasticSearchIndexBuilder
extends BaseElasticSearchIndexBuilder {
    private static final Logger log = LoggerFactory.getLogger(QuestionElasticSearchIndexBuilder.class);
    QuestionPoolService questionPoolService = new QuestionPoolService();
    private SiteService siteService;
    protected String[] searchResultFieldNames;
    protected static final String SAKAI_DOC_TYPE = "question_doc";
    protected static final String ADD_RESOURCE_VALIDATION_KEY_ITEM = "questionId";
    protected static final String DELETE_RESOURCE_KEY_ITEM = "questionId";
    protected boolean useSuggestions = false;
    protected boolean useFacetting = false;
    protected boolean useAggregation = true;
    protected static final String AGGREGATION_NAME = "dedup";
    protected static final String AGGREGATION_TOP_HITS = "dedup_docs";

    protected void beforeElasticSearchConfigInitialization() {
        if (StringUtils.isEmpty((CharSequence)this.indexedDocumentType)) {
            this.indexedDocumentType = SAKAI_DOC_TYPE;
        }
        if (ArrayUtils.isEmpty((Object[])this.suggestionResultFieldNames)) {
            this.suggestionResultFieldNames = new String[0];
        }
        if (ArrayUtils.isEmpty((Object[])this.searchResultFieldNames)) {
            this.searchResultFieldNames = new String[]{"contents", "questionId", "site", "tags", "questionPoolId", "assessmentId", "hash", "type", "subtype"};
        }
    }

    protected void beforeBackgroundSchedulerInitialization() {
    }

    protected SearchRequestBuilder completeFindContentQueueRequestBuilder(SearchRequestBuilder searchRequestBuilder) {
        return searchRequestBuilder;
    }

    protected DeleteRequestBuilder completeDeleteRequestBuilder(DeleteRequestBuilder deleteRequestBuilder, Map<String, Object> deleteParams) {
        return deleteRequestBuilder.setRouting((String)deleteParams.get("questionId"));
    }

    public void rebuildIndex(String siteId) {
        if (this.testMode) {
            this.rebuildSiteIndex(siteId);
            return;
        }
        this.backgroundScheduler.schedule((TimerTask)new RebuildSiteTask(siteId), 0L);
    }

    protected void rebuildIndexImmediately() {
        for (Site s : this.siteService.getSites(SiteService.SelectionType.ANY, null, null, null, SiteService.SortType.NONE, null)) {
            if (!this.isSiteIndexable(s)) continue;
            this.rebuildSiteIndex(s.getId());
        }
        List allPools = this.questionPoolService.getAllPools();
        Iterator qpit = allPools.iterator();
        while (qpit.hasNext()) {
            String qpId = Long.toString(((QuestionPoolData)qpit.next()).getQuestionPoolId());
            this.rebuildQuestionPoolIndex(qpId);
        }
    }

    protected boolean isSiteIndexable(Site site) {
        return !this.siteService.isSpecialSite(site.getId()) && !this.siteService.isUserSite(site.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildQuestionPoolIndex(String qpId) {
        this.getLog().info("Rebuilding the index for QP: '" + qpId + "'");
        try {
            ArrayList qpItemsIds = this.questionPoolService.getAllItemsIds(Long.valueOf(qpId));
            this.enableAzgSecurityAdvisor();
            this.deleteAllDocumentForQuestionPool(qpId);
            long start = System.currentTimeMillis();
            int numberOfDocs = 0;
            BulkRequestBuilder bulkRequest = this.client.prepareBulk();
            ItemContentProducer ecp = new ItemContentProducer();
            Iterator i = qpItemsIds.iterator();
            while (i.hasNext()) {
                if (bulkRequest.numberOfActions() < this.bulkRequestSize) {
                    String reference = Long.toString((Long)i.next());
                    try {
                        this.deleteDocument(ecp.getId(reference));
                        bulkRequest.add(this.prepareIndex(reference, ecp, false));
                        ++numberOfDocs;
                    }
                    catch (Exception e) {
                        this.getLog().error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                this.executeBulkRequest(bulkRequest);
                bulkRequest = this.client.prepareBulk();
            }
            if (bulkRequest.numberOfActions() > 0) {
                this.executeBulkRequest(bulkRequest);
            }
            this.getLog().info("Queued " + numberOfDocs + " docs for indexing from question pool: " + qpId + " in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            this.getLog().error("An exception occurred while rebuilding the index of question pool '" + qpId + "'", (Throwable)e);
        }
        finally {
            this.disableAzgSecurityAdvisor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildSiteIndex(String siteId) {
        this.getLog().info("Rebuilding the index for '" + siteId + "'");
        try {
            this.enableAzgSecurityAdvisor();
            this.deleteAllDocumentForSite(siteId);
            long start = System.currentTimeMillis();
            int numberOfDocs = 0;
            BulkRequestBuilder bulkRequest = this.client.prepareBulk();
            Set questionProducers = Sets.newConcurrentHashSet();
            questionProducers.add(new ItemContentProducer());
            questionProducers.add(new PublishedItemContentProducer());
            for (EntityContentProducer ecp : questionProducers) {
                Iterator i = ecp.getSiteContentIterator(siteId);
                while (i.hasNext()) {
                    if (bulkRequest.numberOfActions() < this.bulkRequestSize) {
                        String reference = Long.toString((Long)i.next());
                        try {
                            this.deleteDocument(ecp.getId(reference));
                            bulkRequest.add(this.prepareIndex(reference, ecp, false));
                            ++numberOfDocs;
                        }
                        catch (Exception e) {
                            this.getLog().error(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    this.executeBulkRequest(bulkRequest);
                    bulkRequest = this.client.prepareBulk();
                }
                if (bulkRequest.numberOfActions() <= 0) continue;
                this.executeBulkRequest(bulkRequest);
            }
            this.getLog().info("Queued " + numberOfDocs + " docs for indexing from site: " + siteId + " in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            this.getLog().error("An exception occurred while rebuilding the index of '" + siteId + "'", (Throwable)e);
        }
        finally {
            this.disableAzgSecurityAdvisor();
        }
    }

    private void deleteAllDocumentForSite(String siteId) {
        this.getLog().debug("removing all documents from question index for siteId: " + siteId);
        DeleteByQueryResponse response = (DeleteByQueryResponse)this.client.prepareDeleteByQuery(new String[]{this.indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"site", (String)siteId)).setTypes(new String[]{this.indexedDocumentType}).execute().actionGet();
    }

    public void deleteAllDocumentForSiteIfDeleted(String siteId) {
        try {
            if (!this.siteService.siteExists(siteId) || this.siteService.getSite(siteId).isSoftlyDeleted()) {
                this.deleteAllDocumentForSite(siteId);
            }
        }
        catch (Exception ex) {
            this.deleteAllDocumentForSite(siteId);
        }
    }

    protected void deleteAllDocumentForQuestionPool(String qpId) {
        this.getLog().debug("removing all documents from question index for questionPool: " + qpId);
        DeleteByQueryResponse response = (DeleteByQueryResponse)this.client.prepareDeleteByQuery(new String[]{this.indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"questionPoolId", (String)qpId)).setTypes(new String[]{this.indexedDocumentType}).execute().actionGet();
    }

    protected void deleteDocument(String id) {
        HashMap params = Maps.newHashMap();
        params.put("questionId", id);
        this.deleteDocumentWithParams(params);
    }

    protected IndexRequestBuilder completeIndexRequestBuilder(IndexRequestBuilder requestBuilder, String resourceName, EntityContentProducer ecp, boolean includeContent) throws IOException {
        return requestBuilder.setRouting(null);
    }

    public EntityContentProducer newEntityContentProducer(String ref) {
        if (ref.contains("/sam_item/") || ref.contains(" itemId=")) {
            this.getLog().debug("Matched content producer ItemContentProducer for reference " + ref + " in index builder " + this.getName());
            return new ItemContentProducer();
        }
        if (ref.contains("/sam_publisheditem/") || ref.contains(" publishedItemId=")) {
            this.getLog().debug("Matched content producer PublishedItemContentProducer for reference " + ref + " in index builder " + this.getName());
            return new PublishedItemContentProducer();
        }
        this.getLog().debug("Failed to match any content producer for reference " + ref + " in index builder " + this.getName());
        return null;
    }

    public EntityContentProducer newEntityContentProducer(Event event) {
        ItemContentProducer icp = new ItemContentProducer();
        Set<String> triggerIcp = icp.getTriggerFunctions();
        if (triggerIcp.contains(event.getEvent())) {
            this.getLog().debug("we have a ItemContentProducer for the event " + event + " in index builder " + this.getName());
            return new ItemContentProducer();
        }
        PublishedItemContentProducer picp = new PublishedItemContentProducer();
        Set<String> triggerPicp = picp.getTriggerFunctions();
        if (triggerPicp.contains(event.getEvent())) {
            this.getLog().debug("we have a PublishedContentProducer for the event " + event + " in index builder " + this.getName());
            return new PublishedItemContentProducer();
        }
        this.getLog().debug("Failed to match any content producer for event " + event + " in index builder " + this.getName());
        return null;
    }

    protected XContentBuilder addFields(XContentBuilder contentSourceBuilder, String resourceName, EntityContentProducer ecp, boolean includeContent) throws IOException {
        if (includeContent || this.testMode) {
            if (ecp.getSubType(resourceName).equals("item")) {
                ItemContentProducer icp = (ItemContentProducer)ecp;
                HashMap<String, Object> allFields = icp.getAllFields(resourceName);
                if (allFields.get("isFromQuestionPool").equals("false")) {
                    contentSourceBuilder.field("site", allFields.get("site"));
                    contentSourceBuilder.field("questionPoolId", new ArrayList());
                } else {
                    contentSourceBuilder.field("site", new ArrayList());
                    contentSourceBuilder.field("questionPoolId", allFields.get("questionPoolId"));
                }
                return contentSourceBuilder.field("questionId", allFields.get("questionId")).field("tags", allFields.get("tags")).field("assessmentId", allFields.get("assessmentId")).field("hash", allFields.get("hash")).field("type", allFields.get("type")).field("subtype", allFields.get("subtype")).field("typeId", allFields.get("typeId")).field("qText", allFields.get("qText"));
            }
            if (ecp.getSubType(resourceName).equals("publisheditem")) {
                PublishedItemContentProducer picp = (PublishedItemContentProducer)ecp;
                HashMap<String, Object> allFieldsPub = picp.getAllFields(resourceName);
                return contentSourceBuilder.field("questionId", allFieldsPub.get("questionId")).field("site", allFieldsPub.get("site")).field("tags", allFieldsPub.get("tags")).field("questionPoolId", new ArrayList()).field("assessmentId", allFieldsPub.get("assessmentId")).field("hash", allFieldsPub.get("hash")).field("type", allFieldsPub.get("type")).field("subtype", allFieldsPub.get("subtype")).field("typeId", allFieldsPub.get("typeId")).field("qText", allFieldsPub.get("qText"));
            }
            return contentSourceBuilder.field("questionId", ecp.getId(resourceName));
        }
        if (ecp.getSubType(resourceName).equals("item")) {
            ItemContentProducer icp = (ItemContentProducer)ecp;
            return contentSourceBuilder.field("questionId", icp.getId(resourceName)).field("subtype", icp.getSubType(resourceName));
        }
        if (ecp.getSubType(resourceName).equals("publisheditem")) {
            PublishedItemContentProducer picp = (PublishedItemContentProducer)ecp;
            return contentSourceBuilder.field("questionId", picp.getId(resourceName)).field("subtype", picp.getSubType(resourceName));
        }
        return contentSourceBuilder.field("questionId", ecp.getId(resourceName));
    }

    protected XContentBuilder addCustomProperties(XContentBuilder contentSourceBuilder, String resourceName, EntityContentProducer ecp, boolean includeContent) throws IOException {
        if (includeContent || this.testMode) {
            Map properties = this.extractCustomProperties(resourceName, ecp);
            for (Map.Entry entry : properties.entrySet()) {
                contentSourceBuilder = contentSourceBuilder.field((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return contentSourceBuilder;
    }

    protected XContentBuilder noContentForIndexRequest(XContentBuilder contentSourceBuilder, String resourceName, EntityContentProducer ecp, boolean includeContent) throws NoContentException {
        throw new NoContentException(ecp.getId(resourceName), resourceName, ecp.getSiteId(resourceName));
    }

    protected XContentBuilder completeIndexRequestContentSourceBuilder(XContentBuilder contentSourceBuilder, String resourceName, EntityContentProducer ecp, boolean includeContent) throws IOException {
        return contentSourceBuilder.endObject();
    }

    protected void completeAddResourceEventValidations(Event event, Map<String, Object> validationContext) throws IllegalArgumentException, IllegalStateException {
    }

    protected DeleteRequestBuilder prepareDeleteDocument(Map<String, Object> deleteParams) {
        DeleteRequestBuilder deleteRequestBuilder = this.newDeleteRequestBuilder(deleteParams);
        deleteRequestBuilder = this.completeDeleteRequestBuilder(deleteRequestBuilder, deleteParams);
        return deleteRequestBuilder;
    }

    private DeleteRequestBuilder newDeleteRequestBuilder(Map<String, Object> deleteParams) {
        return this.client.prepareDelete(this.indexName, this.indexedDocumentType, (String)deleteParams.get("questionId"));
    }

    protected Map<String, Object> extractDeleteDocumentParams(Map<String, Object> validationContext) {
        HashMap params = Maps.newHashMap();
        params.put("questionId", validationContext.get("RESOURCE_NAME"));
        return params;
    }

    protected Map<String, Object> extractDeleteDocumentParams(NoContentException noContentException) {
        HashMap params = Maps.newHashMap();
        params.put("questionId", noContentException.getId());
        return params;
    }

    protected Map<String, Object> extractDeleteDocumentParams(SearchHit searchHit) {
        String id = this.getFieldFromSearchHit("questionId", searchHit);
        HashMap params = Maps.newHashMap();
        params.put("questionId", id);
        return params;
    }

    protected DeleteResponse deleteDocumentWithRequest(DeleteRequestBuilder deleteRequestBuilder) {
        return (DeleteResponse)deleteRequestBuilder.execute().actionGet();
    }

    protected void validateResourceName(Event event, Map<String, Object> validationContext) throws IllegalArgumentException, IllegalStateException {
        String resourceName = event.getResource();
        if (resourceName == null) {
            resourceName = "";
        }
        if (resourceName.indexOf(" itemId=") != -1) {
            resourceName = "/sam_item/" + resourceName.substring(resourceName.indexOf(" itemId=") + 8);
        }
        if (resourceName.indexOf(" publishedItemId=") != -1) {
            resourceName = "/sam_publisheditem/" + resourceName.substring(resourceName.indexOf(" publishedItemId=") + 17);
        }
        if (resourceName.length() > 255) {
            throw new IllegalArgumentException("Entity Reference is longer than 255 characters. Reference=" + resourceName);
        }
        validationContext.put("RESOURCE_NAME", resourceName);
    }

    protected void validateIndexable(Event event, Map<String, Object> validationContext) throws IllegalArgumentException, IllegalStateException {
        EntityContentProducer ecp = (EntityContentProducer)validationContext.get("CONTENT_PRODUCER");
        String resourceName = (String)validationContext.get("RESOURCE_NAME");
        String id1 = event.getResource().indexOf(".delete@/") != -1 ? (event.getResource().indexOf(" itemId=") != -1 ? "/sam_item/" + event.getResource().substring(event.getResource().indexOf(" itemId=") + 8) : (event.getResource().indexOf(" publishedItemId=") != -1 ? "/sam_publisheditem/" + event.getResource().substring(event.getResource().indexOf(" publishedItemId=") + 17) : "error")) : ecp.getId(resourceName);
        String id = id1;
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("Entity ID could not be derived from resource name [" + resourceName + "] for event [" + event + "] in index builder [" + this.getName() + "]");
        }
        validationContext.put("ENTITY_ID", id);
    }

    protected void validateIndexAction(Event event, Map<String, Object> validationContext) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        BaseElasticSearchIndexBuilder.IndexAction action1;
        EntityContentProducer ecp = (EntityContentProducer)validationContext.get("CONTENT_PRODUCER");
        if (ecp.getAction(event) == 100) {
            String siteId = event.getResource().substring(6);
            this.deleteAllDocumentForSiteIfDeleted(siteId);
            action1 = BaseElasticSearchIndexBuilder.IndexAction.getAction((int)SearchBuilderItem.ACTION_UNKNOWN);
        } else {
            action1 = BaseElasticSearchIndexBuilder.IndexAction.getAction((int)ecp.getAction(event));
        }
        BaseElasticSearchIndexBuilder.IndexAction action = action1;
        if (!this.isSupportedIndexAction(action)) {
            throw new UnsupportedOperationException("Event [" + event + "] resolved to an unsupported IndexAction [" + action + "] in index builder [" + this.getName() + "]");
        }
        validationContext.put("INDEX_ACTION", action);
    }

    protected void dispatchValidatedAddResource(Map<String, Object> validationContext) {
        BaseElasticSearchIndexBuilder.IndexAction indexAction = (BaseElasticSearchIndexBuilder.IndexAction)validationContext.get("INDEX_ACTION");
        String resourceName = (String)validationContext.get("RESOURCE_NAME");
        EntityContentProducer ecp = (EntityContentProducer)validationContext.get("CONTENT_PRODUCER");
        log.debug("Action on '" + resourceName + "' detected as " + indexAction.name() + " in index builder " + this.getName());
        switch (indexAction) {
            case ADD: {
                this.indexAdd(resourceName, ecp);
                break;
            }
            case DELETE: {
                this.deleteDocumentWithParams(this.extractDeleteDocumentParams(validationContext));
                break;
            }
            default: {
                throw new UnsupportedOperationException(indexAction + " is not supported in index builder " + this.getName());
            }
        }
    }

    protected void deleteDocumentWithParams(Map<String, Object> deleteParams) {
        DeleteRequestBuilder deleteRequestBuilder = this.prepareDeleteDocument(deleteParams);
        DeleteResponse deleteResponse = this.deleteDocumentWithRequest(deleteRequestBuilder);
        if (this.getLog().isDebugEnabled()) {
            if (!deleteResponse.isFound()) {
                this.getLog().debug("Could not delete doc with by id: " + deleteParams.get("questionId") + " in index builder [" + this.getName() + "] because the document wasn't found");
            } else {
                this.getLog().debug("ES deleted a doc with id: " + deleteResponse.getId() + " in index builder [" + this.getName() + "]");
            }
        }
    }

    protected void processContentQueue() {
        this.startTime = System.currentTimeMillis();
        Thread.currentThread().setPriority(4);
        if (this.getPendingDocuments() == 0) {
            this.getLog().trace("No pending docs for index builder [" + this.getName() + "]");
            return;
        }
        SearchResponse response = this.findContentQueue();
        SearchHit[] hits = response.getHits().hits();
        ArrayList<NoContentException> noContentExceptions = new ArrayList<NoContentException>();
        this.getLog().trace(this.getPendingDocuments() + " pending docs for index builder [" + this.getName() + "]");
        BulkRequestBuilder bulkRequest = this.newContentQueueBulkUpdateRequestBuilder();
        for (SearchHit hit : hits) {
            if (bulkRequest.numberOfActions() < this.bulkRequestSize) {
                try {
                    this.processContentQueueEntry(hit, bulkRequest);
                }
                catch (NoContentException e) {
                    noContentExceptions.add(e);
                }
                continue;
            }
            this.executeBulkRequest(bulkRequest);
            bulkRequest = this.newContentQueueBulkUpdateRequestBuilder();
        }
        if (bulkRequest.numberOfActions() > 0) {
            this.executeBulkRequest(bulkRequest);
        }
        if (!noContentExceptions.isEmpty()) {
            for (NoContentException noContentException : noContentExceptions) {
                this.deleteDocument(noContentException);
            }
        }
        this.lastLoad = System.currentTimeMillis();
        if (hits.length > 0) {
            this.getLog().trace("Finished indexing " + hits.length + " docs in " + (this.lastLoad - this.startTime) + " ms for index builder " + this.getName());
        }
    }

    protected SearchRequestBuilder addFindContentQueueRequestParams(SearchRequestBuilder searchRequestBuilder) {
        return searchRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setTypes(new String[]{this.indexedDocumentType}).setPostFilter((FilterBuilder)FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.missingFilter((String)"indexed"), FilterBuilders.termFilter((String)"indexed", (Object)false)})).setSize(this.contentIndexBatchSize).addFields(new String[]{"questionId", "subtype"});
    }

    protected void processContentQueueEntry(SearchHit hit, BulkRequestBuilder bulkRequest) throws NoContentException {
        String reference = this.getFieldFromSearchHit("questionId", hit);
        String subtype = this.getFieldFromSearchHit("subtype", hit);
        Object ecp = subtype.equals("item") ? new ItemContentProducer() : new PublishedItemContentProducer();
        if (ecp != null) {
            try {
                this.deleteDocument(hit);
                bulkRequest.add(this.prepareIndex(reference, (EntityContentProducer)ecp, true));
            }
            catch (NoContentException e) {
                throw e;
            }
            catch (Exception e) {
                this.getLog().error("Failed to process content queue entry with id [" + hit.getId() + "] in index builder [" + this.getName() + "]", (Throwable)e);
            }
        } else {
            this.noContentProducerForContentQueueEntry(hit, reference);
        }
    }

    protected void prepareIndexAdd(String resourceName, EntityContentProducer ecp, boolean includeContent) throws NoContentException {
        try {
            this.prepareIndex(resourceName, ecp, includeContent).execute().actionGet();
        }
        catch (NoContentException e) {
            throw e;
        }
        catch (Throwable t) {
            this.getLog().error("Error: trying to register resource " + resourceName + " in index builder: " + this.getName(), t);
        }
    }

    protected void indexAdd(String resourceName, EntityContentProducer ecp) {
        try {
            this.prepareIndexAdd(resourceName, ecp, false);
        }
        catch (NoContentException e) {
            this.deleteDocument(e);
        }
        catch (Exception e) {
            this.getLog().error("Problem updating content indexing in index builder: " + this.getName() + " for entity: " + resourceName, (Throwable)e);
        }
    }

    public SearchResponse search(String searchTerms, List<String> references, List<String> siteIds, int start, int end) {
        return this.search(searchTerms, references, siteIds, start, end, new HashMap<String, String>());
    }

    public SearchResponse search(String searchTerms, List<String> references, List<String> siteIds, int start, int end, Map<String, String> additionalSearchInformation) {
        Pair<SearchRequestBuilder, QueryBuilder> searchBuilders = this.prepareSearchRequest(searchTerms, references, siteIds, start, end, additionalSearchInformation);
        SearchRequestBuilder searchRequestBuilder = (SearchRequestBuilder)searchBuilders.getLeft();
        QueryBuilder queryBuilder = (QueryBuilder)searchBuilders.getRight();
        this.getLog().debug("Search request from index builder [" + this.getName() + "]: " + searchRequestBuilder.toString());
        ValidateQueryRequest validateQueryRequest = new ValidateQueryRequest(new String[]{this.indexName});
        QuerySourceBuilder querySourceBuilder = new QuerySourceBuilder().setQuery(queryBuilder);
        validateQueryRequest.source(querySourceBuilder);
        validateQueryRequest.explain(true);
        try {
            ActionFuture future = this.client.admin().indices().validateQuery(validateQueryRequest);
            ValidateQueryResponse responseV = (ValidateQueryResponse)future.get();
            if (responseV.isValid()) {
                SearchResponse response = (SearchResponse)searchRequestBuilder.execute().actionGet();
                this.getLog().debug("Search request from index builder [" + this.getName() + "] took: " + response.getTook().format());
                this.eventTrackingService.post(this.eventTrackingService.newEvent("search.query", "/search/query/" + queryBuilder.toString(), true, 3));
                return response;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> prepareSearchRequest(String searchTerms, List<String> references, List<String> siteIds, int start, int end) {
        return this.prepareSearchRequest(searchTerms, references, siteIds, start, end, new HashMap<String, String>());
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> prepareSearchRequest(String searchTerms, List<String> references, List<String> siteIds, int start, int end, Map<String, String> additionalSearchInformation) {
        Pair builders = this.newSearchRequestAndQueryBuilders(searchTerms, references, siteIds);
        builders = this.addSearchCoreParams(builders, searchTerms, references, siteIds);
        builders = this.addSearchQuery(builders, searchTerms, references, siteIds, additionalSearchInformation);
        builders = this.pairOf(this.addSearchResultFields((SearchRequestBuilder)builders.getLeft()), builders.getRight());
        builders = this.pairOf(this.addSearchPagination((SearchRequestBuilder)builders.getLeft(), start, end), builders.getRight());
        builders = this.pairOf(this.addSearchFacetting((SearchRequestBuilder)builders.getLeft()), builders.getRight());
        return this.completeSearchRequestBuilders((Pair<SearchRequestBuilder, QueryBuilder>)builders, searchTerms, references, siteIds);
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> newSearchRequestAndQueryBuilders(String searchTerms, List<String> references, List<String> siteIds) {
        return this.pairOf(this.client.prepareSearch(new String[]{this.indexName}), QueryBuilders.boolQuery());
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> addSearchCoreParams(Pair<SearchRequestBuilder, QueryBuilder> builders, String searchTerms, List<String> references, List<String> siteIds) {
        SearchRequestBuilder searchRequestBuilder = (SearchRequestBuilder)builders.getLeft();
        return this.pairOf(searchRequestBuilder.setSearchType(SearchType.QUERY_THEN_FETCH).setTypes(new String[]{this.indexedDocumentType}), builders.getRight());
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> addSearchQuery(Pair<SearchRequestBuilder, QueryBuilder> builders, String searchTerms, List<String> references, List<String> siteIds) {
        return this.addSearchQuery(builders, searchTerms, references, siteIds, new HashMap<String, String>());
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> addSearchQuery(Pair<SearchRequestBuilder, QueryBuilder> builders, String searchTerms, List<String> references, List<String> siteIds, Map<String, String> additionalSearchInformation) {
        builders = this.addSearchTerms(builders, searchTerms, additionalSearchInformation);
        builders = this.addSearchReferences(builders, references);
        builders = this.addSearchSiteIds(builders, siteIds);
        return this.pairOf(((SearchRequestBuilder)builders.getLeft()).setQuery((QueryBuilder)builders.getRight()), builders.getRight());
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> addSearchTerms(Pair<SearchRequestBuilder, QueryBuilder> builders, String searchTerms) {
        return this.addSearchTerms(builders, searchTerms, new HashMap<String, String>());
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> addSearchTerms(Pair<SearchRequestBuilder, QueryBuilder> builders, String searchTerms, Map<String, String> additionalSearchInformation) {
        BoolQueryBuilder query = (BoolQueryBuilder)builders.getRight();
        SearchRequestBuilder searchRequestBuilder = (SearchRequestBuilder)builders.getLeft();
        log.debug("Searching the searchterm: " + searchTerms);
        Source parseSearchTerms = new Source((CharSequence)searchTerms);
        searchTerms = parseSearchTerms.getTextExtractor().toString();
        String regex = "([+\\-!\\(\\){}\\[\\]^~*?:\\\\]|[&\\|]{2})";
        searchTerms = searchTerms.replaceAll(regex, "\\\\$1");
        log.debug("Searching the searchterms after escape them: " + searchTerms);
        if (StringUtils.isNotEmpty((CharSequence)searchTerms)) {
            query = additionalSearchInformation.containsKey("logic") && additionalSearchInformation.get("logic").equals("and") ? query.must((QueryBuilder)QueryBuilders.queryStringQuery((String)searchTerms).defaultField("contents").defaultOperator(QueryStringQueryBuilder.Operator.AND)) : query.must((QueryBuilder)QueryBuilders.queryStringQuery((String)searchTerms).defaultField("contents").defaultOperator(QueryStringQueryBuilder.Operator.OR));
        }
        Set<String> keys = additionalSearchInformation.keySet();
        Iterator<String> keysIterator = keys.iterator();
        Boolean oneTimeTagShould = true;
        BoolQueryBuilder tagsQuery = QueryBuilders.boolQuery();
        Boolean tagsFounded = false;
        while (keysIterator.hasNext()) {
            String key = keysIterator.next();
            if (!key.startsWith("tag_")) continue;
            tagsFounded = true;
            String tag = additionalSearchInformation.get(key);
            log.debug("We will search this tag:" + tag);
            if (additionalSearchInformation.containsKey("logic") && additionalSearchInformation.get("logic").equals("or")) {
                tagsQuery = tagsQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"tags", (String)tag));
                if (oneTimeTagShould.booleanValue()) {
                    tagsQuery.minimumNumberShouldMatch(1);
                }
                oneTimeTagShould = false;
                continue;
            }
            tagsQuery = tagsQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tags", (String)tag));
        }
        if (tagsFounded.booleanValue()) {
            query = query.must((QueryBuilder)tagsQuery);
        }
        if (additionalSearchInformation.containsKey("subtype")) {
            log.debug("We will search this subtype:" + additionalSearchInformation.get("subtype"));
            query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"subtype", (Object)additionalSearchInformation.get("subtype")));
        }
        if (additionalSearchInformation.containsKey("hash")) {
            log.debug("We will search this hash:" + additionalSearchInformation.get("hash"));
            query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"hash", (Object)additionalSearchInformation.get("hash")));
        }
        if (additionalSearchInformation.containsKey("scope")) {
            if (additionalSearchInformation.get("scope").equals("all")) {
                log.debug("we won't filter the results by scope");
            } else if (additionalSearchInformation.get("scope").equals("custom")) {
                log.debug("We have a custom scope request");
                Set<String> keysForACL = additionalSearchInformation.keySet();
                for (String key : keysForACL) {
                    ArrayList<String> siteIds = new ArrayList<String>();
                    ArrayList<String> questionPoolsIds = new ArrayList<String>();
                    if (key.startsWith("site_")) {
                        String siteId = additionalSearchInformation.get(key);
                        log.debug("We have this siteId to add:" + siteId);
                        siteIds.add(siteId);
                        query = query.should((QueryBuilder)QueryBuilders.termsQuery((String)"site", (String[])siteIds.toArray(new String[siteIds.size()])));
                    }
                    if (!key.startsWith("qp_")) continue;
                    String qpId = additionalSearchInformation.get(key);
                    log.debug("We have this question Pool to add:" + qpId);
                    questionPoolsIds.add(qpId);
                    query = query.should((QueryBuilder)QueryBuilders.termsQuery((String)"questionPoolId", (String[])questionPoolsIds.toArray(new String[questionPoolsIds.size()])));
                    query = query.minimumNumberShouldMatch(1);
                }
            } else if (!this.securityService.isSuperUser()) {
                log.debug("No superuser.Searching based in permissions");
                List<String> siteIds = this.getAllSitesUserHasQuestionAuthorPermissions();
                List<String> questionPoolsIds = this.getAllUserQuestionPools();
                query = query.should((QueryBuilder)QueryBuilders.termsQuery((String)"site", (String[])siteIds.toArray(new String[siteIds.size()])));
                query = query.should((QueryBuilder)QueryBuilders.termsQuery((String)"questionPoolId", (String[])questionPoolsIds.toArray(new String[questionPoolsIds.size()])));
                query = query.minimumNumberShouldMatch(1);
            } else {
                log.debug("Superuser, so no filtering");
            }
            if (additionalSearchInformation.containsKey("group")) {
                log.debug("We are going to group results by: " + additionalSearchInformation.get("group"));
                searchRequestBuilder.setSize(0);
                searchRequestBuilder = this.addSearchAggregation(searchRequestBuilder, additionalSearchInformation.get("group"));
            }
        }
        return this.pairOf(searchRequestBuilder, query);
    }

    private List<String> getAllSitesUserHasQuestionAuthorPermissions() {
        ArrayList<String> sitesIds = new ArrayList<String>();
        try {
            List allSites = this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, SiteService.SortType.TITLE_ASC, null);
            List moreSites = this.siteService.getSites(SiteService.SelectionType.UPDATE, null, null, null, SiteService.SortType.TITLE_ASC, null);
            if (allSites == null || moreSites == null || allSites.size() == 0 && moreSites.size() == 0) {
                return sitesIds;
            }
            allSites.removeAll(moreSites);
            allSites.addAll(moreSites);
            Iterator allSitesIterator = allSites.iterator();
            while (allSitesIterator.hasNext()) {
                String siteId = ((Site)allSitesIterator.next()).getId();
                log.debug("Checking if user " + AgentFacade.getAgentString() + " is allowed in this site:" + siteId);
                if (!this.securityService.unlock(AgentFacade.getAgentString(), "asn.new", this.siteService.siteReference(siteId))) continue;
                sitesIds.add(siteId);
                log.debug("User allowed in this site:" + siteId);
            }
            if (sitesIds.size() == 0) {
                sitesIds.add("-2");
            }
            return sitesIds;
        }
        catch (Exception e) {
            log.error("Error in getAllSitesUserHasQuestionAuthorPermissions(): " + e.getClass().getName() + " : " + e.getMessage());
            return sitesIds;
        }
    }

    private List<String> getAllUserQuestionPools() {
        ArrayList<String> questionPoolsIds = new ArrayList<String>();
        QuestionPoolIteratorFacade qpif = this.questionPoolService.getAllPoolsWithAccess(AgentFacade.getAgentString());
        try {
            while (qpif.hasNext()) {
                String qpId = Long.toString(qpif.next().getQuestionPoolId());
                questionPoolsIds.add(qpId);
                log.debug("User allowed in this QP:" + qpId);
            }
        }
        catch (SharedException e) {
            log.error("Error retrieving questionPools for actual user: " + ((Object)((Object)e)).getClass().getName() + " : " + e.getMessage());
        }
        catch (Exception ex) {
            log.error("Error retrieving questionPools for actual user: " + ex.getClass().getName() + " : " + ex.getMessage());
        }
        if (questionPoolsIds.size() == 0) {
            questionPoolsIds.add("-2");
        }
        return questionPoolsIds;
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> addSearchReferences(Pair<SearchRequestBuilder, QueryBuilder> builders, List<String> references) {
        BoolQueryBuilder query = (BoolQueryBuilder)builders.getRight();
        if (references.size() > 0) {
            query = query.must((QueryBuilder)QueryBuilders.termsQuery((String)"reference", (String[])references.toArray(new String[references.size()])));
        }
        return this.pairOf(builders.getLeft(), query);
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> addSearchSiteIds(Pair<SearchRequestBuilder, QueryBuilder> builders, List<String> siteIds) {
        return builders;
    }

    protected SearchRequestBuilder addSearchResultFields(SearchRequestBuilder searchRequestBuilder) {
        if (ArrayUtils.isEmpty((Object[])this.searchResultFieldNames)) {
            return searchRequestBuilder;
        }
        return searchRequestBuilder.addFields(this.searchResultFieldNames);
    }

    protected SearchRequestBuilder addSearchPagination(SearchRequestBuilder searchRequestBuilder, int start, int end) {
        return searchRequestBuilder.setFrom(start).setSize(end - start);
    }

    protected SearchRequestBuilder addSearchFacetting(SearchRequestBuilder searchRequestBuilder) {
        if (this.useFacetting) {
            return searchRequestBuilder.addFacet((FacetBuilder)FacetBuilders.termsFacet((String)this.facetName).field("hash").size(this.facetTermSize));
        }
        return searchRequestBuilder;
    }

    protected SearchRequestBuilder addSearchAggregation(SearchRequestBuilder searchRequestBuilder, String field) {
        if (this.useAggregation) {
            return searchRequestBuilder.addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGGREGATION_NAME).field(field)).size(this.serverConfigurationService.getInt("samigo.search.maxResults", 50)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)AGGREGATION_TOP_HITS).setSize(1).addFieldDataField("assessmentId").addFieldDataField("site").addFieldDataField("questionPoolId").addFieldDataField("typeId").addFieldDataField("tags").addFieldDataField("qText")));
        }
        return searchRequestBuilder;
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> completeSearchRequestBuilders(Pair<SearchRequestBuilder, QueryBuilder> builders, String searchTerms, List<String> references, List<String> siteIds) {
        log.debug("This is the search query: " + ((QueryBuilder)builders.getRight()).toString());
        return builders;
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> completeSearchSuggestionsRequestBuilders(Pair<SearchRequestBuilder, QueryBuilder> builders, String searchString, String currentSite, boolean allMySites) {
        return null;
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> addSearchSuggestionsTerms(Pair<SearchRequestBuilder, QueryBuilder> builders, String searchString) {
        return null;
    }

    protected Pair<SearchRequestBuilder, QueryBuilder> addSearchSuggestionsSites(Pair<SearchRequestBuilder, QueryBuilder> builders, String currentSite, boolean allMySites) {
        return null;
    }

    public String getEventResourceFilter() {
        return "/";
    }

    protected Logger getLog() {
        return log;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    protected class RebuildSiteTask
    extends TimerTask {
        private final String siteId;

        public RebuildSiteTask(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setPriority(4);
                QuestionElasticSearchIndexBuilder.this.rebuildSiteIndex(this.siteId);
            }
            catch (Exception e) {
                QuestionElasticSearchIndexBuilder.this.getLog().error("problem queuing content indexing for site: " + this.siteId + " error: " + e.getMessage());
            }
        }
    }
}

