/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.samigo.search;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentBuilder;
import org.osid.shared.SharedException;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.samigo.search.ItemContentProducer;
import org.sakaiproject.samigo.search.PublishedItemContentProducer;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.elasticsearch.BaseElasticSearchIndexBuilder;
import org.sakaiproject.search.elasticsearch.NoContentException;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolIteratorFacade;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionElasticSearchIndexBuilder
extends BaseElasticSearchIndexBuilder {
    private static final Logger log = LoggerFactory.getLogger(QuestionElasticSearchIndexBuilder.class);
    QuestionPoolService questionPoolService = new QuestionPoolService();
    private ItemContentProducer itemContentProducer;
    private PublishedItemContentProducer publishedItemContentProducer;
    private SiteService siteService;
    protected String[] searchResultFieldNames;
    protected static final String SAKAI_DOC_TYPE = "_doc";
    protected static final String ADD_RESOURCE_VALIDATION_KEY_ITEM = "questionId";
    protected static final String DELETE_RESOURCE_KEY_ITEM = "questionId";
    protected boolean useSuggestions = false;
    protected boolean useFacetting = false;
    protected boolean useAggregation = true;
    protected static final String AGGREGATION_NAME = "dedup";
    protected static final String AGGREGATION_TOP_HITS = "dedup_docs";

    protected void beforeElasticSearchConfigInitialization() {
        if (StringUtils.isEmpty((CharSequence)this.indexedDocumentType)) {
            this.indexedDocumentType = SAKAI_DOC_TYPE;
        }
        if (ArrayUtils.isEmpty((Object[])this.suggestionResultFieldNames)) {
            this.suggestionResultFieldNames = new String[0];
        }
        if (ArrayUtils.isEmpty((Object[])this.searchResultFieldNames)) {
            this.searchResultFieldNames = new String[]{"contents", "questionId", "site", "tags", "questionPoolId", "assessmentId", "hash", "type", "subtype"};
        }
        if ("true".equals(this.serverConfigurationService.getString("search.enable", "false"))) {
            this.registerEntityContentProducer(this.itemContentProducer);
            this.registerEntityContentProducer(this.publishedItemContentProducer);
        }
    }

    protected void beforeBackgroundSchedulerInitialization() {
    }

    protected SearchRequest completeFindContentQueueRequest(SearchRequest searchRequest) {
        return searchRequest;
    }

    protected DeleteRequest completeDeleteRequest(DeleteRequest deleteRequest, Map<String, Object> deleteParams) {
        return deleteRequest.routing((String)deleteParams.get("questionId"));
    }

    public void rebuildIndex(String siteId) {
        if (this.testMode) {
            this.rebuildSiteIndex(siteId);
            return;
        }
        this.backgroundScheduler.schedule((TimerTask)new RebuildSiteTask(siteId), 0L);
    }

    protected void rebuildIndexImmediately() {
        for (Site s : this.siteService.getSites(SiteService.SelectionType.ANY, null, null, null, SiteService.SortType.NONE, null)) {
            if (!this.isSiteIndexable(s)) continue;
            this.rebuildSiteIndex(s.getId());
        }
        this.questionPoolService.getAllPools().forEach(p -> this.rebuildQuestionPoolIndex(Long.toString(p.getQuestionPoolId())));
    }

    protected boolean isSiteIndexable(Site site) {
        return !this.siteService.isSpecialSite(site.getId()) && !this.siteService.isUserSite(site.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildQuestionPoolIndex(String qpId) {
        this.getLog().info("Rebuilding the index for QP: '" + qpId + "'");
        try {
            ArrayList qpItemsIds = this.questionPoolService.getAllItemsIds(Long.valueOf(qpId));
            this.enableAzgSecurityAdvisor();
            this.deleteAllDocumentForQuestionPool(qpId);
            long start = System.currentTimeMillis();
            int numberOfDocs = 0;
            BulkRequest bulkRequest = new BulkRequest();
            ItemContentProducer ecp = this.itemContentProducer;
            for (Object qpItemsId : qpItemsIds) {
                if (bulkRequest.numberOfActions() < this.bulkRequestSize) {
                    String reference = Long.toString((Long)qpItemsId);
                    try {
                        this.deleteDocument(ecp.getId(reference));
                        bulkRequest.add(this.prepareIndex(reference, ecp, false));
                        ++numberOfDocs;
                    }
                    catch (Exception e) {
                        this.getLog().error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                this.executeBulkRequest(bulkRequest);
                bulkRequest = new BulkRequest();
            }
            if (bulkRequest.numberOfActions() > 0) {
                this.executeBulkRequest(bulkRequest);
            }
            this.getLog().info("Queued " + numberOfDocs + " docs for indexing from question pool: " + qpId + " in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            this.getLog().error("An exception occurred while rebuilding the index of question pool '" + qpId + "'", (Throwable)e);
        }
        finally {
            this.disableAzgSecurityAdvisor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildSiteIndex(String siteId) {
        this.getLog().info("Rebuilding the index for '" + siteId + "'");
        try {
            this.enableAzgSecurityAdvisor();
            this.deleteAllDocumentForSite(siteId);
            long start = System.currentTimeMillis();
            int numberOfDocs = 0;
            BulkRequest bulkRequest = new BulkRequest();
            Set questionProducers = Sets.newConcurrentHashSet();
            questionProducers.add(this.itemContentProducer);
            questionProducers.add(this.publishedItemContentProducer);
            for (EntityContentProducer ecp : questionProducers) {
                Iterator i = ecp.getSiteContentIterator(siteId);
                while (i.hasNext()) {
                    if (bulkRequest.numberOfActions() < this.bulkRequestSize) {
                        String reference = Long.toString((Long)i.next());
                        try {
                            this.deleteDocument(ecp.getId(reference));
                            bulkRequest.add(this.prepareIndex(reference, ecp, false));
                            ++numberOfDocs;
                        }
                        catch (Exception e) {
                            this.getLog().error(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    this.executeBulkRequest(bulkRequest);
                    bulkRequest = new BulkRequest();
                }
                if (bulkRequest.numberOfActions() <= 0) continue;
                this.executeBulkRequest(bulkRequest);
            }
            this.getLog().info("Queued " + numberOfDocs + " docs for indexing from site: " + siteId + " in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            this.getLog().error("An exception occurred while rebuilding the index of '" + siteId + "'", (Throwable)e);
        }
        finally {
            this.disableAzgSecurityAdvisor();
        }
    }

    private void deleteAllDocumentForSite(String siteId) {
        this.getLog().debug("removing all documents from question index for site: " + siteId);
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{this.indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"site", (String)siteId)).types(new String[]{this.indexedDocumentType});
        try {
            this.client.deleteByQuery(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.getLog().error("Failed to remove all documents from question index for site: " + siteId + ", " + e);
        }
    }

    public void deleteAllDocumentForSiteIfDeleted(String siteId) {
        try {
            if (!this.siteService.siteExists(siteId) || this.siteService.getSite(siteId).isSoftlyDeleted()) {
                this.deleteAllDocumentForSite(siteId);
            }
        }
        catch (Exception ex) {
            this.deleteAllDocumentForSite(siteId);
        }
    }

    protected void deleteAllDocumentForQuestionPool(String qpId) {
        this.getLog().debug("removing all documents from question index for questionPool: " + qpId);
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{this.indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"questionPoolId", (String)qpId)).types(new String[]{this.indexedDocumentType});
        try {
            this.client.deleteByQuery(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.getLog().error("Failed to remove all documents from question index for questionPool: " + qpId + ", " + e);
        }
    }

    protected void deleteDocument(String id) {
        HashMap params = Maps.newHashMap();
        params.put("questionId", id);
        this.deleteDocumentWithParams(params);
    }

    protected IndexRequest completeIndexRequest(IndexRequest indexRequest, String resourceName, EntityContentProducer ecp, boolean includeContent) {
        return indexRequest.routing(null);
    }

    public EntityContentProducer newEntityContentProducer(String ref) {
        if (ref.contains("/sam_item/") || ref.contains(" itemId=")) {
            this.getLog().debug("Matched content producer ItemContentProducer for reference " + ref + " in index builder " + this.getName());
            return this.itemContentProducer;
        }
        if (ref.contains("/sam_publisheditem/") || ref.contains(" publishedItemId=")) {
            this.getLog().debug("Matched content producer PublishedItemContentProducer for reference " + ref + " in index builder " + this.getName());
            return this.publishedItemContentProducer;
        }
        this.getLog().debug("Failed to match any content producer for reference " + ref + " in index builder " + this.getName());
        return null;
    }

    public EntityContentProducer newEntityContentProducer(Event event) {
        ItemContentProducer icp = this.itemContentProducer;
        Set<String> triggerIcp = icp.getTriggerFunctions();
        if (triggerIcp.contains(event.getEvent())) {
            this.getLog().debug("we have a ItemContentProducer for the event " + event + " in index builder " + this.getName());
            return this.itemContentProducer;
        }
        PublishedItemContentProducer picp = this.publishedItemContentProducer;
        Set<String> triggerPicp = picp.getTriggerFunctions();
        if (triggerPicp.contains(event.getEvent())) {
            this.getLog().debug("we have a PublishedContentProducer for the event " + event + " in index builder " + this.getName());
            return this.publishedItemContentProducer;
        }
        this.getLog().debug("Failed to match any content producer for event " + event + " in index builder " + this.getName());
        return null;
    }

    protected XContentBuilder addFields(XContentBuilder contentSourceBuilder, String resourceName, EntityContentProducer ecp, boolean includeContent) throws IOException {
        if (includeContent || this.testMode) {
            if (ecp.getSubType(resourceName).equals("item")) {
                ItemContentProducer icp = (ItemContentProducer)ecp;
                Map<String, Object> allFields = icp.getAllFields(resourceName);
                if (allFields.get("isFromQuestionPool").equals("false")) {
                    contentSourceBuilder.field("site", allFields.get("site"));
                    contentSourceBuilder.field("questionPoolId", new ArrayList());
                } else {
                    contentSourceBuilder.field("site", new ArrayList());
                    contentSourceBuilder.field("questionPoolId", allFields.get("questionPoolId"));
                }
                return contentSourceBuilder.field("questionId", allFields.get("questionId")).field("tags", allFields.get("tags")).field("assessmentId", allFields.get("assessmentId")).field("hash", allFields.get("hash")).field("type", allFields.get("type")).field("subtype", allFields.get("subtype")).field("typeId", allFields.get("typeId")).field("qText", allFields.get("qText"));
            }
            if (ecp.getSubType(resourceName).equals("publisheditem")) {
                PublishedItemContentProducer picp = (PublishedItemContentProducer)ecp;
                Map<String, Object> allFieldsPub = picp.getAllFields(resourceName);
                return contentSourceBuilder.field("questionId", allFieldsPub.get("questionId")).field("site", allFieldsPub.get("site")).field("tags", allFieldsPub.get("tags")).field("questionPoolId", new ArrayList()).field("assessmentId", allFieldsPub.get("assessmentId")).field("hash", allFieldsPub.get("hash")).field("type", allFieldsPub.get("type")).field("subtype", allFieldsPub.get("subtype")).field("typeId", allFieldsPub.get("typeId")).field("qText", allFieldsPub.get("qText"));
            }
            return contentSourceBuilder.field("questionId", ecp.getId(resourceName));
        }
        if (ecp.getSubType(resourceName).equals("item")) {
            ItemContentProducer icp = (ItemContentProducer)ecp;
            return contentSourceBuilder.field("questionId", icp.getId(resourceName)).field("subtype", icp.getSubType(resourceName));
        }
        if (ecp.getSubType(resourceName).equals("publisheditem")) {
            PublishedItemContentProducer picp = (PublishedItemContentProducer)ecp;
            return contentSourceBuilder.field("questionId", picp.getId(resourceName)).field("subtype", picp.getSubType(resourceName));
        }
        return contentSourceBuilder.field("questionId", ecp.getId(resourceName));
    }

    protected XContentBuilder addCustomProperties(XContentBuilder contentSourceBuilder, String resourceName, EntityContentProducer ecp, boolean includeContent) throws IOException {
        if (includeContent || this.testMode) {
            Map properties = this.extractCustomProperties(resourceName, ecp);
            for (Map.Entry entry : properties.entrySet()) {
                contentSourceBuilder = contentSourceBuilder.field((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return contentSourceBuilder;
    }

    protected XContentBuilder noContentForIndexRequest(XContentBuilder contentSourceBuilder, String resourceName, EntityContentProducer ecp, boolean includeContent) throws NoContentException {
        throw new NoContentException(ecp.getId(resourceName), resourceName, ecp.getSiteId(resourceName));
    }

    protected XContentBuilder completeIndexRequestContentSourceBuilder(XContentBuilder contentSourceBuilder, String resourceName, EntityContentProducer ecp, boolean includeContent) throws IOException {
        return contentSourceBuilder.endObject();
    }

    protected void completeAddResourceEventValidations(Event event, Map<String, Object> validationContext) throws IllegalArgumentException, IllegalStateException {
    }

    protected DeleteRequest prepareDeleteDocument(Map<String, Object> deleteParams) {
        DeleteRequest request = this.newDeleteRequest(deleteParams);
        request = this.completeDeleteRequest(request, deleteParams);
        return request;
    }

    private DeleteRequest newDeleteRequest(Map<String, Object> deleteParams) {
        return new DeleteRequest(this.indexName, this.indexedDocumentType, (String)deleteParams.get("questionId"));
    }

    protected Map<String, Object> extractDeleteDocumentParams(Map<String, Object> validationContext) {
        HashMap params = Maps.newHashMap();
        params.put("questionId", validationContext.get("RESOURCE_NAME"));
        return params;
    }

    protected Map<String, Object> extractDeleteDocumentParams(NoContentException noContentException) {
        HashMap params = Maps.newHashMap();
        params.put("questionId", noContentException.getId());
        return params;
    }

    protected Map<String, Object> extractDeleteDocumentParams(SearchHit searchHit) {
        String id = this.getFieldFromSearchHit("questionId", searchHit);
        HashMap params = Maps.newHashMap();
        params.put("questionId", id);
        return params;
    }

    protected DeleteResponse deleteDocumentWithRequest(DeleteRequest deleteRequest) throws IOException {
        return this.client.delete(deleteRequest, RequestOptions.DEFAULT);
    }

    protected void validateResourceName(Event event, Map<String, Object> validationContext) throws IllegalArgumentException, IllegalStateException {
        Object resourceName = event.getResource();
        if (resourceName == null) {
            resourceName = "";
        }
        if (((String)resourceName).indexOf(" itemId=") != -1) {
            resourceName = "/sam_item/" + ((String)resourceName).substring(((String)resourceName).indexOf(" itemId=") + 8);
        }
        if (((String)resourceName).indexOf(" publishedItemId=") != -1) {
            resourceName = "/sam_publisheditem/" + ((String)resourceName).substring(((String)resourceName).indexOf(" publishedItemId=") + 17);
        }
        if (((String)resourceName).length() > 255) {
            throw new IllegalArgumentException("Entity Reference is longer than 255 characters. Reference=" + (String)resourceName);
        }
        validationContext.put("RESOURCE_NAME", resourceName);
    }

    protected void validateIndexable(Event event, Map<String, Object> validationContext) throws IllegalArgumentException, IllegalStateException {
        EntityContentProducer ecp = (EntityContentProducer)validationContext.get("CONTENT_PRODUCER");
        String resourceName = (String)validationContext.get("RESOURCE_NAME");
        Object id1 = event.getResource().indexOf(".delete@/") != -1 ? (event.getResource().indexOf(" itemId=") != -1 ? "/sam_item/" + event.getResource().substring(event.getResource().indexOf(" itemId=") + 8) : (event.getResource().indexOf(" publishedItemId=") != -1 ? "/sam_publisheditem/" + event.getResource().substring(event.getResource().indexOf(" publishedItemId=") + 17) : "error")) : ecp.getId(resourceName);
        String id = id1;
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("Entity ID could not be derived from resource name [" + resourceName + "] for event [" + event + "] in index builder [" + this.getName() + "]");
        }
        validationContext.put("ENTITY_ID", id);
    }

    protected void validateIndexAction(Event event, Map<String, Object> validationContext) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        BaseElasticSearchIndexBuilder.IndexAction action1;
        EntityContentProducer ecp = (EntityContentProducer)validationContext.get("CONTENT_PRODUCER");
        if (ecp.getAction(event) == 100) {
            String siteId = event.getResource().substring(6);
            this.deleteAllDocumentForSiteIfDeleted(siteId);
            action1 = BaseElasticSearchIndexBuilder.IndexAction.getAction((int)SearchBuilderItem.ACTION_UNKNOWN);
        } else {
            action1 = BaseElasticSearchIndexBuilder.IndexAction.getAction((int)ecp.getAction(event));
        }
        BaseElasticSearchIndexBuilder.IndexAction action = action1;
        if (!this.isSupportedIndexAction(action)) {
            throw new UnsupportedOperationException("Event [" + event + "] resolved to an unsupported IndexAction [" + action + "] in index builder [" + this.getName() + "]");
        }
        validationContext.put("INDEX_ACTION", action);
    }

    protected void dispatchValidatedAddResource(Map<String, Object> validationContext) {
        BaseElasticSearchIndexBuilder.IndexAction indexAction = (BaseElasticSearchIndexBuilder.IndexAction)validationContext.get("INDEX_ACTION");
        String resourceName = (String)validationContext.get("RESOURCE_NAME");
        EntityContentProducer ecp = (EntityContentProducer)validationContext.get("CONTENT_PRODUCER");
        log.debug("Action on '" + resourceName + "' detected as " + indexAction.name() + " in index builder " + this.getName());
        switch (indexAction) {
            case ADD: {
                this.indexAdd(resourceName, ecp);
                break;
            }
            case DELETE: {
                this.deleteDocumentWithParams(this.extractDeleteDocumentParams(validationContext));
                break;
            }
            default: {
                throw new UnsupportedOperationException(indexAction + " is not supported in index builder " + this.getName());
            }
        }
    }

    protected void deleteDocumentWithParams(Map<String, Object> deleteParams) {
        DeleteRequest request = this.prepareDeleteDocument(deleteParams);
        try {
            DeleteResponse deleteResponse = this.deleteDocumentWithRequest(request);
            if (this.getLog().isDebugEnabled()) {
                if (RestStatus.NOT_FOUND == deleteResponse.status()) {
                    this.getLog().debug("Could not delete doc with by id: " + deleteParams.get("questionId") + " in index builder [" + this.getName() + "] because the document wasn't found");
                } else {
                    this.getLog().debug("ES deleted a doc with id: " + deleteResponse.getId() + " in index builder [" + this.getName() + "]");
                }
            }
        }
        catch (IOException e) {
            this.getLog().error("Failed to delete a doc in index builder [" + this.getName() + "], " + e);
        }
    }

    protected void processContentQueue() {
        this.startTime = System.currentTimeMillis();
        Thread.currentThread().setPriority(4);
        if (this.getPendingDocuments() == 0) {
            this.getLog().trace("No pending docs for index builder [" + this.getName() + "]");
            return;
        }
        SearchResponse response = this.findContentQueue();
        SearchHit[] hits = response.getHits().getHits();
        ArrayList<NoContentException> noContentExceptions = new ArrayList<NoContentException>();
        this.getLog().trace(this.getPendingDocuments() + " pending docs for index builder [" + this.getName() + "]");
        BulkRequest bulkRequest = new BulkRequest();
        for (SearchHit hit : hits) {
            if (bulkRequest.numberOfActions() < this.bulkRequestSize) {
                try {
                    this.processContentQueueEntry(hit, bulkRequest);
                }
                catch (NoContentException e) {
                    noContentExceptions.add(e);
                }
                continue;
            }
            this.executeBulkRequest(bulkRequest);
            bulkRequest = new BulkRequest();
        }
        if (bulkRequest.numberOfActions() > 0) {
            this.executeBulkRequest(bulkRequest);
        }
        if (!noContentExceptions.isEmpty()) {
            for (NoContentException noContentException : noContentExceptions) {
                this.deleteDocument(noContentException);
            }
        }
        this.lastLoad = System.currentTimeMillis();
        if (hits.length > 0) {
            this.getLog().trace("Finished indexing " + hits.length + " docs in " + (this.lastLoad - this.startTime) + " ms for index builder " + this.getName());
        }
    }

    protected SearchRequest addFindContentQueueRequestParams(SearchRequest searchRequest) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).postFilter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"indexed", (boolean)false)).should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"indexed")))).size(this.contentIndexBatchSize).storedFields(Arrays.asList("questionId", "subtype"));
        return searchRequest.indices(new String[]{this.indexName}).source(searchSourceBuilder).types(new String[]{this.indexedDocumentType});
    }

    protected void processContentQueueEntry(SearchHit hit, BulkRequest bulkRequest) throws NoContentException {
        String reference = this.getFieldFromSearchHit("questionId", hit);
        String subtype = this.getFieldFromSearchHit("subtype", hit);
        Object ecp = subtype.equals("item") ? this.itemContentProducer : this.publishedItemContentProducer;
        if (ecp != null) {
            try {
                this.deleteDocument(hit);
                bulkRequest.add(this.prepareIndex(reference, (EntityContentProducer)ecp, true));
            }
            catch (NoContentException e) {
                throw e;
            }
            catch (Exception e) {
                this.getLog().error("Failed to process content queue entry with id [" + hit.getId() + "] in index builder [" + this.getName() + "]", (Throwable)e);
            }
        } else {
            this.noContentProducerForContentQueueEntry(hit, reference);
        }
    }

    protected void prepareIndexAdd(String resourceName, EntityContentProducer ecp, boolean includeContent) throws NoContentException {
        try {
            IndexRequest request = this.prepareIndex(resourceName, ecp, includeContent);
            this.client.index(request, RequestOptions.DEFAULT);
        }
        catch (NoContentException e) {
            throw e;
        }
        catch (Throwable t) {
            this.getLog().error("Error: trying to register resource " + resourceName + " in index builder: " + this.getName(), t);
        }
    }

    protected void indexAdd(String resourceName, EntityContentProducer ecp) {
        try {
            this.prepareIndexAdd(resourceName, ecp, false);
        }
        catch (NoContentException e) {
            this.deleteDocument(e);
        }
        catch (Exception e) {
            this.getLog().error("Problem updating content indexing in index builder: " + this.getName() + " for entity: " + resourceName, (Throwable)e);
        }
    }

    public SearchResponse search(String searchTerms, List<String> references, List<String> siteIds, int start, int end) {
        return this.search(searchTerms, references, siteIds, start, end, new HashMap<String, String>());
    }

    public SearchResponse search(String searchTerms, List<String> references, List<String> siteIds, int start, int end, Map<String, String> additionalSearchInformation) {
        SearchRequest searchRequest = this.prepareSearchRequest(searchTerms, references, siteIds, start, end, additionalSearchInformation);
        log.debug("Search request from index builder [{}]: {}", (Object)this.getName(), (Object)searchRequest.toString());
        ValidateQueryRequest validateQueryRequest = new ValidateQueryRequest(new String[]{this.indexName});
        validateQueryRequest.query(searchRequest.source().query());
        validateQueryRequest.explain(true);
        try {
            ValidateQueryResponse validateQueryResponse = this.client.indices().validateQuery(validateQueryRequest, RequestOptions.DEFAULT);
            if (validateQueryResponse.isValid()) {
                SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
                log.debug("Search request from index builder [{}] took: {}", (Object)this.getName(), (Object)searchResponse.getTook().millis());
                this.eventTrackingService.post(this.eventTrackingService.newEvent("search.query", "/search/query/" + searchRequest.source().query().toString(), true, 3));
                return searchResponse;
            }
            log.warn("Query was not valid for index {} index builder [{}]", (Object)this.indexName, (Object)this.getName());
        }
        catch (IOException ioe) {
            log.warn("Failure search request from index builder [{}], {}", (Object)this.getName(), (Object)ioe.toString());
        }
        return null;
    }

    protected SearchRequest prepareSearchRequest(String searchTerms, List<String> references, List<String> siteIds, int start, int end) {
        return this.prepareSearchRequest(searchTerms, references, siteIds, start, end, new HashMap<String, String>());
    }

    protected SearchRequest prepareSearchRequest(String searchTerms, List<String> references, List<String> siteIds, int start, int end, Map<String, String> additionalSearchInformation) {
        SearchRequest searchRequest = this.newSearchRequestAndQueryBuilders(searchTerms, references, siteIds);
        this.addSearchCoreParams(searchRequest);
        this.addSearchQuery(searchRequest, searchTerms, references, siteIds, additionalSearchInformation);
        this.addSearchResultFields(searchRequest);
        this.addSearchPagination(searchRequest, start, end);
        this.addSearchFacetting(searchRequest);
        this.completeSearchRequestBuilders(searchRequest, searchTerms, references, siteIds);
        return searchRequest;
    }

    protected SearchRequest newSearchRequestAndQueryBuilders(String searchTerms, List<String> references, List<String> siteIds) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source().query((QueryBuilder)QueryBuilders.boolQuery());
        return searchRequest;
    }

    protected void addSearchCoreParams(SearchRequest searchRequest) {
        searchRequest.searchType(SearchType.QUERY_THEN_FETCH).types(new String[]{this.indexedDocumentType});
    }

    protected void addSearchQuery(SearchRequest searchRequest, String searchTerms, List<String> references, List<String> siteIds) {
        this.addSearchQuery(searchRequest, searchTerms, references, siteIds, new HashMap<String, String>());
    }

    protected void addSearchQuery(SearchRequest searchRequest, String searchTerms, List<String> references, List<String> siteIds, Map<String, String> additionalSearchInformation) {
        this.addSearchTerms(searchRequest, searchTerms, additionalSearchInformation);
        this.addSearchReferences(searchRequest, references);
        this.addSearchSiteIds(searchRequest, siteIds);
    }

    protected void addSearchTerms(SearchRequest searchRequest, String searchTerms) {
        this.addSearchTerms(searchRequest, searchTerms, new HashMap<String, String>());
    }

    protected void addSearchTerms(SearchRequest searchRequest, String searchTerms, Map<String, String> additionalSearchInformation) {
        log.debug("Searching the searchterm: {}", (Object)searchTerms);
        Source parseSearchTerms = new Source((CharSequence)searchTerms);
        searchTerms = parseSearchTerms.getTextExtractor().toString();
        String regex = "([+\\-!\\(\\){}\\[\\]^~*?:\\\\]|[&\\|]{2})";
        searchTerms = searchTerms.replaceAll(regex, "\\\\$1");
        log.debug("Searching the searchterms after escape them: {}", (Object)searchTerms);
        BoolQueryBuilder query = (BoolQueryBuilder)searchRequest.source().query();
        if (StringUtils.isNotEmpty((CharSequence)searchTerms)) {
            if (additionalSearchInformation.containsKey("logic") && additionalSearchInformation.get("logic").equals("and")) {
                query.must((QueryBuilder)QueryBuilders.queryStringQuery((String)searchTerms).defaultField("contents").defaultOperator(Operator.AND));
            } else {
                query.must((QueryBuilder)QueryBuilders.queryStringQuery((String)searchTerms).defaultField("contents").defaultOperator(Operator.OR));
            }
        }
        BoolQueryBuilder tagsQuery = QueryBuilders.boolQuery();
        boolean logicalOr = "or".equals(additionalSearchInformation.get("logic"));
        additionalSearchInformation.keySet().stream().filter(k -> k.startsWith("tag_")).forEach(k -> {
            String tag = (String)additionalSearchInformation.get(k);
            log.debug("search tag: {}", (Object)tag);
            if (logicalOr) {
                tagsQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"tags", (String)tag));
            } else {
                tagsQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tags", (String)tag));
            }
        });
        if (tagsQuery.hasClauses()) {
            if (tagsQuery.should().size() > 1) {
                tagsQuery.minimumShouldMatch(1);
            }
            log.debug("tags sub query: {}", (Object)tagsQuery);
            query.must((QueryBuilder)tagsQuery);
        }
        if (additionalSearchInformation.containsKey("subtype")) {
            log.debug("We will search this subtype: {}", (Object)additionalSearchInformation.get("subtype"));
            query.must((QueryBuilder)QueryBuilders.matchQuery((String)"subtype", (Object)additionalSearchInformation.get("subtype")));
        }
        if (additionalSearchInformation.containsKey("hash")) {
            log.debug("We will search this hash: {}", (Object)additionalSearchInformation.get("hash"));
            query.must((QueryBuilder)QueryBuilders.matchQuery((String)"hash", (Object)additionalSearchInformation.get("hash")));
        }
        if (additionalSearchInformation.containsKey("scope")) {
            if (additionalSearchInformation.get("scope").equals("all")) {
                log.debug("we won't filter the results by scope");
            } else if (additionalSearchInformation.get("scope").equals("custom")) {
                log.debug("We have a custom scope request");
                Set<String> keysForACL = additionalSearchInformation.keySet();
                for (String key : keysForACL) {
                    ArrayList<String> siteIds = new ArrayList<String>();
                    ArrayList<String> questionPoolsIds = new ArrayList<String>();
                    if (key.startsWith("site_")) {
                        String siteId = additionalSearchInformation.get(key);
                        log.debug("We have this siteId to add: {}", (Object)siteId);
                        siteIds.add(siteId);
                        query.should((QueryBuilder)QueryBuilders.termsQuery((String)"site", (String[])siteIds.toArray(new String[siteIds.size()])));
                    }
                    if (!key.startsWith("qp_")) continue;
                    String qpId = additionalSearchInformation.get(key);
                    log.debug("We have this question Pool to add: {}", (Object)qpId);
                    questionPoolsIds.add(qpId);
                    query.should((QueryBuilder)QueryBuilders.termsQuery((String)"questionPoolId", (String[])questionPoolsIds.toArray(new String[questionPoolsIds.size()])));
                    query.minimumShouldMatch(1);
                }
            } else if (!this.securityService.isSuperUser()) {
                log.debug("No superuser.Searching based in permissions");
                List<String> siteIds = this.getAllSitesUserHasQuestionAuthorPermissions();
                List<String> questionPoolsIds = this.getAllUserQuestionPools();
                query.should((QueryBuilder)QueryBuilders.termsQuery((String)"site", (String[])siteIds.toArray(new String[siteIds.size()])));
                query.should((QueryBuilder)QueryBuilders.termsQuery((String)"questionPoolId", (String[])questionPoolsIds.toArray(new String[questionPoolsIds.size()])));
                query.minimumShouldMatch(1);
            } else {
                log.debug("Superuser, so no filtering");
            }
            if (additionalSearchInformation.containsKey("group")) {
                log.debug("We are going to group results by: {}", (Object)additionalSearchInformation.get("group"));
                searchRequest.source().size(0);
                this.addSearchAggregation(searchRequest, additionalSearchInformation.get("group"));
            }
        }
    }

    private List<String> getAllSitesUserHasQuestionAuthorPermissions() {
        ArrayList<String> sitesIds = new ArrayList<String>();
        try {
            List allSites = this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, SiteService.SortType.TITLE_ASC, null);
            List moreSites = this.siteService.getSites(SiteService.SelectionType.UPDATE, null, null, null, SiteService.SortType.TITLE_ASC, null);
            if (allSites == null || moreSites == null || allSites.size() == 0 && moreSites.size() == 0) {
                return sitesIds;
            }
            allSites.removeAll(moreSites);
            allSites.addAll(moreSites);
            Iterator allSitesIterator = allSites.iterator();
            while (allSitesIterator.hasNext()) {
                String siteId = ((Site)allSitesIterator.next()).getId();
                log.debug("Checking if user " + AgentFacade.getAgentString() + " is allowed in this site:" + siteId);
                if (!this.securityService.unlock(AgentFacade.getAgentString(), "asn.new", this.siteService.siteReference(siteId))) continue;
                sitesIds.add(siteId);
                log.debug("User allowed in this site:" + siteId);
            }
            if (sitesIds.size() == 0) {
                sitesIds.add("-2");
            }
            return sitesIds;
        }
        catch (Exception e) {
            log.error("Error in getAllSitesUserHasQuestionAuthorPermissions(): " + e.getClass().getName() + " : " + e.getMessage());
            return sitesIds;
        }
    }

    private List<String> getAllUserQuestionPools() {
        ArrayList<String> questionPoolsIds = new ArrayList<String>();
        QuestionPoolIteratorFacade qpif = this.questionPoolService.getAllPoolsWithAccess(AgentFacade.getAgentString());
        try {
            while (qpif.hasNext()) {
                String qpId = Long.toString(qpif.next().getQuestionPoolId());
                questionPoolsIds.add(qpId);
                log.debug("User allowed in this QP:" + qpId);
            }
        }
        catch (SharedException e) {
            log.error("Error retrieving questionPools for actual user: " + ((Object)((Object)e)).getClass().getName() + " : " + e.getMessage());
        }
        catch (Exception ex) {
            log.error("Error retrieving questionPools for actual user: " + ex.getClass().getName() + " : " + ex.getMessage());
        }
        if (questionPoolsIds.size() == 0) {
            questionPoolsIds.add("-2");
        }
        return questionPoolsIds;
    }

    protected void addSearchReferences(SearchRequest searchRequest, List<String> references) {
        if (references.size() > 0) {
            ((BoolQueryBuilder)searchRequest.source().query()).must((QueryBuilder)QueryBuilders.termsQuery((String)"reference", (String[])references.toArray(new String[0])));
        }
    }

    protected void addSearchSiteIds(SearchRequest searchRequest, List<String> siteIds) {
    }

    protected void addSearchResultFields(SearchRequest searchRequest) {
        if (!ArrayUtils.isEmpty((Object[])this.searchResultFieldNames)) {
            searchRequest.source().storedFields(Arrays.asList(this.searchResultFieldNames));
        }
    }

    protected void addSearchPagination(SearchRequest searchRequest, int start, int end) {
        searchRequest.source().from(start).size(end - start);
    }

    protected void addSearchFacetting(SearchRequest searchRequest) {
        if (this.useFacetting) {
            TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)this.facetName).field("hash")).size(this.facetTermSize);
            searchRequest.source().aggregation((AggregationBuilder)termsAggregationBuilder);
        }
    }

    protected void addSearchAggregation(SearchRequest searchRequest, String field) {
        if (this.useAggregation) {
            List<String> fields = Arrays.asList("assessmentId", "site", "questionPoolId", "typeId", "tags", "qText");
            searchRequest.source().aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)AGGREGATION_NAME).field(field)).size(this.serverConfigurationService.getInt("samigo.search.maxResults", 50)).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)AGGREGATION_TOP_HITS).size(1).storedFields(fields)));
        }
    }

    protected void completeSearchRequestBuilders(SearchRequest searchRequest, String searchTerms, List<String> references, List<String> siteIds) {
        log.debug("This is the search query: {}", (Object)searchRequest.source().query().toString());
    }

    protected void completeSearchSuggestionsRequestBuilders(SearchRequest searchRequest, String searchString, String currentSite, boolean allMySites) {
    }

    protected void addSearchSuggestionsTerms(SearchRequest searchRequest, String searchString) {
    }

    protected void addSearchSuggestionsSites(SearchRequest searchRequest, String currentSite, boolean allMySites) {
    }

    public String getEventResourceFilter() {
        return "/";
    }

    protected Logger getLog() {
        return log;
    }

    public void setItemContentProducer(ItemContentProducer itemContentProducer) {
        this.itemContentProducer = itemContentProducer;
    }

    public void setPublishedItemContentProducer(PublishedItemContentProducer publishedItemContentProducer) {
        this.publishedItemContentProducer = publishedItemContentProducer;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    protected class RebuildSiteTask
    extends TimerTask {
        private final String siteId;

        public RebuildSiteTask(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setPriority(4);
                QuestionElasticSearchIndexBuilder.this.rebuildSiteIndex(this.siteId);
            }
            catch (Exception e) {
                QuestionElasticSearchIndexBuilder.this.getLog().error("problem queuing content indexing for site: " + this.siteId + " error: " + e.getMessage());
            }
        }
    }
}

