/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.samigo.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.email.api.DigestService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.emailtemplateservice.api.EmailTemplateService;
import org.sakaiproject.emailtemplateservice.api.RenderedTemplate;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.samigo.api.SamigoETSProvider;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.api.Preferences;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamigoETSProviderImpl
implements SamigoETSProvider {
    private static final Logger log = LoggerFactory.getLogger(SamigoETSProviderImpl.class);
    private final Map<String, String> constantValues = new HashMap<String, String>();
    private final String MULTIPART_BOUNDARY = "======sakai-multi-part-boundary======";
    private final String BOUNDARY_LINE = "\n\n--======sakai-multi-part-boundary======\n";
    private final String TERMINATION_LINE = "\n\n--======sakai-multi-part-boundary======--\n\n";
    private final String MIME_ADVISORY = "This message is for MIME-compliant mail readers.";
    private static final String ADMIN = "admin";
    private String fromAddress = "";
    private static final ResourceLoader RB = new ResourceLoader("EmailNotificationMessages");
    private static final String CHANGE_SETTINGS_HOW_TO_INSTRUCTOR = RB.getString("changeSetting_instructor");
    private static final String CHANGE_SETTINGS_HOW_TO_STUDENT = RB.getString("changeSetting_student");
    private ServerConfigurationService serverConfigurationService;
    private UserDirectoryService userDirectoryService;
    private EmailTemplateService emailTemplateService;
    private PreferencesService preferencesService;
    private EmailService emailService;
    private DigestService digestService;
    private SiteService siteService;
    private AuthzGroupService authzGroupService;

    public void init() {
        log.info("init()");
        this.fromAddress = this.serverConfigurationService.getString("samigo.fromAddress");
        if (StringUtils.isBlank((CharSequence)this.fromAddress)) {
            String defaultAddress = "no-reply@" + this.serverConfigurationService.getServerName();
            this.fromAddress = this.serverConfigurationService.getString("setup.request", defaultAddress);
        }
        this.constantValues.put("localSakaiName", this.serverConfigurationService.getString("ui.service", "Sakai"));
        this.constantValues.put("localSakaiUrl", this.serverConfigurationService.getPortalUrl());
        ClassLoader cl = SamigoETSProviderImpl.class.getClassLoader();
        this.emailTemplateService.importTemplateFromXmlFile(cl.getResourceAsStream("template-assessmentSubmission.xml"), "sam.assessmentSubmitted");
        this.emailTemplateService.importTemplateFromXmlFile(cl.getResourceAsStream("template-assessmentAutoSubmission.xml"), "sam.assessmentAutoSubmitted");
        this.emailTemplateService.importTemplateFromXmlFile(cl.getResourceAsStream("template-assessmentTimedSubmission.xml"), "sam.assessmentTimedSubmitted");
        this.emailTemplateService.importTemplateFromXmlFile(cl.getResourceAsStream("template-assessmentAutoSubmitErrors.xml"), "sam.assessmentAutoSubmitErrors");
    }

    public void notify(String eventKey, Map<String, Object> notificationValues, Event event) {
        log.debug("Notify, templateKey: " + eventKey + " event: " + event.toString());
        switch (eventKey) {
            case "sam.assessment.submit": {
                this.handleAssessmentSubmitted(notificationValues, event);
                break;
            }
            case "sam.assessment.submit.auto": {
                this.handleAssessmentAutoSubmitted(notificationValues, event);
                break;
            }
            case "sam.assessment.submit.timer.thrd": {
                this.handleAssessmentTimedSubmitted(notificationValues, event);
            }
        }
    }

    public void notifyAutoSubmitFailures(int count) {
        boolean notifyOn = this.serverConfigurationService.getBoolean("samigo.email.autoSubmit.errorNotification.enabled", false);
        if (!notifyOn) {
            return;
        }
        String supportAddress = this.serverConfigurationService.getString("mail.support", this.fromAddress);
        String toAddress = this.serverConfigurationService.getString("samigo.email.autoSubmit.errorNotification.toAddress", supportAddress);
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("failureCount", Integer.toString(count));
        try {
            RenderedTemplate template = this.emailTemplateService.getRenderedTemplate("sam.assessmentAutoSubmitErrors", Locale.getDefault(), replacementValues);
            if (template == null) {
                throw new IllegalStateException("Template is null");
            }
            InternetAddress[] to = new InternetAddress[]{new InternetAddress(toAddress)};
            this.emailService.sendMail(new InternetAddress(this.fromAddress), to, template.getRenderedSubject(), template.getRenderedMessage(), null, null, null);
        }
        catch (Exception e) {
            log.error("Unable to send email notification for AutoSubmit failures.", (Throwable)e);
        }
    }

    private void handleAssessmentSubmitted(Map<String, Object> notificationValues, Event event) {
        log.debug("Assessment Submitted");
        this.assessmentSubmittedHelper(notificationValues, event, 1);
    }

    private void handleAssessmentAutoSubmitted(Map<String, Object> notificationValues, Event event) {
        log.debug("Assessment Auto Submitted");
        this.assessmentSubmittedHelper(notificationValues, event, 2);
    }

    private void handleAssessmentTimedSubmitted(Map<String, Object> notificationValues, Event event) {
        log.debug("Assessment Timed Submitted");
        this.assessmentSubmittedHelper(notificationValues, event, 3);
    }

    private void assessmentSubmittedHelper(Map<String, Object> notificationValues, Event event, int assessmentSubmittedType) {
        log.debug("assessment Submitted helper, assessmentSubmittedType: " + assessmentSubmittedType);
        String priStr = Integer.toString(event.getPriority());
        HashMap<String, Object> replacementValues = new HashMap<String, Object>(this.constantValues);
        try {
            User user = this.userDirectoryService.getUser(notificationValues.get("userID").toString());
            PublishedAssessmentService pubAssServ = new PublishedAssessmentService();
            PublishedAssessmentFacade pubAssFac = pubAssServ.getSettingsOfPublishedAssessment(notificationValues.get("publishedAssessmentID").toString());
            SimpleDateFormat dfIn = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            SimpleDateFormat dfIn2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            SimpleDateFormat dfOut = new SimpleDateFormat("yyyy-MMM-dd hh:mm a", this.preferencesService.getLocale(user.getId()));
            String formattedDueDate = pubAssFac.getDueDate() == null ? "" : dfOut.format(pubAssFac.getDueDate());
            Date submissionDate = null;
            String inSubmissionDateStr = notificationValues.get("submissionDate") == null ? "" : notificationValues.get("submissionDate").toString();
            try {
                submissionDate = dfIn.parse(inSubmissionDateStr);
            }
            catch (ParseException e) {
                log.debug("Submission date parse exception (first format): " + e.getMessage());
            }
            if (submissionDate == null) {
                try {
                    submissionDate = dfIn2.parse(inSubmissionDateStr);
                }
                catch (ParseException e) {
                    log.debug("Submission date parse exception (second format): " + e.getMessage());
                }
            }
            String formattedSubmissionDate = submissionDate == null ? inSubmissionDateStr : dfOut.format(submissionDate);
            String siteID = pubAssFac.getOwnerSiteId();
            replacementValues.put("siteName", pubAssFac.getOwnerSite());
            replacementValues.put("siteID", siteID);
            replacementValues.put("userName", user.getDisplayName());
            replacementValues.put("userDisplayID", user.getDisplayId());
            replacementValues.put("assessmentTitle", pubAssFac.getTitle());
            replacementValues.put("assessmentDueDate", formattedDueDate);
            replacementValues.put("assessmentGradingID", notificationValues.get("assessmentGradingID").toString());
            replacementValues.put("submissionDate", formattedSubmissionDate);
            replacementValues.put("confirmationNumber", notificationValues.get("confirmationNumber").toString());
            if (notificationValues.get("releaseToGroups") != null) {
                replacementValues.put("releaseToGroups", notificationValues.get("releaseToGroups").toString());
            }
            this.notifyStudent(user, priStr, assessmentSubmittedType, replacementValues);
            this.notifyInstructor(siteID, pubAssFac.getInstructorNotification(), assessmentSubmittedType, user, replacementValues);
        }
        catch (UserNotDefinedException e) {
            log.warn("UserNotDefined: " + notificationValues.get("userID").toString() + " in sending samigo notification.");
        }
    }

    private void notifyInstructor(String siteID, Integer instructNoti, int assessmentSubmittedType, User submittingUser, Map<String, Object> replacementValues) {
        log.debug("notifyInstructor");
        replacementValues.put("changeSettingInstructions", CHANGE_SETTINGS_HOW_TO_INSTRUCTOR);
        ArrayList<User> validUsers = new ArrayList<User>();
        RenderedTemplate rt = this.getRenderedTemplateBySubmissionType(assessmentSubmittedType, submittingUser, replacementValues);
        String message = this.getBody(rt);
        try {
            Site site = this.siteService.getSite(siteID);
            Set<Object> siteUsersHasRole = new HashSet();
            if (replacementValues.get("releaseToGroups") != null) {
                siteUsersHasRole = this.extractInstructorsFromGroups(site, (String)replacementValues.get("releaseToGroups"));
            }
            if (siteUsersHasRole.isEmpty()) {
                AuthzGroup azGroup = this.authzGroupService.getAuthzGroup("/site/" + siteID);
                siteUsersHasRole = site.getUsersHasRole(azGroup.getMaintainRole());
            }
            for (String userString : siteUsersHasRole) {
                try {
                    if (userString.equals(ADMIN)) continue;
                    User user = this.userDirectoryService.getUser(userString);
                    validUsers.add(user);
                }
                catch (UserNotDefinedException e) {
                    log.warn("Instructor '" + userString + "' not found in samigo notification.");
                }
            }
        }
        catch (IdUnusedException e) {
            log.warn("Site '{}' not found while sending instructor notifications for samigo submission.", (Object)siteID);
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (GroupNotDefinedException e) {
            log.warn("AuthzGroup '/site/{}' not found while sending instructor notifications for samigo submission", (Object)siteID);
            log.debug(e.getMessage(), (Throwable)e);
        }
        ArrayList<User> immediateUsers = new ArrayList<User>();
        if (validUsers.size() > 0) {
            List<String> headers = this.getHeaders(rt, validUsers, this.constantValues.get("localSakaiName"), this.fromAddress);
            for (User user : validUsers) {
                if (instructNoti == 3) {
                    immediateUsers.add(user);
                    continue;
                }
                if (instructNoti != 2) continue;
                log.debug("notifyInstructor + sendDigest + User: " + user.getDisplayName() + " rt: " + rt.getKey());
                this.digestService.digest(user.getId(), rt.getRenderedSubject(), rt.getRenderedMessage());
            }
            if (instructNoti == 3 && !immediateUsers.isEmpty()) {
                log.debug("notifyInstructor + send one email to Users: " + ((Object)immediateUsers).toString() + " rt: " + rt.getKey());
                this.emailService.sendToUsers(immediateUsers, headers, message);
            }
        }
    }

    private Set<String> extractInstructorsFromGroups(Site site, String allGroups) {
        HashSet<String> usersWithRole = new HashSet<String>();
        List groups = Stream.of(allGroups).map(s -> s.split(";")).flatMap(Arrays::stream).collect(Collectors.toList());
        for (String groupId : groups) {
            Group group = site.getGroup(groupId);
            Set groupUsersWithRole = group.getUsersHasRole(group.getMaintainRole());
            usersWithRole.addAll(groupUsersWithRole);
        }
        return usersWithRole;
    }

    private void notifyStudent(User user, String priStr, int assessmentSubmittedType, Map<String, Object> replacementValues) {
        log.debug("notifyStudent");
        replacementValues.put("changeSettingInstructions", CHANGE_SETTINGS_HOW_TO_STUDENT);
        ArrayList<User> users = new ArrayList<User>();
        RenderedTemplate rt = this.getRenderedTemplateBySubmissionType(assessmentSubmittedType, user, replacementValues);
        String message = this.getBody(rt);
        users.add(user);
        List<String> headers = this.getHeaders(rt, users, this.constantValues.get("localSakaiName"), this.fromAddress);
        int uSamEmailPref = this.getUserPreferences(user, priStr);
        if (uSamEmailPref == 3) {
            log.debug("notifyStudent + send one email + rt: " + rt.getKey());
            this.emailService.sendToUsers(users, headers, message);
        } else if (uSamEmailPref == 2) {
            log.debug("notifyStudent + sendDigest + rt: " + rt.getKey());
            this.digestService.digest(user.getId(), rt.getRenderedSubject(), rt.getRenderedMessage());
        }
    }

    private int getUserPreferences(User user, String priStr) {
        log.debug("getUserPreferences User: " + user.getDisplayName());
        int uSamEmailPref = 3;
        Preferences userPrefs = this.preferencesService.getPreferences(user.getId());
        ResourceProperties props = userPrefs.getProperties("noti:types:sakai:samigo");
        try {
            uSamEmailPref = (int)props.getLongProperty(priStr);
        }
        catch (EntityPropertyNotDefinedException | EntityPropertyTypeException throwable) {
            // empty catch block
        }
        log.debug("getUserPreferences: pref=" + uSamEmailPref);
        return uSamEmailPref;
    }

    private String getBody(RenderedTemplate rt) {
        log.debug("getBody");
        StringBuilder body = new StringBuilder();
        body.append("This message is for MIME-compliant mail readers.");
        if (rt.getRenderedMessage() != null) {
            body.append("\n\n--======sakai-multi-part-boundary======\n");
            body.append("Content-Type: text/plain; charset=UTF-8\n");
            body.append(rt.getRenderedMessage());
        }
        if (rt.getRenderedHtmlMessage() != null) {
            body.append("\n\n--======sakai-multi-part-boundary======\n");
            body.append("Content-Type: text/html; charset=UTF-8\n");
            body.append(rt.getRenderedHtmlMessage());
        }
        body.append("\n\n--======sakai-multi-part-boundary======--\n\n");
        return body.toString();
    }

    private RenderedTemplate getRenderedTemplateBySubmissionType(int assessmentSubmittedType, User user, Map<String, Object> replacementValues) {
        RenderedTemplate template;
        switch (assessmentSubmittedType) {
            case 2: {
                template = this.getRenderedTemplate("sam.assessmentAutoSubmitted", user, replacementValues);
                break;
            }
            case 3: {
                template = this.getRenderedTemplate("sam.assessmentTimedSubmitted", user, replacementValues);
                break;
            }
            default: {
                template = this.getRenderedTemplate("sam.assessmentSubmitted", user, replacementValues);
            }
        }
        return template;
    }

    private RenderedTemplate getRenderedTemplate(String templateName, User user, Map<String, Object> replacementValues) {
        log.debug("getting template: " + templateName);
        RenderedTemplate template = null;
        try {
            template = this.emailTemplateService.getRenderedTemplateForUser(templateName, user != null ? user.getReference() : "", replacementValues);
        }
        catch (Exception e) {
            log.warn("Samigo Notification email template error. " + this + e.getMessage());
        }
        return template;
    }

    private List<String> getHeaders(RenderedTemplate rt, List<User> toAddress, String fromName, String fromEmail) {
        log.debug("getHeaders");
        ArrayList<String> headers = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)rt.getFrom())) {
            headers.add("From: \"" + rt.getFrom());
        } else {
            headers.add("From: \"" + fromName + "\" <" + fromEmail + ">");
        }
        String toName = fromName;
        String toEmail = fromEmail;
        if (toAddress.size() == 1) {
            User u = toAddress.get(0);
            toName = u.getDisplayName();
            toEmail = u.getEmail();
        }
        headers.add("To: \"" + toName + "\" <" + toEmail + ">");
        headers.add("Subject: " + rt.getRenderedSubject());
        headers.add("Content-Type: multipart/alternative; boundary=\"======sakai-multi-part-boundary======\"");
        headers.add("Mime-Version: 1.0");
        headers.add("Return-Path: <>");
        headers.add("Auto-Submitted: auto-generated");
        return headers;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setDigestService(DigestService digestService) {
        this.digestService = digestService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }
}

