/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.samigo.impl;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.api.app.scheduler.ScheduledInvocationManager;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.emailtemplateservice.api.EmailTemplateService;
import org.sakaiproject.emailtemplateservice.api.RenderedTemplate;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.samigo.api.SamigoAvailableNotificationService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.time.api.UserTimeService;
import org.sakaiproject.tool.assessment.data.dao.assessment.ExtendedTime;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamigoAvailableNotificationServiceImpl
implements SamigoAvailableNotificationService {
    private static final Logger log = LoggerFactory.getLogger(SamigoAvailableNotificationServiceImpl.class);
    private EmailService emailService;
    private EmailTemplateService emailTemplateService;
    private PreferencesService preferencesService;
    private ScheduledInvocationManager scheduledInvocationManager;
    private SecurityService securityService;
    private ServerConfigurationService serverConfigurationService;
    private SiteService siteService;
    private UserDirectoryService userDirectoryService;
    private UserTimeService userTimeService;
    private PublishedAssessmentService publishedAssessmentService;
    private static final ResourceLoader rl = new ResourceLoader("SamigoAvailableNotificationMessages");
    private final List<String> additionalHeaders = new ArrayList<String>();

    public void init() {
        log.debug("SamigoAvailableNotificationService init()");
        this.publishedAssessmentService = new PublishedAssessmentService();
        String sender = "Sender: \"" + this.getServiceName() + "\" <" + this.getSetupRequest() + ">";
        this.additionalHeaders.add(sender);
        this.additionalHeaders.add("Content-type: text/html; charset=UTF-8");
    }

    public void scheduleAssessmentAvailableNotification(String publishedId) {
        this.removeScheduledAssessmentNotification(publishedId);
        try {
            PublishedAssessmentFacade publishedAssessment = this.publishedAssessmentService.getPublishedAssessment(publishedId);
            List extensionContainer = PersistenceService.getInstance().getExtendedTimeFacade().getEntriesForPub(publishedAssessment.getData());
            Date startDate = publishedAssessment.getStartDate();
            if (Instant.now().isBefore(startDate.toInstant())) {
                this.scheduledInvocationManager.createDelayedInvocation(startDate.toInstant(), "org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId);
            }
            for (ExtendedTime extension : extensionContainer) {
                if (!Instant.now().isBefore(extension.getStartDate().toInstant())) continue;
                this.scheduledInvocationManager.createDelayedInvocation(extension.getStartDate().toInstant(), "org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId + "," + extension.getId().toString());
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to schedule assessment open notification for assessment {}", (Object)publishedId);
        }
    }

    public void removeScheduledAssessmentNotification(String publishedId) {
        this.scheduledInvocationManager.deleteDelayedInvocation("org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId);
        PublishedAssessmentFacade publishedAssessment = this.publishedAssessmentService.getPublishedAssessment(publishedId);
        if (publishedAssessment != null) {
            List extensionContainer = PersistenceService.getInstance().getExtendedTimeFacade().getEntriesForPub(publishedAssessment.getData());
            for (ExtendedTime extension : extensionContainer) {
                this.scheduledInvocationManager.deleteDelayedInvocation("org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId + "," + extension.getId().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String publishedId) {
        log.debug("Samigo available assessment email notification job starting");
        SecurityAdvisor sa = (userId, function, reference) -> SecurityAdvisor.SecurityAdvice.ALLOWED;
        this.securityService.pushAdvisor(sa);
        String extensionId = "";
        if (StringUtils.contains((CharSequence)publishedId, (int)44)) {
            String masterId = new String(publishedId);
            publishedId = masterId.substring(0, masterId.indexOf(44));
            extensionId = masterId.substring(masterId.indexOf(44) + 1);
        }
        try {
            PublishedAssessmentFacade publishedAssessment = this.publishedAssessmentService.getPublishedAssessment(publishedId);
            log.debug("Samigo available assessment notification for id: {} title: {}", (Object)publishedId, (Object)publishedAssessment.getTitle());
            Site site = this.siteService.getSite(publishedAssessment.getOwnerSiteId());
            log.debug("Site from samigo assessment: {} site: {}", (Object)publishedAssessment.getOwnerSiteId(), (Object)site.getTitle());
            if (site.isPublished() && !site.isSoftlyDeleted() && publishedAssessment.getStatus() != AssessmentBaseIfc.DEAD_STATUS && this.ifSiteHasSamigo(site)) {
                log.debug("Samigo assessment site is published and is not softly deleted.");
                log.debug("Release to: {}", (Object)publishedAssessment.getAssessmentAccessControl().getReleaseTo());
                log.debug("Execution has reached the inside of the main published/not deleted/not dead/Samigo-exists block.");
                if (!StringUtils.isEmpty((CharSequence)extensionId)) {
                    ExtendedTime extension = PersistenceService.getInstance().getExtendedTimeFacade().getEntry(extensionId);
                    if (extension != null) {
                        if (!StringUtils.isEmpty((CharSequence)extension.getUser())) {
                            this.sendEmailNotification(site, publishedAssessment, site.getMember(extension.getUser()), extension);
                        }
                        if (!StringUtils.isEmpty((CharSequence)extension.getGroup())) {
                            for (Member member : site.getGroup(extension.getGroup()).getMembers()) {
                                this.sendEmailNotification(site, publishedAssessment, member, extension);
                            }
                        }
                    }
                } else if (StringUtils.equals((CharSequence)publishedAssessment.getAssessmentAccessControl().getReleaseTo(), (CharSequence)"Selected Groups")) {
                    for (Object groupId : publishedAssessment.getReleaseToGroups().keySet().toArray()) {
                        for (Member member : site.getGroup((String)groupId).getMembers()) {
                            if (!member.isActive() || this.isUserInException(publishedAssessment, member.getUserId(), site)) continue;
                            log.debug("Calling send email notification: {}", (Object)member.getUserId());
                            this.sendEmailNotification(site, publishedAssessment, member, null);
                        }
                    }
                } else if (StringUtils.equals((CharSequence)publishedAssessment.getAssessmentAccessControl().getReleaseTo(), (CharSequence)"Anonymous Users")) {
                } else {
                    for (Member member : site.getMembers()) {
                        log.debug("Samigo assessment open notification checking if member needs an email, member: {}", (Object)member.getUserId());
                        log.debug("Member info: active? {}", (Object)member.isActive());
                        log.debug("Member info: released to this member? TODO: THIS");
                        if (!member.isActive() || this.isUserInException(publishedAssessment, member.getUserId(), site)) continue;
                        log.debug("Calling send email notification: {}", (Object)member.getUserId());
                        this.sendEmailNotification(site, publishedAssessment, member, null);
                    }
                }
            }
        }
        catch (IdUnusedException e) {
            log.warn("Samigo assessment available notification job failed, {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.securityService.popAdvisor(sa);
        }
    }

    private void sendEmailNotification(Site site, PublishedAssessmentFacade publishedAssessment, Member member, ExtendedTime extension) {
        log.debug("SendEmailNotification: '{}' to {}", (Object)publishedAssessment.getTitle(), (Object)member.getUserDisplayId());
        log.debug("Test {}", (Object)rl.getString("available_class_at"));
        User userNow = null;
        try {
            userNow = this.userDirectoryService.getUser(member.getUserId());
        }
        catch (UserNotDefinedException u) {
            log.debug("UserNotDefined exception for user ID {} , no email sent", (Object)member.getUserId());
            return;
        }
        String toStr = this.getUserEmail(member.getUserId());
        String headerToStr = this.getUserDisplayName(member.getUserId()) + " <" + toStr + ">";
        String fromStr = "\"" + site.getTitle() + "\" <" + this.getSetupRequest() + ">";
        HashSet<Member> instructors = new HashSet<Member>();
        for (Member person : site.getMembers()) {
            if (!StringUtils.equals((CharSequence)person.getRole().getId(), (CharSequence)site.getMaintainRole())) continue;
            instructors.add(person);
        }
        String replyToStr = this.getReplyTo(instructors);
        HashMap<String, Object> replacementValues = new HashMap<String, Object>();
        replacementValues.put("assessmentName", publishedAssessment.getTitle());
        replacementValues.put("siteName", site.getTitle());
        if (extension != null) {
            replacementValues.put("openDate", this.prettyDate(extension.getStartDate().toInstant()));
            if (extension.getDueDate() != null) {
                replacementValues.put("dueDate", rl.getFormattedMessage("email.reminder.due", new Object[]{this.prettyDate(extension.getDueDate().toInstant())}));
            } else {
                replacementValues.put("dueDate", "");
            }
            if (extension.getTimeHours() == 0 && extension.getTimeMinutes() == 0) {
                replacementValues.put("timeLimit", rl.getString("email.reminder.nolimit"));
            } else {
                replacementValues.put("timeLimit", rl.getFormattedMessage("email.reminder.limit", new Object[]{this.getTimeLimit(this.convertToSeconds(extension.getTimeHours(), extension.getTimeMinutes()))}));
            }
        } else {
            replacementValues.put("openDate", this.prettyDate(publishedAssessment.getStartDate().toInstant()));
            if (publishedAssessment.getDueDate() != null) {
                replacementValues.put("dueDate", rl.getFormattedMessage("email.reminder.due", new Object[]{this.prettyDate(publishedAssessment.getDueDate().toInstant())}));
            } else {
                replacementValues.put("dueDate", "");
            }
            if (publishedAssessment.getTimeLimit() == 0) {
                replacementValues.put("timeLimit", rl.getString("email.reminder.nolimit"));
            } else {
                replacementValues.put("timeLimit", this.getTimeLimit(publishedAssessment.getTimeLimit()));
            }
        }
        String times = rl.getString("email.reminder.unlimitedtimes");
        if (!publishedAssessment.getAssessmentAccessControl().getUnlimitedSubmissions().booleanValue()) {
            times = publishedAssessment.getAssessmentAccessControl().getSubmissionsAllowed().toString();
        }
        replacementValues.put("numOfAttempts", times);
        String score = rl.getString("email.reminder.highest");
        if (publishedAssessment.getEvaluationModel().getScoringType() == EvaluationModelIfc.AVERAGE_SCORE) {
            score = rl.getString("email.reminder.average");
        } else if (publishedAssessment.getEvaluationModel().getScoringType() == EvaluationModelIfc.LAST_SCORE) {
            score = rl.getString("email.reminder.last");
        } else if (publishedAssessment.getEvaluationModel().getScoringType() == EvaluationModelIfc.ALL_SCORE) {
            score = rl.getString("email.reminder.collective");
        }
        replacementValues.put("scoreType", score);
        Object feedback = " ";
        if (publishedAssessment.getAssessmentFeedback().getFeedbackDelivery() == AssessmentFeedbackIfc.NO_FEEDBACK) {
            feedback = (String)feedback + rl.getString("email.reminder.nofeedback");
        }
        replacementValues.put("feedbackType", feedback);
        replacementValues.put("siteUrl", site.getUrl());
        this.emailTemplateServiceSend("sam.assessmentAvailableReminder", null, userNow, fromStr, toStr, headerToStr, replyToStr, replacementValues);
    }

    private String getReplyTo(Set<Member> instructors) {
        StringBuilder replyTo = new StringBuilder();
        for (Member instructor : instructors) {
            String userEmail = this.getUserEmail(instructor.getUserId());
            String displayName = this.getUserDisplayName(instructor.getUserId());
            if (!StringUtils.isNotEmpty((CharSequence)userEmail)) continue;
            replyTo.append("'");
            replyTo.append(displayName);
            replyTo.append("' <");
            replyTo.append(userEmail);
            replyTo.append(">, ");
        }
        return replyTo.length() > 0 ? replyTo.substring(0, replyTo.length() - 2) : "";
    }

    private String getUserEmail(String userId) {
        String email = null;
        try {
            email = this.userDirectoryService.getUser(userId).getEmail();
        }
        catch (UserNotDefinedException e) {
            log.warn("Cannot get email for id: {} : {} : {}", new Object[]{userId, ((Object)((Object)e)).getClass(), e.getMessage()});
        }
        return email;
    }

    private String getUserDisplayName(String userId) {
        String userDisplayName = "";
        try {
            userDisplayName = this.userDirectoryService.getUser(userId).getDisplayName();
        }
        catch (Exception e) {
            log.debug("Could not get user {}", (Object)(userId + e));
        }
        return userDisplayName;
    }

    private String getUserFirstName(String userId) {
        String email = "";
        try {
            email = this.userDirectoryService.getUser(userId).getFirstName();
        }
        catch (UserNotDefinedException e) {
            log.warn("Cannot get first name for id: {} : {} : {}", new Object[]{userId, ((Object)((Object)e)).getClass(), e.getMessage()});
        }
        return email;
    }

    private String getSetupRequest() {
        return this.serverConfigurationService.getString("setup.request", "no-reply@" + this.serverConfigurationService.getServerName());
    }

    private String getServiceName() {
        return this.serverConfigurationService.getString("ui.service", "Sakai");
    }

    private String getTimeLimit(Integer seconds) {
        StringBuilder output = new StringBuilder();
        int seconds2 = seconds;
        int hours = 0;
        while (seconds2 / 60 > 59) {
            ++hours;
            seconds2 -= 3600;
        }
        if (hours > 0) {
            output.append(hours + rl.getString("email.reminder.hour"));
        }
        output.append(seconds2 / 60 + rl.getString("email.reminder.minutes"));
        return output.toString();
    }

    private Integer convertToSeconds(int hours, int minutes) {
        return hours * 3600 + minutes * 60;
    }

    private boolean ifSiteHasSamigo(Site site) {
        log.debug("Execution has arrived at ifSiteHasSamigo.");
        return site.getToolForCommonId("sakai.samigo") != null;
    }

    private boolean isUserInException(PublishedAssessmentFacade publishedAssessment, String userId, Site site) {
        log.debug("Execution has arrived at isUserInException.");
        for (ExtendedTime extension : PersistenceService.getInstance().getExtendedTimeFacade().getEntriesForPub(publishedAssessment.getData())) {
            if (StringUtils.equals((CharSequence)extension.getUser(), (CharSequence)userId)) {
                return true;
            }
            if (StringUtils.isBlank((CharSequence)extension.getGroup())) continue;
            for (Member member : site.getGroup(extension.getGroup()).getMembers()) {
                if (!StringUtils.equals((CharSequence)member.getUserId(), (CharSequence)userId)) continue;
                return true;
            }
        }
        return false;
    }

    private String prettyDate(Instant date) {
        String fullDate = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault()).format(date);
        Object time = fullDate.substring(fullDate.indexOf(32) + 1);
        Integer hour = Integer.parseInt(((String)time).substring(0, 2));
        String noon = rl.getString("email.reminder.am");
        if (hour > 11) {
            noon = rl.getString("email.reminder.pm");
            if (hour > 12) {
                time = (hour = Integer.valueOf(hour - 12)) < 10 ? ((String)time).replace(((String)time).substring(0, 2), "0" + hour.toString()) : ((String)time).replace(((String)time).substring(0, 2), hour.toString());
            }
        }
        time = (String)time + " " + noon;
        return fullDate.substring(0, fullDate.indexOf(32)) + " " + (String)time;
    }

    private String emailTemplateServiceSend(String templateName, Locale locale, User user, String from, String to, String headerTo, String replyTo, Map<String, Object> replacementValues) {
        log.debug("getting template: {}", (Object)templateName);
        try {
            RenderedTemplate template = locale == null ? this.emailTemplateService.getRenderedTemplateForUser(templateName, user != null ? user.getReference() : "", replacementValues) : this.emailTemplateService.getRenderedTemplate(templateName, locale, replacementValues);
            if (template != null) {
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("Precedence: bulk");
                String content = template.getRenderedMessage();
                this.emailService.send(from, to, template.getRenderedSubject(), content, headerTo, replyTo, headers);
                return content;
            }
        }
        catch (Exception e) {
            log.warn(this + e.getMessage());
            return null;
        }
        return null;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setScheduledInvocationManager(ScheduledInvocationManager scheduledInvocationManager) {
        this.scheduledInvocationManager = scheduledInvocationManager;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setUserTimeService(UserTimeService userTimeService) {
        this.userTimeService = userTimeService;
    }
}

