/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.samigo.impl;

import java.time.Instant;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.api.app.scheduler.DelayedInvocation;
import org.sakaiproject.api.app.scheduler.ScheduledInvocationManager;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.emailtemplateservice.api.EmailTemplateService;
import org.sakaiproject.emailtemplateservice.api.RenderedTemplate;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.samigo.api.SamigoAvailableNotificationService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.time.api.UserTimeService;
import org.sakaiproject.tool.assessment.data.dao.assessment.ExtendedTime;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.api.Preferences;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamigoAvailableNotificationServiceImpl
implements SamigoAvailableNotificationService {
    private static final Logger log = LoggerFactory.getLogger(SamigoAvailableNotificationServiceImpl.class);
    private EmailService emailService;
    private EmailTemplateService emailTemplateService;
    private PreferencesService preferencesService;
    private ScheduledInvocationManager scheduledInvocationManager;
    private SecurityService securityService;
    private ServerConfigurationService serverConfigurationService;
    private SiteService siteService;
    private UserDirectoryService userDirectoryService;
    private UserTimeService userTimeService;
    private PublishedAssessmentService publishedAssessmentService;
    private static final ResourceLoader rl = new ResourceLoader("SamigoAvailableNotificationMessages");

    public void init() {
        log.debug("SamigoAvailableNotificationService init()");
        this.publishedAssessmentService = new PublishedAssessmentService();
    }

    public void rescheduleAssessmentAvailableNotification(String publishedId) {
        DelayedInvocation[] delayedInvocations = this.scheduledInvocationManager.findDelayedInvocations("org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId);
        if (delayedInvocations != null && delayedInvocations.length > 0) {
            this.removeScheduledAssessmentNotification(publishedId);
            this.scheduleAssessmentAvailableNotification(publishedId);
        }
    }

    public void scheduleAssessmentAvailableNotification(String publishedId) {
        PublishedAssessmentFacade publishedAssessment = this.publishedAssessmentService.getPublishedAssessment(publishedId);
        try {
            List extensionContainer = PersistenceService.getInstance().getExtendedTimeFacade().getEntriesForPub(publishedAssessment.getData());
            Date startDate = publishedAssessment.getStartDate();
            if (Instant.now().isBefore(startDate.toInstant())) {
                this.scheduledInvocationManager.createDelayedInvocation(startDate.toInstant(), "org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId);
            } else {
                this.scheduledInvocationManager.createDelayedInvocation(Instant.now(), "org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId);
            }
            for (ExtendedTime extension : extensionContainer) {
                if (!Instant.now().isBefore(extension.getStartDate().toInstant())) continue;
                this.scheduledInvocationManager.createDelayedInvocation(extension.getStartDate().toInstant(), "org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId + "," + extension.getId().toString());
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to schedule assessment open notification for assessment {}", (Object)publishedId);
        }
    }

    public void removeScheduledAssessmentNotification(String publishedId) {
        this.scheduledInvocationManager.deleteDelayedInvocation("org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId);
        PublishedAssessmentFacade publishedAssessment = this.publishedAssessmentService.getPublishedAssessment(publishedId);
        if (publishedAssessment != null) {
            List extensionContainer = PersistenceService.getInstance().getExtendedTimeFacade().getEntriesForPub(publishedAssessment.getData());
            for (ExtendedTime extension : extensionContainer) {
                this.scheduledInvocationManager.deleteDelayedInvocation("org.sakaiproject.samigo.api.SamigoAvailableNotificationService", publishedId + "," + extension.getId().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String publishedId) {
        log.debug("Samigo available assessment email notification job starting");
        SecurityAdvisor sa = (userId, function, reference) -> SecurityAdvisor.SecurityAdvice.ALLOWED;
        this.securityService.pushAdvisor(sa);
        String extensionId = "";
        if (StringUtils.contains((CharSequence)publishedId, (int)44)) {
            String masterId = publishedId;
            publishedId = masterId.substring(0, masterId.indexOf(44));
            extensionId = masterId.substring(masterId.indexOf(44) + 1);
        }
        try {
            PublishedAssessmentFacade publishedAssessment = this.publishedAssessmentService.getPublishedAssessment(publishedId);
            log.debug("Samigo available assessment notification for id: {} title: {}", (Object)publishedId, (Object)publishedAssessment.getTitle());
            Site site = this.siteService.getSite(publishedAssessment.getOwnerSiteId());
            log.debug("Site from samigo assessment: {} site: {}", (Object)publishedAssessment.getOwnerSiteId(), (Object)site.getTitle());
            if (site.isPublished() && !site.isSoftlyDeleted() && !Objects.equals(publishedAssessment.getStatus(), AssessmentBaseIfc.DEAD_STATUS) && this.ifSiteHasSamigo(site)) {
                log.debug("Samigo assessment site is published and is not softly deleted.");
                log.debug("Release to: {}", (Object)publishedAssessment.getAssessmentAccessControl().getReleaseTo());
                log.debug("Execution has reached the inside of the main published/not deleted/not dead/Samigo-exists block.");
                if (StringUtils.isNotBlank((CharSequence)extensionId)) {
                    ExtendedTime extension = PersistenceService.getInstance().getExtendedTimeFacade().getEntry(extensionId);
                    if (extension != null) {
                        if (StringUtils.isNotBlank((CharSequence)extension.getUser())) {
                            User user = this.userDirectoryService.getUser(extension.getUser());
                            this.sendEmailNotification(site, publishedAssessment, user, extension);
                        }
                        if (StringUtils.isNotBlank((CharSequence)extension.getGroup())) {
                            Set groupUserUids = site.getGroup(extension.getGroup()).getUsers();
                            for (User groupUser : this.userDirectoryService.getUsers((Collection)groupUserUids)) {
                                this.sendEmailNotification(site, publishedAssessment, groupUser, extension);
                            }
                        }
                    }
                } else if (StringUtils.equals((CharSequence)publishedAssessment.getAssessmentAccessControl().getReleaseTo(), (CharSequence)"Selected Groups")) {
                    for (Object groupId : publishedAssessment.getReleaseToGroups().keySet().toArray()) {
                        Set studentUserUids = site.getUsersIsAllowed("assessment.takeAssessment");
                        Set groupUserUids = site.getGroup((String)groupId).getUsers();
                        studentUserUids.retainAll(groupUserUids);
                        for (User groupUser : this.userDirectoryService.getUsers((Collection)studentUserUids)) {
                            if (this.isUserInException(publishedAssessment, groupUser.getId(), site)) continue;
                            log.debug("Calling send email notification: {}", (Object)groupUser.getId());
                            this.sendEmailNotification(site, publishedAssessment, groupUser, null);
                        }
                    }
                } else if (StringUtils.equals((CharSequence)publishedAssessment.getAssessmentAccessControl().getReleaseTo(), (CharSequence)"Anonymous Users")) {
                } else {
                    Set studentUserUids = site.getUsersIsAllowed("assessment.takeAssessment");
                    for (User u : this.userDirectoryService.getUsers((Collection)studentUserUids)) {
                        log.debug("Samigo assessment open notification checking if member needs an email, member: {}", (Object)u.getId());
                        if (this.isUserInException(publishedAssessment, u.getId(), site)) continue;
                        log.debug("Calling send email notification for a regular site member: {}", (Object)u.getId());
                        this.sendEmailNotification(site, publishedAssessment, u, null);
                    }
                }
            }
        }
        catch (IdUnusedException e) {
            log.warn("Samigo assessment available notification job failed, {}", (Object)e.getMessage(), (Object)e);
        }
        catch (UserNotDefinedException e) {
            log.warn("User not defined so catching exception and not sending email out for user", (Throwable)e);
        }
        finally {
            this.securityService.popAdvisor(sa);
        }
    }

    private void sendEmailNotification(Site site, PublishedAssessmentFacade publishedAssessment, User userNow, ExtendedTime extension) {
        log.debug("SendEmailNotification: '{}' to {}", (Object)publishedAssessment.getTitle(), (Object)userNow.getDisplayId());
        String userEmail = userNow.getEmail();
        if (StringUtils.isBlank((CharSequence)userEmail)) {
            log.warn("Skipping notification to {} because of missing email", (Object)userNow.getEid());
            return;
        }
        Preferences userPrefs = this.preferencesService.getPreferences(userNow.getId());
        ResourceProperties props = userPrefs.getProperties("noti:types:sakai:samigoOpen");
        String notiStr = props != null && props.getProperty("2") != null ? props.getProperty("2") : String.valueOf(3);
        int noti = Integer.parseInt(notiStr);
        if (noti == 1) {
            log.debug("Skipping notification to user because of user preference override: {}", (Object)userNow.getEid());
            return;
        }
        String headerToStr = userNow.getDisplayName() + " <" + userEmail + ">";
        String fromStr = "\"" + site.getTitle() + "\" <" + this.getSetupRequest() + ">";
        HashMap<String, Object> replacementValues = new HashMap<String, Object>();
        replacementValues.put("assessmentName", publishedAssessment.getTitle());
        replacementValues.put("siteName", site.getTitle());
        if (extension != null) {
            replacementValues.put("openDate", this.userTimeService.dateTimeFormat(extension.getStartDate().toInstant(), null, null));
            if (extension.getDueDate() != null) {
                replacementValues.put("dueDate", rl.getFormattedMessage("email.reminder.due", new Object[]{this.userTimeService.dateTimeFormat(extension.getDueDate().toInstant(), null, FormatStyle.LONG)}));
            } else {
                replacementValues.put("dueDate", "");
            }
            if (extension.getTimeHours() == 0 && extension.getTimeMinutes() == 0) {
                replacementValues.put("timeLimit", rl.getString("email.reminder.nolimit"));
            } else {
                replacementValues.put("timeLimit", rl.getFormattedMessage("email.reminder.limit", new Object[]{this.getTimeLimit(this.convertToSeconds(extension.getTimeHours(), extension.getTimeMinutes()))}));
            }
        } else {
            replacementValues.put("openDate", this.userTimeService.dateTimeFormat(publishedAssessment.getStartDate().toInstant(), null, FormatStyle.LONG));
            if (publishedAssessment.getDueDate() != null) {
                replacementValues.put("dueDate", rl.getFormattedMessage("email.reminder.due", new Object[]{this.userTimeService.dateTimeFormat(publishedAssessment.getDueDate().toInstant(), null, FormatStyle.LONG)}));
            } else {
                replacementValues.put("dueDate", "");
            }
            if (publishedAssessment.getTimeLimit() == 0) {
                replacementValues.put("timeLimit", rl.getString("email.reminder.nolimit"));
            } else {
                replacementValues.put("timeLimit", this.getTimeLimit(publishedAssessment.getTimeLimit()));
            }
        }
        String times = rl.getString("email.reminder.unlimitedtimes");
        if (!publishedAssessment.getAssessmentAccessControl().getUnlimitedSubmissions().booleanValue()) {
            times = publishedAssessment.getAssessmentAccessControl().getSubmissionsAllowed().toString();
        }
        replacementValues.put("numOfAttempts", times);
        String score = rl.getString("email.reminder.highest");
        if (Objects.equals(publishedAssessment.getEvaluationModel().getScoringType(), EvaluationModelIfc.AVERAGE_SCORE)) {
            score = rl.getString("email.reminder.average");
        } else if (Objects.equals(publishedAssessment.getEvaluationModel().getScoringType(), EvaluationModelIfc.LAST_SCORE)) {
            score = rl.getString("email.reminder.last");
        } else if (Objects.equals(publishedAssessment.getEvaluationModel().getScoringType(), EvaluationModelIfc.ALL_SCORE)) {
            score = rl.getString("email.reminder.collective");
        }
        replacementValues.put("scoreType", score);
        Object feedback = " ";
        if (Objects.equals(publishedAssessment.getAssessmentFeedback().getFeedbackDelivery(), AssessmentFeedbackIfc.NO_FEEDBACK)) {
            feedback = (String)feedback + rl.getString("email.reminder.nofeedback");
        }
        replacementValues.put("feedbackType", feedback);
        replacementValues.put("siteUrl", site.getUrl());
        this.emailTemplateServiceSend("sam.assessmentAvailableReminder", null, userNow, fromStr, userEmail, headerToStr, null, replacementValues);
    }

    private String getSetupRequest() {
        return this.serverConfigurationService.getSmtpFrom();
    }

    private String getTimeLimit(Integer seconds) {
        StringBuilder output = new StringBuilder();
        int seconds2 = seconds;
        int hours = 0;
        while (seconds2 / 60 > 59) {
            ++hours;
            seconds2 -= 3600;
        }
        if (hours > 0) {
            output.append(hours).append(rl.getString("email.reminder.hour"));
        }
        output.append(seconds2 / 60).append(rl.getString("email.reminder.minutes"));
        return output.toString();
    }

    private Integer convertToSeconds(int hours, int minutes) {
        return hours * 3600 + minutes * 60;
    }

    private boolean ifSiteHasSamigo(Site site) {
        log.debug("Execution has arrived at ifSiteHasSamigo.");
        return site.getToolForCommonId("sakai.samigo") != null;
    }

    private boolean isUserInException(PublishedAssessmentFacade publishedAssessment, String userId, Site site) {
        log.debug("Execution has arrived at isUserInException.");
        for (ExtendedTime extension : PersistenceService.getInstance().getExtendedTimeFacade().getEntriesForPub(publishedAssessment.getData())) {
            if (StringUtils.equals((CharSequence)extension.getUser(), (CharSequence)userId)) {
                return true;
            }
            if (!StringUtils.isNotBlank((CharSequence)extension.getGroup())) continue;
            for (Member member : site.getGroup(extension.getGroup()).getMembers()) {
                if (!StringUtils.equals((CharSequence)member.getUserId(), (CharSequence)userId)) continue;
                return true;
            }
        }
        return false;
    }

    private void emailTemplateServiceSend(String templateName, Locale locale, User user, String from, String to, String headerTo, String replyTo, Map<String, Object> replacementValues) {
        log.debug("getting template: {}", (Object)templateName);
        try {
            RenderedTemplate template = locale == null ? this.emailTemplateService.getRenderedTemplateForUser(templateName, user.getReference(), replacementValues) : this.emailTemplateService.getRenderedTemplate(templateName, locale, replacementValues);
            if (template != null) {
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("Precedence: bulk");
                String content = template.getRenderedMessage();
                this.emailService.send(from, to, template.getRenderedSubject(), content, headerTo, replyTo, headers);
            }
        }
        catch (Exception e) {
            log.warn("Error sending templated email for available assessment notification", (Throwable)e);
        }
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setScheduledInvocationManager(ScheduledInvocationManager scheduledInvocationManager) {
        this.scheduledInvocationManager = scheduledInvocationManager;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setUserTimeService(UserTimeService userTimeService) {
        this.userTimeService = userTimeService;
    }
}

