/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.handlers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osid.assessment.AssessmentException;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.importer.api.HandlesImportable;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.handlers.SamigoPoolHandler;
import org.sakaiproject.importer.impl.importables.Assessment;
import org.sakaiproject.importer.impl.importables.AssessmentAnswer;
import org.sakaiproject.importer.impl.importables.AssessmentQuestion;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.cover.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamigoAssessmentHandler
implements HandlesImportable {
    private static final Logger log = LoggerFactory.getLogger(SamigoAssessmentHandler.class);
    public static final int TRUE_FALSE = 4;
    public static final int FILL_BLANK = 8;
    public static final int MATCHING = 9;
    public static final int FILL_BLANK_PLUS = 11;
    public static final String QUIZ_TYPE = "62";
    public static final String QUIZ_TEMPLATE = "3";
    private AssessmentService as = new AssessmentService();
    private ItemService itemService = new ItemService();

    public boolean canHandleType(String typeName) {
        return "sakai-assessment".equals(typeName);
    }

    public void handle(Importable thing, String siteId) {
        Assessment importAssessment = (Assessment)thing;
        AssessmentFacade assessment = null;
        try {
            assessment = this.as.createAssessmentWithoutDefaultSection(importAssessment.getTitle(), importAssessment.getDescription(), QUIZ_TYPE, QUIZ_TEMPLATE, siteId);
            AssessmentData data = new AssessmentData(new Long(QUIZ_TEMPLATE), importAssessment.getTitle(), new Date());
            data.setTypeId(new Long(QUIZ_TYPE));
            data.setTitle(importAssessment.getTitle());
            data.setDescription(importAssessment.getDescription());
            data.setAssessmentTemplateId(new Long(QUIZ_TEMPLATE));
            data.setCreatedBy(SessionManager.getCurrentSessionUserId());
            data.setLastModifiedBy(SessionManager.getCurrentSessionUserId());
            data.setLastModifiedDate(new Date());
            data.setStatus(Integer.valueOf(1));
            data.setIsTemplate(Boolean.valueOf(false));
            data.setCreatedDate(new Date());
            HashSet questionItems = new HashSet();
            questionItems.addAll(this.doQuestions(importAssessment.getEssayQuestions(), siteId));
            questionItems.addAll(this.doQuestions(importAssessment.getFillBlankQuestions(), siteId));
            questionItems.addAll(this.doQuestions(importAssessment.getMatchQuestions(), siteId));
            questionItems.addAll(this.doQuestions(importAssessment.getMultiAnswerQuestions(), siteId));
            questionItems.addAll(this.doQuestions(importAssessment.getMultiChoiceQuestions(), siteId));
            questionItems.addAll(this.doQuestions(importAssessment.getTrueFalseQuestions(), siteId));
            HashSet sectionSet = new HashSet();
            SectionFacade section = new SectionFacade();
            section.setTypeId(Long.valueOf(21L));
            section.setCreatedBy(SessionManager.getCurrentSessionUserId());
            section.setCreatedDate(new Date());
            section.setLastModifiedBy(SessionManager.getCurrentSessionUserId());
            section.setLastModifiedDate(new Date());
            section.setStatus(Integer.valueOf(1));
            section.setSequence(Integer.valueOf(1));
            section.setAssessmentId(assessment.getAssessmentId());
            section.setAssessment((AssessmentIfc)assessment);
            this.as.saveOrUpdateSection(section);
            Object[] questionItemsArray = questionItems.toArray();
            Arrays.sort(questionItemsArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Integer i1 = ((ItemFacade)o1).getSequence();
                    Integer i2 = ((ItemFacade)o2).getSequence();
                    return i1.compareTo(i2);
                }
            });
            for (int i = 0; i < questionItemsArray.length; ++i) {
                ItemFacade item = (ItemFacade)questionItemsArray[i];
                item.setSequence(Integer.valueOf(i + 1));
                item.setSection((SectionDataIfc)section);
                section.addItem(this.itemService.saveItem(item));
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.saveitem", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/saved itemId=" + item.getItemId().toString()), (boolean)true));
            }
            data.setSectionSet(sectionSet);
            assessment.setData((AssessmentBaseIfc)data);
            assessment.setSectionSet(sectionSet);
            this.as.saveAssessment(assessment);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (AssessmentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private Collection doQuestions(List questions, String siteId) {
        Vector<ItemFacade> rv = new Vector<ItemFacade>();
        ItemFacade itemFacade = null;
        String questionTextString = null;
        ItemText text = null;
        HashSet<ItemText> textSet = null;
        Answer answer = null;
        HashSet<Answer> answerSet = null;
        Object answerFeedback = null;
        HashSet answerFeedbackSet = null;
        int questionCount = 0;
        for (AssessmentQuestion importableQuestion : questions) {
            Collection answers;
            ++questionCount;
            Set correctAnswerIDs = importableQuestion.getCorrectAnswerIDs();
            itemFacade = new ItemFacade();
            itemFacade.setTypeId(new Long(importableQuestion.getQuestionType()));
            textSet = new HashSet<ItemText>();
            questionTextString = this.contextualizeUrls(importableQuestion.getQuestionText(), siteId);
            if (importableQuestion.getQuestionType() == 9) {
                itemFacade.setInstruction(questionTextString);
                answers = importableQuestion.getAnswers().values();
                Collection choices = importableQuestion.getChoices().values();
                int answerIndex = 1;
                for (AssessmentAnswer importableAnswer : answers) {
                    text = new ItemText();
                    text.setSequence(Long.valueOf(answerIndex));
                    ++answerIndex;
                    text.setText(this.contextualizeUrls(importableAnswer.getAnswerText(), siteId));
                    answerSet = new HashSet();
                    int choiceIndex = 1;
                    for (AssessmentAnswer importableChoice : choices) {
                        answer = new Answer();
                        answer.setItem(itemFacade.getData());
                        answer.setItemText((ItemTextIfc)text);
                        answer.setSequence(new Long(choiceIndex));
                        answer.setLabel(new Character((char)(64 + ++choiceIndex)).toString());
                        answer.setText(this.contextualizeUrls(importableChoice.getAnswerText(), siteId));
                        answer.setIsCorrect(Boolean.valueOf(importableAnswer.getChoiceId().equals(importableChoice.getAnswerId())));
                        answerSet.add(answer);
                    }
                    text.setAnswerSet(answerSet);
                    text.setItem(itemFacade.getData());
                    textSet.add(text);
                }
            } else {
                text = new ItemText();
                text.setSequence(Long.valueOf(1L));
                text.setText(questionTextString);
                answerSet = new HashSet<Answer>();
                answerFeedbackSet = new HashSet();
                answers = importableQuestion.getAnswers().values();
                StringBuilder answerBuffer = new StringBuilder();
                Iterator j = answers.iterator();
                while (j.hasNext()) {
                    Matcher matcher;
                    Pattern pattern;
                    AssessmentAnswer importableAnswer;
                    importableAnswer = (AssessmentAnswer)j.next();
                    answerBuffer.append(importableAnswer.getAnswerText());
                    if (j.hasNext()) {
                        answerBuffer.append("|");
                    }
                    String answerId = importableAnswer.getAnswerId();
                    answer = new Answer();
                    answer.setItem(itemFacade.getData());
                    answer.setItemText((ItemTextIfc)text);
                    answer.setSequence(new Long(importableAnswer.getPosition()));
                    answer.setLabel(new Character((char)(64 + importableAnswer.getPosition())).toString());
                    if (importableQuestion.getQuestionType() == 4) {
                        answer.setText(importableAnswer.getAnswerText().toLowerCase());
                    } else if (importableQuestion.getQuestionType() == SamigoPoolHandler.FILL_BLANK_PLUS) {
                        answer.setText(importableAnswer.getAnswerText());
                        pattern = Pattern.compile("_+|<<.*>>");
                        matcher = pattern.matcher(questionTextString);
                        if (matcher.find()) {
                            questionTextString = questionTextString.replaceFirst(matcher.group(), "{}");
                        }
                        text.setText(questionTextString);
                        itemFacade.setTypeId(Long.valueOf(8L));
                    } else if (importableQuestion.getQuestionType() == 8) {
                        if (j.hasNext()) continue;
                        answer.setText(answerBuffer.toString());
                        pattern = Pattern.compile("_+|<<.*>>");
                        matcher = pattern.matcher(questionTextString);
                        if (matcher.find()) {
                            questionTextString = questionTextString.replaceFirst(matcher.group(), "{}");
                        }
                        text.setText(questionTextString);
                        answer.setSequence(new Long(1L));
                    } else {
                        answer.setText(this.contextualizeUrls(importableAnswer.getAnswerText(), siteId));
                    }
                    answer.setIsCorrect(new Boolean(correctAnswerIDs.contains(answerId)));
                    answerSet.add(answer);
                }
                text.setAnswerSet(answerSet);
                text.setItem(itemFacade.getData());
                textSet.add(text);
            }
            itemFacade.setItemTextSet(textSet);
            itemFacade.setCorrectItemFeedback(importableQuestion.getFeedbackWhenCorrect());
            itemFacade.setInCorrectItemFeedback(importableQuestion.getFeedbackWhenIncorrect());
            itemFacade.setTypeId(Long.valueOf(importableQuestion.getQuestionType()));
            itemFacade.setScore(importableQuestion.getPointValue());
            itemFacade.setSequence(importableQuestion.getPosition());
            itemFacade.setStatus(Integer.valueOf(1));
            itemFacade.setHasRationale(Boolean.FALSE);
            itemFacade.setCreatedBy(SessionManager.getCurrentSessionUserId());
            itemFacade.setCreatedDate(new Date());
            itemFacade.setLastModifiedBy(SessionManager.getCurrentSessionUserId());
            itemFacade.setLastModifiedDate(new Date());
            rv.add(itemFacade);
        }
        return rv;
    }

    protected String contextualizeUrls(String text, String siteId) {
        if (text == null) {
            return null;
        }
        String anyRelativeUrl = "src=\"(?!http)/?";
        return text.replaceAll(anyRelativeUrl, "src=\"/access/content/group/" + siteId + "/TQimages/");
    }
}

