/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.handlers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.importer.api.HandlesImportable;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.importables.AssessmentAnswer;
import org.sakaiproject.importer.impl.importables.AssessmentQuestion;
import org.sakaiproject.importer.impl.importables.QuestionPool;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.cover.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamigoPoolHandler
implements HandlesImportable {
    private static final Logger log = LoggerFactory.getLogger(SamigoPoolHandler.class);
    public static final int TRUE_FALSE = 4;
    public static final int FILL_BLANK = 8;
    public static final int MATCHING = 9;
    public static int FILL_BLANK_PLUS = 11;
    private QuestionPoolService qps = new QuestionPoolService();
    private ItemService itemService = new ItemService();

    public boolean canHandleType(String typeName) {
        return "sakai-question-pool".equals(typeName);
    }

    public void handle(Importable thing, String siteId) {
        QuestionPool importPool = (QuestionPool)thing;
        QuestionPoolFacade pool = new QuestionPoolFacade();
        pool.setOwnerId(SessionManager.getCurrentSessionUserId());
        pool.setTitle(importPool.getTitle());
        pool.setDescription(importPool.getDescription());
        pool.setAccessTypeId(Long.valueOf(30L));
        HashSet questionItems = new HashSet();
        questionItems.addAll(this.doQuestions(importPool.getEssayQuestions(), siteId));
        questionItems.addAll(this.doQuestions(importPool.getFillBlankQuestions(), siteId));
        questionItems.addAll(this.doQuestions(importPool.getMatchQuestions(), siteId));
        questionItems.addAll(this.doQuestions(importPool.getMultiAnswerQuestions(), siteId));
        questionItems.addAll(this.doQuestions(importPool.getMultiChoiceQuestions(), siteId));
        questionItems.addAll(this.doQuestions(importPool.getTrueFalseQuestions(), siteId));
        QuestionPoolFacade savedPool = this.qps.savePool(pool);
        Object[] questionItemsArray = questionItems.toArray();
        Arrays.sort(questionItemsArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer i1 = ((ItemFacade)o1).getSequence();
                Integer i2 = ((ItemFacade)o2).getSequence();
                return i1.compareTo(i2);
            }
        });
        for (int i = 0; i < questionItemsArray.length; ++i) {
            ItemFacade item = (ItemFacade)questionItemsArray[i];
            item.setSequence(Integer.valueOf(i + 1));
            this.qps.addItemToPool(item.getItemId(), savedPool.getQuestionPoolId());
        }
    }

    private Collection doQuestions(List questions, String siteId) {
        Vector<ItemFacade> rv = new Vector<ItemFacade>();
        ItemFacade itemFacade = null;
        String questionTextString = null;
        ItemText text = null;
        HashSet<ItemText> textSet = null;
        Answer answer = null;
        HashSet<Answer> answerSet = null;
        Object answerFeedback = null;
        HashSet answerFeedbackSet = null;
        int questionCount = 0;
        for (AssessmentQuestion importableQuestion : questions) {
            Collection answers;
            ++questionCount;
            Set correctAnswerIDs = importableQuestion.getCorrectAnswerIDs();
            itemFacade = new ItemFacade();
            itemFacade.setTypeId(new Long(importableQuestion.getQuestionType()));
            textSet = new HashSet<ItemText>();
            questionTextString = this.contextualizeUrls(importableQuestion.getQuestionText(), siteId);
            if (importableQuestion.getQuestionType() == 9) {
                itemFacade.setInstruction(questionTextString);
                answers = importableQuestion.getAnswers().values();
                Collection choices = importableQuestion.getChoices().values();
                int answerIndex = 1;
                for (AssessmentAnswer importableAnswer : answers) {
                    text = new ItemText();
                    text.setSequence(Long.valueOf(answerIndex));
                    ++answerIndex;
                    text.setText(this.contextualizeUrls(importableAnswer.getAnswerText(), siteId));
                    answerSet = new HashSet();
                    int choiceIndex = 1;
                    for (AssessmentAnswer importableChoice : choices) {
                        answer = new Answer();
                        answer.setItem(itemFacade.getData());
                        answer.setItemText((ItemTextIfc)text);
                        answer.setSequence(new Long(choiceIndex));
                        answer.setLabel(new Character((char)(64 + ++choiceIndex)).toString());
                        answer.setText(this.contextualizeUrls(importableChoice.getAnswerText(), siteId));
                        answer.setIsCorrect(Boolean.valueOf(importableAnswer.getChoiceId().equals(importableChoice.getAnswerId())));
                        answerSet.add(answer);
                    }
                    text.setAnswerSet(answerSet);
                    text.setItem(itemFacade.getData());
                    textSet.add(text);
                }
            } else {
                text = new ItemText();
                text.setSequence(new Long(1L));
                text.setText(questionTextString);
                answerSet = new HashSet<Answer>();
                answerFeedbackSet = new HashSet();
                answers = importableQuestion.getAnswers().values();
                StringBuilder answerBuffer = new StringBuilder();
                Iterator j = answers.iterator();
                while (j.hasNext()) {
                    Matcher matcher;
                    Pattern pattern;
                    AssessmentAnswer importableAnswer;
                    importableAnswer = (AssessmentAnswer)j.next();
                    answerBuffer.append(importableAnswer.getAnswerText());
                    if (j.hasNext()) {
                        answerBuffer.append("|");
                    }
                    String answerId = importableAnswer.getAnswerId();
                    answer = new Answer();
                    answer.setItem(itemFacade.getData());
                    answer.setItemText((ItemTextIfc)text);
                    answer.setSequence(new Long(importableAnswer.getPosition()));
                    answer.setLabel(new Character((char)(64 + importableAnswer.getPosition())).toString());
                    if (importableQuestion.getQuestionType() == 4) {
                        answer.setText(importableAnswer.getAnswerText().toLowerCase());
                    } else if (importableQuestion.getQuestionType() == FILL_BLANK_PLUS) {
                        answer.setText(importableAnswer.getAnswerText());
                        pattern = Pattern.compile("_+|<<.*>>");
                        matcher = pattern.matcher(questionTextString);
                        if (matcher.find()) {
                            questionTextString = questionTextString.replaceFirst(matcher.group(), "{}");
                        }
                        text.setText(questionTextString);
                        itemFacade.setTypeId(Long.valueOf(8L));
                    } else if (importableQuestion.getQuestionType() == 8) {
                        if (j.hasNext()) continue;
                        answer.setText(answerBuffer.toString());
                        pattern = Pattern.compile("_+|<<.*>>");
                        matcher = pattern.matcher(questionTextString);
                        if (matcher.find()) {
                            questionTextString = questionTextString.replaceFirst(matcher.group(), "{}");
                        }
                        text.setText(questionTextString);
                        answer.setSequence(new Long(1L));
                    } else {
                        answer.setText(this.contextualizeUrls(importableAnswer.getAnswerText(), siteId));
                    }
                    answer.setIsCorrect(Boolean.valueOf(correctAnswerIDs.contains(answerId)));
                    answerSet.add(answer);
                }
                text.setAnswerSet(answerSet);
                text.setItem(itemFacade.getData());
                textSet.add(text);
            }
            itemFacade.setItemTextSet(textSet);
            itemFacade.setCorrectItemFeedback(importableQuestion.getFeedbackWhenCorrect());
            itemFacade.setInCorrectItemFeedback(importableQuestion.getFeedbackWhenIncorrect());
            itemFacade.setScore(importableQuestion.getPointValue());
            itemFacade.setSequence(importableQuestion.getPosition());
            itemFacade.setStatus(Integer.valueOf(1));
            itemFacade.setHasRationale(Boolean.FALSE);
            itemFacade.setCreatedBy(SessionManager.getCurrentSessionUserId());
            itemFacade.setCreatedDate(new Date());
            itemFacade.setLastModifiedBy(SessionManager.getCurrentSessionUserId());
            itemFacade.setLastModifiedDate(new Date());
            this.itemService.saveItem(itemFacade);
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.saveitem", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/saved itemId=" + itemFacade.getItemId().toString()), (boolean)true));
            rv.add(itemFacade);
        }
        return rv;
    }

    protected String contextualizeUrls(String text, String siteId) {
        if (text == null) {
            return null;
        }
        String anyRelativeUrl = "src=\"(?!http)/?";
        return text.replaceAll(anyRelativeUrl, "src=\"/access/content/group/" + siteId + "/TQimages/");
    }
}

