/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.handlers;

import org.sakaiproject.importer.api.HandlesImportable;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.importables.Assessment;
import org.sakaiproject.importer.impl.importables.QuestionPool;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.qti.QTIService;
import org.sakaiproject.tool.cover.SessionManager;

public class SamigoHandler
implements HandlesImportable {
    private QuestionPoolService qps = new QuestionPoolService();

    public boolean canHandleType(String typeName) {
        return "sakai-question-pool".equals(typeName) || "sakai-assessment".equals(typeName);
    }

    public void handle(Importable thing, String siteId) {
        if ("sakai-assessment".equals(thing.getTypeName())) {
            Assessment assessment = (Assessment)thing;
            QTIService qtiService = new QTIService();
            int version = 2;
            if ("1.2".equals(assessment.getVersion())) {
                version = 1;
            }
            try {
                qtiService.createImportedAssessment(assessment.getQti(), version);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("sakai-question-pool".equals(thing.getTypeName())) {
            QuestionPool sourcePool = (QuestionPool)thing;
            QuestionPoolService qps = new QuestionPoolService();
            QuestionPoolFacade destinationPool = new QuestionPoolFacade();
            destinationPool.setOwnerId(SessionManager.getCurrentSessionUserId());
            destinationPool.setTitle(sourcePool.getTitle());
            destinationPool.setDescription(sourcePool.getDescription());
            QuestionPoolFacade savedPool = qps.savePool(destinationPool);
        }
    }
}

