/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.db.api.SqlService;

public class SakaiBootStrap {
    private static final String SAKAI_SAMIGO_DDL_NAME = "sakai_samigo";
    private static final String SQL_UPDATE_SCRIPT_NAME = "sakai_samigo_post_schema_update";
    private static final String SAKAI_AUTO_DDL_PROPERTY = "auto.ddl";
    private static final Log LOG = LogFactory.getLog(SakaiBootStrap.class);
    private SqlService sqlService;
    private boolean autoDdl = false;

    public SakaiBootStrap() {
        LOG.debug((Object)"new SakaiBootStrap()");
    }

    public void init() {
        this.autoDdl = ServerConfigurationService.getBoolean((String)SAKAI_AUTO_DDL_PROPERTY, (boolean)this.autoDdl);
        this.sqlService = org.sakaiproject.db.cover.SqlService.getInstance();
        if (this.sqlService == null) {
            LOG.error((Object)"SakaiBootStrap.init(): SqlService cannot be found!");
            throw new IllegalStateException("SqlService cannot be found!");
        }
        if (this.autoDdl) {
            LOG.info((Object)"SakaiBootStrap.init(): autoDdl enabled; running DDL...");
            try {
                this.sqlService.ddl(this.getClass().getClassLoader(), SQL_UPDATE_SCRIPT_NAME);
            }
            catch (Throwable t) {
                LOG.warn((Object)"SakaiBootStrap.init(): ", t);
            }
            try {
                this.sqlService.ddl(this.getClass().getClassLoader(), SAKAI_SAMIGO_DDL_NAME);
            }
            catch (Throwable t) {
                LOG.warn((Object)"SakaiBootStrap.init(): ", t);
            }
        } else {
            LOG.debug((Object)"****autoDdl disabled.");
        }
        String uploadPath = ServerConfigurationService.getString((String)"samigo.answerUploadRepositoryPath", null);
        if (uploadPath != null) {
            File samigoDir = new File(uploadPath);
            if (!samigoDir.exists()) {
                LOG.info((Object)(samigoDir + " doesn't exist. Creating it now ..."));
                if (samigoDir.mkdirs()) {
                    LOG.info((Object)(samigoDir + " created."));
                } else {
                    LOG.error((Object)"samigo.answerUploadRepositoryPath was not set. No Samigo upload folder has been created.");
                }
            } else {
                LOG.info((Object)(samigoDir + " exists. It will not be recreated."));
            }
        } else {
            LOG.error((Object)"samigo.answerUploadRepositoryPath was not set. No Samigo upload folder has been created.");
        }
    }

    public void setAutoDdl(String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setAutoDdl(String " + value + ")"));
        }
        if ("true".equals(value)) {
            this.autoDdl = true;
        }
    }
}

