/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper.item;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.qti.asi.Item;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringXml;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperBase;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperIfc;
import org.w3c.dom.Element;

public class ItemHelper20Impl
extends ItemHelperBase
implements ItemHelperIfc {
    private static Log log = LogFactory.getLog(ItemHelper20Impl.class);
    private AuthoringXml authoringXml = new AuthoringXml(this.getQtiVersion());

    public ItemHelper20Impl() {
        log.debug((Object)"ItemHelper20Impl");
    }

    @Override
    protected AuthoringXml getAuthoringXml() {
        return this.authoringXml;
    }

    @Override
    public void addMaxScore(Double score, Item itemXml) {
        String xPath;
        List list;
        if (score == null) {
            score = 0.0;
        }
        if ((list = itemXml.selectNodes(xPath = "assessmentItem/responseCondition/responseIf/setOutcomeValue/baseValue")) == null || list.size() == 0) {
            return;
        }
        this.updateItemXml(itemXml, xPath, score.toString());
    }

    @Override
    public void addMinScore(Double score, Item itemXml) {
        String xPath;
        List list;
        if (score == null) {
            score = 0.0;
        }
        if ((list = itemXml.selectNodes(xPath = "assessmentItem/responseDeclaration/outcomeDeclaration/defaultValue")) == null || list.size() == 0) {
            return;
        }
        this.updateItemXml(itemXml, xPath, score.toString());
        xPath = "assessmentItem/responseCondition/responseElse/setOutcomeValue/baseValue";
        list = itemXml.selectNodes(xPath);
        if (list == null || list.size() == 0) {
            return;
        }
        this.updateItemXml(itemXml, xPath, score.toString());
    }

    @Override
    public void addCorrectAnswer(String correctAnswerLabel, Item itemXml) {
        String xPath = "assessmentItem/responseDeclaration/correctResponse/value";
        this.updateItemXml(itemXml, xPath, correctAnswerLabel);
    }

    @Override
    public String getMetaXPath() {
        String xpath = "assessmentItem/qtiMetadata";
        return xpath;
    }

    @Override
    public String getMetaLabelXPath(String fieldlabel) {
        String xpath = "assessmentItem/qtiMetadata/qtimetadatafield/fieldlabel[text()='" + fieldlabel + "']/following-sibling::fieldentry";
        return xpath;
    }

    @Override
    public String getText(Item itemXml) {
        String xpath = "assessmentItem/itemBody";
        String itemType = itemXml.getItemType();
        if (itemType.equals("Matching")) {
            xpath = "assessmentItem/itemBody/matchInteraction/simpleMatchSet/simpleAssociableChoice";
        }
        return this.makeItemNodeText(itemXml, xpath);
    }

    @Override
    public void setItemTexts(List<ItemTextIfc> itemTextList, Item itemXml) {
        String xPath = "assessmentItem/itemBody";
        if (itemTextList.size() < 1) {
            return;
        }
        String text = itemTextList.get(0).getText();
        log.debug((Object)("item text: " + text));
        if (itemXml.isFIB()) {
            // empty if block
        }
        if (itemXml.isFIN()) {
            // empty if block
        }
        try {
            itemXml.update(xPath, text);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getItemType(Item itemXml) {
        String type = "";
        String xpath = "assessmentItem";
        List list = itemXml.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            element.getAttribute("title");
        }
        return type;
    }

    @Override
    public void setAnswers(List<ItemTextIfc> itemTextList, Item itemXml) {
        if (!(itemXml.isMatching() || itemXml.isFIB() || itemXml.isFIN() || itemXml.isMCSC() || itemXml.isMCMC() || itemXml.isMCMCSS() || itemXml.isMXSURVEY())) {
            return;
        }
        String xpath = "assessmentItem/itemBody/choiceInteraction/<simpleChoice";
        List list = itemXml.selectNodes(xpath);
        log.debug((Object)("xpath size:" + list.size()));
        Iterator nodeIter = list.iterator();
        Iterator<ItemTextIfc> iter = itemTextList.iterator();
        Set answerSet = new HashSet();
        char label = 'A';
        int xpathIndex = 1;
        while (iter.hasNext()) {
            answerSet = iter.next().getAnswerSet();
            for (AnswerIfc answer : answerSet) {
                if (Boolean.TRUE.equals(answer.getIsCorrect())) {
                    this.addCorrectAnswer("" + label, itemXml);
                }
                String value = answer.getText();
                log.debug((Object)("answer: " + answer.getText()));
                Object node = null;
                try {
                    boolean isInsert = true;
                    if (nodeIter.hasNext()) {
                        isInsert = false;
                    }
                    this.addIndexedEntry(itemXml, xpath, value, isInsert, xpathIndex, "" + label);
                }
                catch (Exception ex) {
                    log.error((Object)"Cannot process source document.", (Throwable)ex);
                }
                label = (char)(label + '\u0001');
                ++xpathIndex;
            }
        }
    }

    @Override
    public void setFeedback(List<ItemTextIfc> itemTextList, Item itemXml) {
        String xpath = "assessmentItem/itemBody/choiceInteraction/<simpleChoice/feedbackInline";
        int xpathIndex = 1;
        List list = itemXml.selectNodes(xpath);
        if (list == null) {
            return;
        }
        Iterator nodeIter = list.iterator();
        Iterator<ItemTextIfc> iter = itemTextList.iterator();
        Set answerSet = new HashSet();
        int label = 65;
        boolean first = true;
        while (iter.hasNext()) {
            ItemTextIfc itemTextIfc = iter.next();
            if (first) {
                String correctFeedback = itemTextIfc.getItem().getCorrectItemFeedback();
                String incorrectFeedback = itemTextIfc.getItem().getInCorrectItemFeedback();
                String generalFeedback = itemTextIfc.getItem().getGeneralItemFeedback();
                log.debug((Object)("NEED TO SET CORRECT FEEDBACK: " + correctFeedback));
                log.debug((Object)("NEED TO SET INCORRECT FEEDBACK: " + incorrectFeedback));
                log.debug((Object)("NEED TO SET GENERAL FEEDBACK: " + incorrectFeedback));
                first = false;
            }
            answerSet = itemTextIfc.getAnswerSet();
            for (AnswerIfc answer : answerSet) {
                String value = answer.getGeneralAnswerFeedback();
                log.debug((Object)("answer feedback: " + answer.getText()));
                Object node = null;
                try {
                    boolean isInsert = true;
                    if (nodeIter.hasNext()) {
                        isInsert = false;
                    }
                    this.addIndexedEntry(itemXml, xpath, value, isInsert, xpathIndex, null);
                }
                catch (Exception ex) {
                    log.error((Object)"Cannot process source document.", (Throwable)ex);
                }
                label = (char)(label + 1);
                ++xpathIndex;
            }
        }
    }

    private void addIndexedEntry(Item itemXml, String xpath, String value, boolean isInsert, int index, String identifier) {
        String indexBrackets = "[" + index + "]";
        String thisNode = xpath + indexBrackets;
        String thisNodeIdentity = thisNode + "/@identity";
        if (isInsert) {
            log.debug((Object)("Adding entry: " + thisNode));
            itemXml.insertElement(thisNode, xpath, "itemfeedback");
        } else {
            log.debug((Object)("Updating entry: " + thisNode));
        }
        try {
            if (value == null) {
                value = "";
            }
            itemXml.update(thisNode, value);
            log.debug((Object)"updated value in addIndexedEntry()");
        }
        catch (Exception ex) {
            log.error((Object)("Cannot update value in addIndexedEntry(): " + ex));
        }
    }

    @Override
    protected int getQtiVersion() {
        return 2;
    }

    @Override
    public void addIncorrectAnswer(String incorrectAnswerLabel, Item itemXml) {
    }

    @Override
    public void setItemLabel(String itemLabel, Item itemXml) {
    }

    @Override
    public void setItemText(String itemText, Item itemXml) {
    }

    @Override
    public void setItemText(String itemText, String flowClass, Item itemXml) {
    }

    @Override
    public void setPresentationLabel(String presentationLabel, Item itemXml) {
    }

    @Override
    public void setPresentationFlowResponseIdent(String presentationFlowResponseIdent, Item itemXml) {
    }

    @Override
    public void setAttachments(Set<? extends AttachmentIfc> attachmentSet, Item item) {
    }
}

