/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.qti.asi.Item;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringHelper;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringXml;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperIfc;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class ItemHelperBase
implements ItemHelperIfc {
    private static Log log = LogFactory.getLog(ItemHelperBase.class);
    protected static final long ITEM_AUDIO = TypeIfc.AUDIO_RECORDING;
    protected static final long ITEM_ESSAY = TypeIfc.ESSAY_QUESTION;
    protected static final long ITEM_FILE = TypeIfc.FILE_UPLOAD;
    protected static final long ITEM_FIB = TypeIfc.FILL_IN_BLANK;
    protected static final long ITEM_FIN = TypeIfc.FILL_IN_NUMERIC;
    protected static final long ITEM_MCSC = TypeIfc.MULTIPLE_CHOICE;
    protected static final long ITEM_SURVEY = TypeIfc.MULTIPLE_CHOICE_SURVEY;
    protected static final long ITEM_MCMC = TypeIfc.MULTIPLE_CORRECT;
    protected static final long ITEM_MCMC_SS = TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION;
    protected static final long ITEM_TF = TypeIfc.TRUE_FALSE;
    protected static final long ITEM_MATCHING = TypeIfc.MATCHING;
    protected static final long ITEM_MXSURVEY = TypeIfc.MATRIX_CHOICES_SURVEY;
    protected static final long ITEM_CALCQ = TypeIfc.CALCULATED_QUESTION;
    protected static final long ITEM_EMI = TypeIfc.EXTENDED_MATCHING_ITEMS;

    protected abstract AuthoringXml getAuthoringXml();

    protected abstract int getQtiVersion();

    @Override
    public Item readXMLDocument(InputStream inputStream) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("readDocument(InputStream " + inputStream));
        }
        Item itemXml = null;
        try {
            AuthoringHelper authoringHelper = new AuthoringHelper(this.getQtiVersion());
            itemXml = new Item(authoringHelper.readXMLDocument(inputStream).getDocument(), this.getQtiVersion());
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return itemXml;
    }

    @Override
    public Item readTypeXMLItem(Long type) {
        AuthoringXml ax = this.getAuthoringXml();
        String template = this.getTemplateFromType(type);
        InputStream is = ax.getTemplateInputStream(template);
        Item itemXml = this.readXMLDocument(is);
        return itemXml;
    }

    @Override
    public Item readTypeSurveyItem(String scaleName) {
        AuthoringXml ax = this.getAuthoringXml();
        InputStream is = null;
        if (scaleName == null) {
            log.warn((Object)"missing survey scale name, set to: STRONGLY_AGREE");
            scaleName = "STRONGLY_AGREE";
        }
        String template = this.getTemplateFromScale(scaleName);
        is = ax.getTemplateInputStream(template);
        Item itemXml = this.readXMLDocument(is);
        return itemXml;
    }

    private String getTemplateFromScale(String scalename) {
        String template = "survey/10.xml";
        if ("YES".equals(scalename) || "YESNO".equals(scalename)) {
            template = "survey/YES.xml";
        } else if ("AGREE".equals(scalename)) {
            template = "survey/AGREE.xml";
        } else if ("UNDECIDED".equals(scalename)) {
            template = "survey/UNDECIDED.xml";
        } else if ("AVERAGE".equals(scalename)) {
            template = "survey/AVERAGE.xml";
        } else if ("STRONGLY_AGREE".equals(scalename)) {
            template = "survey/STRONGLY_AGREE.xml";
        } else if ("EXCELLENT".equals(scalename)) {
            template = "survey/EXCELLENT.xml";
        } else if ("5".equals(scalename) || "SCALEFIVE".equals(scalename)) {
            template = "survey/5.xml";
        } else if ("10".equals(scalename) || "SCALETEN".equals(scalename)) {
            template = "survey/10.xml";
        }
        log.debug((Object)("scale: " + scalename));
        log.debug((Object)("template: " + template));
        return template;
    }

    private String getTemplateFromType(Long type) {
        String template = "";
        long typeId = ITEM_TF;
        if (type != null) {
            typeId = type;
        }
        if (ITEM_AUDIO == typeId) {
            template = "audioRecordingTemplate.xml";
        } else if (ITEM_ESSAY == typeId) {
            template = "essayTemplate.xml";
        } else if (ITEM_FILE == typeId) {
            template = "fileUploadTemplate.xml";
        } else if (ITEM_FIB == typeId) {
            template = "fibTemplate.xml";
        } else if (ITEM_FIN == typeId) {
            template = "finTemplate.xml";
        } else if (ITEM_MCSC == typeId) {
            template = "mcSCTemplate.xml";
        } else if (ITEM_SURVEY == typeId) {
            template = "mcSurveyTemplate.xml";
        } else if (ITEM_MCMC == typeId) {
            template = "mcMCTemplate.xml";
        } else if (ITEM_MCMC_SS == typeId) {
            template = "mcMCSSTemplate.xml";
        } else if (ITEM_TF == typeId) {
            template = "trueFalseTemplate.xml";
        } else if (ITEM_MATCHING == typeId) {
            template = "matchTemplate.xml";
        } else if (ITEM_EMI == typeId) {
            template = "emiTemplate.xml";
        } else if (ITEM_MXSURVEY == typeId) {
            template = "mxSurveyTemplate.xml";
        } else if (ITEM_CALCQ == typeId) {
            template = "calculatedQuestionTemplate.xml";
        }
        log.debug((Object)("typeId: " + typeId));
        log.debug((Object)("template: " + template));
        return template;
    }

    @Override
    public Item updateItemXml(Item itemXml, String xpath, String value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateItemXml(Item " + itemXml + ", String" + xpath + ", String" + value + ")"));
        }
        try {
            itemXml.update(xpath, value);
        }
        catch (DOMException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return itemXml;
    }

    protected String makeItemNodeText(Item itemXml, String xpath) {
        List nodes = itemXml.selectNodes(xpath);
        Iterator iter = nodes.iterator();
        StringBuilder textbuf = new StringBuilder();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            Node child = node.getFirstChild();
            if (child == null || !(child instanceof CharacterData)) continue;
            CharacterData cdi = (CharacterData)child;
            textbuf.append(" " + cdi.getData());
        }
        String text = textbuf.toString();
        return text;
    }
}

