/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.tool.assessment.qti.util.URIResolver;
import org.sakaiproject.util.api.FormattedText;
import org.springframework.core.io.ClassPathResource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private static Log log = LogFactory.getLog(XmlUtil.class);
    private static String[] M_goodTags = "a,abbr,acronym,address,b,big,blockquote,br,center,cite,code,dd,del,dir,div,dl,dt,em,font,hr,h1,h2,h3,h4,h5,h6,i,ins,kbd,li,marquee,menu,nobr,noembed,ol,p,pre,q,rt,ruby,rbc,rb,rtc,rp,s,samp,small,span,strike,strong,sub,sup,tt,u,ul,var,xmp,img,embed,object,table,tr,td,th,tbody,caption,thead,tfoot,colgroup,col,param".split(",");
    private static Pattern[] M_goodTagsPatterns;
    private static Pattern[] M_goodCloseTagsPatterns;
    private static Pattern M_htmlPattern;
    private static FormattedText formattedText;

    public static Document createDocument() {
        log.debug((Object)"createDocument()");
        Document document = null;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            XmlUtil.setDocumentBuilderFactoryFeatures(builderFactory);
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return document;
    }

    public static Document createDocument(String xmlString) {
        log.debug((Object)"createDocument()");
        Document document = null;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            XmlUtil.setDocumentBuilderFactoryFeatures(builderFactory);
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.parse(xmlString);
        }
        catch (IOException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (SAXException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return document;
    }

    public static Document readDocument(ServletContext context, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("readDocument(String " + path + ")"));
        }
        Document document = null;
        InputStream inputStream = context.getResourceAsStream(path);
        String fullpath = context.getRealPath(path);
        log.debug((Object)("readDocument(full path) " + fullpath + ")"));
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            XmlUtil.setDocumentBuilderFactoryFeatures(builderFactory);
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return document;
    }

    public static Document readDocument(String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("readDocument(String " + path + ")"));
        }
        Document document = null;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        ClassPathResource resource = new ClassPathResource(path);
        try {
            InputStream inputStream = resource.getInputStream();
            XmlUtil.setDocumentBuilderFactoryFeatures(builderFactory);
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return document;
    }

    public static DOMSource getDocumentSource(ServletContext context, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("readDocument(String " + path + ")"));
        }
        InputStream inputStream = context.getResourceAsStream(path);
        String realPath = null;
        try {
            realPath = context.getResource(path).toString();
        }
        catch (MalformedURLException e1) {
            log.debug((Object)e1.getMessage(), (Throwable)e1);
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        Document document = null;
        DOMSource source = null;
        try {
            XmlUtil.setDocumentBuilderFactoryFeatures(builderFactory);
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
            source = new DOMSource(document, realPath);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return source;
    }

    public static Document readDocument(String path, boolean trim) throws ParserConfigurationException, SAXException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("readDocument(String " + path + ")"));
        }
        Document document = null;
        InputStream inputStream = null;
        BufferedReader in = null;
        try {
            if (trim) {
                in = new BufferedReader(new FileReader(path));
                StringBuilder buffer = new StringBuilder();
                String s = "";
                while ((s = in.readLine()) != null) {
                    if (s.trim().length() <= 0) continue;
                    buffer.append(s);
                    buffer.append("\n");
                }
                in.close();
                byte[] bytes = buffer.toString().getBytes();
                inputStream = new ByteArrayInputStream(bytes);
            } else {
                inputStream = new FileInputStream(path);
            }
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            XmlUtil.setDocumentBuilderFactoryFeatures(builderFactory);
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SAXException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e1) {
                    log.debug((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        }
        return document;
    }

    public static Transformer createTransformer(Document stylesheet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createTransformer(Document " + stylesheet + ")"));
        }
        Transformer transformer = null;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        URIResolver resolver = new URIResolver();
        transformerFactory.setURIResolver(resolver);
        try {
            DOMSource source = new DOMSource(stylesheet);
            String systemId = "/xml/xsl/report";
            source.setSystemId(systemId);
            transformer = transformerFactory.newTransformer(source);
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return transformer;
    }

    public static Transformer createTransformer(DOMSource source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createTransformer(DOMSource " + source + ")"));
        }
        Transformer transformer = null;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        URIResolver resolver = new URIResolver();
        transformerFactory.setURIResolver(resolver);
        try {
            transformer = transformerFactory.newTransformer(source);
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return transformer;
    }

    private static void transform(Transformer transformer, Source source, Result result) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("performTransform(Transformer " + transformer + ", Source" + source + ", Result " + result + ")"));
        }
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static Document transformDocument(Document document, Document stylesheet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Document transformDocument(Document " + document + ", Document " + stylesheet + ")"));
        }
        Document transformedDoc = XmlUtil.createDocument();
        DOMSource docSource = new DOMSource(document);
        DOMResult docResult = new DOMResult(transformedDoc);
        Transformer transformer = XmlUtil.createTransformer(stylesheet);
        XmlUtil.transform(transformer, docSource, docResult);
        return transformedDoc;
    }

    public static Document transformDocument(Document document, Transformer transformer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Document transformDocument(Document " + document + ", Trasformer " + transformer));
        }
        Document transformedDoc = XmlUtil.createDocument();
        DOMSource docSource = new DOMSource(document);
        DOMResult docResult = new DOMResult(transformedDoc);
        XmlUtil.transform(transformer, docSource, docResult);
        return transformedDoc;
    }

    public static void transformNode(Node source, Node result, Transformer transformer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("transformNode(Node " + source + ", Node " + result + ", Transformer ," + transformer));
        }
        DOMSource domSource = new DOMSource(source);
        DOMResult domResult = new DOMResult(result);
        XmlUtil.transform(transformer, domSource, domResult);
    }

    public static String getDOMString(Node node) {
        StringBuilder domStringbuf = new StringBuilder();
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                domStringbuf.append("<?xml version=\"1.0\" ?>\n");
                domStringbuf.append(XmlUtil.getDOMString(((Document)node).getDocumentElement()));
                break;
            }
            case 1: {
                domStringbuf.append("<");
                domStringbuf.append(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    domStringbuf.append(" " + attr.getNodeName().trim() + "=\"" + attr.getNodeValue().trim() + "\"");
                }
                domStringbuf.append(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        domStringbuf.append(XmlUtil.getDOMString(children.item(i)));
                    }
                }
                domStringbuf.append("</");
                domStringbuf.append(node.getNodeName());
                domStringbuf.append(">\n");
                break;
            }
            case 5: {
                domStringbuf.append("&");
                domStringbuf.append(node.getNodeName().trim());
                domStringbuf.append(";");
                break;
            }
            case 4: {
                domStringbuf.append("");
                break;
            }
            case 3: {
                String val = node.getNodeValue();
                if (val == null) {
                    val = "";
                }
                domStringbuf.append(val);
                break;
            }
            case 7: {
                domStringbuf.append("");
            }
        }
        if (type == 1) {
            domStringbuf.append("\n");
        }
        String domString = domStringbuf.toString();
        return domString;
    }

    public static String processFormattedText(Log log, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        StringBuilder alertMsg = new StringBuilder();
        String finalValue = "";
        Matcher matcher = M_htmlPattern.matcher(value);
        boolean hasHtmlPattern = false;
        int index = 0;
        StringBuilder textStringBuilder = new StringBuilder();
        String tmpText = "";
        if (M_goodTagsPatterns == null || M_goodCloseTagsPatterns == null) {
            M_goodTagsPatterns = new Pattern[M_goodTags.length];
            M_goodCloseTagsPatterns = new Pattern[M_goodTags.length];
            for (int i = 0; i < M_goodTags.length; ++i) {
                XmlUtil.M_goodTagsPatterns[i] = Pattern.compile(".*<\\s*" + M_goodTags[i] + "(\\s+.*>|>|/>).*", 98);
                XmlUtil.M_goodCloseTagsPatterns[i] = Pattern.compile("<\\s*/\\s*" + M_goodTags[i] + "(\\s.*>|>)", 98);
            }
        }
        while (matcher.find()) {
            hasHtmlPattern = true;
            tmpText = value.substring(index, matcher.start());
            textStringBuilder.append(XmlUtil.convertoLTGT(tmpText));
            String group = matcher.group();
            boolean isGoodTag = false;
            for (int i = 0; i < M_goodTags.length; ++i) {
                if (!M_goodTagsPatterns[i].matcher(group).matches() && !M_goodCloseTagsPatterns[i].matcher(group).matches()) continue;
                textStringBuilder.append(group);
                isGoodTag = true;
                break;
            }
            if (!isGoodTag) {
                textStringBuilder.append(XmlUtil.convertoLTGT(group));
            }
            index = matcher.end();
        }
        textStringBuilder.append(XmlUtil.convertoLTGT(value.substring(index)));
        finalValue = hasHtmlPattern ? formattedText.processFormattedText(textStringBuilder.toString(), alertMsg) : formattedText.processFormattedText(XmlUtil.convertoLTGT(value), alertMsg);
        if (alertMsg.length() > 0) {
            log.debug((Object)alertMsg.toString());
        }
        return finalValue;
    }

    public static String convertoLTGT(String value) {
        return StringUtils.replaceEach((String)value, (String[])new String[]{"<", ">"}, (String[])new String[]{"&lt;", "&gt;"});
    }

    @Deprecated
    public static String convertStrforCDATA(String myString) {
        StringBuffer sbuff = new StringBuffer("<![CDATA[");
        String sTemp = null;
        String escapeStr = myString.replaceAll("]]>", "]]&gt;");
        for (int i = 0; i < escapeStr.length(); ++i) {
            sTemp = escapeStr.charAt(i) < ' ' || escapeStr.charAt(i) == '\u007f' ? "]]>&#" + escapeStr.charAt(i) + ";<![CDATA[" : Character.toString(escapeStr.charAt(i));
            sbuff.append(sTemp);
            sTemp = null;
        }
        sbuff.append("]]>");
        return sbuff.toString();
    }

    public static String convertToSingleCDATA(String text) {
        return "<![CDATA[" + text + "]]>";
    }

    private static void setDocumentBuilderFactoryFeatures(DocumentBuilderFactory builderFactory) throws ParserConfigurationException {
        builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    static {
        M_htmlPattern = Pattern.compile("(<([a-z]\\w*)\\b[^>]*>)|(</\\s*[a-z]\\w*(\\s.*>|>))|(<([a-z]\\w*)\\b[^>]*/>)", 34);
        formattedText = (FormattedText)ComponentManager.get(FormattedText.class);
    }
}

