/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.asi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.qti.util.XmlStringBuffer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class ASIBaseClass
extends XmlStringBuffer {
    private static Log log = LogFactory.getLog(ASIBaseClass.class);
    private static final long serialVersionUID = 5670937321581940933L;
    private String idString;

    protected ASIBaseClass() {
    }

    protected ASIBaseClass(String xml) {
        super(xml);
    }

    protected ASIBaseClass(Document document) {
        super(document);
    }

    protected String extractString(String tagName) throws ParserConfigurationException, SAXException, IOException, DOMException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("extractString(String " + tagName + ")"));
        }
        String title = null;
        String description = null;
        NodeList nodes = this.getDocument().getElementsByTagName(tagName);
        Element element = (Element)nodes.item(0);
        description = title = element.getAttribute("title");
        int size = nodes.getLength();
        for (int i = 0; i < size; ++i) {
            Element node = (Element)nodes.item(i);
            node.setAttribute("ident", this.getIdString());
        }
        return this.stringValue();
    }

    public static String escapeXml(String s) {
        if (s == null) {
            return "";
        }
        return StringEscapeUtils.escapeXml((String)s);
    }

    protected String getFieldentry(String xpath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFieldentry(String " + xpath + ")"));
        }
        String val = null;
        int no = 0;
        try {
            List metadataList = this.selectNodes(xpath);
            no = metadataList.size();
            if (metadataList.size() > 0) {
                Document document = this.getDocument();
                Element fieldentry = (Element)metadataList.get(0);
                CharacterData fieldentryText = (CharacterData)fieldentry.getFirstChild();
                Object getTime = null;
                if (fieldentryText != null && fieldentryText.getNodeValue() != null && fieldentryText.getNodeValue().trim().length() > 0) {
                    val = fieldentryText.getNodeValue();
                }
            }
        }
        catch (DOMException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return val;
    }

    protected void setFieldentry(String xpath, String value) {
        this.setFieldentry(xpath, value, false);
    }

    protected void setFieldentry(String xpath, String value, boolean noEscapeXML) {
        String setValue = null;
        setValue = noEscapeXML ? value : ASIBaseClass.escapeXml(value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("setFieldentry(String " + xpath + ", String " + setValue + ")"));
        }
        try {
            List metadataList = this.selectNodes(xpath);
            int no = metadataList.size();
            String val = null;
            if (metadataList.size() > 0) {
                Document document = this.getDocument();
                Element fieldentry = (Element)metadataList.get(0);
                CharacterData fieldentryText = (CharacterData)fieldentry.getFirstChild();
                Object getTime = null;
                if (fieldentryText != null && fieldentryText.getNodeValue() != null && fieldentryText.getNodeValue().trim().length() > 0) {
                    val = fieldentryText.getNodeValue();
                }
                if (setValue != null) {
                    if (fieldentryText == null) {
                        Text newElementText = fieldentry.getOwnerDocument().createTextNode(setValue);
                        fieldentry.appendChild(newElementText);
                        fieldentryText = (CharacterData)fieldentry.getFirstChild();
                    } else {
                        fieldentryText.setNodeValue(setValue);
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createFieldentry(String xpath, String fieldlabel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createFieldentry(String " + xpath + ", String " + fieldlabel + ")"));
        }
        try {
            List qtimetadataNodes = this.selectNodes(xpath);
            if (qtimetadataNodes.size() > 0) {
                Node qtimetadataNode = (Node)qtimetadataNodes.get(0);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document newDocument = db.newDocument();
                Element qtimetadataField = newDocument.createElement("qtimetadatafield");
                Element fieldlabelElement = newDocument.createElement("fieldlabel");
                Element fieldentryElement = newDocument.createElement("fieldentry");
                Text fieldlabelText = newDocument.createTextNode("fieldlabel");
                fieldlabelText.setNodeValue(fieldlabel);
                fieldlabelElement.appendChild(fieldlabelText);
                Text fieldentryText = newDocument.createTextNode("fieldentry");
                fieldentryElement.appendChild(fieldentryText);
                Node importedFLE = qtimetadataField.getOwnerDocument().importNode(fieldlabelElement, true);
                Node importedFEE = qtimetadataField.getOwnerDocument().importNode(fieldentryElement, true);
                qtimetadataField.appendChild(importedFLE);
                qtimetadataField.appendChild(importedFEE);
                Node importedField = qtimetadataNode.getOwnerDocument().importNode(qtimetadataField, true);
                qtimetadataNode.appendChild(importedField);
            }
        }
        catch (ParserConfigurationException pce) {
            log.error((Object)("Exception thrown from createFieldentry()" + pce.getMessage()), (Throwable)pce);
            pce.printStackTrace();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected List getAllSections(String basePath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAllSections(String " + basePath + ")"));
        }
        String xpath = basePath + "/" + "section";
        List nodes = this.selectNodes(xpath);
        ArrayList<Node> clonedList = new ArrayList<Node>();
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            Node clonedNode = ((Node)nodes.get(i)).cloneNode(true);
            clonedList.add(clonedNode);
        }
        return clonedList;
    }

    protected void removeSections(String basePath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeSections(String " + basePath + ")"));
        }
        String xpath = basePath + "/" + "section";
        this.removeElement(xpath);
    }

    protected List getNumOfSections(String basePath, int selectNumber) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNumOfSections(String " + basePath + ", int " + selectNumber + ")"));
        }
        ArrayList list = new ArrayList();
        ArrayList<Node> clonedList = new ArrayList<Node>();
        List allSections = this.getAllSections(basePath);
        long seed = System.currentTimeMillis();
        int allItemSize = allSections.size();
        Random random = new Random(seed);
        while (list.size() < selectNumber) {
            int randomNum = random.nextInt(allItemSize);
            Object item = allSections.get(randomNum);
            if (list.contains(item)) continue;
            list.add(item);
        }
        for (int i = 0; i < selectNumber; ++i) {
            Node clonedNode = ((Node)list.get(i)).cloneNode(true);
            clonedList.add(clonedNode);
        }
        return clonedList;
    }

    protected void wrappingMattext() {
        log.debug((Object)"wrappingMattext()");
        try {
            NodeList list = this.getDocument().getElementsByTagName("mattext");
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = list.item(i);
                Node childNode = node.getFirstChild();
                if (childNode == null || !(childNode instanceof CharacterData)) continue;
                CharacterData cdi = (CharacterData)childNode;
                String data = cdi.getData();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.newDocument();
                Comment comment = doc.createComment(data);
                node.appendChild(node.getOwnerDocument().importNode(comment, true));
                cdi.setData("");
            }
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getIdString() {
        return this.idString;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }
}

