/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper.item;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.qti.constants.AuthoringConstantStrings;

public class ItemTypeExtractionStrategy {
    private static Log log = LogFactory.getLog(ItemTypeExtractionStrategy.class);
    private static final Long DEFAULT_TYPE = 2L;

    public static Long calculate(String title, String itemIntrospect, String qmdItemtype) {
        String itemType = ItemTypeExtractionStrategy.obtainTypeString(title, itemIntrospect, qmdItemtype);
        Long typeId = ItemTypeExtractionStrategy.getType(itemType);
        return typeId;
    }

    public static Long calculate(Map itemMap) {
        String itemType = null;
        if (itemMap.get("type") != null && !itemMap.get("type").equals("")) {
            if (itemMap.get("type").equals("FIB")) {
                itemType = "Fill In the Blank";
            } else if (itemMap.get("type").equals("Matching")) {
                itemType = "Matching";
            }
        } else if (itemMap.get("itemRcardinality") != null && !itemMap.get("itemRcardinality").equals("")) {
            String itemRcardinality = (String)itemMap.get("itemRcardinality");
            if ("Single".equalsIgnoreCase(itemRcardinality)) {
                List answerList = (List)itemMap.get("itemAnswer");
                if (answerList.size() == 2) {
                    String firstAnswer = ((String)answerList.get(0)).split(":::")[1];
                    String secondAnswer = ((String)answerList.get(1)).split(":::")[1];
                    itemType = firstAnswer.equalsIgnoreCase("true") && secondAnswer.equalsIgnoreCase("false") || firstAnswer.equalsIgnoreCase("false") && secondAnswer.equalsIgnoreCase("true") ? "True False" : "Multiple Choice";
                } else {
                    itemType = "Multiple Choice";
                }
            } else {
                itemType = "Multiple Correct Answer";
            }
        } else {
            itemType = "Short Answers/Essay";
        }
        Long typeId = ItemTypeExtractionStrategy.getType(itemType);
        return typeId;
    }

    public static void main(String[] args) {
        Long l;
        String intro;
        String title;
        String qmd;
        int i;
        String[] typeArray = AuthoringConstantStrings.itemTypes;
        for (i = 0; i < typeArray.length; ++i) {
            qmd = typeArray[i];
            title = "title";
            intro = "introspect";
            l = ItemTypeExtractionStrategy.calculate(title, intro, qmd);
        }
        for (i = 0; i < typeArray.length; ++i) {
            title = typeArray[i];
            intro = "introspect";
            qmd = "qmd";
            l = ItemTypeExtractionStrategy.calculate(title, intro, qmd);
        }
        for (i = 0; i < typeArray.length; ++i) {
            title = "title";
            intro = typeArray[i];
            qmd = "qmd";
            l = ItemTypeExtractionStrategy.calculate(title, intro, qmd);
        }
    }

    private static String obtainTypeString(String titleItemType, String itemIntrospectItemType, String qmdItemType) {
        log.debug((Object)("qmdItemType: " + qmdItemType));
        log.debug((Object)("titleItemType: " + titleItemType));
        log.debug((Object)("itemIntrospectItemType: " + itemIntrospectItemType));
        String itemType = itemIntrospectItemType;
        if (titleItemType != null) {
            if (ItemTypeExtractionStrategy.isExactType(titleItemType)) {
                return titleItemType;
            }
            if ((titleItemType = ItemTypeExtractionStrategy.guessType(titleItemType)) != null) {
                itemType = titleItemType;
            }
        }
        if (qmdItemType != null) {
            if (ItemTypeExtractionStrategy.isExactType(qmdItemType)) {
                return qmdItemType;
            }
            if ((qmdItemType = ItemTypeExtractionStrategy.guessType(qmdItemType)) != null) {
                itemType = qmdItemType;
            }
        }
        log.debug((Object)("returning itemType: " + itemType));
        return itemType;
    }

    private static String guessType(String candidate) {
        String lower = candidate.toLowerCase();
        String itemType = ItemTypeExtractionStrategy.matchGuess(lower);
        return itemType;
    }

    private static String matchGuess(String toGuess) {
        String itemType = null;
        if (toGuess.indexOf("multiple") != -1 && toGuess.indexOf("response") != -1) {
            itemType = "Multiple Correct Answer";
        } else if (toGuess.indexOf("true") != -1 || toGuess.indexOf("tf") != -1) {
            itemType = "True False";
        } else if (toGuess.indexOf("matrix") != -1) {
            itemType = "Survey Matrix";
        } else if (toGuess.indexOf("survey") != -1) {
            itemType = "Multiple Choice Survey";
        } else if (toGuess.indexOf("single") != -1 && toGuess.indexOf("correct") != -1) {
            itemType = toGuess.indexOf("selection") != -1 ? "Multiple Correct Single Selection" : "Multiple Choice";
        } else if (toGuess.indexOf("multiple") != -1 && toGuess.indexOf("correct") != -1) {
            itemType = "Multiple Correct Answer";
        } else if (toGuess.indexOf("audio") != -1 || toGuess.indexOf("recording") != -1) {
            itemType = "Audio Recording";
        } else if (toGuess.indexOf("file") != -1 || toGuess.indexOf("upload") != -1) {
            itemType = "File Upload";
        } else if (toGuess.indexOf("extended") != -1 && toGuess.indexOf("matching") != -1) {
            itemType = "Extended Matching Items";
        } else if (toGuess.indexOf("match") != -1) {
            itemType = "Matching";
        } else if (toGuess.indexOf("fib") != -1 || toGuess.indexOf("fill") != -1 || toGuess.indexOf("f.i.b.") != -1) {
            itemType = "Fill In the Blank";
        } else if (toGuess.indexOf("numerical") != -1 || toGuess.indexOf("calculate") != -1 && toGuess.indexOf("question") == -1 || toGuess.indexOf("math") != -1) {
            itemType = "Numeric Response";
        } else if (toGuess.indexOf("calcq") != -1 || toGuess.indexOf("c.q.") != -1 || toGuess.indexOf("cq") != -1 || toGuess.indexOf("calculate") != -1 && toGuess.indexOf("question") != -1) {
            itemType = "Calculated Question";
        } else if (toGuess.indexOf("imagmq") != -1 || toGuess.indexOf("im.q.") != -1 || toGuess.indexOf("imq") != -1) {
            itemType = "Image Map Question";
        } else if (toGuess.indexOf("essay") != -1 || toGuess.indexOf("short") != -1) {
            itemType = "Short Answers/Essay";
        }
        return itemType;
    }

    private static Long getType(String typeString) {
        Long type = ItemTypeExtractionStrategy.getValidType(typeString);
        if (type == null) {
            log.warn((Object)("Unable to set item type: '" + typeString + "'."));
            log.warn((Object)("guessing item type: '" + DEFAULT_TYPE + "'."));
            type = DEFAULT_TYPE;
        }
        return type;
    }

    private static boolean isExactType(String typeString) {
        return ItemTypeExtractionStrategy.getValidType(typeString) != null;
    }

    private static Long getValidType(String typeString) {
        Long type = null;
        String[] typeArray = AuthoringConstantStrings.itemTypes;
        for (int i = 0; i < typeArray.length; ++i) {
            if (!typeString.trim().equalsIgnoreCase(typeArray[i])) continue;
            type = i;
            break;
        }
        return type;
    }
}

