/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services.qti;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.qti.constants.QTIVersion;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringHelper;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;
import org.sakaiproject.tool.assessment.services.qti.QTIServiceException;
import org.sakaiproject.tool.assessment.shared.api.qti.QTIServiceAPI;
import org.w3c.dom.Document;

public class QTIService
implements QTIServiceAPI {
    private static Log log = LogFactory.getLog(QTIService.class);

    public AssessmentFacade createImportedAssessment(Document document, int qtiVersion) {
        this.testQtiVersion(qtiVersion);
        try {
            AuthoringHelper helper = new AuthoringHelper(qtiVersion);
            return helper.createImportedAssessment(document);
        }
        catch (Exception ex) {
            throw new QTIServiceException(ex);
        }
    }

    public AssessmentFacade createImportedAssessment(Document document, int qtiVersion, String unzipLocation, String templateId) {
        return this.createImportedAssessment(document, qtiVersion, unzipLocation, templateId, null);
    }

    public AssessmentFacade createImportedAssessment(Document document, int qtiVersion, String unzipLocation, String templateId, String siteId) {
        this.testQtiVersion(qtiVersion);
        try {
            AuthoringHelper helper = new AuthoringHelper(qtiVersion);
            return helper.createImportedAssessment(document, unzipLocation, templateId, siteId);
        }
        catch (Exception ex) {
            throw new QTIServiceException(ex);
        }
    }

    public AssessmentFacade createImportedAssessment(Document document, int qtiVersion, String unzipLocation) {
        return this.createImportedAssessment(document, qtiVersion, unzipLocation, false, null);
    }

    public AssessmentFacade createImportedAssessment(Document document, int qtiVersion, String unzipLocation, boolean isRespondus, ArrayList failedMatchingQuestions) {
        this.testQtiVersion(qtiVersion);
        try {
            AuthoringHelper helper = new AuthoringHelper(qtiVersion);
            return helper.createImportedAssessment(document, unzipLocation, isRespondus, failedMatchingQuestions);
        }
        catch (Exception ex) {
            throw new QTIServiceException(ex);
        }
    }

    public AssessmentFacade createImportedAssessment(String documentPath, int qtiVersion, String siteId) {
        try {
            return this.createImportedAssessment(XmlUtil.readDocument(documentPath, true), qtiVersion, null, null, siteId);
        }
        catch (Exception e) {
            throw new QTIServiceException(e);
        }
    }

    public QuestionPoolFacade createImportedQuestionPool(Document document, int qtiVersion) {
        this.testQtiVersion(qtiVersion);
        try {
            AuthoringHelper helper = new AuthoringHelper(qtiVersion);
            return helper.createImportedQuestionPool(document);
        }
        catch (Exception ex) {
            throw new QTIServiceException(ex);
        }
    }

    public ItemFacade createImportedItem(Document document, int qtiVersion) {
        this.testQtiVersion(qtiVersion);
        try {
            AuthoringHelper helper = new AuthoringHelper(qtiVersion);
            return helper.createImportedItem(document);
        }
        catch (Exception ex) {
            throw new QTIServiceException(ex);
        }
    }

    public Document getExportedAssessment(String assessmentId, int qtiVersion) {
        this.testQtiVersion(qtiVersion);
        try {
            AuthoringHelper helper = new AuthoringHelper(qtiVersion);
            return helper.getAssessment(assessmentId);
        }
        catch (Exception ex) {
            throw new QTIServiceException(ex);
        }
    }

    public String getExportedAssessmentAsString(String assessmentId, int qtiVersion) {
        return XmlUtil.getDOMString(this.getExportedAssessment(assessmentId, qtiVersion));
    }

    public Document getExportedItem(String itemId, int qtiVersion) {
        this.testQtiVersion(qtiVersion);
        try {
            AuthoringHelper helper = new AuthoringHelper(qtiVersion);
            return helper.getItem(itemId);
        }
        catch (Exception ex) {
            throw new QTIServiceException(ex);
        }
    }

    public Document getExportedItemBank(String[] itemIds, int qtiVersion) {
        this.testQtiVersion(qtiVersion);
        try {
            AuthoringHelper helper = new AuthoringHelper(qtiVersion);
            return helper.getItemBank(itemIds);
        }
        catch (Exception ex) {
            throw new QTIServiceException(ex);
        }
    }

    private void testQtiVersion(int qtiVersion) {
        if (!QTIVersion.isValid((int)qtiVersion)) {
            throw new QTIServiceException(new IllegalArgumentException("NOT Legal Qti Version."));
        }
    }
}

