/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AuthoringXml {
    private static Logger log = LoggerFactory.getLogger(AuthoringXml.class);
    public static final String SETTINGS_FILE = "SAM.properties";
    public static final String TEMPLATE_PATH = "xml/author/";
    public static final String SURVEY_PATH = "survey/";
    public static final String ASSESSMENT = "assessmentTemplate.xml";
    public static final String SECTION = "sectionTemplate.xml";
    public static final String ITEM_AUDIO = "audioRecordingTemplate.xml";
    public static final String ITEM_ESSAY = "essayTemplate.xml";
    public static final String ITEM_FIB = "fibTemplate.xml";
    public static final String ITEM_FIN = "finTemplate.xml";
    public static final String ITEM_FILE = "fileUploadTemplate.xml";
    public static final String ITEM_MATCH = "matchTemplate.xml";
    public static final String ITEM_MCMC = "mcMCTemplate.xml";
    public static final String ITEM_MCMC_SS = "mcMCSSTemplate.xml";
    public static final String ITEM_MCSC = "mcSCTemplate.xml";
    public static final String ITEM_SURVEY = "mcSurveyTemplate.xml";
    public static final String ITEM_TF = "trueFalseTemplate.xml";
    public static final String ITEM_MATCHING = "matchTemplate.xml";
    public static final String ITEM_MXSURVEY = "mxSurveyTemplate.xml";
    public static final String ITEM_CALCQ = "calculatedQuestionTemplate.xml";
    public static final String ITEM_IMAGMQ = "imageMapTemplate.xml";
    public static final String ITEM_EMI = "emiTemplate.xml";
    public static final String SURVEY_10 = "survey/10.xml";
    public static final String SURVEY_5 = "survey/5.xml";
    public static final String SURVEY_AGREE = "survey/AGREE.xml";
    public static final String SURVEY_AVERAGE = "survey/AVERAGE.xml";
    public static final String SURVEY_EXCELLENT = "survey/EXCELLENT.xml";
    public static final String SURVEY_STRONGLY = "survey/STRONGLY_AGREE.xml";
    public static final String SURVEY_UNDECIDED = "survey/UNDECIDED.xml";
    public static final String SURVEY_YES = "survey/YES.xml";
    private static final String QTI_12_PATH = "v1p2";
    private static final String QTI_20_PATH = "v2p0";
    public Map validTemplates = null;
    private int qtiVersion;
    private String qtiPath;

    public AuthoringXml(int qtiVersion) {
        this.qtiVersion = qtiVersion;
        if (qtiVersion == 1) {
            this.qtiPath = QTI_12_PATH;
        } else if (qtiVersion == 2) {
            this.qtiPath = QTI_20_PATH;
        } else {
            throw new IllegalArgumentException("Unsupported qti version");
        }
    }

    public boolean valid(String s) {
        return this.validTemplates.containsKey(s);
    }

    public InputStream getTemplateInputStream(String templateName) {
        InputStream is = null;
        try {
            ClassPathResource resource = new ClassPathResource(TEMPLATE_PATH + this.qtiPath + "/" + templateName);
            is = resource.getInputStream();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return is;
    }

    public String getTemplateAsString(InputStream templateStream) {
        String xmlString = null;
        try {
            int c;
            InputStreamReader reader = new InputStreamReader(templateStream);
            StringWriter out = new StringWriter();
            while ((c = reader.read()) != -1) {
                out.write(c);
            }
            reader.close();
            xmlString = out.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return xmlString;
    }

    public boolean isAssessment(String documentType) {
        return ASSESSMENT.equals(documentType);
    }

    public boolean isSection(String documentType) {
        return SECTION.equals(documentType);
    }

    public boolean isItem(String documentType) {
        return documentType.startsWith("ITEM_");
    }

    public boolean isSurveyFragment(String documentType) {
        return documentType.startsWith("SURVEY_");
    }

    public Document update(Document document, String xpath, Element element) {
        if (log.isDebugEnabled()) {
            log.debug("update(String " + xpath + ", Element " + element + ")");
        }
        List itemResults = this.selectNodes(document, xpath);
        for (Element node : itemResults) {
            Element replacement = (Element)node.getOwnerDocument().importNode(element, true);
            node.getParentNode().replaceChild(replacement, node);
        }
        if (itemResults.size() == 0) {
            String parentPath = xpath.substring(0, xpath.lastIndexOf("/"));
            this.addElement(document, parentPath, element);
        }
        return document;
    }

    public Document update(Document document, String xpath, String value) throws DOMException, Exception {
        if (log.isDebugEnabled()) {
            log.debug("update(String " + xpath + ", String " + value + ")");
        }
        try {
            Element newElement = null;
            Attr newAttribute = null;
            List newElementList = this.selectNodes(document, xpath);
            int aIndex = xpath.indexOf("@");
            int size = newElementList.size();
            if (size > 1) {
                log.warn("UPDATING MORE THAN ONE ELEMENT");
            }
            if (aIndex == -1 && size != 0) {
                for (int i = 0; i < size; ++i) {
                    newElement = (Element)newElementList.get(i);
                    Node childNode = newElement.getFirstChild();
                    if (childNode == null) {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document core = db.newDocument();
                        Text newElementText = core.createTextNode(newElement.getNodeName());
                        newElementText.setNodeValue(value);
                        Text clonedText = (Text)newElement.getOwnerDocument().importNode(newElementText, true);
                        newElement.appendChild(clonedText);
                        continue;
                    }
                    CharacterData newElementText = (CharacterData)newElement.getFirstChild();
                    newElementText.setNodeValue(value);
                }
            }
            if (aIndex != -1 && size != 0 && (newAttribute = (Attr)newElementList.set(0, null)) != null) {
                newAttribute.setValue(value);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return document;
    }

    public Document addElement(Document document, String parentXpath, Element element) {
        if (log.isDebugEnabled()) {
            log.debug("addElement(String " + parentXpath + ", Element " + element + ")");
        }
        List nodes = this.selectNodes(document, parentXpath);
        for (Element parent : nodes) {
            if (!parent.getOwnerDocument().equals(element.getOwnerDocument())) {
                element = (Element)parent.getOwnerDocument().importNode(element, true);
            }
            parent.insertBefore(element, null);
        }
        return document;
    }

    public Document addAttribute(Document document, String elementXpath, String attributeName) {
        if (log.isDebugEnabled()) {
            log.debug("addAttribute(String " + elementXpath + ", String" + attributeName + ")");
        }
        List nodes = this.selectNodes(document, elementXpath);
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)nodes.get(i);
            element.setAttribute(attributeName, "");
        }
        return document;
    }

    public final List selectNodes(Document document, String xpath) {
        if (log.isDebugEnabled()) {
            log.debug("selectNodes(String " + xpath + ")");
        }
        List result = new ArrayList();
        try {
            DOMXPath path = new DOMXPath(xpath);
            result = path.selectNodes((Object)document);
        }
        catch (JaxenException je) {
            log.error(je.getMessage(), (Throwable)je);
        }
        return result;
    }

    public Document readXMLDocument(InputStream inputStream) {
        if (log.isDebugEnabled()) {
            log.debug("readDocument(InputStream " + inputStream);
        }
        Document document = null;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            document = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return document;
    }

    public static Document readDocumentFromString(String in) {
        try {
            DocumentBuilder docBuilder = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            docBuilder = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(in));
            Document doc = docBuilder.parse(inputSource);
            return doc;
        }
        catch (Exception any) {
            log.warn("Xml.readDocumentFromString: " + any.toString());
            return null;
        }
    }

    public int getQtiVersion() {
        return this.qtiVersion;
    }

    public void setQtiVersion(int qtiVersion) {
        this.qtiVersion = qtiVersion;
    }

    public String getQtiPath() {
        return this.qtiPath;
    }

    public void setQtiPath(String qtiPath) {
        this.qtiPath = qtiPath;
    }
}

