/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper.assessment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.sakaiproject.tool.assessment.data.dao.assessment.AttachmentData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SecuredIPAddressIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.qti.asi.Assessment;
import org.sakaiproject.tool.assessment.qti.asi.Section;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringHelper;
import org.sakaiproject.tool.assessment.qti.helper.assessment.AssessmentHelperIfc;
import org.sakaiproject.tool.assessment.qti.util.Iso8601DateFormat;
import org.sakaiproject.tool.assessment.qti.util.Iso8601TimeInterval;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AssessmentHelperBase
implements AssessmentHelperIfc {
    private static Logger log = LoggerFactory.getLogger(AssessmentHelperBase.class);

    protected abstract int getQtiVersion();

    @Override
    public Assessment readXMLDocument(InputStream inputStream) {
        if (log.isDebugEnabled()) {
            log.debug("readDocument(InputStream " + inputStream);
        }
        Assessment assessXml = null;
        try {
            AuthoringHelper authoringHelper = new AuthoringHelper(this.getQtiVersion());
            assessXml = new Assessment(authoringHelper.readXMLDocument(inputStream).getDocument());
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return assessXml;
    }

    @Override
    public void updateFeedbackModel(Assessment assessmentXml, AssessmentFeedbackIfc feedback) {
        Integer feedbackDelivery = feedback.getFeedbackDelivery();
        if (AssessmentFeedbackIfc.FEEDBACK_BY_DATE.equals(feedbackDelivery)) {
            assessmentXml.setFieldentry("FEEDBACK_DELIVERY", "DATED");
        } else if (AssessmentFeedbackIfc.IMMEDIATE_FEEDBACK.equals(feedbackDelivery)) {
            assessmentXml.setFieldentry("FEEDBACK_DELIVERY", "IMMEDIATE");
        } else if (AssessmentFeedbackIfc.FEEDBACK_ON_SUBMISSION.equals(feedbackDelivery)) {
            assessmentXml.setFieldentry("FEEDBACK_DELIVERY", "ON_SUBMISSION");
        } else {
            assessmentXml.setFieldentry("FEEDBACK_DELIVERY", "NONE");
        }
        Integer feedbackComponentOption = feedback.getFeedbackComponentOption();
        if (AssessmentFeedbackIfc.SELECT_COMPONENTS.equals(feedbackComponentOption)) {
            assessmentXml.setFieldentry("FEEDBACK_COMPONENT_OPTION", "SELECT_COMPONENTS");
        } else {
            assessmentXml.setFieldentry("FEEDBACK_COMPONENT_OPTION", "SHOW_TOTALSCORE_ONLY");
        }
        Integer feedbackAuthoring = feedback.getFeedbackAuthoring();
        if (AssessmentFeedbackIfc.QUESTIONLEVEL_FEEDBACK.equals(feedbackAuthoring)) {
            assessmentXml.setFieldentry("FEEDBACK_AUTHORING", "QUESTION");
        } else if (AssessmentFeedbackIfc.SECTIONLEVEL_FEEDBACK.equals(feedbackAuthoring)) {
            assessmentXml.setFieldentry("FEEDBACK_AUTHORING", "SECTION");
        } else {
            assessmentXml.setFieldentry("FEEDBACK_AUTHORING", "BOTH");
        }
        assessmentXml.setFieldentry("FEEDBACK_SHOW_QUESTION", this.qtiBooleanString(feedback.getShowQuestionText()));
        assessmentXml.setFieldentry("FEEDBACK_SHOW_RESPONSE", this.qtiBooleanString(feedback.getShowStudentResponse()));
        assessmentXml.setFieldentry("FEEDBACK_SHOW_CORRECT_RESPONSE", this.qtiBooleanString(feedback.getShowCorrectResponse()));
        assessmentXml.setFieldentry("FEEDBACK_SHOW_STUDENT_SCORE", this.qtiBooleanString(feedback.getShowStudentScore()));
        assessmentXml.setFieldentry("FEEDBACK_SHOW_STUDENT_QUESTIONSCORE", this.qtiBooleanString(feedback.getShowStudentQuestionScore()));
        assessmentXml.setFieldentry("FEEDBACK_SHOW_ITEM_LEVEL", this.qtiBooleanString(feedback.getShowQuestionLevelFeedback()));
        assessmentXml.setFieldentry("FEEDBACK_SHOW_SELECTION_LEVEL", this.qtiBooleanString(feedback.getShowSelectionLevelFeedback()));
        assessmentXml.setFieldentry("FEEDBACK_SHOW_GRADER_COMMENT", this.qtiBooleanString(feedback.getShowGraderComments()));
        assessmentXml.setFieldentry("FEEDBACK_SHOW_STATS", this.qtiBooleanString(feedback.getShowStatistics()));
    }

    @Override
    public void updateEvaluationModel(Assessment assessmentXml, EvaluationModelIfc evaluationModel) {
        log.debug("EvaluationModelIfc.ANONYMOUS_GRADING: " + EvaluationModelIfc.ANONYMOUS_GRADING);
        log.debug("evaluationModel.getAnonymousGrading(): " + evaluationModel.getAnonymousGrading());
        log.debug("EvaluationModelIfc.TO_SELECTED_GRADEBOOK.toString(): " + EvaluationModelIfc.TO_SELECTED_GRADEBOOK.toString());
        log.debug("evaluationModel.getToGradeBook(): " + evaluationModel.getToGradeBook());
        log.debug("EvaluationModelIfc.HIGHEST_SCORE: " + EvaluationModelIfc.HIGHEST_SCORE);
        log.debug("evaluationModel.getScoringType(): " + evaluationModel.getScoringType());
        if (EvaluationModelIfc.ANONYMOUS_GRADING.equals(evaluationModel.getAnonymousGrading())) {
            assessmentXml.setFieldentry("ANONYMOUS_GRADING", "True");
        } else {
            assessmentXml.setFieldentry("ANONYMOUS_GRADING", "False");
        }
        if (EvaluationModelIfc.TO_SELECTED_GRADEBOOK.toString().equals(evaluationModel.getToGradeBook())) {
            assessmentXml.setFieldentry("GRADEBOOK_OPTIONS", "SELECTED");
        } else if (EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString().equals(evaluationModel.getToGradeBook())) {
            assessmentXml.setFieldentry("GRADEBOOK_OPTIONS", "DEFAULT");
        }
        if (EvaluationModelIfc.NOT_TO_GRADEBOOK.toString().equals(evaluationModel.getToGradeBook())) {
            assessmentXml.setFieldentry("GRADEBOOK_OPTIONS", "NONE");
        }
        if (EvaluationModelIfc.HIGHEST_SCORE.equals(evaluationModel.getScoringType())) {
            assessmentXml.setFieldentry("GRADE_SCORE", "HIGHEST_SCORE");
        } else if (EvaluationModelIfc.AVERAGE_SCORE.equals(evaluationModel.getScoringType())) {
            assessmentXml.setFieldentry("GRADE_SCORE", "AVERAGE_SCORE");
        } else if (EvaluationModelIfc.LAST_SCORE.equals(evaluationModel.getScoringType())) {
            assessmentXml.setFieldentry("GRADE_SCORE", "LAST_SCORE");
        }
    }

    @Override
    public void setDescriptiveText(String description, Assessment assessmentXml) {
        String xpath = "questestinterop/assessment/presentation_material/flow_mat/material/mattext";
        List list = assessmentXml.selectNodes(xpath);
        try {
            if (description == null) {
                log.debug("description is null");
                description = "";
            }
            description = XmlUtil.convertStrforCDATA(description);
            assessmentXml.update(xpath, description);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void updateAccessControl(Assessment assessmentXml, AssessmentAccessControlIfc accessControl) {
        Date dueDate = accessControl.getDueDate();
        Date startDate = accessControl.getStartDate();
        Date scoreDate = accessControl.getScoreDate();
        Date restractDate = accessControl.getRetractDate();
        Date feedbackDate = accessControl.getFeedbackDate();
        assessmentXml.setFieldentry("END_DATE", this.formatDate(dueDate));
        assessmentXml.setFieldentry("FEEDBACK_DELIVERY_DATE", this.formatDate(feedbackDate));
        assessmentXml.setFieldentry("RETRACT_DATE", this.formatDate(restractDate));
        assessmentXml.setFieldentry("START_DATE", this.formatDate(startDate));
        Integer submissionsAllowed = accessControl.getSubmissionsAllowed();
        Boolean unlimitedSubmissions = accessControl.getUnlimitedSubmissions();
        boolean unlimited = false;
        if (unlimitedSubmissions != null) {
            unlimited = unlimitedSubmissions;
        }
        if (unlimited) {
            submissionsAllowed = AssessmentAccessControlIfc.UNLIMITED_SUBMISSIONS_ALLOWED;
        }
        assessmentXml.setFieldentry("MAX_ATTEMPTS", submissionsAllowed.toString());
        Integer autoSubmit = accessControl.getAutoSubmit();
        Integer bookmarking = accessControl.getBookMarkingItem();
        Integer itemNavigation = accessControl.getItemNavigation();
        Integer itemNumbering = accessControl.getItemNumbering();
        Integer displayScores = accessControl.getDisplayScoreDuringAssessments();
        Integer assessmentFormat = accessControl.getAssessmentFormat();
        Integer markForReview = accessControl.getMarkForReview();
        Integer lateHandling = accessControl.getLateHandling();
        Integer retryAllowed = accessControl.getRetryAllowed();
        Integer submissionsSaved = accessControl.getSubmissionsSaved();
        Integer timeLimit = accessControl.getTimeLimit();
        String submissionMessage = accessControl.getSubmissionMessage();
        String finalPageUrl = accessControl.getFinalPageUrl();
        String password = accessControl.getPassword();
        String releaseTo = accessControl.getReleaseTo();
        assessmentXml.setFieldentry("AUTO_SUBMIT", this.qtiBooleanString(autoSubmit));
        if (timeLimit != null && timeLimit != 0) {
            this.setDuration(timeLimit, assessmentXml);
        }
        if (submissionMessage != null) {
            String wrappedSubmissionMessage = XmlUtil.convertStrforCDATA(submissionMessage);
            assessmentXml.setFieldentry("SUBMISSION_MESSAGE", wrappedSubmissionMessage, true);
        }
        if (finalPageUrl != null) {
            assessmentXml.setFieldentry("FINISH_URL", finalPageUrl);
        }
        if (AssessmentAccessControlIfc.BY_QUESTION.equals(assessmentFormat)) {
            assessmentXml.setFieldentry("QUESTION_LAYOUT", "I");
        } else if (AssessmentAccessControlIfc.BY_PART.equals(assessmentFormat)) {
            assessmentXml.setFieldentry("QUESTION_LAYOUT", "S");
        } else if (AssessmentAccessControlIfc.BY_ASSESSMENT.equals(assessmentFormat)) {
            assessmentXml.setFieldentry("QUESTION_LAYOUT", "A");
        }
        if (AssessmentAccessControlIfc.LINEAR_ACCESS.equals(itemNavigation)) {
            assessmentXml.setFieldentry("NAVIGATION", "LINEAR");
        } else if (AssessmentAccessControlIfc.RANDOM_ACCESS.equals(itemNavigation)) {
            assessmentXml.setFieldentry("NAVIGATION", "RANDOM");
        }
        if (AssessmentAccessControlIfc.CONTINUOUS_NUMBERING.equals(itemNumbering)) {
            assessmentXml.setFieldentry("QUESTION_NUMBERING", "CONTINUOUS");
        } else if (AssessmentAccessControlIfc.RESTART_NUMBERING_BY_PART.equals(itemNumbering)) {
            assessmentXml.setFieldentry("QUESTION_NUMBERING", "RESTART");
        }
        if (AssessmentAccessControlIfc.HIDE_ITEM_SCORE_DURING_ASSESSMENT.equals(displayScores)) {
            assessmentXml.setFieldentry("DISPLAY_SCORES", "HIDE");
        } else {
            assessmentXml.setFieldentry("DISPLAY_SCORES", "SHOW");
        }
        if (AssessmentAccessControlIfc.MARK_FOR_REVIEW.equals(markForReview)) {
            assessmentXml.setFieldentry("MARK_FOR_REVIEW", "True");
        } else if (AssessmentAccessControlIfc.NOT_MARK_FOR_REVIEW.equals(markForReview)) {
            assessmentXml.setFieldentry("MARK_FOR_REVIEW", "False");
        }
        if (AssessmentAccessControlIfc.ACCEPT_LATE_SUBMISSION.equals(lateHandling)) {
            assessmentXml.setFieldentry("LATE_HANDLING", "True");
        } else if (AssessmentAccessControlIfc.NOT_ACCEPT_LATE_SUBMISSION.equals(lateHandling)) {
            assessmentXml.setFieldentry("LATE_HANDLING", "False");
        }
        if (password != null) {
            assessmentXml.setFieldentry("PASSWORD", password);
        }
        if (releaseTo != null) {
            assessmentXml.setFieldentry("ASSESSMENT_RELEASED_TO", releaseTo);
        }
    }

    @Override
    public void updateIPAddressSet(Assessment assessmentXml, Set securedIPAddressSet) {
        if (securedIPAddressSet == null || securedIPAddressSet.size() == 0) {
            return;
        }
        Iterator iter = securedIPAddressSet.iterator();
        StringBuilder ipAddressesbuf = new StringBuilder();
        while (iter.hasNext()) {
            SecuredIPAddressIfc sip = (SecuredIPAddressIfc)iter.next();
            String ipAddress = sip.getIpAddress();
            ipAddressesbuf.append(ipAddress + "\n");
        }
        String ipAddresses = ipAddressesbuf.toString();
        assessmentXml.setFieldentry("ALLOW_IP", ipAddresses);
    }

    @Override
    public void updateAttachmentSet(Assessment assessmentXml, Set attachmentSet) {
        Iterator iter = attachmentSet.iterator();
        AttachmentData attachmentData = null;
        StringBuffer attachment = new StringBuffer();
        while (iter.hasNext()) {
            attachmentData = (AttachmentData)iter.next();
            attachment.append(attachmentData.getResourceId().replaceAll(" ", ""));
            attachment.append("|");
            attachment.append(attachmentData.getFilename());
            attachment.append("|");
            attachment.append(attachmentData.getMimeType());
            attachment.append("\n");
        }
        assessmentXml.setFieldentry("ATTACHMENT", attachment.toString());
    }

    @Override
    public void updateMetaData(Assessment assessmentXml, AssessmentFacade assessment) {
        String[] editKeys = new String[]{"templateInfo_isInstructorEditable", "assessmentAuthor_isInstructorEditable", "assessmentCreator_isInstructorEditable", "description_isInstructorEditable", "dueDate_isInstructorEditable", "retractDate_isInstructorEditable", "anonymousRelease_isInstructorEditable", "authenticatedRelease_isInstructorEditable", "ipAccessType_isInstructorEditable", "passwordRequired_isInstructorEditable", "lockedBrowser_isInstructorEditable", "timedAssessment_isInstructorEditable", "timedAssessmentAutoSubmit_isInstructorEditable", "itemAccessType_isInstructorEditable", "displayChunking_isInstructorEditable", "displayNumbering_isInstructorEditable", "displayScores_isInstructorEditable", "submissionModel_isInstructorEditable", "lateHandling_isInstructorEditable", "markForReview_isInstructorEditable", "automaticSubmission_isInstructorEditable", "autoSave_isInstructorEditable", "submissionMessage_isInstructorEditable", "finalPageURL_isInstructorEditable", "feedbackType_isInstructorEditable", "feedbackAuthoring_isInstructorEditable", "feedbackComponents_isInstructorEditable", "testeeIdentity_isInstructorEditable", "toGradebook_isInstructorEditable", "recordedScore_isInstructorEditable", "bgColor_isInstructorEditable", "bgImage_isInstructorEditable", "metadataAssess_isInstructorEditable", "metadataParts_isInstructorEditable", "metadataQuestions_isInstructorEditable", "honorpledge_isInstructorEditable"};
        for (int i = 0; i < editKeys.length; ++i) {
            this.setField(assessmentXml, assessment, editKeys[i]);
        }
        this.setField(assessmentXml, assessment, "hasMetaDataForQuestions", "COLLECT_ITEM_METADATA");
    }

    private void setField(Assessment assessmentXml, AssessmentFacade assessment, String key, String translationKey) {
        String value = assessment.getAssessmentMetaDataByLabel(key);
        log.debug("setField(Assessment assessmentXml, AssessmentFacade assessment, String key, String translationKey)");
        log.debug("key: " + key);
        log.debug("value: " + value);
        if (value == null) {
            assessmentXml.setFieldentry(translationKey, "false");
            return;
        }
        assessmentXml.setFieldentry(translationKey, value);
    }

    private void setField(Assessment assessmentXml, AssessmentFacade assessment, String key) {
        this.setField(assessmentXml, assessment, key, key);
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        Iso8601DateFormat iso = new Iso8601DateFormat();
        return iso.format(date);
    }

    public String qtiBooleanString(Boolean b) {
        if (b != null && b.booleanValue()) {
            return "True";
        }
        return "False";
    }

    public String qtiBooleanString(Integer i) {
        if (i != null && i != 0) {
            return "True";
        }
        return "False";
    }

    public Section getSectionByTitle(Assessment assessment, String sectionTitle) {
        if (log.isDebugEnabled()) {
            log.debug("getSectionByTitle( )");
        }
        Section sectionXml = null;
        Collection secs = assessment.getSections();
        if (secs == null) {
            return sectionXml;
        }
        Iterator iter = secs.iterator();
        if (secs != null && secs.size() > 0 && sectionTitle != null) {
            for (int i = 0; i < secs.size(); ++i) {
                String title;
                while (iter.hasNext() && ((title = (sectionXml = (Section)iter.next()).selectSingleValue("section/@title", "attribute")) == null || !title.equals(sectionTitle))) {
                }
            }
        }
        return sectionXml;
    }

    public void setDuration(Integer duration, Assessment assessmentXml) {
        String xpath = "questestinterop/assessment/duration";
        List list = assessmentXml.selectNodes(xpath);
        try {
            Iso8601TimeInterval isoTime = new Iso8601TimeInterval(1000L * duration.longValue());
            assessmentXml.update(xpath, isoTime.toString());
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

