/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper.section;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.sakaiproject.tool.assessment.qti.asi.Section;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringHelper;
import org.sakaiproject.tool.assessment.qti.helper.section.SectionHelperIfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class SectionHelperBase
implements SectionHelperIfc {
    private static Logger log = LoggerFactory.getLogger(SectionHelperBase.class);
    private Document doc;

    protected abstract int getQtiVersion();

    @Override
    public Section readXMLDocument(InputStream inputStream) {
        if (log.isDebugEnabled()) {
            log.debug("readDocument(InputStream " + inputStream);
        }
        Section sectionXml = null;
        try {
            AuthoringHelper authoringHelper = new AuthoringHelper(this.getQtiVersion());
            sectionXml = new Section(authoringHelper.readXMLDocument(inputStream).getDocument(), this.getQtiVersion());
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sectionXml;
    }

    @Override
    public Section updateSectionXml(Section sectionXml, String xpath, String value) {
        if (log.isDebugEnabled()) {
            log.debug("updateSectionXml(Item " + sectionXml + ", String" + xpath + ", String" + value + ")");
        }
        try {
            sectionXml.update(xpath, value);
        }
        catch (DOMException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sectionXml;
    }
}

