/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.util;

import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sakaiproject.tool.assessment.qti.exception.Iso8601FormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iso8601TimeInterval {
    private static Logger log = LoggerFactory.getLogger(Iso8601TimeInterval.class);
    private static final long SECONDS = 1000L;
    private static final long MINUTES = 60000L;
    private static final long HOURS = 3600000L;
    private static final long DAYS = 86400000L;
    private static final long WEEKS = 604800000L;
    private static final long MONTHS = 2592000000L;
    private static final long YEARS = 31536000000L;
    private static final Pattern PATTERN = Pattern.compile("-?P(?:(\\d*)Y)?(?:(\\d*)M)?(?:(\\d*)W)?(?:(\\d*)D)?T?(?:(\\d*)H)?(?:(\\d*)M)?(?:(\\d*)S)?");
    private boolean bounded = false;
    private boolean recurring = false;
    private String iso8601TimeInterval;
    private Long duration;
    private Calendar begin;
    private Calendar end;
    private Integer years;
    private Integer months;
    private Integer weeks;
    private Integer days;
    private Integer hours;
    private Integer minutes;
    private Integer seconds;
    private boolean negative = false;

    public Iso8601TimeInterval(String iso8601TimeInterval) throws Iso8601FormatException {
        if (log.isDebugEnabled()) {
            log.debug("new TimeInterval(String " + iso8601TimeInterval + ")");
        }
        this.iso8601TimeInterval = iso8601TimeInterval;
        this.duration = this.parseLong(iso8601TimeInterval);
    }

    public Iso8601TimeInterval(long ms) {
        if (log.isDebugEnabled()) {
            log.debug("new Iso8601TimeInterval(long " + ms + ")");
        }
        this.duration = ms;
    }

    private long parseLong(String iso8601TimeInterval) throws Iso8601FormatException {
        if (log.isDebugEnabled()) {
            log.debug("parseLong(String " + iso8601TimeInterval + ")");
        }
        if (iso8601TimeInterval == null) {
            throw new Iso8601FormatException("illegal String iso8601TimeInterval argument:  iso8601TimeInterval ==null");
        }
        Matcher matcher = PATTERN.matcher(iso8601TimeInterval = iso8601TimeInterval.toUpperCase());
        if (matcher.matches()) {
            if (iso8601TimeInterval.indexOf("-") == 0) {
                log.debug("negative = true");
                this.negative = true;
            }
            if (log.isDebugEnabled()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    log.debug("matcher.group(" + i + ")=" + matcher.group(i));
                }
            }
            String tmp = null;
            int years = 0;
            tmp = matcher.group(1);
            if (tmp != null) {
                years = Integer.parseInt(tmp);
                this.years = new Integer(tmp);
            }
            int months = 0;
            tmp = matcher.group(2);
            if (tmp != null) {
                this.months = new Integer(tmp);
                months = this.months;
            }
            int weeks = 0;
            tmp = matcher.group(3);
            if (tmp != null) {
                this.weeks = new Integer(tmp);
                weeks = this.weeks;
            }
            int days = 0;
            tmp = matcher.group(4);
            if (tmp != null) {
                this.days = new Integer(tmp);
                days = this.days;
            }
            int hours = 0;
            tmp = matcher.group(5);
            if (tmp != null) {
                this.hours = new Integer(tmp);
                hours = this.hours;
            }
            int minutes = 0;
            tmp = matcher.group(6);
            if (tmp != null) {
                this.minutes = new Integer(tmp);
                minutes = this.minutes;
            }
            int seconds = 0;
            tmp = matcher.group(7);
            if (tmp != null) {
                this.seconds = new Integer(tmp);
                seconds = this.seconds;
            }
            if (log.isDebugEnabled()) {
                log.debug("years=" + years + ", months=" + months + ", weeks=" + weeks + ", days=" + days + ", hours=" + hours + ", minutes=" + minutes + ", seconds=" + seconds);
            }
            long durtmp = (long)years * 31536000000L + (long)months * 2592000000L + (long)weeks * 604800000L + (long)days * 86400000L + (long)hours * 3600000L + (long)minutes * 60000L + (long)seconds * 1000L;
            if (this.negative) {
                return -durtmp;
            }
            return durtmp;
        }
        throw new Iso8601FormatException("Invalid ISO8601 format: " + iso8601TimeInterval);
    }

    public boolean isBounded() {
        log.debug("isBounded()");
        throw new UnsupportedOperationException();
    }

    public boolean isRecurring() {
        throw new UnsupportedOperationException();
    }

    public long getDuration() {
        log.debug("getDuration()");
        return this.duration;
    }

    public Calendar getBegin() {
        throw new UnsupportedOperationException();
    }

    public Calendar getEnd() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.iso8601TimeInterval == null) {
            this.createIso8601TimeInterval();
        }
        return this.iso8601TimeInterval;
    }

    public void createString() {
        log.debug("regenerateString()");
        this.reset();
        this.createIso8601TimeInterval();
    }

    private void createIso8601TimeInterval() {
        log.debug("createIso8601TimeInterval()");
        if (this.duration == null) {
            throw new IllegalStateException("duration is null!");
        }
        if (this.duration < 0L) {
            this.negative = true;
        }
        long remainder = this.duration;
        int weeks = (int)(remainder / 604800000L);
        int days = (int)((remainder %= 604800000L) / 86400000L);
        int hours = (int)((remainder %= 86400000L) / 3600000L);
        int minutes = (int)((remainder %= 3600000L) / 60000L);
        int seconds = (int)((remainder %= 60000L) / 1000L);
        StringBuilder sb = new StringBuilder();
        if (this.negative) {
            sb.append("-");
        }
        sb.append("P");
        if (weeks != 0) {
            if (this.negative) {
                sb.append(-weeks);
                this.weeks = -weeks;
            } else {
                sb.append(weeks);
                this.weeks = weeks;
            }
            sb.append("W");
        }
        if (days != 0) {
            if (this.negative) {
                sb.append(-days);
                this.days = -days;
            } else {
                sb.append(days);
                this.days = days;
            }
            sb.append("D");
        }
        if (hours != 0 || minutes != 0 || seconds != 0) {
            sb.append("T");
            if (hours != 0) {
                if (this.negative) {
                    sb.append(-hours);
                    this.hours = -hours;
                } else {
                    sb.append(hours);
                    this.hours = hours;
                }
                sb.append("H");
            }
            if (minutes != 0) {
                if (this.negative) {
                    sb.append(-minutes);
                    this.minutes = -minutes;
                } else {
                    sb.append(minutes);
                    this.minutes = minutes;
                }
                sb.append("M");
            }
            if (seconds != 0) {
                if (this.negative) {
                    sb.append(-seconds);
                    this.seconds = -seconds;
                } else {
                    sb.append(seconds);
                    this.seconds = seconds;
                }
                sb.append("S");
            }
        }
        this.iso8601TimeInterval = sb.toString();
    }

    public static void main(String[] args) {
        try {
            Iso8601TimeInterval ti = new Iso8601TimeInterval("-P2y10m15dT10H30M20S");
            long duration = ti.getDuration();
            log.debug("duration=" + duration);
            log.debug("weeks=" + ti.getWeeks());
            log.debug("days=" + ti.getDays());
            Iso8601TimeInterval t2 = new Iso8601TimeInterval(duration);
            log.debug("t2=" + t2);
            log.debug("t2.getWeeks()=" + t2.getWeeks());
            log.debug("t2.getHours()=" + t2.getHours());
        }
        catch (Iso8601FormatException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public Integer getDays() {
        return this.days;
    }

    public Integer getHours() {
        return this.hours;
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public Integer getMonths() {
        return this.months;
    }

    public Integer getSeconds() {
        return this.seconds;
    }

    public Integer getWeeks() {
        return this.weeks;
    }

    public Integer getYears() {
        return this.years;
    }

    public boolean isNegative() {
        return this.negative;
    }

    private void reset() {
        log.debug("reset()");
        this.years = null;
        this.months = null;
        this.weeks = null;
        this.days = null;
        this.hours = null;
        this.minutes = null;
        this.seconds = null;
        this.negative = false;
    }
}

