/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.cover.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentHelper {
    private static final Logger log = LoggerFactory.getLogger(AttachmentHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentResource createContentResource(String fullFilePath, String filename, String mimeType) {
        ContentResource contentResource = null;
        int BUFFER_SIZE = 2048;
        byte[] tempContent = new byte[BUFFER_SIZE];
        File file = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int count = 0;
        try {
            byte[] content;
            try {
                fullFilePath = URLDecoder.decode(fullFilePath, "UTF-8");
                filename = URLDecoder.decode(filename, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
            if (mimeType.equalsIgnoreCase("text/url")) {
                content = filename.getBytes();
                filename = filename.replaceAll("http://", "http:__");
            } else {
                file = new File(fullFilePath);
                fileInputStream = new FileInputStream(file);
                bufInputStream = new BufferedInputStream(fileInputStream);
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((count = bufInputStream.read(tempContent, 0, BUFFER_SIZE)) != -1) {
                    byteArrayOutputStream.write(tempContent, 0, count);
                }
                content = byteArrayOutputStream.toByteArray();
            }
            ResourcePropertiesEdit props = AssessmentService.getContentHostingService().newResourceProperties();
            contentResource = AssessmentService.getContentHostingService().addAttachmentResource(filename, ToolManager.getCurrentPlacement().getContext(), ToolManager.getTool((String)"sakai.samigo").getTitle(), mimeType, content, (ResourceProperties)props);
        }
        catch (IdInvalidException e) {
            log.error("IdInvalidException:" + e.getMessage());
        }
        catch (PermissionException e) {
            log.error("PermissionException:" + e.getMessage());
        }
        catch (InconsistentException e) {
            log.error("InconsistentException:" + e.getMessage());
        }
        catch (IdUsedException e) {
            log.error("IdUsedException:" + e.getMessage());
        }
        catch (OverQuotaException e) {
            log.error("OverQuotaException:" + e.getMessage());
        }
        catch (ServerOverloadException e) {
            log.error("ServerOverloadException:" + e.getMessage());
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException:" + e.getMessage());
        }
        catch (IOException e) {
            log.error("IOException:" + e.getMessage());
        }
        finally {
            if (bufInputStream != null) {
                try {
                    bufInputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return contentResource;
    }
}

