/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.questionpool.QuestionPoolItemIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.integration.helper.integrated.AgentHelperImpl;
import org.sakaiproject.tool.assessment.qti.asi.Assessment;
import org.sakaiproject.tool.assessment.qti.asi.Item;
import org.sakaiproject.tool.assessment.qti.asi.Section;
import org.sakaiproject.tool.assessment.qti.constants.QTIVersion;
import org.sakaiproject.tool.assessment.qti.exception.RespondusMatchingException;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringXml;
import org.sakaiproject.tool.assessment.qti.helper.ExtractionHelper;
import org.sakaiproject.tool.assessment.qti.helper.QTIHelperFactory;
import org.sakaiproject.tool.assessment.qti.helper.assessment.AssessmentHelperIfc;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperIfc;
import org.sakaiproject.tool.assessment.qti.helper.section.SectionHelperIfc;
import org.sakaiproject.tool.assessment.qti.util.XmlStringBuffer;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.util.TextFormat;
import org.sakaiproject.util.FormattedText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AuthoringHelper {
    private static final Logger log = LoggerFactory.getLogger(AuthoringHelper.class);
    private AuthoringXml ax;
    private int qtiVersion;
    private static final String VALIDATE_XSD_PATH = "xml/xsd/";

    private AuthoringHelper() {
    }

    public AuthoringHelper(int qtiVersion) {
        this.qtiVersion = qtiVersion;
        if (!QTIVersion.isValid((int)qtiVersion)) {
            throw new IllegalArgumentException("Version Codes supported: QTIVersion.VERSION_1_2, QTIVersion.VERSION_2_0");
        }
        this.ax = new AuthoringXml(qtiVersion);
    }

    public Document getAssessment(String assessmentId) {
        InputStream is = this.ax.getTemplateInputStream("assessmentTemplate.xml");
        return this.getAssessment(assessmentId, is);
    }

    public Document getAssessment(String assessmentId, InputStream is) {
        try {
            Set attachmentSet;
            Set securedIPAddressSet;
            AssessmentAccessControlIfc assessmentAccessControl;
            AssessmentFeedbackIfc assessmentFeedback;
            EvaluationModelIfc evaluationModel;
            AssessmentService assessmentService = new AssessmentService();
            QTIHelperFactory factory = new QTIHelperFactory();
            AssessmentFacade assessment = assessmentService.getAssessment(assessmentId);
            AssessmentHelperIfc assessmentHelper = factory.getAssessmentHelperInstance(this.qtiVersion);
            Assessment assessmentXml = assessmentHelper.readXMLDocument(is);
            assessmentXml.setIdent(assessmentId);
            assessmentXml.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessment.getTitle()));
            assessmentHelper.setDescriptiveText(assessment.getDescription(), assessmentXml);
            String authors = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_AUTHORS");
            String objectives = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_OBJECTIVES");
            String keywords = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_KEYWORDS");
            String rubrics = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_RUBRICS");
            String bgColor = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGCOLOR");
            String bgImage = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGIMAGE");
            if (authors != null) {
                assessmentXml.setFieldentry("AUTHORS", authors);
            } else {
                AgentHelperImpl helper = new AgentHelperImpl();
                String createdBy = assessment.getCreatedBy();
                String eid = helper.getEidById(createdBy);
                if (eid != null) {
                    assessmentXml.setFieldentry("AUTHORS", eid);
                } else {
                    log.debug("\n\nNO AUTHORS");
                }
            }
            if (objectives != null) {
                assessmentXml.setFieldentry("ASSESSMENT_OBJECTIVES", objectives);
            }
            if (keywords != null) {
                assessmentXml.setFieldentry("ASSESSMENT_KEYWORDS", keywords);
            }
            if (rubrics != null) {
                assessmentXml.setFieldentry("ASSESSMENT_RUBRICS", rubrics);
            }
            if (bgColor != null) {
                assessmentXml.setFieldentry("BGCOLOR", bgColor);
            }
            if (bgImage != null) {
                assessmentXml.setFieldentry("BGIMG", bgImage);
            }
            if ((evaluationModel = assessment.getEvaluationModel()) != null) {
                assessmentHelper.updateEvaluationModel(assessmentXml, evaluationModel);
            }
            if ((assessmentFeedback = assessment.getAssessmentFeedback()) != null) {
                assessmentHelper.updateFeedbackModel(assessmentXml, assessmentFeedback);
            }
            if ((assessmentAccessControl = assessment.getAssessmentAccessControl()) != null) {
                assessmentHelper.updateAccessControl(assessmentXml, assessmentAccessControl);
            }
            if ((securedIPAddressSet = assessment.getSecuredIPAddressSet()) != null) {
                assessmentHelper.updateIPAddressSet(assessmentXml, securedIPAddressSet);
            }
            if ((attachmentSet = assessment.getAssessmentAttachmentSet()) != null && attachmentSet.size() != 0) {
                assessmentHelper.updateAttachmentSet(assessmentXml, attachmentSet);
            }
            assessmentHelper.updateMetaData(assessmentXml, assessment);
            factory = new QTIHelperFactory();
            SectionHelperIfc sectionHelper = factory.getSectionHelperInstance(this.qtiVersion);
            ArrayList sectionList = assessment.getSectionArraySorted();
            for (int i = 0; i < sectionList.size(); ++i) {
                SectionDataIfc section = (SectionDataIfc)sectionList.get(i);
                InputStream sis = this.ax.getTemplateInputStream("sectionTemplate.xml");
                Section sectionXml = sectionHelper.readXMLDocument(sis);
                sectionXml.update(section);
                this.addSection(assessmentXml, sectionXml);
            }
            return assessmentXml.getDocument();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Document getItemBank(String[] itemIds) {
        Document objectBank = XmlUtil.createDocument();
        Element root = objectBank.createElement("questestinterop");
        Element ob = objectBank.createElement("objectbank");
        String objectBankIdent = "object" + Math.random();
        ob.setAttribute("ident", objectBankIdent);
        for (int i = 0; i < itemIds.length; ++i) {
            Document itemDoc = this.getItem(itemIds[i]);
            Element itemElement = itemDoc.getDocumentElement();
            Node itemImport = objectBank.importNode(itemElement, true);
            ob.appendChild(itemImport);
        }
        root.appendChild(ob);
        objectBank.appendChild(root);
        return objectBank;
    }

    public Document getAssessmentBank(String[] assessmentIds) {
        Document objectBank = XmlUtil.createDocument();
        Element root = objectBank.createElement("questestinterop");
        Element ob = objectBank.createElement("objectbank");
        String objectBankIdent = "object" + Math.random();
        ob.setAttribute("ident", objectBankIdent);
        for (int i = 0; i < assessmentIds.length; ++i) {
            Document itemDoc = this.getAssessment(assessmentIds[i]);
            Element itemElement = itemDoc.getDocumentElement();
            Node itemImport = objectBank.importNode(itemElement, true);
            ob.appendChild(itemImport);
        }
        root.appendChild(ob);
        objectBank.appendChild(root);
        return objectBank;
    }

    public Document getItem(String itemId) {
        Item itemXml = new Item(this.qtiVersion);
        try {
            ItemService itemService = new ItemService();
            QTIHelperFactory factory = new QTIHelperFactory();
            ItemHelperIfc itemHelper = factory.getItemHelperInstance(this.qtiVersion);
            ItemFacade item = itemService.getItem(itemId);
            Long type = item.getTypeId();
            if (TypeIfc.MULTIPLE_CHOICE_SURVEY.equals(type)) {
                String scale = item.getItemMetaDataByLabel("SCALENAME");
                itemXml = itemHelper.readTypeSurveyItem(scale);
            } else {
                itemXml = itemHelper.readTypeXMLItem(type);
            }
            itemXml.setIdent(item.getItemIdString());
            itemXml.update((ItemDataIfc)item);
            return itemXml.getDocument();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private void addSection(Assessment assessmentXml, Section sectionXml) throws IOException, SAXException, ParserConfigurationException {
        this.ax.addElement(assessmentXml.getDocument(), "questestinterop/assessment", sectionXml.getDocument().getDocumentElement());
    }

    public InputStream getBlankSectionTemplateFileStream() {
        InputStream is = this.ax.getTemplateInputStream("sectionTemplate.xml");
        return is;
    }

    public AssessmentFacade[] createMultipleImportedAssessments(Document objectBank) {
        Document[] docs = this.getDocumentsFromObjectBankDoc(objectBank, "assessment");
        return this.createMultipleImportedAssessments(docs);
    }

    private Document[] getDocumentsFromObjectBankDoc(Document objectBank, String elementName) {
        Document[] documents = null;
        NodeList nodeList = objectBank.getElementsByTagName("//" + elementName);
        int numDocs = nodeList.getLength();
        if (numDocs == 0) {
            return null;
        }
        documents = new Document[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            Node node = nodeList.item(i);
            Document objectDoc = XmlUtil.createDocument();
            Node importNode = objectDoc.importNode(node, true);
            objectDoc.appendChild(importNode);
            documents[i] = objectDoc;
        }
        return documents;
    }

    public AssessmentFacade[] createMultipleImportedAssessments(Document[] documents) {
        AssessmentFacade[] assessments = new AssessmentFacade[documents.length];
        for (int i = 0; i < documents.length; ++i) {
            assessments[i] = this.createImportedAssessment(documents[i]);
        }
        return assessments;
    }

    public AssessmentFacade createImportedAssessment(Document document) {
        return this.createImportedAssessment(document, null);
    }

    public AssessmentFacade createImportedAssessment(Document document, String unzipLocation) {
        return this.createImportedAssessment(document, unzipLocation, false, null);
    }

    public AssessmentFacade createImportedAssessment(Document document, String unzipLocation, boolean isRespondus, List failedMatchingQuestions) {
        return this.createImportedAssessment(document, unzipLocation, null, isRespondus, failedMatchingQuestions, null);
    }

    public AssessmentFacade createImportedAssessment(Document document, String unzipLocation, String templateId, String siteId) {
        return this.createImportedAssessment(document, unzipLocation, templateId, false, null, siteId);
    }

    private boolean validateImportXml(Document doc) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String schemaFile = "xml/xsd/qtiv1p2.xsd";
        log.debug("schemaFile = " + schemaFile);
        Schema schema = factory.newSchema(new StreamSource(AuthoringHelper.class.getClassLoader().getResourceAsStream(schemaFile)));
        Validator validator = schema.newValidator();
        DOMSource source = new DOMSource(doc);
        try {
            validator.validate(source);
            log.debug("The xml is valid.");
            return true;
        }
        catch (SAXException ex) {
            log.debug("The xml is not valid QTI format.", (Throwable)ex);
            return false;
        }
    }

    protected String getAgentString() {
        return AgentFacade.getAgentString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssessmentFacade createImportedAssessment(Document document, String unzipLocation, String templateId, boolean isRespondus, List failedMatchingQuestions, String siteId) {
        AssessmentFacade assessment = null;
        AssessmentService assessmentService = new AssessmentService();
        try {
            boolean notUnique;
            String me = this.getAgentString();
            ExtractionHelper exHelper = new ExtractionHelper(this.qtiVersion);
            exHelper.setUnzipLocation(unzipLocation);
            ItemService itemService = new ItemService();
            Document removeNamespace = exHelper.getTransformDocument("removeDefaultNamespaceFromQTI.xsl");
            Document flatNamespaceXml = XmlUtil.transformDocument(document, removeNamespace);
            boolean success = this.validateImportXml(flatNamespaceXml);
            if (!success) {
                throw new RuntimeException("Invalid QTI XML format.");
            }
            Assessment assessmentXml = new Assessment(flatNamespaceXml);
            Map assessmentMap = exHelper.mapAssessment(assessmentXml, isRespondus);
            String description = (String)assessmentMap.get("description");
            String title = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((String)((String)assessmentMap.get("title")));
            assessment = assessmentService.createAssessmentWithoutDefaultSection(title, exHelper.makeFCKAttachment(description), null, templateId, siteId);
            String baseId = assessment.getAssessmentBaseId().toString();
            boolean bl = notUnique = !assessmentService.assessmentTitleIsUnique(baseId, title, false);
            if (notUnique) {
                String string = title;
                synchronized (string) {
                    log.debug("Assessment " + title + " is not unique.");
                    int count = 0;
                    while (notUnique) {
                        title = exHelper.renameDuplicate(title);
                        log.debug("renameDuplicate(title): " + title);
                        assessment.setTitle(title);
                        boolean bl2 = notUnique = !assessmentService.assessmentTitleIsUnique(baseId, title, false);
                        if (count++ <= 99) continue;
                    }
                }
            }
            if (isRespondus) {
                AssessmentFeedback feedback;
                EvaluationModel evaluationModel;
                AssessmentAccessControl control = (AssessmentAccessControl)assessment.getAssessmentAccessControl();
                if (control == null) {
                    control = new AssessmentAccessControl();
                    control.setAssessmentBase(assessment.getData());
                }
                if ((evaluationModel = (EvaluationModel)assessment.getEvaluationModel()) == null) {
                    evaluationModel = new EvaluationModel();
                    evaluationModel.setAssessmentBase(assessment.getData());
                }
                if ((feedback = (AssessmentFeedback)assessment.getAssessmentFeedback()) == null) {
                    feedback = new AssessmentFeedback();
                    feedback.setAssessmentBase(assessment.getData());
                }
            } else {
                exHelper.updateAssessment(assessment, assessmentMap);
            }
            assessment.setCreatedBy(me);
            assessment.setCreatedDate(assessment.getCreatedDate());
            assessment.setLastModifiedBy(me);
            assessment.setLastModifiedDate(assessment.getCreatedDate());
            assessment.setTypeId(TypeIfc.QUIZ);
            assessment.setStatus(Integer.valueOf(1));
            String comments = (String)assessmentMap.get("comments");
            assessment.setComments(comments);
            List sectionList = exHelper.getSectionXmlList(assessmentXml);
            int sectionListSize = sectionList.size();
            log.debug("sections=" + sectionListSize);
            for (int sec = 0; sec < sectionListSize; ++sec) {
                Section sectionXml = (Section)sectionList.get(sec);
                Map sectionMap = exHelper.mapSection(sectionXml, isRespondus);
                SectionFacade section = assessmentService.addSection("" + assessment.getAssessmentId());
                exHelper.updateSection(section, sectionMap);
                section.setCreatedBy(me);
                section.setCreatedDate(assessment.getCreatedDate());
                section.setLastModifiedBy(me);
                section.setLastModifiedDate(assessment.getCreatedDate());
                section.setTypeId(TypeIfc.DEFAULT_SECTION);
                section.setStatus(Integer.valueOf(1));
                section.setSequence(Integer.valueOf(sec + 1));
                List itemList = exHelper.getItemXmlList(sectionXml);
                for (int itm = 0; itm < itemList.size(); ++itm) {
                    ItemFacade item;
                    block20: {
                        log.debug("items=" + itemList.size());
                        Item itemXml = (Item)itemList.get(itm);
                        item = new ItemFacade();
                        try {
                            exHelper.updateItem(item, itemXml, isRespondus);
                        }
                        catch (RespondusMatchingException rme) {
                            if (failedMatchingQuestions == null) break block20;
                            failedMatchingQuestions.add(itm + 1);
                        }
                    }
                    item.setCreatedBy(me);
                    item.setCreatedDate(assessment.getCreatedDate());
                    item.setLastModifiedBy(me);
                    item.setLastModifiedDate(assessment.getCreatedDate());
                    item.setStatus(ItemDataIfc.ACTIVE_STATUS);
                    item.setSequence(Integer.valueOf(itm + 1));
                    item.setSection((SectionDataIfc)section);
                    item.addItemMetaData("PARTID", section.getSectionId().toString());
                    exHelper.makeItemAttachmentSet(item);
                    section.addItem(item);
                    itemService.saveItem(item);
                    EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.saveitem", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/saved itemId=" + item.getItemId().toString()), (boolean)true));
                }
                exHelper.makeSectionAttachmentSet(section, sectionMap);
                assessmentService.saveOrUpdateSection(section);
            }
            String allowIp = assessment.getAssessmentMetaDataByLabel("ALLOW_IP");
            if (allowIp != null && !allowIp.trim().equalsIgnoreCase("null")) {
                exHelper.makeSecuredIPAddressSet(assessment, allowIp);
                Set assessmentSet = assessment.getAssessmentMetaDataSet();
                Iterator assessmentSetIterator = assessmentSet.iterator();
                while (assessmentSetIterator.hasNext()) {
                    AssessmentMetaData assessmentMetaData = (AssessmentMetaData)assessmentSetIterator.next();
                    if (!"ALLOW_IP".equals(assessmentMetaData.getLabel())) continue;
                    assessmentSetIterator.remove();
                    break;
                }
            }
            exHelper.makeAssessmentAttachmentSet(assessment);
            assessmentService.saveAssessment(assessment);
            return assessment;
        }
        catch (RespondusMatchingException rme) {
            log.error(rme.getMessage(), (Throwable)rme);
            assessmentService.removeAssessment(assessment.getAssessmentId().toString());
            throw new RespondusMatchingException(rme);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            assessmentService.removeAssessment(assessment.getAssessmentId().toString());
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuestionPoolFacade createImportedQuestionPool(Document document) {
        QuestionPoolFacade questionpool = new QuestionPoolFacade();
        QuestionPoolService questionPoolService = new QuestionPoolService();
        try {
            String me = AgentFacade.getAgentString();
            ExtractionHelper exHelper = new ExtractionHelper(this.qtiVersion);
            ItemService itemService = new ItemService();
            Document removeNamespace = exHelper.getTransformDocument("removeDefaultNamespaceFromQTI.xsl");
            Document flatNamespaceXml = XmlUtil.transformDocument(document, removeNamespace);
            Assessment assessmentXml = new Assessment(flatNamespaceXml);
            boolean success = this.validateImportXml(flatNamespaceXml);
            if (!success) {
                throw new RuntimeException("Invalid QTI XML format.");
            }
            Map assessmentMap = exHelper.mapAssessment(assessmentXml);
            String title = (String)assessmentMap.get("title");
            questionpool.setOwnerId(me);
            questionpool.setTitle(title);
            questionpool.setLastModifiedById(me);
            questionpool.setAccessTypeId(QuestionPoolFacade.ACCESS_DENIED);
            questionpool = questionPoolService.savePool(questionpool);
            exHelper.updateQuestionPool(questionpool, assessmentMap);
            String baseId = questionpool.getQuestionPoolId().toString();
            boolean isUnique = questionPoolService.poolIsUnique(baseId, title, "0", me);
            if (!isUnique) {
                String string = title;
                synchronized (string) {
                    log.debug("Questionpool " + title + " is not unique.");
                    int count = 0;
                    while (!isUnique) {
                        title = exHelper.renameDuplicate(title);
                        log.debug("renameDuplicate(title): " + title);
                        questionpool.setTitle(title);
                        isUnique = questionPoolService.poolIsUnique(baseId, title, "0", me);
                        if (count++ <= 99) continue;
                    }
                }
            }
            List sectionList = exHelper.getSectionXmlList(assessmentXml);
            int sectionListSize = sectionList.size();
            log.debug("sections=" + sectionListSize);
            HashSet itemSet = new HashSet();
            questionpool.setQuestionPoolItems(itemSet);
            for (int sec = 0; sec < sectionListSize; ++sec) {
                Section sectionXml = (Section)sectionList.get(sec);
                Map sectionMap = exHelper.mapSection(sectionXml);
                List itemList = exHelper.getItemXmlList(sectionXml);
                for (int itm = 0; itm < itemList.size(); ++itm) {
                    log.debug("items=" + itemList.size());
                    Item itemXml = (Item)itemList.get(itm);
                    ItemFacade item = new ItemFacade();
                    exHelper.updateItem(item, itemXml);
                    item.setCreatedBy(me);
                    item.setCreatedDate(questionpool.getLastModified());
                    item.setLastModifiedBy(me);
                    item.setLastModifiedDate(questionpool.getLastModified());
                    item.setStatus(ItemDataIfc.ACTIVE_STATUS);
                    itemService.saveItem(item);
                    EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.saveitem", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/saved itemId=" + item.getItemId().toString()), (boolean)true));
                    QuestionPoolItemData questionPoolItem = new QuestionPoolItemData();
                    questionPoolItem.setQuestionPoolId(questionpool.getQuestionPoolId());
                    questionPoolItem.setItemId(item.getItemId());
                    questionpool.addQuestionPoolItem((QuestionPoolItemIfc)questionPoolItem);
                }
            }
            questionPoolService.savePool(questionpool);
            return questionpool;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            questionPoolService.deletePool(questionpool.getQuestionPoolId(), AgentFacade.getAgentString(), null);
            throw new RuntimeException(e);
        }
    }

    public ItemFacade createImportedItem(Document document) {
        ItemFacade item = new ItemFacade();
        try {
            ExtractionHelper exHelper = new ExtractionHelper(this.qtiVersion);
            Item itemXml = new Item(document, 1);
            exHelper.updateItem(item, itemXml);
            ItemService itemService = new ItemService();
            itemService.saveItem(item);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return item;
    }

    public XmlStringBuffer readXMLDocument(InputStream inputStream) {
        Document document = null;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new XmlStringBuffer(document);
    }

    public ArrayList changeDelimitedStringtoArray(String inputStr, String delimiter) {
        ArrayList<String> selectedList = new ArrayList<String>();
        if (inputStr != null && inputStr.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(inputStr, delimiter);
            if (st != null) {
                while (st.hasMoreTokens()) {
                    selectedList.add(st.nextToken());
                }
            } else {
                selectedList.add(inputStr);
            }
        }
        return selectedList;
    }

    public int getQtiVersion() {
        return this.qtiVersion;
    }

    public void setQtiVersion(int qtiVersion) {
        this.qtiVersion = qtiVersion;
    }
}

