/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.asi;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;

public class PrintUtil {
    private static StringBuilder buf = new StringBuilder();
    private static int pTab = 0;

    public static String printItem(ItemDataIfc item) {
        PrintUtil.pNewItem(item);
        PrintUtil.p("ThemeText", item.getThemeText());
        PrintUtil.p("IsAnswerOptionsSimple", item.getIsAnswerOptionsSimple());
        PrintUtil.p("LeadInText", item.getLeadInText());
        PrintUtil.p("Sequence", item.getSequence());
        PrintUtil.p("Score", item.getScore());
        PrintUtil.p("Discount", item.getDiscount());
        PrintUtil.p("AnswerKey", item.getAnswerKey());
        PrintUtil.p("AnswerOptionsRichCount", item.getAnswerOptionsRichCount());
        PrintUtil.p("EmiAnswerOptionLabels", item.getEmiAnswerOptionLabels());
        PrintUtil.p("EmiAnswerOptionsRichText", item.getEmiAnswerOptionsRichText());
        PrintUtil.p("NumberOfCorrectEmiOptions", item.getNumberOfCorrectEmiOptions());
        PrintUtil.p("PartialCreditFlag", item.getPartialCreditFlag());
        PrintUtil.p("Status", item.getStatus());
        PrintUtil.pa(item.getItemAttachmentSet());
        PrintUtil.pt(item.getItemTextArraySorted());
        PrintUtil.pEndData();
        String data = buf.toString();
        buf.setLength(0);
        return data;
    }

    private static void pt(Collection<ItemTextIfc> itemTextSet) {
        if (itemTextSet == null) {
            return;
        }
        PrintUtil.pNewData("ItemTextSet");
        for (ItemTextIfc it : itemTextSet) {
            PrintUtil.p(String.valueOf(it.getId()), it);
        }
        PrintUtil.pEndData();
    }

    private static void pa(Set<ItemAttachmentIfc> attachSet) {
        if (attachSet == null) {
            return;
        }
        PrintUtil.pNewData("ItemAttachmentSet");
        for (ItemAttachmentIfc ia : attachSet) {
            PrintUtil.p("AttachmentType", ia.getAttachmentType());
            PrintUtil.p("Description", ia.getDescription());
            PrintUtil.p("Filename", ia.getFilename());
            PrintUtil.p("FileSize", ia.getFileSize());
            PrintUtil.p("IsLink", ia.getIsLink());
            PrintUtil.p("Location", ia.getLocation());
            PrintUtil.p("MimeType", ia.getMimeType());
            PrintUtil.p("ResourceId", ia.getResourceId());
            PrintUtil.p("Status", ia.getStatus());
        }
        PrintUtil.pEndData();
    }

    private static void p(String label, ItemTextIfc itemText) {
        PrintUtil.pNewData(label);
        PrintUtil.p("EmiCorrectOptionLabels", itemText.getEmiCorrectOptionLabels());
        PrintUtil.p("RequiredOptionsCount", itemText.getRequiredOptionsCount());
        PrintUtil.p("Sequence", itemText.getSequence());
        PrintUtil.p("Text", itemText.getText());
        PrintUtil.p("HasAttachment", itemText.getHasAttachment());
        PrintUtil.p("isEmiQuestionItemText", itemText.isEmiQuestionItemText());
        PrintUtil.pan(itemText.getAnswerSet());
        PrintUtil.patt(itemText.getItemTextAttachmentSet());
        PrintUtil.pEndData();
    }

    private static void pan(Set<AnswerIfc> answerSet) {
        if (answerSet == null) {
            return;
        }
        PrintUtil.pNewData("AnswerSet");
        for (AnswerIfc answer : answerSet) {
            PrintUtil.pNewData(answer.getSequence().toString());
            PrintUtil.p("Sequence", answer.getSequence());
            PrintUtil.p("Label", answer.getLabel());
            PrintUtil.p("Text", answer.getText());
            PrintUtil.p("IsCorrect", answer.getIsCorrect());
            PrintUtil.p("Score", answer.getScore());
            PrintUtil.p("Discount", answer.getDiscount());
            PrintUtil.pEndData();
        }
        PrintUtil.pEndData();
    }

    private static void patt(Set<ItemTextAttachmentIfc> attachSet) {
        if (attachSet == null) {
            return;
        }
        PrintUtil.pNewData("ItemTextAttachmentSet");
        for (ItemTextAttachmentIfc ita : attachSet) {
            PrintUtil.p("AttachmentType", ita.getAttachmentType());
            PrintUtil.p("Description", ita.getDescription());
            PrintUtil.p("Filename", ita.getFilename());
            PrintUtil.p("FileSize", ita.getFileSize());
            PrintUtil.p("IsLink", ita.getIsLink());
            PrintUtil.p("Location", ita.getLocation());
            PrintUtil.p("MimeType", ita.getMimeType());
            PrintUtil.p("ResourceId", ita.getResourceId());
            PrintUtil.p("Status", ita.getStatus());
        }
        PrintUtil.pEndData();
    }

    private static void pNewItem(ItemDataIfc item) {
        pTab = 0;
        PrintUtil.p("************ " + item.getItemIdString() + ": " + item.getThemeText() + " **************");
    }

    private static void pNewData(String text) {
        PrintUtil.p("----- " + text + " -----");
        ++pTab;
    }

    private static void pEndData() {
        --pTab;
        PrintUtil.p("----- End -----");
    }

    private static void p(String label, Object text) {
        PrintUtil.p(label, text == null ? "Object" : text.getClass().getSimpleName(), text == null ? "null" : text.toString());
    }

    private static void p(String label, String text) {
        PrintUtil.p(label, "String", text);
    }

    private static void p(String label, Boolean text) {
        PrintUtil.p(label, "Boolean", String.valueOf(text));
    }

    private static void p(String label, Integer text) {
        PrintUtil.p(label, "Integer", String.valueOf(text));
    }

    private static void p(String label, Long text) {
        PrintUtil.p(label, "Long", String.valueOf(text));
    }

    private static void p(String label, Float text) {
        PrintUtil.p(label, "Float", String.valueOf(text));
    }

    private static void p(String label, Double text) {
        PrintUtil.p(label, "Double", String.valueOf(text));
    }

    private static void p(String label, Date text) {
        PrintUtil.p(label, "Date", String.valueOf(text));
    }

    private static void p(String label, String type, String text) {
        PrintUtil.p(label + "(" + type + "): " + text);
    }

    private static void p(String text) {
        for (int i = 0; i < pTab; ++i) {
            buf.append("\t");
        }
        buf.append(text);
        buf.append("\n");
    }
}

