/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTextAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.SecuredIPAddress;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.qti.asi.ASIBaseClass;
import org.sakaiproject.tool.assessment.qti.asi.Assessment;
import org.sakaiproject.tool.assessment.qti.asi.Item;
import org.sakaiproject.tool.assessment.qti.asi.Section;
import org.sakaiproject.tool.assessment.qti.constants.QTIVersion;
import org.sakaiproject.tool.assessment.qti.exception.Iso8601FormatException;
import org.sakaiproject.tool.assessment.qti.exception.RespondusMatchingException;
import org.sakaiproject.tool.assessment.qti.helper.AttachmentHelper;
import org.sakaiproject.tool.assessment.qti.helper.MetaDataList;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemTypeExtractionStrategy;
import org.sakaiproject.tool.assessment.qti.util.Iso8601DateFormat;
import org.sakaiproject.tool.assessment.qti.util.Iso8601TimeInterval;
import org.sakaiproject.tool.assessment.qti.util.XmlMapper;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.util.TextFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ExtractionHelper {
    private static final Logger log = LoggerFactory.getLogger(ExtractionHelper.class);
    private static final String QTI_VERSION_1_2_PATH = "v1p2";
    private static final String QTI_VERSION_2_0_PATH = "v2p0";
    private static final String TRANSFORM_PATH = "xml/xsl/dataTransform/import";
    private static final String TRANSFORM_PATH_RESPONDUS = "xml/xsl/dataTransform/import/respondus";
    private static final String ASSESSMENT_TRANSFORM = "extractAssessment.xsl";
    private static final String SECTION_TRANSFORM = "extractSection.xsl";
    private static final String ITEM_TRANSFORM = "extractItem.xsl";
    private static final String ITEM_EMI_TRANSFORM = "extractEMIItem.xsl";
    public static final String REMOVE_NAMESPACE_TRANSFORM = "removeDefaultNamespaceFromQTI.xsl";
    private int qtiVersion = 1;
    private String overridePath = null;
    private String FIB_BLANK_INDICATOR = " {} ";
    private String unzipLocation;

    public ExtractionHelper() {
        this.setQtiVersion(1);
    }

    public ExtractionHelper(int qtiVersion) {
        this.setQtiVersion(qtiVersion);
    }

    public String getTransformPath() {
        return this.getTransformPath(false);
    }

    public String getTransformPath(boolean isRespondus) {
        if (this.overridePath != null) {
            return this.overridePath;
        }
        if (isRespondus) {
            return TRANSFORM_PATH_RESPONDUS;
        }
        return "xml/xsl/dataTransform/import/" + this.getQtiPath();
    }

    private String getQtiPath() {
        return this.qtiVersion == 1 ? QTI_VERSION_1_2_PATH : QTI_VERSION_2_0_PATH;
    }

    public int getQtiVersion() {
        return this.qtiVersion;
    }

    public void setQtiVersion(int qtiVersion) {
        if (!QTIVersion.isValid((int)qtiVersion)) {
            throw new IllegalArgumentException("NOT Legal Qti Version.");
        }
        this.qtiVersion = qtiVersion;
    }

    public Document getTransformDocument(String template, boolean isRespondus) {
        if (!this.isOKtransform(template)) {
            throw new IllegalArgumentException("NOT valid template.");
        }
        String templateContextPath = this.getTransformPath(isRespondus) + "/" + template;
        return XmlUtil.readDocument(templateContextPath);
    }

    public Document getTransformDocument(String template) {
        return this.getTransformDocument(template, false);
    }

    public Map mapAssessment(Assessment assessmentXml) {
        return this.mapAssessment(assessmentXml, false);
    }

    public Map mapAssessment(Assessment assessmentXml, boolean isRespondus) {
        log.debug("inside: mapAssessment");
        return this.map(ASSESSMENT_TRANSFORM, assessmentXml, isRespondus);
    }

    public Map mapSection(Section sectionXml, boolean isRespondus) {
        return this.map(SECTION_TRANSFORM, sectionXml, isRespondus);
    }

    public Map mapSection(Section sectionXml) {
        return this.mapSection(sectionXml, false);
    }

    public Map mapItem(Item itemXml) {
        return this.mapItem(itemXml, false);
    }

    public Map mapItem(Item itemXml, boolean isRespondus) {
        return this.map(ITEM_TRANSFORM, itemXml, isRespondus);
    }

    public Map mapEMIItem(Item itemXml, boolean isRespondus) {
        return this.map(ITEM_EMI_TRANSFORM, itemXml, isRespondus);
    }

    private Map map(String transformType, ASIBaseClass asi, boolean isRespondus) {
        if (!this.isOKasi(asi)) {
            throw new IllegalArgumentException("Incorrect ASI subclass.");
        }
        if (!this.isOKtransform(transformType)) {
            throw new IllegalArgumentException("Incorrect transform: " + transformType + ".");
        }
        Map map = null;
        try {
            Document transform = this.getTransformDocument(transformType, isRespondus);
            Document xml = asi.getDocument();
            Document model = XmlUtil.transformDocument(xml, transform);
            map = XmlMapper.map(model);
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        catch (SAXException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return map;
    }

    private Map map(String transformType, ASIBaseClass asi) {
        return this.map(transformType, asi, false);
    }

    public List getSectionXmlList(Assessment assessmentXml) {
        List nodeList = assessmentXml.selectNodes("//section");
        ArrayList<Section> sectionXmlList = new ArrayList<Section>();
        for (int i = 0; i < nodeList.size(); ++i) {
            try {
                Node node = (Node)nodeList.get(i);
                Document sectionDoc = XmlUtil.createDocument();
                Node importNode = sectionDoc.importNode(node, true);
                sectionDoc.appendChild(importNode);
                Section sectionXml = new Section(sectionDoc, this.getQtiVersion());
                sectionXmlList.add(sectionXml);
                continue;
            }
            catch (DOMException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return sectionXmlList;
    }

    public List getItemXmlList(Section sectionXml) {
        String itemElementName = this.qtiVersion == 1 ? "//item" : "//assessmentItem";
        List nodeList = sectionXml.selectNodes(itemElementName);
        ArrayList<Item> itemXmlList = new ArrayList<Item>();
        for (int i = 0; i < nodeList.size(); ++i) {
            try {
                Node node = (Node)nodeList.get(i);
                Document itemDoc = XmlUtil.createDocument();
                Node importNode = itemDoc.importNode(node, true);
                itemDoc.appendChild(importNode);
                Item itemXml = new Item(itemDoc, this.getQtiVersion());
                itemXmlList.add(itemXml);
                continue;
            }
            catch (DOMException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return itemXmlList;
    }

    private boolean isOKtransform(String transform) {
        return ASSESSMENT_TRANSFORM.equals(transform) || SECTION_TRANSFORM.equals(transform) || ITEM_TRANSFORM.equals(transform) || ITEM_EMI_TRANSFORM.equals(transform) || REMOVE_NAMESPACE_TRANSFORM.equals(transform);
    }

    private boolean isOKasi(ASIBaseClass asi) {
        return asi instanceof Assessment || asi instanceof Section || asi instanceof Item;
    }

    public void updateAssessment(AssessmentFacade assessment, Map assessmentMap) {
        log.debug("ASSESSMENT updating metadata information");
        List metalist = (List)assessmentMap.get("metadata");
        MetaDataList metadataList = new MetaDataList(metalist);
        metadataList.setDefaults(assessment);
        metadataList.addTo(assessment);
        log.debug("ASSESSMENT updating access control, evaluation model, feedback");
        String duration = (String)assessmentMap.get("duration");
        log.debug("duration: " + duration);
        this.makeAccessControl(assessment, duration);
        String submissionMsg = metadataList.getSubmissionMessage();
        this.updateSubmissionMessage(assessment, submissionMsg);
        this.makeEvaluationModel(assessment);
        this.makeAssessmentFeedback(assessment);
    }

    private void makeAssessmentFeedback(AssessmentFacade assessment) {
        AssessmentFeedback feedback = (AssessmentFeedback)assessment.getAssessmentFeedback();
        if (feedback == null) {
            feedback = new AssessmentFeedback();
            feedback.setAssessmentBase(assessment.getData());
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_QUESTION"))) {
            feedback.setShowQuestionText(Boolean.TRUE);
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_QUESTION"))) {
            feedback.setShowQuestionText(Boolean.FALSE);
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_RESPONSE"))) {
            feedback.setShowStudentResponse(Boolean.TRUE);
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_RESPONSE"))) {
            feedback.setShowStudentResponse(Boolean.FALSE);
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_CORRECT_RESPONSE"))) {
            feedback.setShowCorrectResponse(Boolean.TRUE);
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_CORRECT_RESPONSE"))) {
            feedback.setShowCorrectResponse(Boolean.FALSE);
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_STUDENT_SCORE"))) {
            feedback.setShowStudentScore(Boolean.TRUE);
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_STUDENT_SCORE"))) {
            feedback.setShowStudentScore(Boolean.FALSE);
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_STUDENT_QUESTIONSCORE"))) {
            feedback.setShowStudentQuestionScore(Boolean.TRUE);
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_STUDENT_QUESTIONSCORE"))) {
            feedback.setShowStudentQuestionScore(Boolean.FALSE);
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_ITEM_LEVEL"))) {
            feedback.setShowQuestionLevelFeedback(Boolean.TRUE);
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_ITEM_LEVEL"))) {
            feedback.setShowQuestionLevelFeedback(Boolean.FALSE);
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_SELECTION_LEVEL"))) {
            feedback.setShowSelectionLevelFeedback(Boolean.TRUE);
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_SELECTION_LEVEL"))) {
            feedback.setShowSelectionLevelFeedback(Boolean.FALSE);
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_GRADER_COMMENT"))) {
            feedback.setShowGraderComments(Boolean.TRUE);
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_GRADER_COMMENT"))) {
            feedback.setShowGraderComments(Boolean.FALSE);
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_STATS"))) {
            feedback.setShowStatistics(Boolean.TRUE);
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_SHOW_STATS"))) {
            feedback.setShowStatistics(Boolean.FALSE);
        }
        if (this.notNullOrEmpty(assessment.getAssessmentMetaDataByLabel("FEEDBACK_DELIVERY_DATE")) || "DATED".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_DELIVERY"))) {
            feedback.setFeedbackDelivery(AssessmentFeedback.FEEDBACK_BY_DATE);
        } else if ("IMMEDIATE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_DELIVERY"))) {
            feedback.setFeedbackDelivery(AssessmentFeedback.IMMEDIATE_FEEDBACK);
        } else if ("ON_SUBMISSION".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_DELIVERY"))) {
            feedback.setFeedbackDelivery(AssessmentFeedback.FEEDBACK_ON_SUBMISSION);
        } else if ("NONE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_DELIVERY"))) {
            feedback.setFeedbackDelivery(AssessmentFeedback.NO_FEEDBACK);
        }
        if ("SELECT_COMPONENTS".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_COMPONENT_OPTION"))) {
            feedback.setFeedbackComponentOption(AssessmentFeedback.SELECT_COMPONENTS);
        } else if ("SHOW_TOTALSCORE_ONLY".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_COMPONENT_OPTION"))) {
            feedback.setFeedbackComponentOption(AssessmentFeedback.SHOW_TOTALSCORE_ONLY);
        }
        if ("QUESTION".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_AUTHORING"))) {
            feedback.setFeedbackAuthoring(AssessmentFeedback.QUESTIONLEVEL_FEEDBACK);
        } else if ("SECTION".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_AUTHORING"))) {
            feedback.setFeedbackAuthoring(AssessmentFeedback.SECTIONLEVEL_FEEDBACK);
        } else if ("BOTH".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("FEEDBACK_AUTHORING"))) {
            feedback.setFeedbackAuthoring(AssessmentFeedback.BOTH_FEEDBACK);
        }
        assessment.setAssessmentFeedback((AssessmentFeedbackIfc)feedback);
    }

    private void makeEvaluationModel(AssessmentFacade assessment) {
        EvaluationModel evaluationModel = (EvaluationModel)assessment.getEvaluationModel();
        if (evaluationModel == null) {
            evaluationModel = new EvaluationModel();
            evaluationModel.setAssessmentBase(assessment.getData());
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("ANONYMOUS_GRADING"))) {
            evaluationModel.setAnonymousGrading(EvaluationModel.ANONYMOUS_GRADING);
        } else {
            evaluationModel.setAnonymousGrading(EvaluationModel.NON_ANONYMOUS_GRADING);
        }
        if ("DEFAULT".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("GRADEBOOK_OPTIONS"))) {
            evaluationModel.setToGradeBook(EvaluationModel.TO_DEFAULT_GRADEBOOK.toString());
        } else if ("SELECTED".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("GRADEBOOK_OPTIONS"))) {
            evaluationModel.setToGradeBook(EvaluationModel.NOT_TO_GRADEBOOK.toString());
        } else if ("NONE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("GRADEBOOK_OPTIONS"))) {
            evaluationModel.setToGradeBook(EvaluationModel.NOT_TO_GRADEBOOK.toString());
        }
        if ("HIGHEST_SCORE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("GRADE_SCORE"))) {
            evaluationModel.setScoringType(EvaluationModel.HIGHEST_SCORE);
        } else if ("AVERAGE_SCORE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("GRADE_SCORE"))) {
            evaluationModel.setScoringType(EvaluationModel.AVERAGE_SCORE);
        } else if ("LAST_SCORE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("GRADE_SCORE"))) {
            evaluationModel.setScoringType(EvaluationModel.LAST_SCORE);
        }
        assessment.setEvaluationModel((EvaluationModelIfc)evaluationModel);
    }

    private void updateSubmissionMessage(AssessmentFacade assessment, String submissionMsg) {
        AssessmentAccessControl control = (AssessmentAccessControl)assessment.getAssessmentAccessControl();
        if (control == null) {
            control = new AssessmentAccessControl();
            control.setAssessmentBase(assessment.getData());
        }
        if (submissionMsg != null) {
            control.setSubmissionMessage(this.makeFCKAttachment(submissionMsg));
        }
    }

    private void makeAccessControl(AssessmentFacade assessment, String duration) {
        AssessmentAccessControl control;
        block53: {
            control = (AssessmentAccessControl)assessment.getAssessmentAccessControl();
            if (control == null) {
                control = new AssessmentAccessControl();
                control.setAssessmentBase(assessment.getData());
            }
            Iso8601DateFormat iso = new Iso8601DateFormat();
            String startDate = assessment.getAssessmentMetaDataByLabel("START_DATE");
            String dueDate = assessment.getAssessmentMetaDataByLabel("END_DATE");
            String retractDate = assessment.getAssessmentMetaDataByLabel("RETRACT_DATE");
            String feedbackDate = assessment.getAssessmentMetaDataByLabel("FEEDBACK_DELIVERY_DATE");
            try {
                control.setStartDate(iso.parse(startDate).getTime());
                assessment.getData().addAssessmentMetaData("hasAvailableDate", "true");
            }
            catch (Iso8601FormatException ex) {
                log.debug("Cannot set startDate.");
            }
            try {
                control.setDueDate(iso.parse(dueDate).getTime());
                assessment.getData().addAssessmentMetaData("dueDate", "true");
            }
            catch (Iso8601FormatException ex) {
                log.debug("Cannot set dueDate.");
            }
            try {
                control.setRetractDate(iso.parse(retractDate).getTime());
                assessment.getData().addAssessmentMetaData("hasRetractDate", "true");
            }
            catch (Iso8601FormatException ex) {
                log.debug("Cannot set retractDate.");
            }
            try {
                control.setFeedbackDate(iso.parse(feedbackDate).getTime());
                assessment.getData().addAssessmentMetaData("FEEDBACK_DELIVERY", "DATED");
            }
            catch (Iso8601FormatException ex) {
                log.debug("Cannot set feedbackDate.");
            }
            String releasedTo = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_RELEASED_TO");
            if (releasedTo != null && releasedTo.indexOf("Authenticated Users") > -1) {
                log.debug("Fixing obsolete reference to 'Authenticated Users', setting released to 'Anonymous Users'.");
                releasedTo = "Anonymous Users";
            } else if (releasedTo != null && releasedTo.indexOf("Selected Groups") > -1) {
                releasedTo = AgentFacade.getCurrentSiteName();
            } else if (releasedTo != null && releasedTo.indexOf("Anonymous Users") > -1) {
                releasedTo = "Anonymous Users";
            } else if (AgentFacade.getCurrentSiteName() != null) {
                releasedTo = AgentFacade.getCurrentSiteName();
            }
            if (releasedTo != null) {
                control.setReleaseTo(releasedTo);
            }
            if (duration != null && !duration.trim().isEmpty()) {
                try {
                    Iso8601TimeInterval tiso = new Iso8601TimeInterval(duration);
                    log.debug("tiso.getDuration(): " + tiso.getDuration());
                    if (tiso == null) {
                        throw new Iso8601FormatException("Assessment duration could not be resolved.");
                    }
                    long millisecondsDuration = tiso.getDuration();
                    int seconds = (int)millisecondsDuration / 1000;
                    control.setTimeLimit(Integer.valueOf(seconds));
                    if (seconds != 0) {
                        control.setTimedAssessment(AssessmentAccessControl.TIMED_ASSESSMENT);
                        assessment.getData().addAssessmentMetaData("hasTimeAssessment", "true");
                        break block53;
                    }
                    control.setTimeLimit(Integer.valueOf(0));
                    control.setTimedAssessment(AssessmentAccessControl.DO_NOT_TIMED_ASSESSMENT);
                }
                catch (Iso8601FormatException ex) {
                    log.warn("Can't format assessment duration. " + ex);
                    control.setTimeLimit(Integer.valueOf(0));
                    control.setTimedAssessment(AssessmentAccessControl.DO_NOT_TIMED_ASSESSMENT);
                }
            } else {
                control.setTimeLimit(Integer.valueOf(0));
                control.setTimedAssessment(AssessmentAccessControl.DO_NOT_TIMED_ASSESSMENT);
            }
        }
        log.debug("assessment.getAssessmentMetaDataByLabel(AUTO_SUBMIT): " + assessment.getAssessmentMetaDataByLabel("AUTO_SUBMIT"));
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("AUTO_SUBMIT"))) {
            log.debug("AUTO SUBMIT IS TRUE");
            control.setAutoSubmit(AssessmentAccessControl.AUTO_SUBMIT);
            assessment.getData().addAssessmentMetaData("hasAutoSubmit", "true");
        } else if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("AUTO_SUBMIT"))) {
            control.setAutoSubmit(AssessmentAccessControl.DO_NOT_AUTO_SUBMIT);
        }
        if ("LINEAR".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("NAVIGATION"))) {
            control.setItemNavigation(AssessmentAccessControl.LINEAR_ACCESS);
        } else if ("RANDOM".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("NAVIGATION"))) {
            control.setItemNavigation(AssessmentAccessControl.RANDOM_ACCESS);
        }
        if ("CONTINUOUS".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("QUESTION_NUMBERING"))) {
            control.setItemNumbering(AssessmentAccessControl.CONTINUOUS_NUMBERING);
        } else if ("RESTART".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("QUESTION_NUMBERING"))) {
            control.setItemNumbering(AssessmentAccessControl.RESTART_NUMBERING_BY_PART);
        }
        if ("HIDE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("DISPLAY_SCORES"))) {
            control.setDisplayScoreDuringAssessments(AssessmentAccessControl.HIDE_ITEM_SCORE_DURING_ASSESSMENT);
        } else if ("SHOW".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("DISPLAY_SCORES"))) {
            control.setDisplayScoreDuringAssessments(AssessmentAccessControl.DISPLAY_ITEM_SCORE_DURING_ASSESSMENT);
        }
        if ("I".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("QUESTION_LAYOUT"))) {
            control.setAssessmentFormat(AssessmentAccessControl.BY_QUESTION);
        } else if ("S".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("QUESTION_LAYOUT"))) {
            control.setAssessmentFormat(AssessmentAccessControl.BY_PART);
        } else if ("A".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("QUESTION_LAYOUT"))) {
            control.setAssessmentFormat(AssessmentAccessControl.BY_ASSESSMENT);
        }
        if ("True".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("MARK_FOR_REVIEW"))) {
            control.setMarkForReview(AssessmentAccessControl.MARK_FOR_REVIEW);
        } else if ("False".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("MARK_FOR_REVIEW"))) {
            control.setMarkForReview(AssessmentAccessControl.NOT_MARK_FOR_REVIEW);
        }
        String maxAttempts = "" + assessment.getAssessmentMetaDataByLabel("MAX_ATTEMPTS");
        String unlimited = "9999";
        log.debug("maxAttempts: '" + maxAttempts + "'");
        log.debug("unlimited: '" + unlimited + "'");
        if (unlimited.equals(maxAttempts.trim())) {
            log.debug("unlimited.equals(maxAttempts.trim()");
            control.setUnlimitedSubmissions(Boolean.TRUE);
            control.setSubmissionsAllowed(AssessmentAccessControlIfc.UNLIMITED_SUBMISSIONS);
        } else if (maxAttempts != null && !"".equals(maxAttempts) && !"null".equals(maxAttempts)) {
            control.setUnlimitedSubmissions(Boolean.FALSE);
            try {
                control.setSubmissionsAllowed(new Integer(maxAttempts));
            }
            catch (NumberFormatException ex1) {
                control.setSubmissionsAllowed(new Integer("1"));
            }
        }
        log.debug("Set: control.getSubmissionsAllowed()=" + control.getSubmissionsAllowed());
        log.debug("Set: control.getUnlimitedSubmissions()=" + control.getUnlimitedSubmissions());
        if ("FALSE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("LATE_HANDLING"))) {
            control.setLateHandling(AssessmentAccessControl.NOT_ACCEPT_LATE_SUBMISSION);
        } else if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("LATE_HANDLING"))) {
            control.setLateHandling(Integer.valueOf(1));
        }
        if ("TRUE".equalsIgnoreCase(assessment.getAssessmentMetaDataByLabel("AUTO_SAVE"))) {
            control.setAutoSubmit(AssessmentAccessControl.AUTO_SAVE);
        }
        String password = assessment.getAssessmentMetaDataByLabel("PASSWORD");
        String finalPageUrl = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((String)assessment.getAssessmentMetaDataByLabel("FINISH_URL"));
        if (this.notNullOrEmpty(password)) {
            control.setPassword(password);
            assessment.getData().addAssessmentMetaData("hasUsernamePassword", "true");
        }
        control.setFinalPageUrl(finalPageUrl);
        assessment.setAssessmentAccessControl((AssessmentAccessControlIfc)control);
    }

    public void makeSecuredIPAddressSet(AssessmentFacade assessment, String ipList) {
        HashSet<SecuredIPAddress> securedIPAddressSet = assessment.getSecuredIPAddressSet();
        AssessmentBaseIfc data = assessment.getData();
        if (securedIPAddressSet == null) {
            securedIPAddressSet = new HashSet<SecuredIPAddress>();
        }
        if (ipList == null) {
            ipList = "";
        }
        String[] ip = ipList.split("\\n");
        for (int j = 0; j < ip.length; ++j) {
            if (ip[j] == null) continue;
            SecuredIPAddress sip = new SecuredIPAddress(data, null, ip[j]);
            securedIPAddressSet.add(sip);
        }
        if (securedIPAddressSet.size() > 0) {
            data.addAssessmentMetaData("hasIpAddress", "true");
            data.addAssessmentMetaData("hasSpecificIP", "true");
            assessment.updateData(data);
            assessment.setSecuredIPAddressSet(securedIPAddressSet);
        }
    }

    public void makeAssessmentAttachmentSet(AssessmentFacade assessment) {
        if (this.unzipLocation == null) {
            return;
        }
        String attachment = assessment.getAssessmentAttachmentMetaData();
        if (attachment == null || "".equals(attachment)) {
            return;
        }
        String[] attachmentArray = attachment.split("\\n");
        HashSet<AssessmentAttachmentIfc> set = new HashSet<AssessmentAttachmentIfc>();
        AttachmentHelper attachmentHelper = new AttachmentHelper();
        AssessmentService assessmentService = new AssessmentService();
        for (int i = 0; i < attachmentArray.length; ++i) {
            String[] attachmentInfo = attachmentArray[i].split("\\|");
            String fullFilePath = this.unzipLocation + "/" + attachmentInfo[0];
            String filename = attachmentInfo[1];
            ContentResource contentResource = attachmentHelper.createContentResource(fullFilePath, filename, attachmentInfo[2]);
            AssessmentAttachmentIfc assessmentAttachment = assessmentService.createAssessmentAttachment((AssessmentIfc)assessment, contentResource.getId(), filename, ServerConfigurationService.getServerUrl());
            assessmentAttachment.setAssessment((AssessmentIfc)assessment.getData());
            set.add(assessmentAttachment);
        }
        assessment.setAssessmentAttachmentSet(set);
    }

    public void makeSectionAttachmentSet(SectionFacade section, Map sectionMap) {
        if (this.unzipLocation == null) {
            return;
        }
        String attachment = (String)sectionMap.get("attachment");
        if (attachment == null || "".equals(attachment)) {
            return;
        }
        String[] attachmentArray = attachment.split("\\n");
        HashSet<SectionAttachmentIfc> set = new HashSet<SectionAttachmentIfc>();
        AttachmentHelper attachmentHelper = new AttachmentHelper();
        AssessmentService assessmentService = new AssessmentService();
        for (int i = 0; i < attachmentArray.length; ++i) {
            String[] attachmentInfo = attachmentArray[i].split("\\|");
            String fullFilePath = this.unzipLocation + "/" + attachmentInfo[0];
            String filename = attachmentInfo[1];
            ContentResource contentResource = attachmentHelper.createContentResource(fullFilePath, filename, attachmentInfo[2]);
            SectionAttachmentIfc sectionAttachment = assessmentService.createSectionAttachment((SectionDataIfc)section, contentResource.getId(), filename, ServerConfigurationService.getServerUrl());
            sectionAttachment.setSection(section.getData());
            set.add(sectionAttachment);
        }
        section.setSectionAttachmentSet(set);
    }

    public void makeItemAttachmentSet(ItemFacade item) {
        if (this.unzipLocation == null) {
            return;
        }
        String attachment = item.getItemAttachmentMetaData();
        if (attachment == null || "".equals(attachment)) {
            return;
        }
        String[] attachmentArray = attachment.split("\\n");
        HashSet<ItemAttachmentIfc> set = new HashSet<ItemAttachmentIfc>();
        AttachmentHelper attachmentHelper = new AttachmentHelper();
        AssessmentService assessmentService = new AssessmentService();
        for (int i = 0; i < attachmentArray.length; ++i) {
            String[] attachmentInfo = attachmentArray[i].split("\\|");
            String fullFilePath = this.unzipLocation + "/" + attachmentInfo[0];
            String filename = attachmentInfo[1];
            ContentResource contentResource = attachmentHelper.createContentResource(fullFilePath, filename, attachmentInfo[2]);
            ItemAttachmentIfc itemAttachment = assessmentService.createItemAttachment((ItemDataIfc)item, contentResource.getId(), filename, ServerConfigurationService.getServerUrl());
            itemAttachment.setItem(item.getData());
            set.add(itemAttachment);
        }
        item.setItemAttachmentSet(set);
    }

    public String makeFCKAttachment(String text) {
        if (text == null) {
            return text;
        }
        String processedText = XmlUtil.processFormattedText(text);
        if (this.unzipLocation == null || processedText.equals("")) {
            return processedText;
        }
        String accessURL = ServerConfigurationService.getAccessUrl();
        AssessmentService.getContentHostingService();
        String referenceRoot = "/content";
        String prependString = accessURL + referenceRoot;
        StringBuffer updatedText = null;
        ContentResource contentResource = null;
        AttachmentHelper attachmentHelper = new AttachmentHelper();
        String resourceId = null;
        String importedPrependString = this.getImportedPrependString(processedText);
        if (importedPrependString == null) {
            return processedText;
        }
        String[] splittedString = processedText.split("src=\"" + importedPrependString);
        ArrayList<String> splittedList = new ArrayList<String>();
        String src = "";
        for (int i = 0; i < splittedString.length; ++i) {
            splittedString[i] = src + splittedString[i];
            String[] splittedRefString = splittedString[i].split("href=\"" + importedPrependString);
            String href = "";
            for (int j = 0; j < splittedRefString.length; ++j) {
                splittedRefString[j] = href + splittedRefString[j];
                splittedList.add(splittedRefString[j]);
                href = "href=\"";
            }
            src = "src=\"";
        }
        splittedString = splittedList.toArray(splittedString);
        int endIndex = 0;
        String filename = null;
        String contentType = null;
        String fullFilePath = null;
        String oldResourceId = null;
        updatedText = new StringBuffer(splittedString[0]);
        for (int i = 1; i < splittedString.length; ++i) {
            log.debug("splittedString[" + i + "] = " + splittedString[i]);
            endIndex = splittedString[i].indexOf("\"", splittedString[i].indexOf("\"") + 1);
            oldResourceId = splittedString[i].substring(splittedString[i].indexOf("\"") + 1, endIndex);
            String[] oldSplittedResourceId = oldResourceId.split("/");
            fullFilePath = this.unzipLocation + "/" + oldResourceId.replace(" ", "");
            filename = oldSplittedResourceId[oldSplittedResourceId.length - 1];
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
            contentType = mimetypesFileTypeMap.getContentType(filename);
            contentResource = attachmentHelper.createContentResource(fullFilePath, filename, contentType);
            if (contentResource == null) {
                throw new RuntimeException("resourceId is null");
            }
            resourceId = contentResource.getId();
            updatedText.append(splittedString[i].substring(0, splittedString[i].indexOf("\"") + 1));
            updatedText.append(prependString);
            updatedText.append(resourceId);
            updatedText.append(splittedString[i].substring(endIndex));
        }
        return updatedText.toString();
    }

    public String makeFCKAttachmentFromRespondus(String text) {
        if (text == null) {
            return text;
        }
        String processedText = XmlUtil.processFormattedText(text);
        if (this.unzipLocation == null || text.equals("")) {
            return processedText;
        }
        String accessURL = ServerConfigurationService.getAccessUrl();
        AssessmentService.getContentHostingService();
        String referenceRoot = "/content";
        String url = accessURL + referenceRoot;
        String finalString = this.makeImageAttachment(text, url);
        return finalString;
    }

    private String makeImageAttachment(String text, String url) {
        String splitDelimiter = "<img alt=\"\" src=\"";
        String[] splittedString = text.split(splitDelimiter);
        if (splittedString.length == 1) {
            return this.makeAudioAttachment(text, url);
        }
        String prependString = splitDelimiter + url;
        ContentResource contentResource = null;
        String resourceId = null;
        String filename = "";
        StringBuffer updatedText = new StringBuffer(splittedString[0]);
        int endIndex = 0;
        for (int i = 1; i < splittedString.length; ++i) {
            endIndex = splittedString[i].indexOf("\"");
            filename = splittedString[i].substring(0, endIndex);
            contentResource = this.makeContentResource(filename);
            if (contentResource == null) {
                throw new RuntimeException("resourceId is null");
            }
            resourceId = contentResource.getId();
            updatedText.append(prependString);
            updatedText.append(resourceId);
            updatedText.append(this.makeAudioAttachment(splittedString[i].substring(endIndex), url));
        }
        return updatedText.toString();
    }

    private String makeAudioAttachment(String text, String url) {
        String splitDelimiter = "<embed src=\"";
        String[] splittedString = text.split(splitDelimiter);
        if (splittedString.length == 1) {
            return this.makeOtherAttachment(text, url);
        }
        String prependString = splitDelimiter + url;
        ContentResource contentResource = null;
        String resourceId = null;
        String filename = "";
        StringBuffer updatedText = new StringBuffer(splittedString[0]);
        int endIndex = 0;
        for (int i = 1; i < splittedString.length; ++i) {
            String s = splittedString[i];
            endIndex = splittedString[i].indexOf("\"");
            filename = splittedString[i].substring(0, endIndex);
            contentResource = this.makeContentResource(filename);
            if (contentResource == null) {
                throw new RuntimeException("resourceId is null");
            }
            resourceId = contentResource.getId();
            updatedText.append(prependString);
            updatedText.append(resourceId);
            updatedText.append("\" type=\"application/x-shockwave-flash");
            updatedText.append(this.makeOtherAttachment(splittedString[i].substring(endIndex), url));
        }
        return updatedText.toString();
    }

    private String makeOtherAttachment(String text, String url) {
        String splitDelimiter = "<a href=\"";
        String[] splittedString = text.split(splitDelimiter);
        if (splittedString.length == 1) {
            return text;
        }
        String prependString = splitDelimiter + url;
        ContentResource contentResource = null;
        String resourceId = null;
        String filename = "";
        StringBuffer updatedText = new StringBuffer(splittedString[0]);
        int endIndex = 0;
        for (int i = 1; i < splittedString.length; ++i) {
            endIndex = splittedString[i].indexOf("\"");
            filename = splittedString[i].substring(0, endIndex);
            contentResource = this.makeContentResource(filename);
            if (contentResource == null) {
                throw new RuntimeException("resourceId is null");
            }
            resourceId = contentResource.getId();
            updatedText.append(prependString);
            updatedText.append(resourceId);
            updatedText.append("\" target=\"_blank\"");
            updatedText.append(splittedString[i].substring(endIndex));
        }
        return updatedText.toString();
    }

    private ContentResource makeContentResource(String filename) {
        AttachmentHelper attachmentHelper = new AttachmentHelper();
        StringBuffer fullFilePath = new StringBuffer(this.unzipLocation);
        fullFilePath.append("/");
        fullFilePath.append(filename);
        MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
        String contentType = mimetypesFileTypeMap.getContentType(filename);
        ContentResource contentResource = attachmentHelper.createContentResource(fullFilePath.toString(), filename, contentType);
        return contentResource;
    }

    public String makeFCKAttachment(List respondueTextList) {
        if (respondueTextList == null || respondueTextList.size() == 0) {
            return "";
        }
        String accessURL = ServerConfigurationService.getAccessUrl();
        AssessmentService.getContentHostingService();
        String referenceRoot = "/content";
        String prependString = accessURL + referenceRoot;
        ContentResource contentResource = null;
        AttachmentHelper attachmentHelper = new AttachmentHelper();
        String resourceId = null;
        String contentType = "";
        String filename = "";
        StringBuffer fullFilePath = null;
        Iterator iter = respondueTextList.iterator();
        String itemText = "";
        String formattedText = "";
        StringBuffer updatedText = new StringBuffer();
        while (iter.hasNext()) {
            itemText = (String)iter.next();
            formattedText = XmlUtil.processFormattedText(itemText);
            String[] splittedText = (formattedText = formattedText.replaceAll("\\?\\?", " ")).split(":::");
            if ("mattext".equals(splittedText[0])) {
                String correctedText = splittedText[1].replaceAll("&lt;!-- RspA --&gt;", "");
                updatedText.append(correctedText);
                continue;
            }
            if (!"matimage".equals(splittedText[0])) continue;
            contentType = splittedText[1];
            filename = splittedText[2];
            fullFilePath = new StringBuffer(this.unzipLocation);
            fullFilePath.append("/");
            fullFilePath.append(filename);
            contentResource = attachmentHelper.createContentResource(fullFilePath.toString(), filename, contentType);
            if (contentResource != null) {
                resourceId = contentResource.getId();
                updatedText.append("<img src=\"");
                updatedText.append(prependString);
                updatedText.append(resourceId);
                updatedText.append("\"/>");
                continue;
            }
            throw new RuntimeException("resourceId is null");
        }
        return updatedText.toString();
    }

    private String getImportedPrependString(String text) {
        String accessPath = ServerConfigurationService.getAccessPath();
        AssessmentService.getContentHostingService();
        String referenceRoot = "/content";
        String importedPrependString = accessPath + referenceRoot;
        String[] splittedString = text.split("src=\"");
        for (int i = 0; i < splittedString.length; ++i) {
            String[] splittedRefString = splittedString[i].split("href=\"");
            for (int j = 0; j < splittedRefString.length; ++j) {
                if (splittedRefString[j].indexOf(importedPrependString) <= -1) continue;
                int length = importedPrependString.length();
                return splittedRefString[j].substring(0, splittedRefString[j].indexOf(importedPrependString) + length);
            }
        }
        return null;
    }

    public void updateQuestionPool(QuestionPoolFacade questionpool, Map assessmentMap) {
        String title = (String)assessmentMap.get("title");
        questionpool.setDescription((String)assessmentMap.get("description"));
        questionpool.setLastModified(new Date());
        questionpool.setOrganizationName((String)assessmentMap.get("ASSESSMENT_ORGANIZATIONNAME"));
        questionpool.setObjectives((String)assessmentMap.get("ASSESSMENT_OBJECTIVES"));
        questionpool.setKeywords((String)assessmentMap.get("ASSESSMENT_KEYWORDS"));
        questionpool.setRubric((String)assessmentMap.get("ASSESSMENT_RUBRICS"));
        questionpool.setIntellectualPropertyId((Long)assessmentMap.get("INTELLECTUALPROPERTYID"));
        log.debug("QPOOL ASSESSMENT updating metadata information");
    }

    public void updateSection(SectionFacade section, Map sectionMap) {
        section.setTitle(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((String)((String)sectionMap.get("title"))));
        section.setDescription(this.makeFCKAttachment((String)sectionMap.get("description")));
        section.addSectionMetaData("SECTION_KEYWORDS", (String)sectionMap.get("keyword"));
        section.addSectionMetaData("SECTION_OBJECTIVES", (String)sectionMap.get("objective"));
        section.addSectionMetaData("SECTION_RUBRICS", (String)sectionMap.get("rubric"));
        String qorderString = (String)sectionMap.get("questions-ordering");
        if (StringUtils.isNotBlank((CharSequence)qorderString) && StringUtils.isNumeric((CharSequence)qorderString)) {
            section.addSectionMetaData("QUESTIONS_ORDERING", qorderString);
        } else {
            section.addSectionMetaData("QUESTIONS_ORDERING", SectionDataIfc.AS_LISTED_ON_ASSESSMENT_PAGE.toString());
        }
    }

    public void updateItem(ItemFacade item, Item itemXml) {
        this.updateItem(item, itemXml, false);
    }

    public void updateItem(ItemFacade item, Item itemXml, boolean isRespondus) {
        Map itemMap = this.mapItem(itemXml, isRespondus);
        this.updateItem(item, itemXml, itemMap, isRespondus);
    }

    public void updateItem(ItemFacade item, Item itemXml, Map itemMap) {
        this.updateItem(item, itemXml, itemMap, false);
    }

    public void updateItem(ItemFacade item, Item itemXml, Map itemMap, boolean isRespondus) {
        String title = (String)itemMap.get("title");
        item.setDescription(title);
        List metalist = (List)itemMap.get("metadata");
        MetaDataList metadataList = new MetaDataList(metalist);
        metadataList.addTo(item);
        Long typeId = null;
        if (isRespondus) {
            typeId = ItemTypeExtractionStrategy.calculate(itemMap);
        } else {
            log.debug("itemMap=" + itemMap);
            String qmd = item.getItemMetaDataByLabel("qmd_itemtype");
            String itemIntrospect = (String)itemMap.get("itemIntrospect");
            log.debug("Calling ItemTypeExtractionStrategy.calculate(");
            log.debug("    title=" + title);
            log.debug("    , itemIntrospect=" + itemIntrospect);
            log.debug("    ,  qmd=" + qmd);
            log.debug(");");
            typeId = ItemTypeExtractionStrategy.calculate(title, itemIntrospect, qmd);
        }
        item.setTypeId(typeId);
        this.addItemProperties(item, itemMap, isRespondus);
        HashMap<String, String> varequalLinkrefidMap = null;
        HashMap<String, String> allFeedbacksMap = new HashMap<String, String>();
        if (isRespondus) {
            List allFeedbackList;
            List varequalLinkrefidMappingList = (List)itemMap.get("varequalLinkrefidMapping");
            varequalLinkrefidMap = new HashMap<String, String>();
            if (varequalLinkrefidMappingList != null) {
                Iterator iter = varequalLinkrefidMappingList.iterator();
                String[] vl = null;
                while (iter.hasNext()) {
                    vl = ((String)iter.next()).split(":::");
                    varequalLinkrefidMap.put(vl[0], vl[1]);
                }
            }
            if ((allFeedbackList = (List)itemMap.get("allFeedbacks")) != null) {
                String[] af = null;
                Object feedbackList = null;
                String s = null;
                for (int i = 0; i < allFeedbackList.size(); ++i) {
                    s = (String)allFeedbackList.get(i);
                    af = s.split(":::");
                    if (af.length == 2) {
                        allFeedbacksMap.put(af[0], af[1]);
                        continue;
                    }
                    log.warn("allFeedbackMap size != 2 on " + s);
                }
            }
            this.addRespondusFeedbacks(item, allFeedbacksMap, typeId);
        } else {
            this.addFeedback(item, itemMap, typeId);
        }
        if (TypeIfc.FILL_IN_BLANK.longValue() == typeId.longValue()) {
            if (isRespondus) {
                this.addRespondusFibTextAndAnswers(item, itemMap);
            } else {
                this.addFibTextAndAnswers(item, itemMap);
            }
        } else if (TypeIfc.FILL_IN_NUMERIC.longValue() == typeId.longValue()) {
            this.addFibTextAndAnswers(item, itemMap);
        } else if (TypeIfc.MATCHING.longValue() == typeId.longValue()) {
            if (isRespondus) {
                this.addRespondusMatchTextAndAnswers(item, itemMap);
            } else {
                this.addMatchTextAndAnswers(item, itemMap);
            }
        } else if (TypeIfc.MATRIX_CHOICES_SURVEY.longValue() == typeId.longValue()) {
            this.addMatrixSurveyTextAndAnswers(item, itemMap);
        } else if (TypeIfc.EXTENDED_MATCHING_ITEMS.longValue() == typeId.longValue()) {
            this.addExtendedMatchingItemsTextAndAnswers(item, itemXml, itemMap);
        } else if (TypeIfc.CALCULATED_QUESTION.longValue() == typeId.longValue()) {
            this.addCalculatedQuestionAnswers(item, itemMap);
        } else if (isRespondus) {
            this.addRespondusTextAndAnswers(item, itemMap, varequalLinkrefidMap, allFeedbacksMap);
        } else {
            this.addTextAndAnswers(item, itemMap);
        }
    }

    private void addItemProperties(ItemFacade item, Map itemMap, boolean isRespondus) {
        String score = "0";
        if (isRespondus) {
            if (item.getTypeId().equals(TypeIfc.ESSAY_QUESTION)) {
                score = "1";
            } else if (item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.FILL_IN_BLANK) || item.getTypeId().equals(TypeIfc.MATCHING) || item.getTypeId().equals(TypeIfc.CALCULATED_QUESTION)) {
                score = (String)itemMap.get("score");
            } else {
                List scoreList = (List)itemMap.get("scoreList");
                Iterator iter = scoreList.iterator();
                StringBuffer buf = new StringBuffer();
                while (iter.hasNext()) {
                    buf.append((String)iter.next());
                }
                score = buf.toString();
            }
        } else {
            score = (String)itemMap.get("score");
        }
        String discount = (String)itemMap.get("discount");
        String hasRationale = item.getItemMetaDataByLabel("hasRationale");
        String status = (String)itemMap.get("status");
        String createdBy = (String)itemMap.get("createdBy");
        String partialCreditFlag = item.getItemMetaDataByLabel("PARTIAL_CREDIT");
        if (createdBy == null) {
            createdBy = "Imported by Sakai";
        }
        String createdDate = (String)itemMap.get("createdDate");
        item.setInstruction((String)itemMap.get("instruction"));
        item.setScore(Double.valueOf(this.getValidDouble(score)));
        item.setDiscount(Double.valueOf(this.getValidDouble(discount)));
        if (this.notNullOrEmpty(partialCreditFlag)) {
            item.setPartialCreditFlag(Boolean.valueOf(Boolean.parseBoolean(partialCreditFlag)));
        } else {
            item.setPartialCreditFlag(Boolean.FALSE);
        }
        item.setHint((String)itemMap.get("hint"));
        if (this.notNullOrEmpty(hasRationale)) {
            item.setHasRationale(Boolean.valueOf(hasRationale));
        }
        if (this.notNullOrEmpty(status)) {
            item.setStatus(Integer.valueOf(status));
        }
        item.setCreatedBy(createdBy);
        try {
            Iso8601DateFormat iso = new Iso8601DateFormat();
            Calendar cal = iso.parse(createdDate);
            item.setCreatedDate(cal.getTime());
        }
        catch (Exception ex) {
            item.setCreatedDate(new Date());
        }
        item.setLastModifiedBy("Sakai Import");
        item.setLastModifiedDate(new Date());
    }

    private void addRespondusFeedbacks(ItemFacade item, Map<String, String> map, Long typeId) {
        String type = null;
        String correctItemFeedback = "";
        String incorrectItemFeedback = "";
        String generalItemFeedback = "";
        if (typeId.equals(TypeIfc.ESSAY_QUESTION)) {
            generalItemFeedback = "";
        } else if (typeId.equals(TypeIfc.TRUE_FALSE)) {
            for (Map.Entry<String, String> af : map.entrySet()) {
                type = af.getKey();
                if (type.endsWith("_ALL")) {
                    generalItemFeedback = this.makeFCKAttachmentFromRespondus(af.getValue());
                    continue;
                }
                if (type.endsWith("_C")) {
                    correctItemFeedback = this.makeFCKAttachmentFromRespondus(af.getValue());
                    continue;
                }
                if (!type.endsWith("_IC")) continue;
                incorrectItemFeedback = this.makeFCKAttachmentFromRespondus(af.getValue());
            }
            correctItemFeedback = generalItemFeedback + correctItemFeedback;
            incorrectItemFeedback = generalItemFeedback + incorrectItemFeedback;
        } else {
            for (Map.Entry<String, String> af : map.entrySet()) {
                type = af.getKey();
                if (!type.endsWith("_ALL")) continue;
                generalItemFeedback = this.makeFCKAttachmentFromRespondus(af.getValue());
            }
            correctItemFeedback = generalItemFeedback;
            incorrectItemFeedback = generalItemFeedback;
        }
        item.setGeneralItemFeedback(generalItemFeedback);
        item.setCorrectItemFeedback(correctItemFeedback);
        item.setInCorrectItemFeedback(incorrectItemFeedback);
    }

    private void addFeedback(ItemFacade item, Map<String, String> map, Long typeId) {
        String correctItemFeedback = map.get("correctItemFeedback");
        String incorrectItemFeedback = map.get("incorrectItemFeedback");
        String generalItemFeedback = map.get("generalItemFeedback");
        if (generalItemFeedback == null) {
            generalItemFeedback = "";
        }
        if (TypeIfc.AUDIO_RECORDING.longValue() == typeId.longValue() || TypeIfc.FILE_UPLOAD.longValue() == typeId.longValue() || TypeIfc.ESSAY_QUESTION.longValue() == typeId.longValue()) {
            if (this.notNullOrEmpty(incorrectItemFeedback)) {
                generalItemFeedback = generalItemFeedback + " " + incorrectItemFeedback;
            }
            if (this.notNullOrEmpty(correctItemFeedback)) {
                generalItemFeedback = generalItemFeedback + " " + correctItemFeedback;
            }
        }
        if (this.notNullOrEmpty(correctItemFeedback)) {
            item.setCorrectItemFeedback(this.makeFCKAttachment(correctItemFeedback));
        }
        if (this.notNullOrEmpty(incorrectItemFeedback)) {
            item.setInCorrectItemFeedback(this.makeFCKAttachment(incorrectItemFeedback));
        }
        if (this.notNullOrEmpty(generalItemFeedback)) {
            item.setGeneralItemFeedback(this.makeFCKAttachment(generalItemFeedback));
        }
    }

    private void addTextAndAnswers(ItemFacade item, Map itemMap) {
        List itemTextList = (List)itemMap.get("itemText");
        HashSet<ItemText> itemTextSet = new HashSet<ItemText>();
        List answerFeedbackList = (List)itemMap.get("itemAnswerFeedback");
        ArrayList correctLabels = (ArrayList)itemMap.get("itemAnswerCorrectLabel");
        if (correctLabels == null) {
            correctLabels = new ArrayList();
        }
        ArrayList answerList = new ArrayList();
        List aList = (List)itemMap.get("itemAnswer");
        answerList = aList == null ? answerList : aList;
        for (int i = 0; i < itemTextList.size(); ++i) {
            ItemText itemText = new ItemText();
            String text = (String)itemTextList.get(i);
            if (text == null) {
                text = "";
            }
            text = text.replaceAll("\\?\\?", " ");
            log.debug("text: " + text);
            itemText.setText(this.makeFCKAttachment(text));
            itemText.setItem(item.getData());
            itemText.setSequence(Long.valueOf(i + 1));
            List sList = (List)itemMap.get("answerScore");
            List answerScoreList = sList == null ? new ArrayList() : sList;
            HashSet<Answer> answerSet = new HashSet<Answer>();
            char answerLabel = 'A';
            for (int a = 0; a < answerList.size(); ++a) {
                Answer answer = new Answer();
                String answerText = XmlUtil.processFormattedText((String)answerList.get(a));
                String ident = "";
                if (!this.notNullOrEmpty(answerText)) continue;
                answerText = answerText.replaceAll("\\?\\?", " ");
                log.debug("answerText: " + answerText);
                char c = answerLabel;
                answerLabel = (char)(answerLabel + 1);
                String label = "" + c;
                answer.setLabel(label);
                double score = 0.0;
                double discount = 0.0;
                answer.setIsCorrect(Boolean.FALSE);
                if (this.isCorrectLabel(label, correctLabels)) {
                    answer.setIsCorrect(Boolean.TRUE);
                }
                if (item.getTypeId().equals(TypeIfc.TRUE_FALSE)) {
                    if (answerText.equalsIgnoreCase("true")) {
                        answerText = "true";
                    }
                    if (answerText.equalsIgnoreCase("false")) {
                        answerText = "false";
                    }
                }
                score = this.getCorrectScore((ItemDataIfc)item, 1);
                discount = this.getCorrectDiscount((ItemDataIfc)item);
                log.debug("setting answer" + label + " score to:" + score);
                answer.setScore(Double.valueOf(score));
                log.debug("setting answer " + label + " discount to:" + discount);
                answer.setDiscount(Double.valueOf(discount));
                answer.setText(this.makeFCKAttachment(answerText));
                answer.setItemText((ItemTextIfc)itemText);
                answer.setItem(item.getData());
                int sequence = a + 1;
                answer.setSequence(Long.valueOf(sequence));
                if (item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT)) {
                    boolean MCSC;
                    HashSet<AnswerFeedback> set = new HashSet<AnswerFeedback>();
                    if (answerFeedbackList != null) {
                        AnswerFeedback answerFeedback = new AnswerFeedback();
                        answerFeedback.setAnswer((AnswerIfc)answer);
                        answerFeedback.setTypeId("General Feedback");
                        if (answerFeedbackList.get(sequence - 1) != null) {
                            answerFeedback.setText(this.makeFCKAttachment(XmlUtil.processFormattedText((String)answerFeedbackList.get(sequence - 1))));
                            set.add(answerFeedback);
                            answer.setAnswerFeedbackSet(set);
                        }
                    }
                    if (MCSC = itemMap.get("itemIntrospect").equals("Multiple Choice")) {
                        int indexInteger;
                        String strPCredit;
                        double fltPCredit;
                        Double pCredit;
                        long index = answer.getSequence();
                        if ((pCredit = Double.valueOf((fltPCredit = Double.parseDouble(strPCredit = answerScoreList.contains(indexInteger = Long.valueOf(--index).intValue()) ? (String)answerScoreList.get(indexInteger) : "0")) / item.getScore() * 100.0)).isNaN()) {
                            answer.setPartialCredit(Double.valueOf(0.0));
                        } else {
                            answer.setPartialCredit(pCredit);
                        }
                    }
                }
                answerSet.add(answer);
            }
            itemText.setAnswerSet(answerSet);
            itemTextSet.add(itemText);
        }
        item.setItemTextSet(itemTextSet);
    }

    private void addRespondusTextAndAnswers(ItemFacade item, Map itemMap, HashMap<String, String> varequalLinkrefidMap, HashMap<String, String> allFeedbacksMap) {
        List itemTextList = (List)itemMap.get("itemText");
        HashSet<ItemText> itemTextSet = new HashSet<ItemText>();
        List answerFeedbackList = (List)itemMap.get("itemAnswerFeedback");
        ArrayList correctLabels = (ArrayList)itemMap.get("itemAnswerCorrectLabel");
        if (correctLabels == null) {
            correctLabels = new ArrayList();
        }
        ArrayList<HashMap<String, String>> answerList = new ArrayList<HashMap<String, String>>();
        List aList = (List)itemMap.get("itemAnswer");
        List<HashMap<String, String>> list = answerList = aList == null ? answerList : aList;
        if (item.getTypeId().equals(TypeIfc.ESSAY_QUESTION)) {
            answerList.add(allFeedbacksMap);
        }
        for (int i = 0; i < itemTextList.size(); ++i) {
            ItemText itemText = new ItemText();
            itemText.setText(this.makeFCKAttachmentFromRespondus((String)itemTextList.get(i)));
            itemText.setItem(item.getData());
            itemText.setSequence(Long.valueOf(i + 1));
            ArrayList answerScoreList = new ArrayList();
            List sList = (List)itemMap.get("answerScore");
            answerScoreList = sList == null ? answerScoreList : sList;
            HashSet<Answer> answerSet = new HashSet<Answer>();
            char answerLabel = 'A';
            for (int a = 0; a < answerList.size(); ++a) {
                Answer answer = new Answer();
                if (item.getTypeId().equals(TypeIfc.ESSAY_QUESTION)) {
                    for (Map.Entry<String, String> entrySet : allFeedbacksMap.entrySet()) {
                        String allFeedback = entrySet.getValue();
                        answer.setText(this.makeFCKAttachmentFromRespondus(allFeedback));
                    }
                    answer.setIsCorrect(Boolean.TRUE);
                } else {
                    String answerText = (String)answerList.get(a);
                    if (this.notNullOrEmpty(answerText)) {
                        String[] data = answerText.split(":::");
                        String ident = data[0];
                        answer.setIsCorrect(Boolean.FALSE);
                        if (this.isCorrectLabel(ident, correctLabels)) {
                            answer.setIsCorrect(Boolean.TRUE);
                        }
                        answerText = data[1];
                        if (item.getTypeId().equals(TypeIfc.TRUE_FALSE)) {
                            if (answerText.equalsIgnoreCase("true")) {
                                answerText = "true";
                            }
                            if (answerText.equalsIgnoreCase("false")) {
                                answerText = "false";
                            }
                            answer.setText(answerText);
                        } else {
                            answer.setText(this.makeFCKAttachmentFromRespondus(answerText));
                        }
                        if (item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT)) {
                            String linkrefid;
                            HashSet<AnswerFeedback> set = new HashSet<AnswerFeedback>();
                            AnswerFeedback answerFeedback = new AnswerFeedback();
                            answerFeedback.setAnswer((AnswerIfc)answer);
                            answerFeedback.setTypeId("General Feedback");
                            if (varequalLinkrefidMap.get(ident) != null && ((linkrefid = varequalLinkrefidMap.get(ident)).endsWith("_C") || linkrefid.endsWith("_IC")) && allFeedbacksMap.get(linkrefid) != null) {
                                answerFeedback.setText(this.makeFCKAttachmentFromRespondus(allFeedbacksMap.get(linkrefid)));
                                set.add(answerFeedback);
                                answer.setAnswerFeedbackSet(set);
                            }
                        }
                    }
                }
                char c = answerLabel;
                answerLabel = (char)(answerLabel + 1);
                String label = "" + c;
                answer.setLabel(label);
                double score = 0.0;
                double discount = 0.0;
                score = this.getCorrectScore((ItemDataIfc)item, 1);
                discount = this.getCorrectDiscount((ItemDataIfc)item);
                log.debug("setting answer" + label + " score to:" + score);
                answer.setScore(Double.valueOf(score));
                log.debug("setting answer " + label + " discount to:" + discount);
                answer.setDiscount(Double.valueOf(discount));
                answer.setItemText((ItemTextIfc)itemText);
                answer.setItem(item.getData());
                int sequence = a + 1;
                answer.setSequence(Long.valueOf(sequence));
                answerSet.add(answer);
            }
            itemText.setAnswerSet(answerSet);
            itemTextSet.add(itemText);
        }
        item.setItemTextSet(itemTextSet);
    }

    private double getValidDouble(String scoreText) {
        if (StringUtils.isBlank((CharSequence)scoreText)) {
            return 0.0;
        }
        try {
            return Double.valueOf(scoreText);
        }
        catch (NumberFormatException e) {
            log.warn("Tried to parse this double in IMS-QTI extraction: {}", (Object)scoreText);
            return 0.0;
        }
    }

    private double getCorrectScore(ItemDataIfc item, int answerSize) {
        double score = 0.0;
        if (answerSize > 0 && item != null && item.getScore() != null) {
            score = item.getScore() / (double)answerSize;
        }
        return score;
    }

    private double getCorrectDiscount(ItemDataIfc item) {
        double discount = 0.0;
        if (item != null && item.getDiscount() != null) {
            discount = item.getDiscount();
        }
        return discount;
    }

    private boolean isCorrectLabel(String testLabel, ArrayList labels) {
        return testLabel != null && labels != null && labels.indexOf(testLabel) != -1;
    }

    private boolean isCorrectAnswer(String answerText, ArrayList correctLabels) {
        return answerText != null && correctLabels != null && correctLabels.indexOf(answerText) != -1;
    }

    private boolean isCorrectAnswer2(String answerText, ArrayList correctLabels) {
        if (answerText == null || correctLabels == null) {
            return false;
        }
        String[] data = answerText.split(":::");
        return correctLabels.indexOf(data[0]) != -1;
    }

    private void addFibTextAndAnswers(ItemFacade item, Map itemMap) {
        ArrayList<String> itemTextList = new ArrayList<String>();
        List iList = (List)itemMap.get("itemFibText");
        itemTextList = iList == null ? itemTextList : iList;
        ArrayList itemTList = new ArrayList();
        List tList = (List)itemMap.get("itemText");
        itemTList = iList == null ? itemTList : tList;
        HashSet<ItemText> itemTextSet = new HashSet<ItemText>();
        ItemText itemText = new ItemText();
        List answerFeedbackList = (List)itemMap.get("itemFeedback");
        ArrayList answerList = new ArrayList();
        List aList = (List)itemMap.get("itemFibAnswer");
        List list = answerList = aList == null ? answerList : aList;
        if (!itemTList.isEmpty() && !itemTextList.isEmpty() && itemTextList.size() <= 1) {
            try {
                String firstFib = XmlUtil.processFormattedText((String)itemTextList.get(0));
                String firstText = XmlUtil.processFormattedText((String)itemTList.get(0));
                if (firstFib.equals(firstText)) {
                    log.debug("Setting FIB instructional text.");
                    String newFirstFib = firstFib + "<br />" + itemTextList.get(0);
                    itemTextList.set(0, newFirstFib);
                }
            }
            catch (Exception ex) {
                log.warn("Thought we found an instructional text but couldn't put it in. " + ex);
            }
        }
        StringBuilder itemTextStringbuf = new StringBuilder();
        for (int i = 0; i < itemTextList.size(); ++i) {
            String text = (String)itemTextList.get(i);
            if (text == null) continue;
            itemTextStringbuf.append(text);
            if (i >= answerList.size()) continue;
            itemTextStringbuf.append(this.FIB_BLANK_INDICATOR);
        }
        String itemTextString = XmlUtil.processFormattedText(itemTextStringbuf.toString());
        itemTextString = itemTextString.replaceAll("\\?\\?", " ");
        log.debug("itemTextString=" + itemTextString);
        itemText.setText(this.makeFCKAttachment(itemTextString));
        itemText.setItem(item.getData());
        itemText.setSequence(Long.valueOf(0L));
        HashSet<Answer> answerSet = new HashSet<Answer>();
        char answerLabel = 'A';
        for (int a = 0; a < answerList.size(); ++a) {
            Answer answer = new Answer();
            String answerText = (String)answerList.get(a);
            if (!this.notNullOrEmpty(answerText)) continue;
            answerText = answerText.replaceAll("\\?\\?", " ");
            log.debug("answerText=" + answerText);
            char c = answerLabel;
            answerLabel = (char)(answerLabel + 1);
            String label = "" + c;
            answer.setLabel(label);
            answer.setText(this.makeFCKAttachment(answerText));
            answer.setItemText((ItemTextIfc)itemText);
            answer.setIsCorrect(Boolean.TRUE);
            double score = this.getCorrectScore((ItemDataIfc)item, 1);
            double discount = this.getCorrectDiscount((ItemDataIfc)item);
            log.debug("setting answer " + label + " score to:" + score);
            answer.setScore(Double.valueOf(score));
            log.debug("setting answer " + label + " discount to:" + discount);
            answer.setDiscount(Double.valueOf(discount));
            answer.setItem(item.getData());
            int sequence = a + 1;
            answer.setSequence(Long.valueOf(sequence));
            HashSet<AnswerFeedback> set = new HashSet<AnswerFeedback>();
            if (answerFeedbackList != null) {
                AnswerFeedback answerFeedback = new AnswerFeedback();
                answerFeedback.setAnswer((AnswerIfc)answer);
                answerFeedback.setTypeId("General Feedback");
                if (answerFeedbackList.get(sequence - 1) != null) {
                    answerFeedback.setText(this.makeFCKAttachment((String)answerFeedbackList.get(sequence - 1)));
                    set.add(answerFeedback);
                    answer.setAnswerFeedbackSet(set);
                }
            }
            answerSet.add(answer);
        }
        itemText.setAnswerSet(answerSet);
        itemTextSet.add(itemText);
        item.setItemTextSet(itemTextSet);
    }

    private void addRespondusFibTextAndAnswers(ItemFacade item, Map itemMap) {
        HashSet<ItemText> itemTextSet = new HashSet<ItemText>();
        ItemText itemText = new ItemText();
        List answerFeedbackList = (List)itemMap.get("itemFeedback");
        ArrayList answerList = new ArrayList();
        List aList = (List)itemMap.get("itemFibAnswer");
        answerList = aList == null ? answerList : aList;
        List itemTextList = (List)itemMap.get("itemText");
        StringBuilder itemTextStringbuf = new StringBuilder();
        if (itemTextList != null && itemTextList.size() > 0) {
            itemTextStringbuf.append(this.makeFCKAttachmentFromRespondus((String)itemTextList.get(0)));
        }
        itemTextStringbuf.append(this.FIB_BLANK_INDICATOR);
        itemText.setText(itemTextStringbuf.toString());
        itemText.setItem(item.getData());
        itemText.setSequence(Long.valueOf(0L));
        HashSet<Answer> answerSet = new HashSet<Answer>();
        Answer answer = new Answer();
        StringBuilder answerTextStringbuf = new StringBuilder();
        for (int a = 0; a < answerList.size(); ++a) {
            String answerText = (String)answerList.get(a);
            if (!this.notNullOrEmpty(answerText)) continue;
            answerText = answerText.replaceAll("\\?\\?", " ");
            log.debug("answerText=" + answerText);
            answerTextStringbuf.append(answerText);
            if (a >= answerList.size() - 1) continue;
            answerTextStringbuf.append("|");
        }
        answer.setLabel("A");
        answer.setText(this.makeFCKAttachment(answerTextStringbuf.toString()));
        answer.setItemText((ItemTextIfc)itemText);
        answer.setIsCorrect(Boolean.TRUE);
        answer.setScore(Double.valueOf(item.getScore()));
        answer.setItem(item.getData());
        answer.setSequence(Long.valueOf(1L));
        answerSet.add(answer);
        itemText.setAnswerSet(answerSet);
        itemTextSet.add(itemText);
        item.setItemTextSet(itemTextSet);
    }

    private void addMatchTextAndAnswers(ItemFacade item, Map itemMap) {
        List sourceList = (List)itemMap.get("itemMatchSourceText");
        List targetList = (List)itemMap.get("itemMatchTargetText");
        List indexList = (List)itemMap.get("itemMatchIndex");
        List answerFeedbackList = (List)itemMap.get("itemFeedback");
        List correctMatchFeedbackList = (List)itemMap.get("itemMatchCorrectFeedback");
        List incorrectMatchFeedbackList = (List)itemMap.get("itemMatchIncorrectFeedback");
        List itemTextList = (List)itemMap.get("itemText");
        sourceList = sourceList == null ? new ArrayList() : sourceList;
        targetList = targetList == null ? new ArrayList() : targetList;
        indexList = indexList == null ? new ArrayList() : indexList;
        answerFeedbackList = answerFeedbackList == null ? new ArrayList() : answerFeedbackList;
        correctMatchFeedbackList = correctMatchFeedbackList == null ? new ArrayList() : correctMatchFeedbackList;
        incorrectMatchFeedbackList = incorrectMatchFeedbackList == null ? new ArrayList() : incorrectMatchFeedbackList;
        log.debug("*** original incorrect order");
        for (int i = 0; i < incorrectMatchFeedbackList.size(); ++i) {
            log.debug("incorrectMatchFeedbackList.get(" + i + ")=" + incorrectMatchFeedbackList.get(i));
        }
        int maxNumCorrectFeedback = sourceList.size();
        int numIncorrectFeedback = incorrectMatchFeedbackList.size();
        if (maxNumCorrectFeedback > 0 && numIncorrectFeedback > 0) {
            incorrectMatchFeedbackList = this.reassembleIncorrectMatches(incorrectMatchFeedbackList, maxNumCorrectFeedback);
        }
        log.debug("*** NEW order");
        for (int i = 0; i < incorrectMatchFeedbackList.size(); ++i) {
            log.debug("incorrectMatchFeedbackList.get(" + i + ")=" + incorrectMatchFeedbackList.get(i));
        }
        List list = itemTextList = itemTextList == null ? new ArrayList() : itemTextList;
        if (targetList.size() < indexList.size()) {
            log.debug("targetList.size(): " + targetList.size());
            log.debug("indexList.size(): " + indexList.size());
        }
        String itemTextString = "";
        if (itemTextList.size() > 0) {
            itemTextString = XmlUtil.processFormattedText((String)itemTextList.get(0));
        }
        HashSet<ItemText> itemTextSet = new HashSet<ItemText>();
        if (itemTextString == null) {
            itemTextString = "";
        }
        itemTextString = itemTextString.replaceAll("\\?\\?", " ");
        log.debug("item.setInstruction itemTextString: " + itemTextString);
        item.setInstruction(itemTextString);
        for (int i = 0; i < sourceList.size(); ++i) {
            String sourceText = (String)sourceList.get(i);
            if (sourceText == null) {
                sourceText = "";
            }
            sourceText = sourceText.replaceAll("\\?\\?", " ");
            log.debug("sourceText: " + sourceText);
            ItemText sourceItemText = new ItemText();
            sourceItemText.setText(this.makeFCKAttachment(sourceText));
            sourceItemText.setItem(item.getData());
            sourceItemText.setSequence(Long.valueOf(i + 1));
            HashSet<Answer> targetSet = new HashSet<Answer>();
            int targetIndex = 999;
            try {
                targetIndex = Integer.parseInt((String)indexList.get(i));
            }
            catch (NumberFormatException ex) {
                log.warn("No match for " + sourceText + ".");
            }
            catch (IndexOutOfBoundsException ex) {
                log.error("Corrupt index list.  Cannot assign match for: " + sourceText + ".");
            }
            char answerLabel = 'A';
            for (int a = 0; a < targetList.size(); ++a) {
                String fb;
                String targetString = XmlUtil.processFormattedText((String)targetList.get(a));
                if (targetString == null) {
                    targetString = "";
                }
                targetString = targetString.replaceAll("\\?\\?", " ");
                log.debug("targetString: " + targetString);
                Answer target = new Answer();
                HashSet<AnswerFeedback> answerFeedbackSet = new HashSet<AnswerFeedback>();
                if (correctMatchFeedbackList.size() > i) {
                    fb = (String)correctMatchFeedbackList.get(i);
                    answerFeedbackSet.add(new AnswerFeedback((AnswerIfc)target, "Correct Feedback", fb));
                }
                if (incorrectMatchFeedbackList.size() > i) {
                    fb = (String)incorrectMatchFeedbackList.get(i);
                    log.debug("setting incorrect fb=" + fb);
                    answerFeedbackSet.add(new AnswerFeedback((AnswerIfc)target, "InCorrect Feedback", fb));
                }
                target.setAnswerFeedbackSet(answerFeedbackSet);
                char c = answerLabel;
                answerLabel = (char)(answerLabel + 1);
                String label = "" + c;
                target.setLabel(label);
                target.setText(this.makeFCKAttachment(targetString));
                target.setItemText((ItemTextIfc)sourceItemText);
                target.setItem(item.getData());
                target.setSequence(Long.valueOf(a + 1));
                double score = this.getCorrectScore((ItemDataIfc)item, 1);
                double discount = this.getCorrectDiscount((ItemDataIfc)item);
                int index = a + i * targetList.size();
                String correctStatus = (String)indexList.get(index);
                if ("CorrectMatch".equals(correctStatus)) {
                    target.setIsCorrect(Boolean.TRUE);
                    log.debug("source: " + sourceText + " matches target: " + targetString);
                } else {
                    target.setIsCorrect(Boolean.FALSE);
                }
                log.debug("setting answer " + a + " score to:" + score);
                target.setScore(Double.valueOf(score));
                target.setDiscount(Double.valueOf(discount));
                if (answerFeedbackList != null) {
                    HashSet<AnswerFeedback> targetFeedbackSet = new HashSet<AnswerFeedback>();
                    AnswerFeedback tAnswerFeedback = new AnswerFeedback();
                    tAnswerFeedback.setAnswer((AnswerIfc)target);
                    tAnswerFeedback.setTypeId("General Feedback");
                    String targetFeedback = "";
                    if (answerFeedbackList.size() > 0) {
                        targetFeedback = (String)answerFeedbackList.get(targetIndex);
                    }
                    if (targetFeedback.length() > 0) {
                        tAnswerFeedback.setText(this.makeFCKAttachment(targetFeedback));
                        targetFeedbackSet.add(tAnswerFeedback);
                        target.setAnswerFeedbackSet(targetFeedbackSet);
                    }
                }
                targetSet.add(target);
            }
            sourceItemText.setAnswerSet(targetSet);
            itemTextSet.add(sourceItemText);
        }
        item.setItemTextSet(itemTextSet);
    }

    private void addRespondusMatchTextAndAnswers(ItemFacade item, Map itemMap) throws RespondusMatchingException {
        List sourceList = (List)itemMap.get("itemMatchSourceText");
        List targetList = (List)itemMap.get("itemAnswer");
        List correctList = (List)itemMap.get("itemMatchingAnswerCorrect");
        sourceList = sourceList == null ? new ArrayList() : sourceList;
        targetList = targetList == null ? new ArrayList() : targetList;
        correctList = correctList == null ? new ArrayList() : correctList;
        List itemTextList = (List)itemMap.get("itemText");
        if (itemTextList != null && itemTextList.size() > 0) {
            item.setInstruction(this.makeFCKAttachmentFromRespondus((String)itemTextList.get(0)));
        }
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        if (sourceList != null) {
            Iterator iter = sourceList.iterator();
            String[] s = null;
            while (iter.hasNext()) {
                s = ((String)iter.next()).split(":::");
                sourceMap.put(s[0], s[1]);
            }
        }
        HashMap<String, String> targetMap = new HashMap<String, String>();
        if (targetList != null) {
            Iterator iter = targetList.iterator();
            String[] s = null;
            while (iter.hasNext()) {
                s = ((String)iter.next()).split(":::");
                targetMap.put(s[0], s[1]);
            }
        }
        HashMap<String, String> correctMap = new HashMap<String, String>();
        if (correctList != null) {
            Iterator iter = correctList.iterator();
            String[] s = null;
            while (iter.hasNext()) {
                s = ((String)iter.next()).split(":::");
                correctMap.put(s[0], s[1]);
            }
        }
        HashSet<ItemText> itemTextSet = new HashSet<ItemText>();
        String ident = "";
        String correctVar = "";
        String sourceText = "";
        String targetText = "";
        int itemSequence = 1;
        for (Map.Entry source : sourceMap.entrySet()) {
            char answerLabel = 'A';
            sourceText = (String)source.getValue();
            if (sourceText == null) {
                sourceText = "";
            }
            sourceText = sourceText.replaceAll("\\?\\?", " ");
            log.debug("sourceText: " + sourceText);
            ItemText sourceItemText = new ItemText();
            int answerSequence = 1;
            HashSet<Answer> targetSet = new HashSet<Answer>();
            for (Map.Entry target : targetMap.entrySet()) {
                targetText = (String)target.getValue();
                if (targetText == null) {
                    targetText = "";
                }
                targetText = targetText.replaceAll("\\?\\?", " ");
                log.debug("targetText: " + targetText);
                Answer answer = new Answer();
                char c = answerLabel;
                answerLabel = (char)(answerLabel + 1);
                String label = "" + c;
                answer.setLabel(label);
                answer.setText(this.makeFCKAttachmentFromRespondus(targetText));
                answer.setItemText((ItemTextIfc)sourceItemText);
                answer.setItem(item.getData());
                answer.setSequence(Long.valueOf(answerSequence++));
                answer.setScore(Double.valueOf(this.getCorrectScore((ItemDataIfc)item, 1)));
                ident = (String)source.getKey();
                correctVar = (String)correctMap.get(ident);
                if (((String)target.getKey()).equals(correctVar)) {
                    answer.setIsCorrect(Boolean.TRUE);
                } else {
                    answer.setIsCorrect(Boolean.FALSE);
                }
                targetSet.add(answer);
            }
            sourceItemText.setText(this.makeFCKAttachmentFromRespondus(sourceText));
            sourceItemText.setItem(item.getData());
            sourceItemText.setSequence(Long.valueOf(itemSequence++));
            sourceItemText.setAnswerSet(targetSet);
            itemTextSet.add(sourceItemText);
        }
        HashSet<String> correctAnswers = new HashSet<String>();
        HashSet<String> allAnswers = new HashSet<String>();
        for (ItemText itemText : itemTextSet) {
            Set answers = itemText.getAnswerSet();
            for (AnswerIfc answer : answers) {
                allAnswers.add(answer.getText());
                if (!answer.getIsCorrect().booleanValue()) continue;
                correctAnswers.add(answer.getText());
            }
        }
        if (!correctAnswers.containsAll(allAnswers)) {
            throw new RespondusMatchingException("All answers do not have a valid choice.");
        }
        item.setItemTextSet(itemTextSet);
    }

    private void addMatrixSurveyTextAndAnswers(ItemFacade item, Map itemMap) {
        List sourceList = (List)itemMap.get("itemMatchSourceText");
        List targetList = (List)itemMap.get("itemMatchTargetText");
        List itemTextList = (List)itemMap.get("itemText");
        sourceList = sourceList == null ? new ArrayList() : sourceList;
        targetList = targetList == null ? new ArrayList() : targetList;
        itemTextList = itemTextList == null ? new ArrayList() : itemTextList;
        String itemTextString = "";
        if (itemTextList.size() > 0) {
            itemTextString = XmlUtil.processFormattedText((String)itemTextList.get(0));
        }
        HashSet<ItemText> itemTextSet = new HashSet<ItemText>();
        if (itemTextString == null) {
            itemTextString = "";
        }
        itemTextString = itemTextString.replaceAll("\\?\\?", " ");
        log.debug("item.setInstruction itemTextString: " + itemTextString);
        item.setInstruction(itemTextString);
        for (int i = 0; i < targetList.size(); ++i) {
            String sourceText = XmlUtil.processFormattedText((String)targetList.get(i));
            if (sourceText == null) {
                sourceText = "";
            }
            sourceText = sourceText.replaceAll("\\?\\?", " ");
            log.debug("sourceText: " + sourceText);
            ItemText sourceItemText = new ItemText();
            sourceItemText.setText(this.makeFCKAttachment(sourceText));
            sourceItemText.setItem(item.getData());
            sourceItemText.setSequence(Long.valueOf(i + 1));
            HashSet<Answer> targetSet = new HashSet<Answer>();
            char answerLabel = 'A';
            for (int a = 0; a < sourceList.size(); ++a) {
                String targetString = XmlUtil.processFormattedText((String)sourceList.get(a));
                if (targetString == null) {
                    targetString = "";
                }
                targetString = targetString.replaceAll("\\?\\?", " ");
                log.debug("targetString: " + targetString);
                Answer target = new Answer();
                HashSet answerFeedbackSet = new HashSet();
                target.setAnswerFeedbackSet(answerFeedbackSet);
                char c = answerLabel;
                answerLabel = (char)(answerLabel + 1);
                String label = "" + c;
                target.setLabel(label);
                target.setText(this.makeFCKAttachment(targetString));
                target.setItemText((ItemTextIfc)sourceItemText);
                target.setItem(item.getData());
                target.setSequence(Long.valueOf(a + 1));
                double score = 0.0;
                double discount = 0.0;
                log.debug("setting answer " + a + " score to:" + score);
                target.setScore(Double.valueOf(score));
                target.setDiscount(Double.valueOf(discount));
                targetSet.add(target);
            }
            sourceItemText.setAnswerSet(targetSet);
            itemTextSet.add(sourceItemText);
        }
        item.setItemTextSet(itemTextSet);
    }

    private List reassembleIncorrectMatches(List list, int n) {
        if (n < 0) {
            n = -n;
        }
        if (n == 0) {
            return list;
        }
        if (list == null) {
            list = new ArrayList<String>();
        }
        for (int i = 0; i < n && list.size() < n + 1; ++i) {
            list.add("");
        }
        ArrayList newList = new ArrayList();
        newList.add(list.get(n - 1));
        for (int i = 0; i < n - 1; ++i) {
            String s = (String)list.get(i);
            newList.add(s);
        }
        return newList;
    }

    private void addCalculatedQuestionAnswers(ItemFacade item, Map itemMap) {
        String forDecimalPlaces;
        String forTolerance;
        String forText;
        Answer answer;
        String varDecimalPlaces;
        String varMax;
        String varMin;
        int j;
        HashSet<Answer> answerSet;
        ItemText itemText;
        char answerLabel;
        int i;
        String instruction;
        List variableNames = (List)itemMap.get("variableNames");
        List variableMins = (List)itemMap.get("variableMins");
        List variableMaxs = (List)itemMap.get("variableMaxs");
        List variableDecimalPlaces = (List)itemMap.get("variableDecimalPlaces");
        List formulaNames = (List)itemMap.get("formulaNames");
        List formulaTexts = (List)itemMap.get("formulaTexts");
        List formulaTolerances = (List)itemMap.get("formulaTolerances");
        List formulaDecimalPlaces = (List)itemMap.get("formulaDecimalPlaces");
        List instructions = (List)itemMap.get("itemText");
        if (instructions.size() > 0 && (instruction = (String)instructions.get(0)) != null && instruction.length() > 0) {
            instruction = XmlUtil.processFormattedText((String)instructions.get(0));
            instruction = instruction.replaceAll("\\?\\?", " ");
            item.setInstruction(this.makeFCKAttachment(instruction));
        }
        HashSet<ItemText> itemTextSet = new HashSet<ItemText>();
        for (i = 0; i < variableNames.size(); ++i) {
            answerLabel = 'A';
            itemText = new ItemText();
            itemText.setText((String)variableNames.get(i));
            itemText.setItem(item.getData());
            itemText.setSequence(Long.valueOf(i + 1));
            answerSet = new HashSet<Answer>();
            for (j = 0; j < variableNames.size(); ++j) {
                varMin = (String)variableMins.get(j);
                varMax = (String)variableMaxs.get(j);
                varDecimalPlaces = (String)variableDecimalPlaces.get(j);
                answer = new Answer();
                answer.setItem(item.getData());
                answer.setItemText((ItemTextIfc)itemText);
                char c = answerLabel;
                answerLabel = (char)(answerLabel + 1);
                answer.setLabel("" + c);
                answer.setText(varMin + "|" + varMax + "," + varDecimalPlaces);
                answer.setSequence(Long.valueOf(j + 1));
                answer.setIsCorrect(Boolean.valueOf(i == j));
                answerSet.add(answer);
            }
            for (j = 0; j < formulaNames.size(); ++j) {
                forText = (String)formulaTexts.get(j);
                forTolerance = (String)formulaTolerances.get(j);
                forDecimalPlaces = (String)formulaDecimalPlaces.get(j);
                answer = new Answer();
                answer.setItem(item.getData());
                answer.setItemText((ItemTextIfc)itemText);
                char c = answerLabel;
                answerLabel = (char)(answerLabel + '\u0001');
                answer.setLabel("" + c);
                answer.setText(forText + "|" + forTolerance + "," + forDecimalPlaces);
                answer.setSequence(Long.valueOf(variableNames.size() + j + 1));
                answer.setIsCorrect(Boolean.FALSE);
                answerSet.add(answer);
            }
            itemText.setAnswerSet(answerSet);
            itemTextSet.add(itemText);
        }
        for (i = 0; i < formulaNames.size(); ++i) {
            answerLabel = 'A';
            itemText = new ItemText();
            itemText.setText((String)formulaNames.get(i));
            itemText.setItem(item.getData());
            itemText.setSequence(Long.valueOf(variableNames.size() + i + 1));
            answerSet = new HashSet();
            for (j = 0; j < variableNames.size(); ++j) {
                varMin = (String)variableMins.get(j);
                varMax = (String)variableMaxs.get(j);
                varDecimalPlaces = (String)variableDecimalPlaces.get(j);
                answer = new Answer();
                answer.setItem(item.getData());
                answer.setItemText((ItemTextIfc)itemText);
                char c = answerLabel;
                answerLabel = (char)(answerLabel + '\u0001');
                answer.setLabel("" + c);
                answer.setText(varMin + "|" + varMax + "," + varDecimalPlaces);
                answer.setSequence(Long.valueOf(j + 1));
                answer.setIsCorrect(Boolean.FALSE);
                answerSet.add(answer);
            }
            for (j = 0; j < formulaNames.size(); ++j) {
                forText = (String)formulaTexts.get(j);
                forTolerance = (String)formulaTolerances.get(j);
                forDecimalPlaces = (String)formulaDecimalPlaces.get(j);
                answer = new Answer();
                answer.setItem(item.getData());
                answer.setItemText((ItemTextIfc)itemText);
                char c = answerLabel;
                answerLabel = (char)(answerLabel + '\u0001');
                answer.setLabel("" + c);
                answer.setText(forText + "|" + forTolerance + "," + forDecimalPlaces);
                answer.setSequence(Long.valueOf(variableNames.size() + j + 1));
                answer.setIsCorrect(Boolean.valueOf(i == j));
                answerSet.add(answer);
            }
            itemText.setAnswerSet(answerSet);
            itemTextSet.add(itemText);
        }
        item.setItemTextSet(itemTextSet);
    }

    private boolean notNullOrEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    public String getOverridePath() {
        return this.overridePath;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }

    public void setUnzipLocation(String unzipLocation) {
        this.unzipLocation = unzipLocation;
    }

    private String get(Map itemMap, String key) {
        return ((String)itemMap.get(key)).trim();
    }

    private List<String> getList(Map itemMap, String key) {
        return (List)itemMap.get(key);
    }

    private void addExtendedMatchingItemsTextAndAnswers(ItemFacade item, Item itemXml, Map itemMap) {
        itemMap = this.mapEMIItem(itemXml, false);
        TreeSet<ItemText> itemTextSet = new TreeSet<ItemText>();
        item.setItemTextSet(itemTextSet);
        item.setStatus(ItemDataIfc.ACTIVE_STATUS);
        itemTextSet.add(new ItemText((ItemData)item.getData(), ItemTextIfc.EMI_THEME_TEXT_SEQUENCE, this.get(itemMap, "theme"), null));
        boolean simple = "Simple".equals(this.get(itemMap, "answerOptions"));
        item.setAnswerOptionsSimpleOrRich(simple ? ItemDataIfc.ANSWER_OPTIONS_SIMPLE : ItemDataIfc.ANSWER_OPTIONS_RICH);
        HashMap<String, String> optionMap = new HashMap<String, String>();
        if (simple) {
            itemTextSet.add(this.makeEMISimpleOptions(item, this.getList(itemMap, "options"), optionMap));
            item.setAnswerOptionsRichCount(Integer.valueOf(0));
        } else {
            itemTextSet.add(this.makeEMIRichOptions(item, this.get(itemMap, "richOptionText"), this.getList(itemMap, "options"), optionMap));
        }
        itemTextSet.add(new ItemText((ItemData)item.getData(), ItemTextIfc.EMI_LEAD_IN_TEXT_SEQUENCE, this.get(itemMap, "leadin"), null));
        item.setScore(Double.valueOf(this.get(itemMap, "score")));
        item.setDiscount(Double.valueOf(this.get(itemMap, "discount")));
        itemTextSet.addAll(this.makeEMIItems(item, this.getList(itemMap, "items"), optionMap));
    }

    private Set<ItemAttachmentIfc> makeEMIAttachments(ItemFacade item, List<String> attachList) {
        if (attachList == null || attachList.isEmpty()) {
            return null;
        }
        TreeSet<ItemAttachmentIfc> attachSet = new TreeSet<ItemAttachmentIfc>();
        for (String attach : attachList) {
            attach = attach.trim();
            int index = attach.indexOf("[");
            String fileName = attach.substring(0, index);
            attach = attach.substring(index);
            index = attach.indexOf("]");
            String mimeType = attach.substring(1, index);
            index = attach.indexOf("(");
            attach = attach.substring(index);
            index = attach.indexOf(")");
            Long size = Long.valueOf(attach.substring(1, index));
            String location = attach = attach.substring(index + 1);
            String resourceId = location.replace("%2B", "+").replace("%20", " ").replace("/access/content", "");
            attachSet.add((ItemAttachmentIfc)new ItemAttachment(null, (ItemDataIfc)item, resourceId, fileName, mimeType, size, null, location, Boolean.valueOf(false), ItemAttachmentIfc.ACTIVE_STATUS, null, null, null, null));
        }
        return attachSet;
    }

    private ItemText makeEMISimpleOptions(ItemFacade item, List<String> options, Map<String, String> optionMap) {
        ItemText itemText = new ItemText((ItemData)item.getData(), ItemTextIfc.EMI_ANSWER_OPTIONS_SEQUENCE, "", null);
        TreeSet<Answer> answerSet = new TreeSet<Answer>();
        itemText.setAnswerSet(answerSet);
        long seq = 1L;
        for (String option : options) {
            option = option.trim();
            String text = option.substring(3).trim();
            Answer a = new Answer((ItemTextIfc)itemText, text, Long.valueOf(seq++), option.substring(1, 2));
            a.setIsCorrect(Boolean.FALSE);
            answerSet.add(a);
            optionMap.put(option.substring(1, 2), text);
        }
        return itemText;
    }

    private ItemText makeEMIRichOptions(ItemFacade item, String richText, List<String> options, Map<String, String> optionMap) {
        item.setAnswerOptionsRichCount(Integer.valueOf(options.size()));
        for (String option : options) {
            option = option.trim().substring(1, 2);
            optionMap.put(option, option);
        }
        ItemText itemText = new ItemText((ItemData)item.getData(), ItemTextIfc.EMI_ANSWER_OPTIONS_SEQUENCE, richText, null);
        return itemText;
    }

    private Set<ItemText> makeEMIItems(ItemFacade item, List<String> items, Map<String, String> optionMap) {
        TreeSet<ItemText> itemTextSet = new TreeSet<ItemText>();
        long seq = 1L;
        for (String itemdata : items) {
            itemdata = itemdata.trim();
            int index = itemdata.indexOf("|");
            int required = Integer.valueOf(itemdata.substring(1, index));
            itemdata = itemdata.substring(index + 1).trim();
            index = itemdata.indexOf("]");
            String grade = itemdata.substring(0, index);
            itemdata = itemdata.substring(index + 1).trim();
            index = itemdata.indexOf("@ATTACH@");
            String text = itemdata.substring(0, index).trim();
            itemdata = itemdata.substring(index + "@ATTACH@".length()).trim();
            TreeSet<Answer> answers = new TreeSet<Answer>();
            ItemText itemText = new ItemText((ItemData)item.getData(), Long.valueOf(seq++), text, answers);
            itemText.setRequiredOptionsCount(Integer.valueOf(required));
            index = itemdata.indexOf("@ANSWERS@");
            itemText.setItemTextAttachmentSet(this.makeEMIItemTextAttachmentSet(itemText, itemdata.substring(0, index)));
            itemTextSet.add(itemText);
            itemdata = itemdata.substring(index + "@ANSWERS@".length()).trim();
            index = itemdata.indexOf("[");
            long answerSeq = 1L;
            while (index != -1) {
                String label = itemdata.substring(1, 2);
                itemdata = itemdata.substring(3).trim();
                boolean correct = itemdata.startsWith("CORRECT");
                index = itemdata.indexOf(")");
                double score = Double.valueOf(itemdata.substring(itemdata.indexOf("|") + 1, index));
                answers.add(new Answer((ItemTextIfc)itemText, optionMap.get(label), Long.valueOf(answerSeq++), label, Boolean.valueOf(correct), grade, Double.valueOf(correct ? score : 0.0), null, Double.valueOf(correct ? 0.0 : -score)));
                itemdata = itemdata.substring(index + 1).trim();
                index = itemdata.indexOf("[");
            }
        }
        return itemTextSet;
    }

    private Set<ItemTextAttachmentIfc> makeEMIItemTextAttachmentSet(ItemText itemText, String attachments) {
        if ((attachments = attachments.trim()).length() == 0) {
            return null;
        }
        List<String> attachList = Arrays.asList(attachments.split("@"));
        HashSet<ItemTextAttachmentIfc> attachSet = new HashSet<ItemTextAttachmentIfc>();
        for (String attach : attachList) {
            if ((attach = attach.trim()).length() == 0) continue;
            int index = attach.indexOf("[");
            String fileName = attach.substring(0, index);
            attach = attach.substring(index);
            index = attach.indexOf("]");
            String mimeType = attach.substring(1, index);
            index = attach.indexOf("(");
            if ((index = (attach = attach.substring(index)).indexOf(")")) <= 1) continue;
            Long size = Long.valueOf(attach.substring(1, index));
            attach = attach.substring(index + 1);
            String resourceId = attach.replace("%2B", "+").replace("%20", " ").replace("/access/content", "");
            try {
                ContentResource cr = new AssessmentService().createCopyOfContentResource(resourceId, fileName);
                attachSet.add((ItemTextAttachmentIfc)new ItemTextAttachment(null, (ItemTextIfc)itemText, cr.getId(), fileName, mimeType, size, null, cr.getUrl(true), Boolean.valueOf(false), ItemTextAttachmentIfc.ACTIVE_STATUS, itemText.getItem().getCreatedBy(), new Date(), itemText.getItem().getLastModifiedBy(), new Date()));
            }
            catch (Exception e) {
                log.warn("Unable to add EMI attachment " + resourceId + ", " + e.getMessage());
            }
        }
        return attachSet;
    }
}

