/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sakaiproject.tool.assessment.qti.exception.Iso8601FormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iso8601DateFormat {
    private static final Logger log = LoggerFactory.getLogger(Iso8601DateFormat.class);
    public static final String BASIC_FORMAT = "yyyyMMdd'T'HHmmssZ";
    private static final String GMT = "GMT";
    private static final Pattern PATTERN_MATCH = Pattern.compile("^(?:(\\d{2,4})-?)?(?:(\\d{2})-?)?(\\d{2})?T?(?:(\\d{2}):?)?(?:(\\d{2}):?)?(\\d{2})?(Z?|(?:\\+|-).+)?$");
    private String pattern;

    public Iso8601DateFormat() {
        log.debug("new Iso8601DateFormat()");
        this.pattern = BASIC_FORMAT;
    }

    public Iso8601DateFormat(String simpleDateFormatPattern) {
        log.debug("new Iso8601DateFormat(String " + simpleDateFormatPattern + ")");
        this.pattern = simpleDateFormatPattern;
    }

    public String format(Date date) {
        log.debug("format(Date " + date + ")");
        SimpleDateFormat sdf = null;
        sdf = this.pattern == null ? new SimpleDateFormat() : new SimpleDateFormat(this.pattern);
        return sdf.format(date);
    }

    public Calendar parse(String iso8601String) throws Iso8601FormatException {
        log.debug("parse(String " + iso8601String + ")");
        if (iso8601String == null) {
            throw new Iso8601FormatException("illegal String iso8601TimeInterval argument: iso8601String == null");
        }
        Matcher matcher = PATTERN_MATCH.matcher(iso8601String = iso8601String.toUpperCase());
        if (matcher.matches()) {
            if (log.isDebugEnabled()) {
                for (int i = 0; i <= matcher.groupCount(); ++i) {
                    log.debug(i + "=" + matcher.group(i));
                }
            }
            String tz = matcher.group(7);
            Calendar cal = null;
            if (tz != null && tz.length() > 0) {
                tz = "Z".equals(tz) ? "Zulu" : GMT + tz;
                if (log.isDebugEnabled()) {
                    log.debug("tz=" + tz);
                    log.debug("TimeZone.getID()=" + TimeZone.getTimeZone(tz).getID());
                }
                cal = GregorianCalendar.getInstance(TimeZone.getTimeZone(tz));
            } else {
                cal = GregorianCalendar.getInstance();
                cal.clear();
            }
            if (matcher.group(1) == null) {
                throw new Iso8601FormatException("Year is required");
            }
            int year = Integer.parseInt(matcher.group(1));
            cal.set(1, year);
            if (matcher.group(2) != null) {
                int month = Integer.parseInt(matcher.group(2)) - 1;
                cal.set(2, month);
            }
            if (matcher.group(3) != null) {
                int date = Integer.parseInt(matcher.group(3));
                cal.set(5, date);
            }
            if (matcher.group(4) != null) {
                int hour = Integer.parseInt(matcher.group(4));
                cal.set(11, hour);
            }
            if (matcher.group(5) != null) {
                int min = Integer.parseInt(matcher.group(5));
                cal.set(12, min);
            }
            if (matcher.group(6) != null) {
                int sec = Integer.parseInt(matcher.group(6));
                cal.set(13, sec);
            }
            return cal;
        }
        throw new Iso8601FormatException("ISO8601 format could not be matched");
    }
}

