/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.ReferenceMap;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.sakaiproject.importer.impl.XPathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlStringBuffer
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(XmlStringBuffer.class);
    private static final long serialVersionUID = 1L;
    private transient org.w3c.dom.Document document = null;
    private transient DocumentBuilder builder = null;
    private transient ReferenceMap cache = null;
    private StringBuffer xml;

    protected XmlStringBuffer() {
        this.xml = new StringBuffer();
    }

    public XmlStringBuffer(String xml) {
        this.xml = new StringBuffer(xml);
    }

    public XmlStringBuffer(org.w3c.dom.Document document) {
        this.document = document;
    }

    public XmlStringBuffer(Document jdomDoc) {
        try {
            this.document = new DOMOutputter().output(jdomDoc);
        }
        catch (JDOMException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public final void clear() {
        this.xml.setLength(0);
        this.reset();
    }

    public final void replace(String xml) {
        this.xml = new StringBuffer(xml);
        this.reset();
    }

    public final org.w3c.dom.Document getDocument() throws ParserConfigurationException, SAXException, IOException {
        if (this.document == null) {
            this.parseContent();
        }
        return this.document;
    }

    private ReferenceMap getCache() {
        if (this.cache == null) {
            this.cache = new ReferenceMap();
        }
        return this.cache;
    }

    private void clearCache() {
        if (this.cache == null) {
            this.cache = new ReferenceMap();
        } else {
            this.cache.clear();
        }
    }

    private final void parseContent() throws ParserConfigurationException, SAXException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("parseContent()");
        }
        this.clearCache();
        DocumentBuilderFactory dbfi = null;
        DocumentBuilder builder = null;
        StringReader sr = null;
        InputSource is = null;
        try {
            dbfi = DocumentBuilderFactory.newInstance();
            builder = dbfi.newDocumentBuilder();
            String s = this.xml.toString();
            if (s == null) {
                log.warn("string value null");
                s = "";
            }
            sr = new StringReader(s);
            is = new InputSource(sr);
            this.document = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SAXException e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("DocumentBuilderFactory dbfi = " + dbfi);
            log.error("StringReader sr = " + sr);
            log.error("InputSource is = " + is);
            log.error("StringBuffer xml = " + this.xml);
            throw e;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public final String stringValue() {
        if (log.isDebugEnabled()) {
            log.debug("stringValue()");
        }
        if (this.document == null) {
            return this.xml.toString();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            LSOutput output = impl.createLSOutput();
            output.setByteStream(out);
            writer.write(this.document, output);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return out.toString();
    }

    public final boolean isEmpty() {
        return this.xml == null || this.xml.length() == 0;
    }

    private void reset() {
        this.document = null;
        this.cache = null;
    }

    public String selectSingleValue(String xpath, String type) {
        String value = null;
        List list = this.selectNodes(xpath);
        if (list != null) {
            int no = list.size();
            if (list.size() > 0) {
                Object getTime;
                CharacterData elementText;
                if (type != null && type.equals("element")) {
                    org.w3c.dom.Element element = (org.w3c.dom.Element)list.get(0);
                    elementText = (CharacterData)element.getFirstChild();
                    getTime = null;
                    if (elementText != null && elementText.getNodeValue() != null && elementText.getNodeValue().trim().length() > 0) {
                        value = elementText.getNodeValue();
                    }
                }
                if (type != null && type.equals("attribute")) {
                    Attr attr = (Attr)list.get(0);
                    elementText = (CharacterData)attr.getFirstChild();
                    getTime = null;
                    if (elementText != null && elementText.getNodeValue() != null && elementText.getNodeValue().trim().length() > 0) {
                        value = elementText.getNodeValue();
                    }
                }
            }
        }
        return value;
    }

    public final List selectNodes(String xpath) {
        if (log.isDebugEnabled()) {
            log.debug("selectNodes(String " + xpath + ")");
        }
        return XPathHelper.selectNodes((String)xpath, (Object)this.document);
    }

    public String getValueOf(String xpath) {
        return XPathHelper.getNodeValue((String)xpath, (Node)this.document);
    }

    public final XmlStringBuffer update(String xpath, String value) throws DOMException, Exception {
        if (log.isDebugEnabled()) {
            log.debug("update(String " + xpath + ", String " + value + ")");
        }
        try {
            org.w3c.dom.Element newElement = null;
            Attr newAttribute = null;
            List newElementList = this.selectNodes(xpath);
            int aIndex = xpath.lastIndexOf("/");
            if (aIndex == -1) {
                aIndex = 0;
            }
            aIndex = xpath.indexOf("@", aIndex);
            int size = newElementList.size();
            if (size > 1) {
                log.info("UPDATING MORE THAN ONE ELEMENT");
            }
            if (aIndex == -1 && size != 0) {
                for (int i = 0; i < size; ++i) {
                    newElement = (org.w3c.dom.Element)newElementList.get(i);
                    Node childNode = newElement.getFirstChild();
                    if (childNode == null) {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        org.w3c.dom.Document document = db.newDocument();
                        Text newElementText = document.createTextNode(newElement.getNodeName());
                        newElementText.setNodeValue(value);
                        Text clonedText = (Text)newElement.getOwnerDocument().importNode(newElementText, true);
                        newElement.appendChild(clonedText);
                        continue;
                    }
                    CharacterData newElementText = (CharacterData)newElement.getFirstChild();
                    newElementText.setNodeValue(value);
                }
            }
            if (aIndex != -1 && size != 0 && (newAttribute = (Attr)newElementList.set(0, null)) != null) {
                newAttribute.setValue(value);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public final void update(String xpath, org.w3c.dom.Element element) {
        if (log.isDebugEnabled()) {
            log.debug("update(String " + xpath + ", Element " + element + ")");
        }
        List itemResults = this.selectNodes(xpath);
        for (org.w3c.dom.Element node : itemResults) {
            org.w3c.dom.Element replacement = (org.w3c.dom.Element)node.getOwnerDocument().importNode(element, true);
            node.getParentNode().replaceChild(replacement, node);
        }
        if (itemResults.size() == 0) {
            String parentPath = xpath.substring(0, xpath.lastIndexOf("/"));
            this.addElement(parentPath, element);
        }
    }

    public final void addJDOMElement(String xpath, Element element) {
        try {
            List nodes = this.selectNodes(xpath);
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                Element node = (Element)nodes.get(i);
                node.addContent((Content)element);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void insertElement(String afterNode, String parentXpath, String childXpath) {
        try {
            String nextXpath = parentXpath + "/" + afterNode;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            org.w3c.dom.Document document = db.newDocument();
            org.w3c.dom.Element element = document.createElement(childXpath);
            org.w3c.dom.Element parent2 = null;
            List parentNodes = this.selectNodes(parentXpath);
            for (org.w3c.dom.Element parent2 : parentNodes) {
            }
            if (parent2 != null) {
                List nodes = this.selectNodes(nextXpath);
                Iterator iterator = nodes.iterator();
                org.w3c.dom.Element nextSibling = null;
                while (iterator.hasNext()) {
                    nextSibling = (org.w3c.dom.Element)iterator.next();
                }
                if (nextSibling != null && !nextSibling.getOwnerDocument().equals(element.getOwnerDocument())) {
                    element = (org.w3c.dom.Element)parent2.getOwnerDocument().importNode(element, true);
                    parent2.insertBefore(element, nextSibling);
                }
            }
        }
        catch (ParserConfigurationException pce) {
            log.error("Exception thrown from insertElement() : " + pce.getMessage());
        }
    }

    public final void add(String parentXpath, String childXpath) {
        org.w3c.dom.Element childElement = this.createChildElement(childXpath);
        this.addElement(parentXpath, childElement);
    }

    protected final org.w3c.dom.Element createChildElement(String childXpath) {
        int index = childXpath.indexOf("/");
        String elementName = childXpath;
        String subChildXpath = null;
        org.w3c.dom.Element element = null;
        org.w3c.dom.Element child = null;
        if (index > 0) {
            elementName = childXpath.substring(0, index);
            subChildXpath = childXpath.substring(index + 1);
            child = this.createChildElement(subChildXpath);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            org.w3c.dom.Document document = db.newDocument();
            element = document.createElement(elementName);
            if (child != null) {
                Node importedNode = document.importNode(child, true);
                element.appendChild(importedNode);
            }
        }
        catch (ParserConfigurationException pce) {
            log.error("Exception thrown from createChildElement(): " + pce.getMessage());
        }
        return element;
    }

    public final void addElement(String parentXpath, org.w3c.dom.Element element) {
        if (log.isDebugEnabled()) {
            log.debug("addElement(String " + parentXpath + ", Element " + element + ")");
        }
        List nodes = this.selectNodes(parentXpath);
        for (org.w3c.dom.Element parent : nodes) {
            if (!parent.getOwnerDocument().equals(element.getOwnerDocument())) {
                element = (org.w3c.dom.Element)parent.getOwnerDocument().importNode(element, true);
            }
            parent.appendChild(element);
        }
    }

    public final void addAttribute(String elementXpath, String attributeName) {
        if (log.isDebugEnabled()) {
            log.debug("addAttribute(String " + elementXpath + ", String" + attributeName + ")");
        }
        List nodes = this.selectNodes(elementXpath);
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            org.w3c.dom.Element element = (org.w3c.dom.Element)nodes.get(i);
            element.setAttribute(attributeName, "");
        }
    }

    public final void removeElement(String xpath) {
        if (log.isDebugEnabled()) {
            log.debug("removeElement(String " + xpath + ")");
        }
        List nodes = this.selectNodes(xpath);
        for (Node node : nodes) {
            Node parent = node.getParentNode();
            parent.removeChild(node);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("writeObject(ObjectOutputStream " + out + ")");
        }
        this.xml = new StringBuffer(this.stringValue());
        out.defaultWriteObject();
    }
}

